/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.pmm.common.util.PmmGoodsUtil;

public class PackageSelectionEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit goodsEdit = (BasedataEdit)this.getControl("goods");
        goodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"goods")) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            showParameter.setMultiSelect(true);
            qFilters.clear();
            if (this.getModel().getValue("createorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"PackageSelectionEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
            if (entryRowEntity.getString("source").equalsIgnoreCase("pmm_prodmanage")) {
                qFilters.add(new QFilter("source", "=", (Object)"1"));
                qFilters.add(new QFilter("status", "=", (Object)"C"));
            }
            this.setF7OpenStyle(showParameter);
        }
    }

    private void setF7OpenStyle(ListShowParameter showParameter) {
        showParameter.setCustomParam("ismergerows", (Object)true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1152px");
        styleCss.setHeight("696px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        HashSet<String> hideFields = new HashSet<String>(8);
        hideFields.add("status");
        hideFields.add("prodmatmappingstatus");
        hideFields.add("protocol.effectdate");
        hideFields.add("protocol.invaliddate");
        showParameter.setCustomParam("hideFields", (Object)SerializationUtils.toJsonString(hideFields));
    }

    private void doGoodsChange(ChangeData[] changedData) {
        ArrayList<Long> goodsIds = new ArrayList<Long>(changedData.length);
        int rowIndex = changedData[0].getRowIndex();
        for (ChangeData data : changedData) {
            DynamicObject newValue = (DynamicObject)data.getNewValue();
            if (newValue == null) {
                this.clear(rowIndex);
                continue;
            }
            goodsIds.add(((DynamicObject)data.getNewValue()).getLong("id"));
        }
        String source = this.getModel().getValue("source", rowIndex).toString();
        if (rowIndex > 0 && StringUtils.isBlank((CharSequence)source)) {
            source = (String)this.getModel().getValue("source", rowIndex - 1);
        }
        Map goodsMap = null;
        if ("pbd_mallgoods".equals(source)) {
            String mallSelector = "id,number,name,model,group.id,group.name,mainpic,unitid.id,unitid.name,unitid.precision precision,priceinfo.price,source";
            goodsMap = PmmGoodsUtil.getGoodsDynMap(null, goodsIds, null, (String)mallSelector);
        } else {
            String selfSelector = "id,number,name,model,source,category.id,category.name,thumbnail,unit.id,unit.name,unit.precision precision,taxprice,supplier.id,supplier.name,curr,curr.name";
            goodsMap = PmmGoodsUtil.getGoodsDynMap(goodsIds, null, (String)selfSelector, null);
        }
        for (ChangeData data : changedData) {
            DynamicObject newValue = (DynamicObject)data.getNewValue();
            if (newValue == null) continue;
            DynamicObject goodsData = (DynamicObject)goodsMap.get(newValue.getPkValue());
            rowIndex = data.getRowIndex();
            this.setGoodsValue((DynamicObject)data.getNewValue(), goodsData, rowIndex);
        }
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        if ("goods".equals(property)) {
            this.doGoodsChange(changedData);
        } else if ("source".equals(property)) {
            for (ChangeData data : changedData) {
                int rowIndex = data.getRowIndex();
                this.getModel().setValue("goods", null, rowIndex);
                this.clear(rowIndex);
            }
        } else if ("isprimary".equals(property)) {
            for (ChangeData data : changedData) {
                boolean isprimary;
                if (data.getNewValue() == null || !(isprimary = Boolean.parseBoolean(data.getNewValue().toString()))) continue;
                this.getModel().beginInit();
                int rowcount = this.getModel().getEntryEntity("entryentity").size();
                int rowIndex = data.getRowIndex();
                for (int i = 0; i < rowcount; ++i) {
                    if (i == rowIndex) continue;
                    this.getModel().setValue("isprimary", (Object)false, i);
                }
                this.getModel().endInit();
            }
            this.getView().updateView("entryentity");
        } else if ("qty".equals(property)) {
            for (ChangeData data : changedData) {
                BigDecimal qty = BigDecimal.ONE;
                int rowIndex = data.getRowIndex();
                if (data.getNewValue() != null) {
                    qty = new BigDecimal(data.getNewValue().toString());
                    qty = qty.setScale(0, 5);
                }
                if (this.getModel().getValue("price", rowIndex) != null) {
                    BigDecimal price = new BigDecimal(this.getModel().getValue("price", rowIndex).toString());
                    this.getModel().setValue("amount", (Object)price.multiply(qty).setScale(6, RoundingMode.HALF_UP), rowIndex);
                }
                this.getModel().beginInit();
                this.getModel().setValue("qty", (Object)qty, rowIndex);
                this.getModel().endInit();
            }
            this.getView().updateView("entryentity");
        }
        this.sumAmount();
    }

    private void setGoodsValue(DynamicObject newValue, DynamicObject goodsData, int rowIndex) {
        IDataModel model = this.getModel();
        this.getModel().beginInit();
        if (rowIndex > 0 && StringUtils.isBlank((Object)model.getValue("source", rowIndex))) {
            model.setValue("source", model.getValue("source", rowIndex - 1), rowIndex);
        }
        if (model.getValue("goods", rowIndex) == null) {
            model.setValue("goods", (Object)newValue, rowIndex);
        }
        this.getModel().endInit();
        String source = model.getValue("source", rowIndex).toString();
        if ("pbd_mallgoods".equals(source)) {
            model.setValue("goodsname", (Object)goodsData.getString("name"), rowIndex);
            model.setValue("model", (Object)goodsData.getString("model"), rowIndex);
            if (goodsData.getString("unitid.id") != null) {
                DynamicObject unit = BusinessDataServiceHelper.newDynamicObject((String)"bd_measureunits");
                unit.set("id", (Object)goodsData.getLong("unitid.id"));
                unit.set("name", (Object)goodsData.getString("unitid.name"));
                unit.set("precision", goodsData.get("precision"));
                model.setValue("unit", (Object)unit, rowIndex);
            }
            model.setValue("price", (Object)goodsData.getBigDecimal("priceinfo.price"), rowIndex);
            model.setValue("picture", (Object)goodsData.getString("mainpic"), rowIndex);
            String supplierName = null;
            source = goodsData.getString("source");
            if (StringUtils.isNotBlank((CharSequence)source)) {
                supplierName = EcApiUtil.getMalName((String)source);
            }
            model.setValue("goodssupplier", (Object)supplierName, rowIndex);
            BigDecimal qty = BigDecimal.ONE;
            if (model.getValue("qty") != null) {
                qty = new BigDecimal(model.getValue("qty").toString());
            }
            if (goodsData.getBigDecimal("priceinfo.price") != null && model.getValue("qty") != null) {
                model.setValue("amount", (Object)goodsData.getBigDecimal("priceinfo.price").multiply(qty).setScale(6, RoundingMode.HALF_UP), rowIndex);
            }
        } else if ("pmm_prodmanage".equals(source)) {
            model.setValue("goodsname", (Object)goodsData.getString("name"), rowIndex);
            model.setValue("model", (Object)goodsData.getString("model"), rowIndex);
            if (goodsData.getString("unit.id") != null) {
                DynamicObject unit = BusinessDataServiceHelper.newDynamicObject((String)"bd_measureunits");
                unit.set("id", (Object)goodsData.getLong("unit.id"));
                unit.set("name", (Object)goodsData.getString("unit.name"));
                unit.set("precision", (Object)goodsData.getString("precision"));
                model.setValue("unit", (Object)unit, rowIndex);
            }
            model.setValue("picture", (Object)goodsData.getString("thumbnail"), rowIndex);
            model.setValue("price", (Object)goodsData.getBigDecimal("taxprice"), rowIndex);
            model.setValue("goodssupplier", (Object)goodsData.getString("supplier.name"), rowIndex);
            if (goodsData.getString("supplier.name") != null) {
                model.setValue("goodssupplier", (Object)goodsData.getString("supplier.name"), rowIndex);
            }
            BigDecimal qty = BigDecimal.ONE;
            if (model.getValue("qty", rowIndex) != null) {
                qty = new BigDecimal(model.getValue("qty", rowIndex).toString());
            }
            if (goodsData.getBigDecimal("taxprice") != null && model.getValue("qty", rowIndex) != null) {
                model.setValue("amount", (Object)goodsData.getBigDecimal("taxprice").multiply(qty).setScale(6, RoundingMode.HALF_UP), rowIndex);
            }
        }
    }

    private void clear(int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("goodsname", null, rowIndex);
        model.setValue("price", null, rowIndex);
        model.setValue("amount", null, rowIndex);
        model.setValue("unit", null, rowIndex);
        model.setValue("picture", null, rowIndex);
        model.setValue("goodssupplier", null, rowIndex);
        model.setValue("qty", (Object)BigDecimal.ONE, rowIndex);
        model.setValue("model", null, rowIndex);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object allprodids = showParameter.getCustomParam("allprodids");
        if (Objects.nonNull(allprodids)) {
            this.doDefaultValue();
        } else {
            model.setValue("isprimary", (Object)true, 0);
            model.setValue("source", (Object)"pmm_prodmanage", 0);
        }
    }

    private void doDefaultValue() {
        this.getModel().beginInit();
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String cur_org = (String)showParameter.getCustomParam("cur_org");
        long org = Long.parseLong(cur_org);
        model.setValue("createorg", (Object)org);
        model.setValue("useorg", (Object)org);
        String allprodids = (String)showParameter.getCustomParam("allprodids");
        if (StringUtils.isBlank((CharSequence)allprodids)) {
            return;
        }
        String[] prodIdArray = allprodids.split(",");
        int prodIdCount = prodIdArray.length;
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(prodIdCount);
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(prodIdCount);
        String source = (String)showParameter.getCustomParam("source");
        for (String prodIdStr : prodIdArray) {
            Long prodId = Long.parseLong(prodIdStr);
            if ("pbd_mallgoods".equals(source)) {
                ecGoodsIds.add(prodId);
                continue;
            }
            selfGoodsIds.add(prodId);
        }
        String mallSelector = "id, name,model,mainpic thumbnail,unitid.id unitid,unitid.name unitname, source suppliername,priceinfo.price shopprice";
        String selfSelector = "id,name,model,unit.id unitid,unit.name unitname,supplier.name suppliername,thumbnail,shopprice ";
        Map goodsMap = PmmGoodsUtil.getGoodsDynMap(selfGoodsIds, ecGoodsIds, (String)selfSelector, (String)mallSelector);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        this.getModel().deleteEntryData("entryentity");
        DynamicObject goods = null;
        for (Map.Entry goodsEntry : goodsMap.entrySet()) {
            goods = (DynamicObject)goodsEntry.getValue();
            vs.addField("isprimary", new Object[]{false});
            if ("pmm_prodmanage".equals(source)) {
                vs.addField("goodssupplier", new Object[]{goods.getString("suppliername")});
            } else {
                String supplierName = null;
                String malSource = goods.getString("suppliername");
                if (StringUtils.isNotBlank((CharSequence)malSource)) {
                    supplierName = EcApiUtil.getMalName((String)malSource);
                }
                vs.addField("goodssupplier", new Object[]{supplierName});
            }
            vs.addField("source", new Object[]{source});
            vs.addField("goods", new Object[]{goods.getLong("id")});
            vs.addField("unit", new Object[]{goods.getLong("unitid")});
            vs.addField("picture", new Object[]{goods.getString("thumbnail")});
            vs.addField("model", new Object[]{goods.getString("model")});
            vs.addField("goodsname", new Object[]{goods.getString("name")});
            vs.addField("price", new Object[]{goods.getBigDecimal("shopprice")});
            vs.addField("amount", new Object[]{goods.getBigDecimal("shopprice")});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        String ctrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)"pmm_packageselection", (String)String.valueOf(org));
        this.getModel().setValue("ctrlstrategy", (Object)ctrlStrgy);
        this.getPageCache().remove("source");
        this.getPageCache().remove("pakage_prodlist");
        this.getPageCache().remove("allprodids");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "newentry": {
                int index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("source", (Object)"pmm_prodmanage", index);
                this.sumAmount();
                break;
            }
            case "save": 
            case "submit": {
                if (args.getOperationResult().isSuccess()) {
                    this.getView().invokeOperation("refresh");
                }
            }
            case "deleteentry": {
                this.sumAmount();
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("origin", (Object)"A");
        this.fillGoodsEntryInfo();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.fillGoodsEntryInfo();
        this.getModel().setDataChanged(false);
    }

    private void fillGoodsEntryInfo() {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(entryCol.size());
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(entryCol.size());
        for (DynamicObject entry : entryCol) {
            Long goodsId = entry.getLong("goods.id");
            String source = entry.getString("source");
            if (!StringUtils.isNotBlank((CharSequence)source)) continue;
            if ("pmm_prodmanage".equals(source)) {
                selfGoodsIds.add(goodsId);
                continue;
            }
            ecGoodsIds.add(goodsId);
        }
        String selfSelector = "id,name,model,unit.id unitid ,unit.name unitname,unit.precision precision,supplier.name,thumbnail,shopprice";
        String mallSelector = "id,number,name,model,mainpic thumbnail,unitid.id unitid,unitid.name unitname,unitid.precision precision,priceinfo.price shopprice,source";
        Map goodsMap = PmmGoodsUtil.getGoodsDynMap(selfGoodsIds, ecGoodsIds, (String)selfSelector, (String)mallSelector);
        for (DynamicObject entry : entryCol) {
            String source = entry.getString("source");
            DynamicObject goodsEntry = (DynamicObject)goodsMap.get(entry.getLong("goods.id"));
            if (goodsEntry == null) continue;
            entry.set("goodsname", (Object)goodsEntry.getString("name"));
            entry.set("model", (Object)goodsEntry.getString("model"));
            if (goodsEntry.getString("unitid") != null) {
                DynamicObject unit = BusinessDataServiceHelper.newDynamicObject((String)"bd_measureunits");
                unit.set("id", (Object)goodsEntry.getLong("unitid"));
                unit.set("name", (Object)goodsEntry.getString("unitname"));
                unit.set("precision", goodsEntry.get("precision"));
                entry.set("unit", (Object)unit);
            }
            entry.set("price", (Object)goodsEntry.getBigDecimal("shopprice"));
            entry.set("picture", (Object)goodsEntry.getString("thumbnail"));
            BigDecimal qty = BigDecimal.ONE;
            if (entry.getBigDecimal("qty") != null) {
                qty = entry.getBigDecimal("qty");
            }
            if (goodsEntry.getBigDecimal("shopprice") != null) {
                entry.set("amount", (Object)goodsEntry.getBigDecimal("shopprice").multiply(qty).setScale(6, RoundingMode.HALF_UP));
            }
            if ("pmm_prodmanage".equals(source)) {
                entry.set("goodssupplier", (Object)goodsEntry.getString("supplier.name"));
                continue;
            }
            String supplierName = null;
            String malSource = goodsEntry.getString("source");
            if (StringUtils.isNotBlank((CharSequence)malSource)) {
                supplierName = EcApiUtil.getMalName((String)malSource);
            }
            entry.set("goodssupplier", (Object)supplierName);
        }
        this.getView().updateView("entryentity");
        this.sumAmount();
    }

    private void sumAmount() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            BigDecimal rowAmount = BigDecimal.ZERO;
            if (entry.getBigDecimal("amount") == null) continue;
            rowAmount = entry.getBigDecimal("amount");
            sumAmount = sumAmount.add(rowAmount);
        }
        this.getModel().setValue("totalamount", (Object)sumAmount);
    }

    public void afterBindData(EventObject e) {
        this.getModel().setDataChanged(false);
    }
}

