/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.MalOrderUtil;

public class PmmBizconfigEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String JDMATERIAL = "jdmaterial";
    private static final String FEEMATERIAL = "feematerial";
    private static final String MATERIALGROUP = "materialgroup";
    private static final String PRICE = "price";
    private static final String MGLONGNUMBER = "mglongnumber";

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        QFilter qFilter = new QFilter("isdisposable", "=", (Object)"1");
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)JDMATERIAL) || StringUtils.equals((CharSequence)fieldKey, (CharSequence)FEEMATERIAL)) {
            qFilter = new QFilter("isdisposable", "=", (Object)"1");
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setdefaultCur();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit jdmaterial = (BasedataEdit)this.getView().getControl(JDMATERIAL);
        jdmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit feematerial = (BasedataEdit)this.getView().getControl(FEEMATERIAL);
        feematerial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.setdefaultCur();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject materialgroup;
        boolean isSame;
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object value = model.getValue(propertyName, rowIndex);
        if (null != value && null != model.getValue(PRICE, rowIndex) && MATERIALGROUP.equals(propertyName)) {
            BigDecimal price = new BigDecimal(String.valueOf(model.getValue(PRICE, rowIndex)));
            boolean isSame2 = this.getCountByMaterialgroup(value, entry, price);
            if (isSame2) {
                model.setValue(propertyName, null, rowIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u7684\u54c1\u7c7b\u548c\u91d1\u989d\u9619\u503c\u3002", (String)"PmmBizconfigEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObject dyn = (DynamicObject)value;
                model.setValue(MGLONGNUMBER, (Object)dyn.getString("longnumber"), rowIndex);
            }
        } else if (null != value && null != model.getValue(MATERIALGROUP, rowIndex) && PRICE.equals(propertyName) && (isSame = this.getCountByMaterialgroup(value, entry, materialgroup = (DynamicObject)model.getValue(MATERIALGROUP, rowIndex)))) {
            model.setValue(propertyName, null, rowIndex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u7684\u54c1\u7c7b\u548c\u91d1\u989d\u9619\u503c\u3002", (String)"PmmBizconfigEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean getCountByMaterialgroup(Object value, DynamicObjectCollection entry, Object other) {
        DynamicObject dyn = null;
        boolean isSame = false;
        int count = 0;
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject materialgroup;
            dyn = (DynamicObject)entry.get(i);
            if (value instanceof DynamicObject) {
                DynamicObject newValue = (DynamicObject)value;
                materialgroup = dyn.getDynamicObject(MATERIALGROUP);
                BigDecimal price = new BigDecimal(String.valueOf(other));
                if (null == materialgroup) continue;
                if (newValue.getPkValue().equals(materialgroup.getPkValue()) && price.compareTo(dyn.getBigDecimal(PRICE)) == 0) {
                    if (count == 1) {
                        isSame = true;
                        break;
                    }
                    ++count;
                }
            }
            if (!(value instanceof BigDecimal)) continue;
            BigDecimal price = new BigDecimal(String.valueOf(value));
            materialgroup = dyn.getDynamicObject(MATERIALGROUP);
            DynamicObject newOther = (DynamicObject)other;
            if (null == materialgroup || null == newOther || !newOther.getPkValue().equals(materialgroup.getPkValue()) || price.compareTo(dyn.getBigDecimal(PRICE)) != 0) continue;
            if (count == 1) {
                isSame = true;
                break;
            }
            ++count;
        }
        return isSame;
    }

    public void setdefaultCur() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            if (null != this.getModel().getValue("curr", i)) continue;
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency(), i);
        }
    }
}

