/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmmCategoryUnionEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String SELFCLASS = "selfclass";
    public static final String ECCLASS = "ecclass";
    public static final String MULECCLASS = "mulecclass";

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object platform = customParams.get("platform");
        if ("1".equals(platform)) {
            e.setCheckDataChange(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object platform = customParams.get("platform");
        if (!"1".equals(platform)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{SELFCLASS});
            this.getView().setEnable(Boolean.FALSE, new String[]{ECCLASS});
            this.getView().setVisible(Boolean.FALSE, new String[]{MULECCLASS});
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(ECCLASS);
            basedataEdit.setMustInput(true);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{SELFCLASS});
            this.getView().setEnable(Boolean.TRUE, new String[]{ECCLASS});
            Object selfClass = this.getModel().getValue(SELFCLASS);
            if (null != selfClass) {
                DynamicObject selfClassDyn = (DynamicObject)selfClass;
                Set<Long> eclssIdsBySelf = this.getEclssIdsBySelf(selfClassDyn.getLong("id"));
                this.getModel().setValue(MULECCLASS, (Object)eclssIdsBySelf.toArray(new Object[0]));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{ECCLASS});
            MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getView().getControl(MULECCLASS);
            mulBasedataEdit.setMustInput(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object platform = customParams.get("platform");
        Object classid = customParams.get("classid");
        if (null != platform) {
            if (!"1".equals(platform)) {
                this.getModel().setValue("platform", platform);
                this.getModel().setValue(ECCLASS, (Object)Long.parseLong(String.valueOf(classid)));
            } else {
                long selfClassId = Long.parseLong(String.valueOf(classid));
                this.getModel().setValue(SELFCLASS, (Object)selfClassId);
                Set<Long> eclssIdsBySelf = this.getEclssIdsBySelf(selfClassId);
                this.getModel().setValue(MULECCLASS, (Object)eclssIdsBySelf.toArray(new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit selfclass = (BasedataEdit)this.getView().getControl(SELFCLASS);
        selfclass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ecclass = (BasedataEdit)this.getView().getControl(ECCLASS);
        ecclass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulEcclass = (MulBasedataEdit)this.getView().getControl(MULECCLASS);
        mulEcclass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (SELFCLASS.equals(name)) {
            QFilter qFilter = new QFilter("standard.id", "=", (Object)Long.parseLong("944841720602823680"));
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            formShowParameter.setCustomParam("showGoodsF7", (Object)"self");
        }
        if (ECCLASS.equals(name)) {
            DynamicObjectCollection standardDyos = this.getStandardDyos();
            if (this.getStandardDyos().size() > 0) {
                formShowParameter.setCustomParam("cmbstandardlst", (Object)((DynamicObject)standardDyos.get(0)).getString("standard.id"));
            }
            formShowParameter.setCustomParam("showGoodsF7", (Object)"mal");
        }
        if (MULECCLASS.equals(name)) {
            this.doMulEcClassBeforeF7Select(evt);
        }
    }

    private void doMulEcClassBeforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObjectCollection standardDyos = this.getStandardDyos();
        if (this.getStandardDyos().size() > 0) {
            formShowParameter.setCustomParam("cmbstandardlst", (Object)((DynamicObject)standardDyos.get(0)).getString("standard.id"));
        }
        HashSet classIds = new HashSet(16);
        Object selfClass = this.getModel().getValue(SELFCLASS);
        if (null != selfClass) {
            QFilter qFilter = new QFilter("selfclass.id", "!=", (Object)((DynamicObject)selfClass).getLong("id"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"pmm_categoryunion", (String)"pmm_categoryunion", (String)"ecclass.id", (QFilter[])qFilter.toArray(), (String)"id");){
                dataSet.forEach(row -> classIds.add(row.getLong("ecclass.id")));
            }
            if (classIds.size() > 0) {
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", classIds));
            }
        }
        formShowParameter.setCustomParam("showGoodsF7", (Object)"mal");
    }

    private Set<Long> getEclssIdsBySelf(long selfClassId) {
        QFilter qFilter = new QFilter("selfclass.id", "=", (Object)selfClassId);
        DynamicObjectCollection pmmCategoryunions = QueryServiceHelper.query((String)"pmm_categoryunion", (String)"ecclass.id", (QFilter[])qFilter.toArray());
        HashSet<Long> ecclassIds = new HashSet<Long>(16);
        for (DynamicObject row : pmmCategoryunions) {
            ecclassIds.add(row.getLong("ecclass.id"));
        }
        return ecclassIds;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private DynamicObjectCollection getStandardDyos() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        return QueryServiceHelper.query((String)"pmm_ecadmit", (String)"standard.id,platform,name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (ECCLASS.equals(name)) {
            this.setDefaultValue();
        }
        if (MULECCLASS.equals(name) && null != (value = this.getModel().getValue(MULECCLASS))) {
            DynamicObjectCollection mulEcClass = (DynamicObjectCollection)value;
            Object ecClass = this.getModel().getValue(ECCLASS);
            if (null != ecClass) {
                DynamicObject ecClassDyn = (DynamicObject)ecClass;
                boolean isContain = false;
                for (DynamicObject row : mulEcClass) {
                    long curEcClassId;
                    long fbasedataid = row.getDynamicObject("fbasedataid").getLong("id");
                    if (fbasedataid != (curEcClassId = ecClassDyn.getLong("id"))) continue;
                    isContain = true;
                }
                if (!isContain && mulEcClass.size() > 0) {
                    this.getModel().setValue(ECCLASS, ((DynamicObject)mulEcClass.get(0)).get("fbasedataid"));
                }
            } else {
                this.getModel().setValue(ECCLASS, ((DynamicObject)mulEcClass.get(0)).get("fbasedataid"));
            }
        }
    }

    private DynamicObject getPlateFrom() {
        Object ecclass = this.getModel().getValue(ECCLASS);
        if (null == ecclass) {
            return null;
        }
        Long ecClassId = 0L;
        ecClassId = ecclass instanceof DynamicObject ? Long.valueOf(((DynamicObject)ecclass).getLong("id")) : Long.valueOf(Long.parseLong(String.valueOf(ecClassId)));
        QFilter qFilter = new QFilter("id", "=", (Object)ecClassId);
        DynamicObject mdr_goodsclass = QueryServiceHelper.queryOne((String)"mdr_goodsclass", (String)"standard.id", (QFilter[])qFilter.toArray());
        if (null != mdr_goodsclass && 0L != mdr_goodsclass.getLong("standard.id")) {
            qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())).and(new QFilter("standard.id", "=", (Object)mdr_goodsclass.getLong("standard.id"))));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)"platform,standard.id", (QFilter[])qFilter.toArray());
            return dynamicObject;
        }
        return null;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        DynamicObject ecadmit;
        Map sourceData = e.getSourceData();
        Object platform = sourceData.get("platform");
        QFilter qFilter = new QFilter("platform", "=", platform);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)"openstatus,tenantid,enable,name", (QFilter[])new QFilter[]{qFilter});
        if (!(dynamicObject.getString("openstatus").equals("2") && dynamicObject.getString("enable").equals("1") && dynamicObject.getString("tenantid").equals(RequestContext.getOrCreate().getTenantId()))) {
            String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u63d0\u793a\u7535\u5546{0}\u672a\u5f00\u901a\u3002", (String)"PmmCategoryUnionEditPlugin_0", (String)"scm-pmm-formplugin", (Object[])new Object[]{dynamicObject.getString("name")});
            e.setCancel(true);
            e.setCancelMessage(msg);
            e.setFireAfterImportData(false);
        }
        if (platform != null && null != (ecadmit = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)"standard.number", (QFilter[])new QFilter[]{qFilter = new QFilter("platform", "=", platform).and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId()))}))) {
            this.getPageCache().put("platform", ecadmit.getString("standard.number"));
        }
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        Map searchResult = e.getSearchResult();
        String standard = this.getPageCache().get("platform");
        for (Map.Entry map : searchResult.entrySet()) {
            DynamicObject goodsClass;
            String searchKey = ((BasedataItem)map.getKey()).getSearchKey();
            String searchValue = ((BasedataItem)map.getKey()).getSearchValue();
            List value = (List)map.getValue();
            if (value == null || value.size() == 0 || !ECCLASS.equals(((BasedataItem)map.getKey()).getFieldKey()) && !SELFCLASS.equals(((BasedataItem)map.getKey()).getFieldKey())) continue;
            QFilter qFilter = new QFilter(searchKey, "=", (Object)searchValue);
            if (SELFCLASS.equals(((BasedataItem)map.getKey()).getFieldKey())) {
                qFilter.and("standard.id", "=", (Object)Long.parseLong("944841720602823680"));
            } else if (null != standard) {
                qFilter.and("standard.number", "=", (Object)standard);
            }
            if ((goodsClass = QueryServiceHelper.queryOne((String)"mdr_goodsclass", (String)"id", (QFilter[])qFilter.toArray())) == null) continue;
            value.clear();
            value.add(goodsClass.getLong("id"));
        }
    }

    private void setDefaultValue() {
        DynamicObject plateFrom = this.getPlateFrom();
        if (null != plateFrom) {
            this.getModel().setValue("platform", (Object)plateFrom.getString("platform"));
        }
    }
}

