/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.malcore.domain.ProdCommentContentDetail;
import kd.scm.malcore.domain.ProdCommentLabel;
import kd.scm.malcore.enums.ProdCommentTypeEnum;

public final class PmmCommentManageEdit
extends AbstractBillPlugIn
implements UploadListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showCommentView();
    }

    private void showCommentView() {
        List<ProdCommentContentDetail> commentDetails = this.getCommentDetail();
        List<ProdCommentLabel> prodCommentLabels = this.getProdCommentLabels();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pbd_prodcomment");
        fsp.setCustomParam("openStyle", (Object)"view");
        fsp.setCustomParam("commentDetails", (Object)SerializationUtils.toJsonString(commentDetails));
        fsp.setCustomParam("prodCommentLabels", (Object)SerializationUtils.toJsonString(prodCommentLabels));
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("commentcontainer");
        this.getView().showForm(fsp);
    }

    private List<ProdCommentContentDetail> getCommentDetail() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<ProdCommentContentDetail> prodCommentContentDetails = new ArrayList<ProdCommentContentDetail>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            ProdCommentContentDetail prodCommentContentDetail = new ProdCommentContentDetail();
            prodCommentContentDetail.setId(Long.valueOf(entry.getLong("id")));
            prodCommentContentDetail.setCommentTitle((String)((ILocaleString)entry.get("commenttitle")).getDefaultItem());
            prodCommentContentDetail.setModuleType(entry.getDynamicObject("moduletype").getString("number"));
            prodCommentContentDetail.setValue(entry.getString("content"));
            prodCommentContentDetails.add(prodCommentContentDetail);
        }
        ProdCommentContentDetail prodCommentContentDetail = new ProdCommentContentDetail();
        String pictureUrl = (String)this.getModel().getValue("pictureurl_tag");
        prodCommentContentDetail.setId((Long)this.getModel().getValue("id"));
        prodCommentContentDetail.setModuleType(ProdCommentTypeEnum.PICTURE.getVal());
        prodCommentContentDetail.setValue(pictureUrl);
        prodCommentContentDetails.add(prodCommentContentDetail);
        return prodCommentContentDetails;
    }

    private List<ProdCommentLabel> getProdCommentLabels() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List labelIds = entryEntity.stream().filter(k -> ProdCommentTypeEnum.LABEL.getVal().equals(k.getDynamicObject("moduletype").getString("number"))).map(k -> Long.valueOf(k.getString("content"))).collect(Collectors.toList());
        ArrayList<ProdCommentLabel> prodCommentLabels = new ArrayList<ProdCommentLabel>(labelIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"pmm_commentlabel", (String)"id,name,labeltype", (QFilter[])new QFilter[]{new QFilter("id", "in", labelIds)}, (String)"id");){
            dataSet.forEach(row -> {
                ProdCommentLabel prodCommentLabel = new ProdCommentLabel();
                prodCommentLabel.setId(row.getLong("id"));
                prodCommentLabel.setName(row.getString("name"));
                prodCommentLabel.setLabelType(row.getString("labeltype"));
                prodCommentLabels.add(prodCommentLabel);
            });
        }
        return prodCommentLabels;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("abandon".equals(operateKey)) {
            HashMap paramMap = new HashMap(8);
            ArrayList<Long> billIds = new ArrayList<Long>(8);
            billIds.add((Long)this.getModel().getValue("id"));
            paramMap.put("billIds", billIds);
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pbd_commentabandon", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            this.getView().invokeOperation("refresh");
        }
    }
}

