/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.malcore.domain.GoodsInventory;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;
import kd.scm.pmm.business.service.GoodsInventoryService;
import kd.scm.pmm.business.service.PmmBusinessServiceFactory;

public class PmmInstockEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String PROD_CURQTY = "currentqty";
    private static final String PROD_NEWQTY = "newqty";
    private static final String PROD_AVAILABLEQTY = "availableqty";
    private static final String PROD_LOCKEDQTY = "lockedqty";
    private static final String PROD_QTY = "qty";

    public void afterCreateNewData(EventObject e) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List<DynamicObject> allProd = this.queryProd();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < allProd.size(); ++i) {
            DynamicObject prod = allProd.get(i);
            vs.set("goods", prod.get("goods"), i);
            if (null != prod.get(PROD_QTY)) {
                vs.set(PROD_CURQTY, (Object)prod.getBigDecimal(PROD_QTY), i);
                vs.set(PROD_NEWQTY, (Object)(prod.getBigDecimal(PROD_QTY).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : prod.getBigDecimal(PROD_QTY)), i);
                vs.set(PROD_AVAILABLEQTY, (Object)prod.getBigDecimal(PROD_AVAILABLEQTY), i);
                vs.set(PROD_LOCKEDQTY, (Object)prod.getBigDecimal(PROD_LOCKEDQTY), i);
            }
            if (null == prod.get("unit")) continue;
            vs.set("unit", prod.get("unit"), i);
            vs.set(PROD_QTY, null, i);
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    private List<DynamicObject> queryProd() {
        ArrayList<DynamicObject> allProd = new ArrayList<DynamicObject>();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getCustomParams().containsKey("allProd")) {
            String selectcol = (String)showParameter.getCustomParam("allProd");
            ArrayList allProdid = StringConversionUtil.conversion((String)selectcol);
            ArrayList<Long> prodList = new ArrayList<Long>(allProdid.size());
            for (String prod : allProdid) {
                prodList.add(Long.parseLong(prod));
            }
            DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_inventory", (String)"goods,unit,qty,lockedqty,availableqty,supplier", (QFilter[])new QFilter[]{new QFilter("goods", "in", prodList)});
            this.getModel().setValue("supplier", (Object)((DynamicObject)prods.get(0)).getLong("supplier"));
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
            this.getModel().setValue("org", supplier.get("createorg"));
            QFilter enterFilter = new QFilter("id", "=", supplier.get("id"));
            DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,name,number,bizpartner", (QFilter[])new QFilter[]{enterFilter});
            for (DynamicObject dyn : suppliers) {
                Object bizpartnerdy = dyn.get("bizpartner");
                if (null == bizpartnerdy) continue;
                this.getModel().setValue("bizpartner", bizpartnerdy);
            }
            allProd.addAll((Collection<DynamicObject>)prods);
        }
        return allProd;
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String proName = arg0.getProperty().getName();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        Object value = arg0.getChangeSet()[0].getNewValue();
        BillModel dataModel = (BillModel)this.getModel();
        BigDecimal currentqty = (BigDecimal)dataModel.getValue(PROD_CURQTY, rowIndex);
        switch (proName) {
            case "supplier": {
                DynamicObject supplierdy = dataModel.getDataEntity().getDynamicObject("supplier");
                if (supplierdy == null) {
                    return;
                }
                QFilter enterFilter = new QFilter("id", "=", supplierdy.get("id"));
                DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,name,number,bizpartner", (QFilter[])new QFilter[]{enterFilter});
                for (DynamicObject dyn : suppliers) {
                    Object bizpartnerdy = dyn.get("bizpartner");
                    if (null == bizpartnerdy) continue;
                    this.getModel().setValue("bizpartner", bizpartnerdy);
                }
                dataModel.deleteEntryData("entryentity");
                dataModel.createNewEntryRow("entryentity");
                break;
            }
            case "goods": {
                DynamicObject goods = (DynamicObject)value;
                if (goods == null) {
                    return;
                }
                DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
                dataModel.setValue("unit", goods.get("unit_id"), rowIndex);
                QFilter qFilter = new QFilter("supplier", "in", (Object)supplier.getLong("id")).and(new QFilter("goods", "in", (Object)goods.getLong("id")));
                DynamicObject qtyDyn = QueryServiceHelper.queryOne((String)"pmm_inventory", (String)"qty,availableqty,lockedqty", (QFilter[])new QFilter[]{qFilter});
                if (null != qtyDyn) {
                    dataModel.setValue(PROD_CURQTY, (Object)qtyDyn.getBigDecimal(PROD_QTY), rowIndex);
                    dataModel.setValue(PROD_QTY, null, rowIndex);
                    dataModel.setValue(PROD_NEWQTY, (Object)(qtyDyn.getBigDecimal(PROD_QTY).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtyDyn.getBigDecimal(PROD_QTY)), rowIndex);
                    dataModel.setValue(PROD_AVAILABLEQTY, (Object)qtyDyn.getBigDecimal(PROD_AVAILABLEQTY), rowIndex);
                    dataModel.setValue(PROD_LOCKEDQTY, (Object)qtyDyn.getBigDecimal(PROD_LOCKEDQTY), rowIndex);
                    break;
                }
                dataModel.setValue(PROD_CURQTY, null, rowIndex);
                dataModel.setValue(PROD_QTY, null, rowIndex);
                dataModel.setValue(PROD_NEWQTY, null, rowIndex);
                dataModel.setValue(PROD_AVAILABLEQTY, null, rowIndex);
                QFilter malOrderQFilter = new QFilter("entryentity.goods", "=", (Object)goods.getLong("id"));
                malOrderQFilter.and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
                BigDecimal lockedQty = BigDecimal.ZERO;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order", (String)"entryentity.goods goods,entryentity.qty qty", (QFilter[])malOrderQFilter.toArray(), null);){
                    for (Row row : dataSet) {
                        lockedQty = lockedQty.add(row.getBigDecimal(PROD_QTY));
                    }
                }
                dataModel.setValue(PROD_LOCKEDQTY, (Object)lockedQty, rowIndex);
                break;
            }
            case "qty": {
                dataModel.beginInit();
                if (BigDecimal.valueOf(0L, currentqty.scale()).compareTo(currentqty.add((BigDecimal)value)) <= 0) {
                    dataModel.setValue(PROD_NEWQTY, (Object)currentqty.add((BigDecimal)value), rowIndex);
                } else {
                    dataModel.setValue(PROD_QTY, (Object)0, rowIndex);
                    dataModel.setValue(PROD_NEWQTY, (Object)0, rowIndex);
                }
                dataModel.endInit();
                break;
            }
            case "newqty": {
                dataModel.beginInit();
                if (BigDecimal.ZERO.compareTo((BigDecimal)value) > 0) {
                    dataModel.setValue(PROD_NEWQTY, (Object)BigDecimal.ZERO, rowIndex, rowIndex);
                }
                dataModel.setValue(PROD_QTY, (Object)((BigDecimal)dataModel.getValue(PROD_NEWQTY, rowIndex)).subtract(currentqty), rowIndex);
                dataModel.endInit();
                break;
            }
        }
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit goodsEdit = (BasedataEdit)this.getControl("goods");
        goodsEdit.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"goods")) {
            DynamicObject supplierdy = this.getModel().getDataEntity().getDynamicObject("supplier");
            if (null == supplierdy) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4f9b\u5e94\u5546\u201d\uff0c\u518d\u5f55\u5165\u5546\u54c1\u660e\u7ec6\u3002", (String)"PmmInstockEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                arg0.setCancel(true);
                return;
            }
            QFilter qfilter = new QFilter("supplier", "=", supplierdy.get("id")).and("status", "=", (Object)"C");
            DynamicObjectCollection malquery = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id", (QFilter[])new QFilter[]{qfilter});
            ArrayList<Long> idList = new ArrayList<Long>(malquery.size());
            if (malquery.size() > 0) {
                for (DynamicObject dyn : malquery) {
                    idList.add(dyn.getLong("id"));
                }
            }
            DynamicObjectCollection dynProd = this.getModel().getEntryEntity("entryentity");
            ArrayList<Long> list = new ArrayList<Long>(dynProd.size());
            for (DynamicObject dyn : dynProd) {
                String goodsid = dyn.getString("goods.id");
                if (null == goodsid) continue;
                list.add(Long.parseLong(goodsid));
            }
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idList));
            if (list.size() > 0) {
                showParameter.getListFilterParameter().getQFilters().clear();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idList).and(new QFilter("id", "not in", list)));
            }
            this.setF7OpenStyle(showParameter);
        }
    }

    private void setF7OpenStyle(ListShowParameter showParameter) {
        showParameter.setCustomParam("ismergerows", (Object)true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (((AbstractOperate)args.getSource()).getOperateKey().equals("submit")) {
            DynamicObjectCollection dataEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<Long> idList = new ArrayList<Long>(dataEntity.size());
            for (DynamicObject dyn : dataEntity) {
                DynamicObject unit = (DynamicObject)dyn.get("unit");
                if (null == unit) continue;
                long goodsid = dyn.getLong("goods.id");
                idList.add(goodsid);
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            if (idList.size() > query.size()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u76f8\u5173\u5546\u54c1\u6570\u636e\u3002", (String)"PmmInstockEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (((AbstractOperate)args.getSource()).getOperateKey().equals("submit")) {
            if (args.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("refresh");
            } else {
                this.reCalculateGoodsInventoryQty();
            }
        }
    }

    private void reCalculateGoodsInventoryQty() {
        this.getModel().beginInit();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        HashMap<Long, DynamicObject> goodsIdAndDynMap = new HashMap<Long, DynamicObject>(dynamicObjectCollection.size());
        ArrayList<GoodsInventoryHandleSku> skuList = new ArrayList<GoodsInventoryHandleSku>(dynamicObjectCollection.size());
        for (DynamicObject entry : dynamicObjectCollection) {
            if (entry.getDynamicObject("goods") == null) continue;
            long goodsId = entry.getLong("goods_id");
            GoodsInventoryHandleSku sku = new GoodsInventoryHandleSku();
            sku.setGoodsId(Long.valueOf(goodsId));
            sku.setGoodsNumber(entry.getDynamicObject("goods").getString("number"));
            sku.setQty(entry.getBigDecimal(PROD_NEWQTY));
            skuList.add(sku);
            goodsIdAndDynMap.put(goodsId, entry);
        }
        List goodsInventories = ((GoodsInventoryService)PmmBusinessServiceFactory.serviceOf(GoodsInventoryService.class)).queryGoodsInventory(skuList);
        List noInventoryGoodsIds = goodsInventories.stream().filter(GoodsInventory::isUnlimited).map(GoodsInventory::getGoodsId).collect(Collectors.toList());
        HashMap goodsIdAndMalOrderQtyMap = new HashMap(noInventoryGoodsIds.size());
        QFilter qFilter = new QFilter("entryentity.goods", "in", noInventoryGoodsIds);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order", (String)"entryentity.goods goods,entryentity.qty qty", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> {
                BigDecimal qty = goodsIdAndMalOrderQtyMap.getOrDefault(row.getLong("goods"), BigDecimal.ZERO);
                qty = qty.add(row.getBigDecimal(PROD_QTY));
                goodsIdAndMalOrderQtyMap.put(row.getLong("goods"), qty);
            });
        }
        for (GoodsInventory goodsInventory : goodsInventories) {
            DynamicObject dynamicObject = (DynamicObject)goodsIdAndDynMap.get(goodsInventory.getGoodsId());
            BigDecimal currentqty = dynamicObject.getBigDecimal(PROD_CURQTY);
            BigDecimal lockedQty = goodsInventory.isUnlimited() ? goodsIdAndMalOrderQtyMap.getOrDefault(goodsInventory.getGoodsId(), BigDecimal.ZERO) : goodsInventory.getLockedQty();
            dynamicObject.set(PROD_LOCKEDQTY, (Object)lockedQty);
            dynamicObject.set(PROD_CURQTY, (Object)goodsInventory.getCurrentQty());
            dynamicObject.set(PROD_AVAILABLEQTY, (Object)goodsInventory.getAvailableQty());
            if (goodsInventory.getCurrentQty().compareTo(currentqty) == 0) continue;
            dynamicObject.set(PROD_NEWQTY, (Object)BigDecimal.ZERO);
            dynamicObject.set(PROD_QTY, (Object)BigDecimal.ZERO);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }
}

