/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PmmPriceManageEdit
extends AbstractBasePlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseModel model = (BaseModel)this.getModel();
        String prodid = model.getDataEntity().getPkValue().toString();
        String selectFields = "id,org,cfmdate,entryentity,entryentity.goods,entryentity.taxprice_old,entryentity.shopprice_old,entryentity.taxprice,entryentity.shopprice,entryentity.note";
        QFilter idfilter = new QFilter("entryentity.goods", "=", (Object)Long.valueOf(prodid));
        QFilter statusfilter = new QFilter("cfmstatus", "=", (Object)"B");
        QFilter[] filters = new QFilter[]{idfilter, statusfilter};
        String orderBys = "cfmdate desc";
        DynamicObject[] adjustPriceCol = BusinessDataServiceHelper.load((String)"pmm_priceaudit", (String)selectFields, (QFilter[])filters, (String)orderBys);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int row = 0;
        for (DynamicObject adjustPrice : adjustPriceCol) {
            DynamicObjectCollection entries = adjustPrice.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject prod = entry.getDynamicObject("goods");
                if (!prodid.equals(prod.getPkValue().toString())) continue;
                BigDecimal taxprice = entry.getBigDecimal("taxprice");
                BigDecimal oldtaxprice = entry.getBigDecimal("taxprice_old");
                BigDecimal shopprice = entry.getBigDecimal("shopprice");
                BigDecimal oldshopprice = entry.getBigDecimal("shopprice_old");
                String note = entry.getString("note");
                DynamicObject org = adjustPrice.getDynamicObject("org");
                Date adjustdate = adjustPrice.getDate("cfmdate");
                vs.set("taxprice_old", (Object)oldtaxprice, row);
                vs.set("shopprice_old", (Object)oldshopprice, row);
                vs.set("taxprice_new", (Object)taxprice, row);
                vs.set("shopprice_new", (Object)shopprice, row);
                vs.set("adjustdate", (Object)adjustdate, row);
                vs.set("note", (Object)note, row);
                vs.set("auditorg", org.getPkValue(), row);
                ++row;
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
    }
}

