/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.common.util.ValidateDataUtil;
import kd.scm.common.util.cal.CalculateUtils;

public class PmmPriceRequestEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
RowClickEventListener,
CellClickListener,
BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BTN_ADJUST = "bar_adjust";
    private static final String CFMSTATUS = "cfmstatus";
    private static final String MODE = "adjustmode";
    private static final String TYPE = "adjusttype";
    private static final String PERCENT = "percent";
    private static final String AMOUNT = "amount";
    private static final String ADJUSTPRICE = "adjustPrice";
    private static final String SUPPLIER = "supplier";
    private static final String PROD_SEQ = "seq";
    private static final String PROD_NUMBER = "goods";
    private static final String PROD_CLASS = "class";
    private static final String PROD_UNIT = "unit";
    private static final String PROD_PRICE = "price";
    private static final String PROD_PRICEOLD = "price_old";
    private static final String PROD_TAXPRICE = "taxprice";
    private static final String PROD_TAXPRICEOLD = "taxprice_old";
    private static final String PROD_SHOPPRICE = "shopprice";
    private static final String PROD_SHOPPRICEOLD = "shopprice_old";
    private static final String PROD_TAXRATE = "taxrate";
    private static final String PROD_CATEGORY = "category";
    private static final String ORG = "org";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equalsIgnoreCase("bar_close")) {
            return;
        }
        if ((itemKey.equalsIgnoreCase("bar_save") || itemKey.equalsIgnoreCase("bar_submit")) && !ValidateDataUtil.EntryDuplicateValidate((IFormView)this.getView(), (DynamicObjectCollection)this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY), (String)PROD_NUMBER)) {
            evt.setCancel(true);
            return;
        }
    }

    public void afterCreateNewData(EventObject eventobject) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        super.afterCreateNewData(eventobject);
        model.setValue(ORG, (Object)RequestContext.get().getOrgId());
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selectcol = (String)showParameter.getCustomParam("allProd");
        ArrayList allProdid = StringConversionUtil.conversion((String)selectcol);
        HashSet proIds = new HashSet();
        if (allProdid == null) {
            return;
        }
        allProdid.forEach(id -> proIds.add(Long.valueOf(id)));
        QFilter idfilter = new QFilter("id", "in", proIds);
        String selectFields = "id,number,name,category,unit,model,price,taxprice,mallstatus,description,taxrate,shopprice";
        DynamicObject[] allProd = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{idfilter});
        if (null != allProd && allProd.length > 0) {
            model.deleteEntryData(ENTRY_ENTITY);
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (int i = 0; i < allProd.length; ++i) {
                DynamicObject prod = allProd[i];
                vs.set(PROD_SEQ, (Object)(i + 1), i);
                vs.set(PROD_NUMBER, (Object)prod.getLong("id"), i);
                vs.set(PROD_CLASS, (DynamicObject)prod.get(PROD_CATEGORY) == null ? null : Long.valueOf(((DynamicObject)prod.get(PROD_CATEGORY)).getLong("id")), i);
                if (null != prod.get(PROD_UNIT)) {
                    vs.set(PROD_UNIT, (Object)((DynamicObject)prod.get(PROD_UNIT)).getLong("id"), i);
                }
                vs.set(PROD_PRICEOLD, (Object)prod.getBigDecimal(PROD_PRICE), i);
                vs.set(PROD_TAXPRICEOLD, (Object)prod.getBigDecimal(PROD_TAXPRICE), i);
                vs.set(PROD_TAXRATE, (Object)prod.getBigDecimal(PROD_TAXRATE), i);
                vs.set(PROD_SHOPPRICE, (Object)prod.getBigDecimal(PROD_SHOPPRICE), i);
                vs.set(PROD_SHOPPRICEOLD, (Object)prod.getBigDecimal(PROD_SHOPPRICE), i);
            }
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        }
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propertyName;
        super.propertyChanged(arg0);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (propertyName = arg0.getProperty().getName()) {
            case "supplier": {
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
                break;
            }
            case "taxprice": {
                int rowIndex = arg0.getChangeSet()[0].getRowIndex();
                if (null == model.getValue(propertyName)) {
                    return;
                }
                DynamicObject curr = (DynamicObject)this.getModel().getValue("curr");
                int scale = curr.getInt("priceprecision");
                BigDecimal taxPrice = (BigDecimal)model.getValue(propertyName, rowIndex);
                BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
                int rowIndex1 = arg0.getChangeSet()[0].getRowIndex();
                IDataModel entryOperate = this.getModel();
                DynamicObject entry = entryOperate.getEntryRowEntity(ENTRY_ENTITY, rowIndex1);
                DynamicObject entryprod = entry.getDynamicObject(PROD_NUMBER);
                if (null == entryprod) {
                    entry.set(PROD_TAXPRICE, null);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u54c1\u7f16\u7801\u201d\uff0c\u518d\u5f55\u5165\u201c\u65b0\u7ed3\u7b97\u4ef7\u201d\u3002", (String)"PmmPriceRequestEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                    return;
                }
                BigDecimal taxRate = entry.getBigDecimal(PROD_TAXRATE);
                String taxtype = entryprod.getString("taxtype");
                price = "0".equals(taxtype) ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale) : CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale);
                model.setValue(PROD_PRICE, (Object)price, rowIndex1);
                view.updateView();
                break;
            }
            case "goods": {
                DynamicObject cate;
                BigDecimal shopPrice;
                DynamicObject newObject = (DynamicObject)arg0.getChangeSet()[0].getNewValue();
                if (newObject == null) {
                    return;
                }
                DynamicObjectCollection oldRows = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
                if (oldRows == null || oldRows.size() == 0) {
                    return;
                }
                int count = 0;
                int currentRow = arg0.getChangeSet()[0].getRowIndex();
                DynamicObject oldObject = null;
                for (DynamicObject obj : oldRows) {
                    oldObject = obj.getDynamicObject(PROD_NUMBER);
                    if (oldObject != null && oldObject.getPkValue().equals(newObject.getPkValue())) {
                        ++count;
                    }
                    if (oldObject == null || count != 2) continue;
                    this.getView().showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5f55\u5165\u91cd\u590d\u7684\u5546\u54c1\u7f16\u7801\uff1a{0}\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmPriceRequestEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]), oldObject.getString("number")), MessageBoxOptions.OK);
                    return;
                }
                int rowIndex = arg0.getChangeSet()[0].getRowIndex();
                DynamicObject entryEntity = ((BillModel)model).getEntryEntity(ENTRY_ENTITY, rowIndex);
                DynamicObject prod = (DynamicObject)entryEntity.get(propertyName);
                DynamicObject unit = (DynamicObject)prod.get(PROD_UNIT);
                BigDecimal price = prod.getBigDecimal(PROD_PRICE);
                if (null != price) {
                    model.setValue(PROD_PRICEOLD, (Object)price, rowIndex);
                }
                BigDecimal taxPrice = prod.getBigDecimal(PROD_TAXPRICE);
                if (null != price) {
                    model.setValue(PROD_TAXPRICEOLD, (Object)taxPrice, rowIndex);
                }
                if (null != (shopPrice = prod.getBigDecimal(PROD_SHOPPRICE))) {
                    model.setValue(PROD_SHOPPRICEOLD, (Object)shopPrice, rowIndex);
                }
                if (null != (cate = (DynamicObject)prod.get(PROD_CATEGORY))) {
                    model.setValue(PROD_CLASS, (Object)cate, rowIndex);
                }
                BigDecimal taxrate = (BigDecimal)prod.get(PROD_TAXRATE);
                if (null == cate) break;
                model.setValue(PROD_TAXRATE, (Object)taxrate, rowIndex);
                break;
            }
            case "taxrate": {
                int rowIndex2 = arg0.getChangeSet()[0].getRowIndex();
                IDataModel entryOperate1 = this.getModel();
                DynamicObject entry1 = entryOperate1.getEntryRowEntity(ENTRY_ENTITY, rowIndex2);
                DynamicObject entryprod = entry1.getDynamicObject(PROD_NUMBER);
                if (null == entryprod) {
                    entry1.set(PROD_TAXRATE, null);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u54c1\u7f16\u7801\u201d\uff0c\u518d\u5f55\u5165\u201c\u7a0e\u7387\u201d\u3002", (String)"PmmPriceRequestEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                    return;
                }
                BigDecimal price = entry1.getBigDecimal(PROD_TAXPRICE);
                BigDecimal taxPrice1 = entry1.getBigDecimal(PROD_TAXPRICE);
                BigDecimal taxRate1 = entry1.getBigDecimal(PROD_TAXRATE);
                String taxtype = entryprod.getString("taxtype");
                price = "0".equals(taxtype) ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate1, (BigDecimal)taxPrice1, (int)2) : CalculateUtils.calPrice((BigDecimal)taxPrice1, (BigDecimal)taxRate1, (int)2);
                model.setValue(PROD_PRICE, (Object)price, rowIndex2);
                view.updateView();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel model = this.getModel();
        BasedataEdit supplier1 = (BasedataEdit)this.getView().getControl(SUPPLIER);
        supplier1.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent arg0) {
                ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("mallstatus", "=", (Object)Character.valueOf('B')));
            }
        });
        BasedataEdit product = (BasedataEdit)this.getView().getControl(PROD_NUMBER);
        product.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener(this::beforeF7Select);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.equals(PROD_NUMBER)) {
            DynamicObject supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER);
            if (supplier == null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u5bb6\u201d\uff0c\u518d\u5f55\u5165\u5546\u54c1\u660e\u7ec6\u3002", (String)"PmmPriceRequestEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter prodfilter = new QFilter("id", "not in", this.getExistProd());
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(prodfilter);
        }
        if (name.equals(ORG)) {
            List userHasAllPurPermissionOrgs = OrgUtil.getUserHasAllPurPermissionOrgs();
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)userHasAllPurPermissionOrgs));
        }
    }

    private ArrayList<Long> getExistProd() {
        ArrayList<Long> productId = new ArrayList<Long>();
        QFilter statusfilter = new QFilter(CFMSTATUS, "=", (Object)"A");
        String selectProperties = DynamicObjectUtil.getSelectfields((String)"ent_pricerequest", (boolean)false);
        selectProperties = DynamicObjectUtil.getEntrySelectfields((String)selectProperties, (String)"ent_pricerequest", (String)ENTRY_ENTITY, (boolean)false);
        DynamicObject[] priceReqBill = BusinessDataServiceHelper.load((String)"ent_pricerequest", (String)selectProperties, (QFilter[])new QFilter[]{statusfilter});
        for (int i = 0; i < priceReqBill.length; ++i) {
            DynamicObjectCollection billentries = priceReqBill[i].getDynamicObjectCollection(ENTRY_ENTITY);
            for (int j = 0; j < billentries.size(); ++j) {
                DynamicObject entry = (DynamicObject)billentries.get(j);
                DynamicObject prod = entry.getDynamicObject(PROD_NUMBER);
                if (null == prod) continue;
                productId.add(prod.getLong("id"));
            }
        }
        return productId;
    }

    public void cellClick(CellClickEvent arg0) {
        DynamicObject supplier;
        if (StringUtils.equals((CharSequence)PROD_NUMBER, (CharSequence)arg0.getFieldKey()) && (supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER)) == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u5bb6\u201d\uff0c\u518d\u5f55\u5165\u5546\u54c1\u660e\u7ec6\u3002", (String)"PmmPriceRequestEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
        DynamicObject supplier;
        if (StringUtils.equals((CharSequence)PROD_NUMBER, (CharSequence)arg0.getFieldKey()) && (supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER)) == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u5bb6\u201d\uff0c\u518d\u5f55\u5165\u5546\u54c1\u660e\u7ec6\u3002", (String)"PmmPriceRequestEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObjectCollection rows = null;
        rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObject dynamicObject = (DynamicObject)rows.get(arg0.getRowIndex());
        DynamicObject o = (DynamicObject)dynamicObject.get(PROD_NUMBER);
        String productId = o.getString("id");
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)Long.parseLong(productId), null, null));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_adjust": {
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"ent_adjustprice", null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ADJUSTPRICE), (ShowType)ShowType.Modal));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        if (ADJUSTPRICE.equals(closedCallBackEvent.getActionId())) {
            Object condition = closedCallBackEvent.getReturnData();
            IPageCache cache = this.getPageCache();
            if (condition != null) {
                DynamicObject curr = (DynamicObject)this.getModel().getValue("curr");
                int scale = curr.getInt("priceprecision");
                Map map = condition instanceof Map ? (Map)condition : new HashMap();
                cache.put(MODE, (String)map.get(MODE));
                int mode = Integer.parseInt((String)map.get(MODE));
                cache.put(TYPE, (String)map.get(TYPE));
                int type = Integer.parseInt((String)map.get(TYPE));
                DynamicObjectCollection entryCol = this.getModel().getEntryEntity(ENTRY_ENTITY);
                DynamicObject prod = new DynamicObject();
                int flag = 0;
                for (int i = 0; i < entryCol.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryCol.get(i);
                    prod = (DynamicObject)entry.get(PROD_NUMBER);
                    if (prod == null) {
                        ++flag;
                        continue;
                    }
                    BigDecimal oldprice = entry.getBigDecimal(PROD_TAXPRICEOLD);
                    BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
                    if (mode == 1) {
                        BigDecimal percent = (BigDecimal)map.get(PERCENT);
                        price = type == 1 ? oldprice.subtract(oldprice.multiply(percent.divide(CalConstant.BIGDECIMAL_ONEHUNDRED, scale, RoundingMode.HALF_UP))) : oldprice.add(oldprice.multiply(percent.divide(CalConstant.BIGDECIMAL_ONEHUNDRED, scale, RoundingMode.HALF_UP)));
                    } else if (mode == 2) {
                        price = type == 1 ? oldprice.subtract((BigDecimal)map.get(AMOUNT)) : oldprice.add((BigDecimal)map.get(AMOUNT));
                    }
                    model.setValue(PROD_TAXPRICE, (Object)price, i);
                }
                if (prod == null && entryCol.size() == flag) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u5e94\u5546\u54c1\u8fdb\u884c\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"PmmPriceRequestEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "save": {
                DynamicObjectCollection entities = model.getEntryEntity(ENTRY_ENTITY);
                for (DynamicObject entitiy : entities) {
                    entitiy.set(PROD_SHOPPRICE, entitiy.get(PROD_TAXPRICE));
                }
                break;
            }
            case "submit": {
                DynamicObjectCollection entities = model.getEntryEntity(ENTRY_ENTITY);
                for (DynamicObject entitiy : entities) {
                    entitiy.set(PROD_SHOPPRICE, entitiy.get(PROD_TAXPRICE));
                }
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        if (key.equals("submit")) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setFormId("pmm_priceaudit");
            billShowParameter.setPkId(this.getModel().getValue("id"));
            billShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

