/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmProdAuditProtocolEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static Log log = LogFactory.getLog(PmmProdAuditProtocolEdit.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ORG = "org";
    private static final String SUPPLIER = "supplier";
    private static final String BIZPARTER = "bizpartner";
    private static final String PROD_SEQ = "seq";
    private static final String PROD_NUMBER = "goods";
    private static final String PROD_CLASS = "class";
    private static final String PROD_UNIT = "unit";
    private static final String PROD_PRICE = "price";
    private static final String PROD_TAXPRICE = "taxprice";
    private static final String PROD_SHOPPRICE = "shopprice";
    private static final String PROD_TAXRATE = "taxrate";
    private static final String PROD_MALLSTATUS = "mallstatus";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String PRICEEFFECTDATE = "priceeffectdate";
    private static final String PRICEINVALIDDATE = "priceinvaliddate";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selectcol = (String)showParameter.getCustomParam("allProd");
        Long proticolId = (Long)showParameter.getCustomParam("protocolId");
        ArrayList allProd = StringConversionUtil.conversion((String)selectcol);
        model.setValue("protocolid", (Object)proticolId);
        this.setHeadInfo(model);
        if (null != allProd && allProd.size() > 0) {
            model.deleteEntryData(ENTRY_ENTITY);
            ArrayList<Long> list = new ArrayList<Long>(allProd.size());
            for (String str : allProd) {
                list.add(Long.parseLong(str));
            }
            HashMap<Long, Long> materiaId_goodMap = new HashMap<Long, Long>(1024);
            HashMap<String, Long> entry_goodMap = new HashMap<String, Long>();
            HashMap<String, DynamicObject> entry_bdMap = new HashMap<String, DynamicObject>();
            if (null == showParameter.getCustomParam("protocolId")) {
                this.setEntryData(model);
            } else {
                this.setGoodIds(materiaId_goodMap, list, entry_goodMap, entry_bdMap, String.valueOf(proticolId));
                this.setEntryData(list, entry_goodMap, entry_bdMap);
            }
            this.setDefaultLadPrice();
        }
        if ("1".equals(this.getModel().getValue("biztype"))) {
            this.setPriceEffectDefaultValue();
        }
        this.setSrcBillField();
        if (this.getView().getParentView() != null && (Boolean.parseBoolean((String)AppCache.get((String)this.getView().getParentView().getPageId()).get("resubmit", String.class)) || Boolean.parseBoolean((String)AppCache.get((String)this.getView().getPageId()).get("resubmit", String.class)))) {
            AppCache.get((String)this.getView().getParentView().getPageId()).remove("resubmit");
            AppCache.get((String)this.getView().getPageId()).remove("resubmit");
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            ArrayList<Integer> indexs = new ArrayList<Integer>(1024);
            for (DynamicObject row : entrys) {
                String entryresult = row.getString("entryresult");
                if (!"1".equals(entryresult)) continue;
                indexs.add(row.getInt(PROD_SEQ) - 1);
            }
            if (indexs.size() > 0) {
                int[] removeIndexs = new int[indexs.size()];
                for (int i = 0; i < indexs.size(); ++i) {
                    removeIndexs[i] = (Integer)indexs.get(i);
                }
                this.getPageCache().put("option", "resubmit");
                this.getModel().deleteEntryRows(ENTRY_ENTITY, removeIndexs);
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void setSrcBillField() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map goodsId_LogIdMap = new HashMap(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        String protocolId = "0";
        if (null != dataEntity.get("protocolid")) {
            protocolId = dataEntity.getString("protocolid.id");
        }
        for (DynamicObject row : entryCols) {
            String key;
            if (null == row.get(PROD_NUMBER)) continue;
            String goodsId = row.getString("goods.id");
            String protocolEntryId = "0";
            if (null != row.get("protocolentry")) {
                protocolEntryId = row.getString("protocolentry.id");
            }
            if (null != customParams.get("srcbillidMap") && (goodsId_LogIdMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("srcbillidMap")), Map.class)).containsKey(key = goodsId + protocolId + protocolEntryId)) {
                this.getModel().setValue("srcbillid", goodsId_LogIdMap.get(key), row.getInt(PROD_SEQ) - 1);
            }
            if (null == customParams.get("srcbilltype")) continue;
            this.getModel().setValue("srcbilltype", customParams.get("srcbilltype"), row.getInt(PROD_SEQ) - 1);
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)ENTRY_ENTITY, (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    private void setDefaultLadPrice() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selector = "goods,protocol,protocolentry,auditorg,goods.id,priceentry.qtyfrom,priceentry.qtyto,priceentry.ladprice";
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Long> goodsIds = new ArrayList<Long>(1024);
        for (DynamicObject row : entryentity) {
            if (null == row.getDynamicObject(PROD_NUMBER)) continue;
            Long goodId = row.getDynamicObject(PROD_NUMBER).getLong("id");
            goodsIds.add(goodId);
        }
        QFilter qFilter = new QFilter("goods.id", "in", goodsIds);
        Map customParams = showParameter.getCustomParams();
        if (null == showParameter.getCustomParam("protocolId")) {
            String selectcol = (String)showParameter.getCustomParam("allProd");
            ArrayList allProd = StringConversionUtil.conversion((String)selectcol);
            if (null != allProd) {
                ArrayList<Long> list = new ArrayList<Long>(1024);
                for (String str : allProd) {
                    list.add(Long.parseLong(str));
                }
                if (list.size() > 0) {
                    qFilter.and(new QFilter("id", "in", list));
                }
            }
        } else if (null != customParams.get("protocolId")) {
            Long proticolId = Long.parseLong(String.valueOf(customParams.get("protocolId")));
            qFilter.and(new QFilter("protocol", "=", (Object)proticolId));
        }
        DynamicObjectCollection prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selector, (QFilter[])qFilter.toArray());
        HashMap good_PoolsMap = new HashMap(1024);
        for (int i = 0; i < prodpools.size(); ++i) {
            DynamicObject prod = (DynamicObject)prodpools.get(i);
            String key = prod.getString("goods.id") + prod.getString("protocol") + prod.getString("protocolentry");
            List<Object> pools = new ArrayList<DynamicObject>(1024);
            if (null != good_PoolsMap.get(key)) {
                pools = (List)good_PoolsMap.get(key);
            }
            pools.add(prod);
            good_PoolsMap.put(key, pools);
        }
        IDataModel entryOperate = this.getModel();
        for (DynamicObject row : entryentity) {
            if (row == null || null == row.get(PROD_NUMBER)) continue;
            String goodsId = row.getString("goods.id");
            String protocolId = "0";
            if (null != dataEntity.get("protocolid")) {
                protocolId = dataEntity.getString("protocolid.id");
            }
            String protocolentryId = "0";
            if (null != row.get("protocolentry")) {
                protocolentryId = row.getString("protocolentry.id");
            }
            String key = goodsId + protocolId + protocolentryId;
            List pools = (List)good_PoolsMap.get(key);
            int entrySeq = row.getInt(PROD_SEQ) - 1;
            if (pools == null) continue;
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, entrySeq);
            entryOperate.deleteEntryData("subentryentity");
            boolean ispricetype = false;
            for (DynamicObject pool : pools) {
                BigDecimal qtyto = pool.getBigDecimal("priceentry.qtyto");
                BigDecimal qtyfrom = pool.getBigDecimal("priceentry.qtyfrom");
                BigDecimal ladprice = pool.getBigDecimal("priceentry.ladprice");
                if (ladprice.compareTo(BigDecimal.ZERO) == 0) continue;
                int subRow = entryOperate.createNewEntryRow("subentryentity");
                this.getModel().setValue("qtyto", (Object)qtyto, subRow, entrySeq);
                this.getModel().setValue("qtyfrom", (Object)qtyfrom, subRow, entrySeq);
                this.getModel().setValue("ladprice", (Object)ladprice, subRow, entrySeq);
                this.getModel().setValue("subkey", (Object)qtyfrom, subRow, entrySeq);
                ispricetype = true;
            }
            this.getView().updateView("subentryentity");
            if (ispricetype) {
                this.getModel().setValue("pricetype", (Object)"B", entrySeq);
                continue;
            }
            this.getModel().setValue("pricetype", (Object)"A", entrySeq);
            entryOperate.deleteEntryData("subentryentity");
        }
    }

    private void setEntryData(AbstractFormDataModel model) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selectcol = (String)showParameter.getCustomParam("allProd");
        ArrayList allProd = StringConversionUtil.conversion((String)selectcol);
        ArrayList<Long> list = new ArrayList<Long>(allProd.size());
        for (String str : allProd) {
            list.add(Long.parseLong(str));
        }
        QFilter qFilter = new QFilter("id", "in", list);
        String selector = "goods,auditorg,goods.barcode,goods.id,goods.category,goods.unit,taxprice,price,protocol,protocolentry,priceeffectdate,priceinvaliddate,minorderqty,leadtime";
        DynamicObjectCollection prodpools = QueryServiceHelper.query((String)"ent_prodpool", (String)selector, (QFilter[])qFilter.toArray());
        HashSet<Long> protocolEntryIds = new HashSet<Long>(1024);
        HashMap<Long, DynamicObject> proEntry_EntryDynMap = new HashMap<Long, DynamicObject>(1024);
        for (Object row : prodpools) {
            protocolEntryIds.add(row.getLong("protocolentry"));
        }
        if (protocolEntryIds.size() > 0) {
            selector = "material,materialgroup,unit,auxpty,entryid";
            qFilter = new QFilter("entryid", "in", protocolEntryIds);
            DynamicObjectCollection proEntrys = QueryServiceHelper.query((String)"ent_protocolentry_bd", (String)selector, (QFilter[])qFilter.toArray());
            for (DynamicObject row : proEntrys) {
                proEntry_EntryDynMap.put(row.getLong("entryid"), row);
            }
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int seq = 0;
        for (int i = 0; i < prodpools.size(); ++i) {
            DynamicObject prod = (DynamicObject)prodpools.get(i);
            vs.set(PROD_SEQ, (Object)(seq + 1), seq);
            vs.set(PROD_NUMBER, (Object)prod.getLong("goods.id"), seq);
            vs.set(PROD_CLASS, prod.get("goods.category"), seq);
            vs.set(PROD_UNIT, prod.get("goods.unit"), seq);
            vs.set(PROD_PRICE, prod.get(PROD_PRICE), seq);
            vs.set(PROD_TAXPRICE, prod.get(PROD_TAXPRICE), seq);
            vs.set(PROD_SHOPPRICE, prod.get(PROD_TAXPRICE), seq);
            vs.set(PRICEEFFECTDATE, prod.get(PRICEEFFECTDATE), seq);
            vs.set(PRICEINVALIDDATE, prod.get(PRICEINVALIDDATE), seq);
            vs.set("minorderqty", prod.get("minorderqty"), seq);
            vs.set("leadtime", prod.get("leadtime"), seq);
            vs.set("barcode", prod.get("goods.barcode"), seq);
            if (proEntry_EntryDynMap.containsKey(prod.getLong("protocolentry"))) {
                DynamicObject row = (DynamicObject)proEntry_EntryDynMap.get(prod.getLong("protocolentry"));
                vs.set("protocolentry", (Object)prod.getLong("protocolentry"), seq);
                vs.set("material", (Object)row.getLong("material"), seq);
                if (null != row.get("auxpty")) {
                    vs.set("auxpty", row.get("auxpty"), seq);
                    if (row.get("auxpty") instanceof DynamicObject) {
                        vs.set("auxpty_id", (Object)row.getDynamicObject("auxpty").getLong("id"), seq);
                    } else {
                        vs.set("auxpty_id", row.get("auxpty"), seq);
                    }
                }
            }
            ++seq;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        if (prodpools.size() > 0) {
            model.setValue(ORG, (Object)((DynamicObject)prodpools.get(0)).getLong("auditorg"));
            model.setValue("protocolid", (Object)((DynamicObject)prodpools.get(0)).getLong("protocol"));
        }
    }

    private void setHeadInfo(AbstractFormDataModel model) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (null != model.getValue("protocolid")) {
            String selectors = "org,partyb,bizpartner,remark";
            DynamicObject protocol = (DynamicObject)model.getValue("protocolid");
            QFilter qFilter = new QFilter("id", "=", (Object)protocol.getLong("id"));
            DynamicObject protocols = QueryServiceHelper.queryOne((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
            if (null != protocols) {
                Long orgId = protocols.getLong(ORG);
                model.setValue(ORG, (Object)orgId);
                Long supplierId = protocols.getLong("partyb");
                model.setValue(SUPPLIER, (Object)supplierId);
                Long bizpartner = protocols.getLong(BIZPARTER);
                model.setValue(BIZPARTER, (Object)bizpartner);
                model.setValue("remark", (Object)protocols.getString("remark"));
            }
        } else {
            Long supplierPrt = (Long)showParameter.getCustomParam(SUPPLIER);
            QFilter enterFilter = new QFilter("id", "=", (Object)supplierPrt);
            DynamicObject suppliers = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,name,number,bizpartner", (QFilter[])new QFilter[]{enterFilter});
            if (null != suppliers) {
                model.setValue(SUPPLIER, (Object)supplierPrt);
                model.setValue(BIZPARTER, suppliers.get(BIZPARTER));
            }
        }
        String biztype = (String)showParameter.getCustomParam("biztype");
        if ("download".equals(biztype)) {
            model.setValue("biztype", (Object)"2");
        }
        model.setValue("person", (Object)RequestContext.get().getUserId());
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
    }

    private List<Long> setGoodIds(Map<Long, Long> materiaId_goodMap, List<Long> list, Map<String, Long> entry_goodMap, Map<String, DynamicObject> entry_bdMap, String protocolId) {
        DynamicObject[] dynamicObjectArray;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long supplierPrt = 0L;
        if (null != showParameter.getCustomParam(SUPPLIER)) {
            supplierPrt = (Long)showParameter.getCustomParam(SUPPLIER);
        } else if (null != this.getModel().getValue(SUPPLIER)) {
            DynamicObject sup = (DynamicObject)this.getModel().getValue(SUPPLIER);
            supplierPrt = sup.getLong("id");
        }
        HashSet<Long> goodsIdSet = new HashSet<Long>(1024);
        QFilter qFilter = new QFilter(SUPPLIER, "=", (Object)supplierPrt);
        DynamicObjectCollection ent_prodmanages = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id", (QFilter[])qFilter.toArray());
        for (DynamicObject info : ent_prodmanages) {
            goodsIdSet.add(info.getLong("id"));
        }
        QFilter filter = new QFilter("protocol", "in", (Object)Long.valueOf(protocolId));
        filter.and(PROD_MALLSTATUS, "in", Arrays.asList(MallStatusEnum.SOLD.getVal(), MallStatusEnum.UNSOLD.getVal()));
        HashMap<Long, Date> materiaId_dateMap = new HashMap<Long, Date>(1024);
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods", (QFilter[])filter.toArray());
        ArrayList goodsIdList = new ArrayList(prodPools.size());
        prodPools.forEach(prodPool -> goodsIdList.add(prodPool.getLong(PROD_NUMBER)));
        qFilter = new QFilter("material", "in", list);
        qFilter.and(new QFilter(PROD_NUMBER, "not in", goodsIdList));
        String selectors = "goods,material,modifytime";
        DynamicObjectCollection pmmProdmatmappings = QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)selectors, (QFilter[])qFilter.toArray());
        for (DynamicObject info : pmmProdmatmappings) {
            Long materialId = info.getLong("material");
            Long goodId = info.getLong(PROD_NUMBER);
            Date date = info.getDate("modifytime");
            if (!goodsIdSet.contains(goodId) || 0L == materialId || 0L == goodId) continue;
            if (materiaId_dateMap.get(materialId) != null) {
                Date beforeupDat = (Date)materiaId_dateMap.get(materialId);
                if (!date.after(beforeupDat)) continue;
                materiaId_goodMap.put(materialId, goodId);
                materiaId_dateMap.put(materialId, date);
                continue;
            }
            materiaId_goodMap.put(materialId, goodId);
            materiaId_dateMap.put(materialId, date);
        }
        String entryMapStr = (String)this.getView().getFormShowParameter().getCustomParam("entrymapping");
        HashMap<String, String> entryMap = null;
        if (null == this.getView().getFormShowParameter().getCustomParam("entrymapping")) {
            qFilter = new QFilter("id", "=", (Object)Long.parseLong(protocolId));
            String selector = "entryentity.material,partyb,entryentity.id";
            DynamicObjectCollection ent_protocolCol = QueryServiceHelper.query((String)"ent_protocol", (String)selector, (QFilter[])qFilter.toArray());
            entryMap = new HashMap<String, String>();
            for (Object protocol : ent_protocolCol) {
                entryMap.put(protocol.getString("entryentity.id"), protocol.getString("entryentity.material"));
            }
        } else {
            entryMap = (HashMap<String, String>)SerializationUtils.fromJsonString((String)entryMapStr, Map.class);
        }
        HashSet goodIDs = new HashSet(1024);
        for (Map.Entry entry : materiaId_goodMap.entrySet()) {
            goodIDs.add(entry.getValue());
        }
        list.clear();
        list.addAll(goodIDs);
        HashSet<Long> entryIdSet = new HashSet<Long>(1024);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : entryMap.entrySet()) {
            String proEntryId = (String)entry.getKey();
            String proMaterialId = (String)entry.getValue();
            Long goodId = materiaId_goodMap.get(Long.parseLong(proMaterialId));
            stringBuilder.setLength(0);
            stringBuilder.append(proEntryId).append('_').append(goodId);
            entry_goodMap.put(stringBuilder.toString(), goodId);
            entryIdSet.add(Long.parseLong(proEntryId));
        }
        String entProtocolentrySel = DynamicObjectUtil.getSelectfields((String)"pmm_protocolentry_bd", (boolean)false);
        qFilter = new QFilter("entryid", "in", entryIdSet);
        for (DynamicObject dyn : dynamicObjectArray = BusinessDataServiceHelper.load((String)"pmm_protocolentry_bd", (String)entProtocolentrySel, (QFilter[])qFilter.toArray())) {
            entry_bdMap.put(dyn.getString("id"), dyn);
        }
        return list;
    }

    private void setEntryData(List<Long> list, Map<String, Long> entry_goodMap, Map<String, DynamicObject> entry_bdMap) {
        Map<String, List<DynamicObject>> ladPriceMap = this.getLadPriceMapByProtocolEntryID(entry_bdMap.keySet());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String selectFields = "id,number,name,category,unit,model,price,taxprice,mallstatus,supplier,description,status,barcode";
        QFilter qFilter = new QFilter("id", "in", list);
        DynamicObject[] prods = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> id_goodMap = new HashMap<Long, DynamicObject>(1024);
        for (DynamicObject goods : prods) {
            id_goodMap.put(goods.getLong("id"), goods);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int seq = 0;
        HashMap<Integer, Object> seq_LadPricemap = new HashMap<Integer, Object>(1024);
        if (prods.length == 0) {
            seq = 0;
            for (Map.Entry<String, Long> map1 : entry_goodMap.entrySet()) {
                String[] entryId_materialId = map1.getKey().split("_");
                if (Long.parseLong(entryId_materialId[0]) == 0L) continue;
                vs.set("protocolentry", (Object)entryId_materialId[0], seq);
                if (entry_bdMap.containsKey(entryId_materialId[0])) {
                    DynamicObject entryInfo = entry_bdMap.get(entryId_materialId[0]);
                    this.setEntryDataByProtocol(vs, seq, entryInfo);
                    if ("B".equals(entryInfo.get("entrypricetype"))) {
                        List<DynamicObject> ladPrices = ladPriceMap.get(entryId_materialId[0]);
                        ArrayList<Map> subRows = new ArrayList<Map>(1024);
                        if (null != ladPrices && ladPrices.size() > 0) {
                            for (DynamicObject subRow : ladPrices) {
                                Map subRowMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)subRow);
                                subRows.add(subRowMap);
                            }
                        }
                        seq_LadPricemap.put(seq, subRows);
                    }
                }
                ++seq;
            }
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
            model.endInit();
            this.getView().updateView(ENTRY_ENTITY);
            this.setLadderPriceFromProtocol(seq_LadPricemap);
            return;
        }
        seq = 0;
        for (Map.Entry<String, Long> map1 : entry_goodMap.entrySet()) {
            String[] entryId_materialId = map1.getKey().split("_");
            if (null == map1.getValue()) {
                if (Long.parseLong(entryId_materialId[0]) == 0L) continue;
                this.setEntryForNull(vs, seq);
            } else if (id_goodMap.containsKey(map1.getValue())) {
                DynamicObject prod = (DynamicObject)id_goodMap.get(map1.getValue());
                if (null != prod) {
                    vs.set(PROD_SEQ, (Object)(seq + 1), seq);
                    vs.set(PROD_NUMBER, (Object)prod.getLong("id"), seq);
                    vs.set(PROD_CLASS, (DynamicObject)prod.get("category") == null ? null : Long.valueOf(((DynamicObject)prod.get("category")).getLong("id")), seq);
                    if (null != prod.get(PROD_UNIT)) {
                        vs.set(PROD_UNIT, (DynamicObject)prod.get(PROD_UNIT) == null ? null : Long.valueOf(((DynamicObject)prod.get(PROD_UNIT)).getLong("id")), seq);
                    }
                    vs.set(PROD_PRICE, prod.get(PROD_PRICE), seq);
                    vs.set(PROD_TAXPRICE, prod.get(PROD_TAXPRICE), seq);
                    vs.set(PROD_SHOPPRICE, prod.get(PROD_TAXPRICE), seq);
                    vs.set("barcode", prod.get("barcode"), seq);
                }
            } else {
                this.setEntryForNull(vs, seq);
            }
            vs.set("protocolentry", (Object)entryId_materialId[0], seq);
            if (entry_bdMap.containsKey(entryId_materialId[0])) {
                DynamicObject entryInfo = entry_bdMap.get(entryId_materialId[0]);
                this.setEntryDataByProtocol(vs, seq, entryInfo);
                if ("B".equals(entryInfo.get("entrypricetype"))) {
                    List<DynamicObject> ladPrices = ladPriceMap.get(entryId_materialId[0]);
                    ArrayList<Map> subRows = new ArrayList<Map>(1024);
                    if (null != ladPrices && ladPrices.size() > 0) {
                        for (DynamicObject subRow : ladPrices) {
                            Map subRowMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)subRow);
                            subRows.add(subRowMap);
                        }
                    }
                    seq_LadPricemap.put(seq, subRows);
                }
            }
            ++seq;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
        this.setLadderPriceFromProtocol(seq_LadPricemap);
    }

    private Map<String, List<DynamicObject>> getLadPriceMapByProtocolEntryID(Set<String> protocolEntryIds) {
        HashMap<String, List<DynamicObject>> entryId_LadPriceMap = new HashMap<String, List<DynamicObject>>(1024);
        if (protocolEntryIds.size() == 0) {
            return entryId_LadPriceMap;
        }
        HashSet<Long> newEntryIdSet = new HashSet<Long>(1024);
        for (String key : protocolEntryIds) {
            newEntryIdSet.add(Long.parseLong(key));
        }
        String ladSelectors = "entryentity1.id,entryentity1.subentryentity.qtyfrom,entryentity1.subentryentity.qtyto,entryentity1.subentryentity.ladprice";
        QFilter qFilter = new QFilter("entryentity1.id", "in", newEntryIdSet);
        DynamicObjectCollection pmm_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)ladSelectors, (QFilter[])qFilter.toArray());
        for (DynamicObject row : pmm_protocols) {
            String entryId = row.getString("entryentity1.id");
            List<Object> ladpriceEntrys = new ArrayList<DynamicObject>(1024);
            if (null != entryId_LadPriceMap.get(entryId)) {
                ladpriceEntrys = (List)entryId_LadPriceMap.get(entryId);
            }
            ladpriceEntrys.add(row);
            entryId_LadPriceMap.put(entryId, ladpriceEntrys);
        }
        return entryId_LadPriceMap;
    }

    private void setEntryDataByProtocol(TableValueSetter vs, int seq, DynamicObject entryInfo) {
        if (null != entryInfo.getDynamicObject("material")) {
            vs.set("material", (Object)entryInfo.getDynamicObject("material"), seq);
            vs.set("material_id", entryInfo.getDynamicObject("material").getPkValue(), seq);
        }
        if (null != entryInfo.get("auxpty")) {
            vs.set("auxpty", entryInfo.get("auxpty"), seq);
            if (entryInfo.get("auxpty") instanceof DynamicObject) {
                vs.set("auxpty_id", (Object)entryInfo.getDynamicObject("auxpty").getLong("id"), seq);
            } else {
                vs.set("auxpty_id", entryInfo.get("auxpty"), seq);
            }
        }
        vs.set(PRICEEFFECTDATE, (Object)entryInfo.getDate(PRICEEFFECTDATE), seq);
        vs.set(PRICEINVALIDDATE, (Object)entryInfo.getDate(PRICEINVALIDDATE), seq);
        vs.set("pricetype", entryInfo.get("entrypricetype"), seq);
        vs.set("minorderqty", entryInfo.get("minorderqty"), seq);
        vs.set("leadtime", entryInfo.get("leadtime"), seq);
    }

    private void setEntryForNull(TableValueSetter vs, int seq) {
        vs.set(PROD_SEQ, (Object)(seq + 1), seq);
        vs.set(PROD_NUMBER, null, seq);
        vs.set(PROD_CLASS, null, seq);
        vs.set(PROD_UNIT, null, seq);
        vs.set(PROD_PRICE, null, seq);
        vs.set(PROD_TAXPRICE, null, seq);
        vs.set(PROD_SHOPPRICE, null, seq);
    }

    private void setLadderPriceFromProtocol(Map<Integer, Object> seq_ladPricemap) {
        IDataModel entryOperate = this.getModel();
        for (Map.Entry<Integer, Object> map : seq_ladPricemap.entrySet()) {
            List subRows = (List)map.getValue();
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, map.getKey().intValue());
            entryOperate.deleteEntryData("subentryentity");
            List<Object> ladderPriceInfos = new ArrayList(1024);
            for (Object subRow : subRows) {
                entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, map.getKey().intValue());
                Map subRowMap = (Map)subRow;
                int subIndex = entryOperate.createNewEntryRow("subentryentity");
                BigDecimal qtyfrom = BigDecimal.ZERO;
                if (null != subRowMap.get("entryentity1.subentryentity.qtyfrom")) {
                    qtyfrom = new BigDecimal(String.valueOf(subRowMap.get("entryentity1.subentryentity.qtyfrom")));
                }
                BigDecimal qtyto = BigDecimal.ZERO;
                if (null != subRowMap.get("entryentity1.subentryentity.qtyto")) {
                    qtyto = new BigDecimal(String.valueOf(subRowMap.get("entryentity1.subentryentity.qtyto")));
                }
                BigDecimal ladprice = BigDecimal.ZERO;
                if (null != subRowMap.get("entryentity1.subentryentity.ladprice")) {
                    ladprice = new BigDecimal(String.valueOf(subRowMap.get("entryentity1.subentryentity.ladprice")));
                }
                this.getModel().setValue("qtyfrom", (Object)qtyfrom, subIndex, map.getKey().intValue());
                this.getModel().setValue("qtyto", (Object)qtyto, subIndex, map.getKey().intValue());
                this.getModel().setValue("ladprice", (Object)ladprice, subIndex, map.getKey().intValue());
                this.getModel().setValue("subkey", subRowMap.get("entryentity1.subentryentity.qtyfrom"), subIndex, map.getKey().intValue());
                LadderPriceInfo info = new LadderPriceInfo(qtyfrom, qtyto, ladprice, Long.valueOf(0L));
                ladderPriceInfos.add(info);
            }
            if ((ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList())).size() <= 0) continue;
            DynamicObject entryprod = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY).get(map.getKey().intValue());
            BigDecimal ladprice = ((LadderPriceInfo)ladderPriceInfos.get(0)).getLadprice();
            this.getModel().setValue(PROD_TAXPRICE, (Object)ladprice, map.getKey().intValue());
            DynamicObject prod = entryprod.getDynamicObject(PROD_NUMBER);
            BigDecimal price = BigDecimal.ZERO;
            if (null == prod) continue;
            BigDecimal taxRate = prod.getBigDecimal(PROD_TAXRATE);
            int taxtype = prod.getInt("taxtype");
            price = 0 == taxtype ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)ladprice, (int)2) : CalculateUtils.calPrice((BigDecimal)ladprice, (BigDecimal)taxRate, (int)2);
            this.getModel().setValue(PROD_PRICE, (Object)price, map.getKey().intValue());
            this.getModel().setValue(PROD_SHOPPRICE, (Object)ladprice, map.getKey().intValue());
        }
    }

    private void setPriceEffectDefaultValue() {
        this.setProtocolEffectDefaultValue();
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        List<Long> goodsIds = entryEntity.stream().filter(entry -> entry.getDynamicObject(PROD_NUMBER) != null).map(entry -> entry.getDynamicObject(PROD_NUMBER).getLong("id")).collect(Collectors.toList());
        this.setGoodsEffectDateToEntry(goodsIds);
    }

    private void setProtocolEffectDefaultValue() {
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        if (protocol == null) {
            return;
        }
        Date protocolEffectDate = protocol.getDate("effectdate");
        Date protocolInvalidDate = protocol.getDate("invaliddate");
        this.getPageCache().put("protocolEffectDate", DateUtil.date2str((Date)protocolEffectDate, (String)YYYY_MM_DD));
        this.getPageCache().put("protocolInvalidDate", DateUtil.date2str((Date)protocolInvalidDate, (String)YYYY_MM_DD));
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        this.getModel().beginInit();
        for (DynamicObject entry : entryEntity) {
            if (entry.get(PROD_NUMBER) == null) continue;
            if (null == entry.getDate(PRICEEFFECTDATE)) {
                entry.set(PRICEEFFECTDATE, (Object)protocolEffectDate);
            }
            if (null != entry.getDate(PRICEINVALIDDATE)) continue;
            entry.set(PRICEINVALIDDATE, (Object)protocolInvalidDate);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setGoodsEffectDateToEntry(List<Long> goodsIds) {
        QFilter qFilter = new QFilter(PROD_NUMBER, "in", goodsIds);
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        if (protocol != null) {
            qFilter.and(new QFilter("protocol", "=", (Object)protocol.getLong("id")));
        } else {
            qFilter.and(new QFilter("protocol", "=", (Object)0L).or(new QFilter("protocol", "is null", (Object)0L)));
        }
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods,priceinvaliddate", (QFilter[])qFilter.toArray());
        HashMap prodAndDateMap = new HashMap(prodPools.size());
        prodPools.forEach(prodPool -> prodAndDateMap.put(prodPool.getLong(PROD_NUMBER), prodPool.getDate(PRICEINVALIDDATE)));
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        this.getModel().beginInit();
        for (DynamicObject entry : entryEntity) {
            long entryGoodsId = entry.getLong("goods_id");
            if (prodAndDateMap.get(entryGoodsId) == null) continue;
            Date addDays = DateUtil.addDays((Date)((Date)prodAndDateMap.get(entryGoodsId)), (int)1);
            entry.set(PRICEEFFECTDATE, (Object)addDays);
            Object priceInvalidDate = entry.get(PRICEINVALIDDATE);
            if (priceInvalidDate == null || !addDays.after((Date)priceInvalidDate)) continue;
            entry.set(PRICEEFFECTDATE, priceInvalidDate);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void afterBindData(EventObject e) {
        String param;
        super.afterBindData(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_export", "protocolid", "protocolentry", "proentryseq", "material", "materialname", "proprice", "protaxrate", "protaxprice", "promodel", "prounit", "auxpty", PRICEEFFECTDATE, PRICEINVALIDDATE, "advconbaritemap", "leadtime", "minorderqty", "barcode", "purorgnap"});
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (null == model.getValue("protocolid") || model.getValue("biztype").equals("2")) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
            view.setEnable(Boolean.FALSE, new String[]{ORG, SUPPLIER});
        }
        this.setMustInput(model);
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        if (protocol != null) {
            Date protocolEffectDate = protocol.getDate("effectdate");
            Date protocolInvalidDate = protocol.getDate("invaliddate");
            this.getPageCache().put("protocolEffectDate", DateUtil.date2str((Date)protocolEffectDate, (String)YYYY_MM_DD));
            this.getPageCache().put("protocolInvalidDate", DateUtil.date2str((Date)protocolInvalidDate, (String)YYYY_MM_DD));
        }
        if (Boolean.parseBoolean(param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pricetype", "ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pricetype", "ladderprice"});
        }
        String biztype = (String)this.getModel().getValue("biztype");
        if ("2".equals(biztype)) {
            this.downloadView();
        }
        this.setPricelimit();
        Object cfmstatus = this.getModel().getValue("cfmstatus");
        if ("C".equals(cfmstatus) || "D".equals(cfmstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"resubmit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"resubmit"});
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("pmm_goodsrulelog".equals(customParams.get("srcbilltype")) && "2".equals(biztype)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
            DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject row : entrys) {
                this.getView().setEnable(Boolean.FALSE, row.getInt(PROD_SEQ) - 1, new String[]{PROD_NUMBER});
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setPricelimit();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        if (this.getView().getParentView() != null && (Boolean.parseBoolean((String)AppCache.get((String)this.getView().getParentView().getPageId()).get("resubmit", String.class)) || Boolean.parseBoolean((String)AppCache.get((String)this.getView().getPageId()).get("resubmit", String.class)))) {
            AppCache.get((String)this.getView().getParentView().getPageId()).remove("resubmit");
            AppCache.get((String)this.getView().getPageId()).remove("resubmit");
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            ArrayList<Integer> indexs = new ArrayList<Integer>(1024);
            for (DynamicObject row : entrys) {
                String entryresult = row.getString("entryresult");
                if (!"1".equals(entryresult)) continue;
                indexs.add(row.getInt(PROD_SEQ) - 1);
            }
            if (indexs.size() > 0) {
                int[] removeIndexs = new int[indexs.size()];
                for (int i = 0; i < indexs.size(); ++i) {
                    removeIndexs[i] = (Integer)indexs.get(i);
                }
                this.getPageCache().put("option", "resubmit");
                this.getModel().deleteEntryRows(ENTRY_ENTITY, removeIndexs);
            }
            this.getModel().setDataChanged(false);
        }
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue("entryresult", (Object)"1", i);
        }
        this.setPricelimit();
    }

    private void setPricelimit() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (DynamicObject row : entryCols) {
            DynamicObject goods = row.getDynamicObject(PROD_NUMBER);
            if (null == goods) continue;
            String mallstatus = goods.getString(PROD_MALLSTATUS);
            if (MallStatusEnum.TEMPSTATUS.getVal().equals(mallstatus)) continue;
            goodsIds.add(goods.getLong("id"));
        }
        Map<String, DynamicObject> prodPoolMap = this.getProPoolMap(goodsIds);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        for (DynamicObject row : entryCols) {
            DynamicObject goods = row.getDynamicObject(PROD_NUMBER);
            BigDecimal reqTaxPrice = row.getBigDecimal(PROD_TAXPRICE);
            this.setPricelimitValue(goods, row.getInt(PROD_SEQ) - 1, reqTaxPrice, prodPoolMap, cellStyles);
        }
        if (cellStyles.size() > 0) {
            grid.setCellStyle(cellStyles);
        }
    }

    private Map<String, DynamicObject> getProPoolMap(Set<Long> goodsIds) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        HashMap<String, DynamicObject> prodPoolMap = new HashMap<String, DynamicObject>(16);
        String billstatus = dataEntity.getString("billstatus");
        if (goodsIds.size() > 0) {
            QFilter qFilter = new QFilter("goods.id", "in", goodsIds);
            DynamicObjectCollection ent_prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.id,id,taxprice,protocol,protocolentry", (QFilter[])qFilter.toArray());
            for (DynamicObject row : ent_prodpools) {
                String key = row.getString("goods.id") + row.getString("protocol") + row.getString("protocolentry");
                prodPoolMap.put(key, row);
            }
            if (!"A".equals(billstatus) && !"B".equals(billstatus)) {
                String id = dataEntity.getString("id");
                QFilter logQFilter = new QFilter("goods.id", "in", goodsIds);
                logQFilter.and(new QFilter("srcbillid", "=", (Object)id));
                DynamicObjectCollection newPricelog = QueryServiceHelper.query((String)"pmm_newpricelog", (String)"adjustdate,goods.id,id,lastprice taxprice,goodspool.protocol protocol,goodspool.protocolentry protocolentry", (QFilter[])logQFilter.toArray(), (String)"adjustdate asc");
                for (DynamicObject row : newPricelog) {
                    String key = row.getString("goods.id") + row.getString("protocol") + row.getString("protocolentry");
                    prodPoolMap.put(key, row);
                }
            }
        }
        return prodPoolMap;
    }

    private void setPricelimitValue(DynamicObject goods, int seq, BigDecimal reqTaxPrice, Map<String, DynamicObject> prodPoolMap, ArrayList<CellStyle> cellStyles) {
        String protocolEntryId = "0";
        String protocolId = "0";
        BigDecimal hundred = new BigDecimal("100");
        BigDecimal divTaxPrice = BigDecimal.ZERO;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject protocol = dataEntity.getDynamicObject("protocolid");
        DynamicObject protocolentry = null;
        if (null != this.getModel().getValue("protocolentry", seq)) {
            protocolentry = (DynamicObject)this.getModel().getValue("protocolentry", seq);
            protocolEntryId = protocolentry.getString("id");
        }
        BigDecimal taxPrice = BigDecimal.ZERO;
        if (null != protocol) {
            protocolId = protocol.getString("id");
        }
        if (null != goods) {
            String mallstatus = goods.getString(PROD_MALLSTATUS);
            if (MallStatusEnum.TEMPSTATUS.getVal().equals(mallstatus)) {
                taxPrice = goods.getBigDecimal(PROD_TAXPRICE);
            } else {
                String key = goods.getString("id") + protocolId + protocolEntryId;
                if (null != prodPoolMap.get(key)) {
                    DynamicObject prodPool = prodPoolMap.get(key);
                    taxPrice = prodPool.getBigDecimal(PROD_TAXPRICE);
                } else {
                    taxPrice = goods.getBigDecimal(PROD_TAXPRICE);
                }
            }
            String biztype = dataEntity.getString("biztype");
            if ("2".equals(biztype)) {
                taxPrice = reqTaxPrice;
            }
            divTaxPrice = taxPrice;
            if (taxPrice.compareTo(BigDecimal.ZERO) > 0 && divTaxPrice.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newTaxPrice = reqTaxPrice.subtract(taxPrice);
                if (newTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal multiply = newTaxPrice.divide(divTaxPrice, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
                    if (newTaxPrice.compareTo(BigDecimal.ZERO) > 0) {
                        this.getModel().setValue("pricelimit", (Object)(multiply + "%"), seq);
                        cellStyles.add(this.getCellStyle("#D9001B", "pricelimit", seq));
                    } else {
                        this.getModel().setValue("pricelimit", (Object)(multiply + "%"), seq);
                        cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
                    }
                } else {
                    this.getModel().setValue("pricelimit", (Object)"-", seq);
                    cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
                }
            } else {
                this.getModel().setValue("pricelimit", (Object)"-", seq);
                cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
            }
            this.getModel().setValue("beforesetprice", (Object)divTaxPrice, seq);
            if (null != protocolentry) {
                BigDecimal protaxprice = protocolentry.getBigDecimal(PROD_TAXPRICE);
                if (protaxprice.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal newTaxPrice = reqTaxPrice.subtract(protaxprice);
                    if (newTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal protocolpricelimit = newTaxPrice.divide(protaxprice, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
                        if (newTaxPrice.compareTo(BigDecimal.ZERO) > 0) {
                            this.getModel().setValue("protocolpricelimit", (Object)(protocolpricelimit + "%"), seq);
                            cellStyles.add(this.getCellStyle("#D9001B", "protocolpricelimit", seq));
                        } else {
                            this.getModel().setValue("protocolpricelimit", (Object)(protocolpricelimit + "%"), seq);
                            cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
                        }
                    } else {
                        this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
                        cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
                    }
                } else {
                    this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
                    cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
                }
            }
        }
    }

    private CellStyle getCellStyle(String foreColor, String fieldName, int seq) {
        CellStyle cs = new CellStyle();
        cs.setForeColor(foreColor);
        cs.setRow(seq);
        cs.setFieldKey(fieldName);
        return cs;
    }

    private void downloadView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_export", "quickcreategoods", "bar_import", "bar_refresh", "advconbaritemap"});
        this.getView().setEnable(Boolean.FALSE, new String[]{ORG, "protocolid"});
        this.getView().setEnable(Boolean.FALSE, -1, new String[]{PRICEEFFECTDATE, PRICEINVALIDDATE, PROD_CLASS, "pricetype", PROD_TAXPRICE, "minorderqty", "leadtime", "barcode"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            if (null == this.getModel().getValue("protocolid") || this.getModel().getValue("biztype").equals("2")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
            }
        }
        if ("resubmit".equals(key) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            AppCache.get((String)this.getView().getPageId()).put("resubmit", (Object)"true");
            this.getView().invokeOperation("copy");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save") || StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit")) {
            this.getPageCache().put("option", "save");
            this.checkGoodsUnqiue(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"deleteentry")) {
            this.getPageCache().put("option", "deleteentry");
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"setladderprice")) {
            this.setLadderPrice(args);
        }
        if ((StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"exportlist") || StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"importdata")) && this.getModel().getDataEntity(true).getPkValue().equals(0L)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u4e00\u4e0b\u3002", (String)"PmmProdAuditProtocolEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"viewpurorg")) {
            this.viewPurOrg(args);
        }
    }

    private void viewPurOrg(BeforeDoOperationEventArgs args) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObject goods = row.getDynamicObject(PROD_NUMBER);
        DynamicObject protocolentry = row.getDynamicObject("protocolentry");
        DynamicObject protocolid = dataEntity.getDynamicObject("protocolid");
        if (null == goods && null == protocolid || null != protocolid && null == goods) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5546\u54c1\u518d\u67e5\u770b\u91c7\u4e70\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"PmmProdAuditProtocolEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmm_orgscopesetting");
        ArrayList<Long> goodsIds = new ArrayList<Long>(1024);
        if (null != goods) {
            goodsIds.add(goods.getLong("id"));
        }
        detailParamMap.put("goodsid", goodsIds);
        if (null != protocolentry) {
            detailParamMap.put("protocolentryid", protocolentry.getLong("id"));
        }
        if (null != protocolid) {
            detailParamMap.put("protocolid", protocolid.getLong("id"));
            detailParamMap.put("differentarea", protocolid.getBoolean("differentarea"));
        }
        detailParamMap.put("status", "0");
        showParameter.setCustomParams(detailParamMap);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "viewpurorg"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    /*
     * WARNING - void declaration
     */
    private void checkGoodsUnqiue(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject protocolid = dataEntity.getDynamicObject("protocolid");
        if (null == protocolid || !protocolid.getBoolean("differentarea")) {
            return;
        }
        HashMap<String, void> purPlanId_SeqsMap = new HashMap<String, void>(1024);
        for (Object row : entryCol) {
            void var8_8;
            if (null == row.getDynamicObject(PROD_NUMBER)) continue;
            ArrayList arrayList = new ArrayList(1024);
            String key = row.getDynamicObject("protocolentry").getDynamicObject("purplanid").getString("id") + row.getDynamicObject(PROD_NUMBER).getString("id");
            if (null != purPlanId_SeqsMap.get(key)) {
                List list = (List)purPlanId_SeqsMap.get(key);
            }
            var8_8.add(row.getInt(PROD_SEQ));
            purPlanId_SeqsMap.put(key, var8_8);
        }
        ArrayList seqList = new ArrayList(1024);
        for (Map.Entry entry : purPlanId_SeqsMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            seqList.addAll((Collection)entry.getValue());
        }
        if (seqList.size() > 0) {
            Collections.sort(seqList);
            StringBuilder stringBuilder = new StringBuilder();
            for (Integer seq : seqList) {
                DynamicObject row = (DynamicObject)entryCol.get(seq - 1);
                String number = row.getDynamicObject(PROD_NUMBER).getString("number");
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u5546\u54c1\u7f16\u7801\uff1a{1}\uff1b", (String)"PmmProdAuditProtocolEdit_5", (String)"scm-pmm-formplugin", (Object[])new Object[]{seq, number});
                stringBuilder.append(msg).append('\n');
            }
            String string = ResManager.loadKDString((String)"\u4e00\u4e2a\u91c7\u4e70\u65b9\u6848\u4e0b\u4e0d\u5141\u8bb8\u51fa\u73b0\u91cd\u590d\u5546\u54c1\u3002", (String)"PmmProdAuditProtocolEdit_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(string, stringBuilder.toString(), MessageTypes.Default);
            args.setCancel(true);
        }
    }

    private void setLadderPrice(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        if ("A".equals((row = (DynamicObject)entryCol.get(rowIndex)).getString("pricetype"))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u4ef7\u683c\u7c7b\u578b\u4e3a\u9636\u68af\u4ef7\u624d\u80fd\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"PmmProdAuditProtocolEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        BigDecimal minorderqty = row.getBigDecimal("minorderqty");
        if (minorderqty.compareTo(BigDecimal.ZERO) == 0) {
            minorderqty = BigDecimal.ZERO;
        }
        DynamicObjectCollection subEntryRows = row.getDynamicObjectCollection("subentryentity");
        List<Object> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
        for (DynamicObject subrow : subEntryRows) {
            if (subrow.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) <= 0) continue;
            LadderPriceInfo info = new LadderPriceInfo(subrow.getBigDecimal("qtyfrom"), subrow.getBigDecimal("qtyto"), subrow.getBigDecimal("ladprice"), Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id")));
            ladderPriceInfos.add(info);
        }
        BigDecimal price = row.getBigDecimal(PROD_TAXPRICE);
        if (ladderPriceInfos.size() < 2) {
            ladderPriceInfos.clear();
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty, minorderqty.add(BigDecimal.ONE), price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty.add(BigDecimal.ONE), BigDecimal.ZERO, price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        Object billstatus = this.getModel().getValue("billstatus");
        Object biztype = this.getModel().getValue("biztype");
        if ("A".equals(billstatus) && "1".equals(biztype)) {
            detailParamMap.put("status", "0");
        } else {
            detailParamMap.put("status", "1");
        }
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"setladderprice")) {
            this.doSetladderprice(e);
        }
    }

    private void doSetladderprice(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (null != returnData) {
            Map returnDataMap = (Map)returnData;
            List entryList = (List)returnDataMap.get("entry");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("subentryentity");
            int index = 0;
            BigDecimal price = BigDecimal.ZERO;
            for (LadderPriceInfo info : entryList) {
                vs.set("qtyfrom", (Object)info.getQtyfrom(), index);
                vs.set("qtyto", (Object)info.getQtyto(), index);
                vs.set("ladprice", (Object)info.getLadprice(), index);
                if (index == 0) {
                    price = info.getLadprice();
                }
                ++index;
            }
            model.beginInit();
            model.batchCreateNewEntryRow("subentryentity", vs);
            model.endInit();
            this.getView().updateView("subentryentity");
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectRows = grid.getSelectRows();
            int rowIndex = selectRows[0];
            if (null != this.getPageCache().get("row")) {
                rowIndex = Integer.parseInt(this.getPageCache().get("row"));
                this.getPageCache().remove("row");
            }
            this.getModel().setValue(PROD_TAXPRICE, (Object)price, rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        ArrayList<Long> goodIds = new ArrayList<Long>(1024);
        boolean isDel = true;
        for (int index : rowIndexs) {
            DynamicObject good;
            if (null != this.getModel().getValue(PROD_NUMBER, index) && "A".equals((good = (DynamicObject)this.getModel().getValue(PROD_NUMBER, index)).getString("status"))) {
                goodIds.add(good.getLong("id"));
            }
            if (null == this.getModel().getValue("protocolentry", index)) continue;
            isDel = false;
            break;
        }
        String option = this.getPageCache().get("option");
        String biztype = (String)this.getModel().getValue("biztype");
        if (!isDel && option != null && !"save".equals(option) && !"resubmit".equals(option) && "1".equals(biztype)) {
            if ("deleteentry".equals(option)) {
                String msg = ResManager.loadKDString((String)"\u5173\u8054\u534f\u8bae\u6e05\u5355\u7684\u5546\u54c1\u660e\u7ec6\u5206\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdAuditProtocolEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
            e.setCancel(true);
        }
        if ("save".equals(option) || option == null) {
            e.setCancel(true);
        }
        if (goodIds.size() > 0) {
            this.getPageCache().put(PROD_NUMBER, SerializationUtils.toJsonString(goodIds));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String property = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (property) {
            case "goods": {
                this.doProdChange(model, property, rowIndex, oldValue);
                this.doPriceLimitChange(e);
                break;
            }
            case "priceeffectdate": {
                this.doPriceEffectDateChange(e);
                break;
            }
            case "priceinvaliddate": {
                this.doPriceInvalidDateChange(e);
                break;
            }
            case "minorderqty": {
                this.doMinorderqtyChange(e);
                break;
            }
            case "taxprice": {
                this.doPriceLimitChange(e);
                break;
            }
        }
    }

    private void doPriceLimitChange(PropertyChangedArgs arg0) {
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        if (null != this.getModel().getValue(PROD_NUMBER, rowIndex)) {
            DynamicObject goods = (DynamicObject)this.getModel().getValue(PROD_NUMBER, rowIndex);
            String mallstatus = goods.getString(PROD_MALLSTATUS);
            if (!MallStatusEnum.TEMPSTATUS.getVal().equals(mallstatus)) {
                goodsIds.add(goods.getLong("id"));
            }
            Map<String, DynamicObject> prodPoolMap = this.getProPoolMap(goodsIds);
            BigDecimal reqTaxPrice = BigDecimal.ZERO;
            if (null != this.getModel().getValue(PROD_TAXPRICE, rowIndex)) {
                reqTaxPrice = (BigDecimal)this.getModel().getValue(PROD_TAXPRICE, rowIndex);
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            this.setPricelimitValue(goods, rowIndex, reqTaxPrice, prodPoolMap, cellStyles);
            if (cellStyles.size() > 0) {
                grid.setCellStyle(cellStyles);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"minorderqty", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                IDataModel entryOperate = this.getModel();
                entryOperate.deleteEntryData("subentryentity");
            } else {
                String qtyStr = this.getPageCache().get("minorderqty");
                String rowIndex = this.getPageCache().get("rowIndex");
                this.getModel().setValue("minorderqty", (Object)new BigDecimal(qtyStr), Integer.parseInt(rowIndex));
            }
        }
    }

    private void doMinorderqtyChange(PropertyChangedArgs arg0) {
        Object newValue = arg0.getChangeSet()[0].getNewValue();
        Object oldValue = arg0.getChangeSet()[0].getOldValue();
        BigDecimal newMinOrderQty = CommonUtil.getBigDecimalPro((Object)newValue);
        if (newMinOrderQty.compareTo(CommonUtil.getBigDecimalPro((Object)oldValue)) == 0) {
            return;
        }
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        model.setValue("minorderqty", (Object)newMinOrderQty.setScale(0, RoundingMode.FLOOR), rowIndex);
        DynamicObjectCollection entryCol = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
        if (subentryentity.size() > 1) {
            DynamicObject subrow = (DynamicObject)subentryentity.get(0);
            if (newMinOrderQty.compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("qtyfrom", (Object)BigDecimal.ZERO, 0, rowIndex);
            } else {
                BigDecimal minqty = new BigDecimal(String.valueOf(newValue));
                BigDecimal qtyto = subrow.getBigDecimal("qtyto");
                if (minqty.compareTo(BigDecimal.ZERO) == 0) {
                    model.setValue("qtyfrom", (Object)BigDecimal.ZERO, 0, rowIndex);
                    return;
                }
                if (minqty.compareTo(qtyto) < 0) {
                    model.setValue("qtyfrom", (Object)minqty, 0, rowIndex);
                } else if ("A".equals(model.getValue("pricetype"))) {
                    IDataModel entryOperate = this.getModel();
                    entryOperate.deleteEntryData("subentryentity");
                } else {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("minorderqty", (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9636\u68af\u4ef7\uff0c\u4fee\u6539\u8d77\u8ba2\u91cf\u540e\u6e05\u7a7a\u9636\u68af\u4ef7\uff0c\u9700\u91cd\u8bbe\u3002", (String)"PmmProdAuditProtocolEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                    this.getPageCache().put("minorderqty", String.valueOf(oldValue));
                    this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                }
            }
        }
    }

    private void doProdChange(IDataModel model, String property, int rowIndex, Object oldValue) {
        DynamicObject newObject = (DynamicObject)model.getValue(property, rowIndex);
        if (newObject == null) {
            model.setValue("beforesetprice", null, rowIndex);
            model.setValue("pricelimit", null, rowIndex);
            model.setValue("protocolpricelimit", null, rowIndex);
            if (null != oldValue) {
                ArrayList<Object> goodIds = new ArrayList<Object>(1024);
                DynamicObject good = (DynamicObject)oldValue;
                if ("A".equals(good.getString("status"))) {
                    goodIds.add(good.getLong("id"));
                }
                if (goodIds.size() > 0) {
                    this.deleteSaveGoods(goodIds);
                }
            }
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, rowIndex);
            entryOperate.deleteEntryData("subentryentity");
            if (null == model.getValue("protocolentry", rowIndex)) {
                model.setValue(PRICEEFFECTDATE, null, rowIndex);
                model.setValue(PRICEINVALIDDATE, null, rowIndex);
            }
            return;
        }
        this.prodChangePriceEffectValueSet(rowIndex, newObject);
    }

    private void deleteSaveGoods(List<Object> goods) {
        ArrayList<Long> goodIds = new ArrayList<Long>(1024);
        for (Object id : goods) {
            goodIds.add(Long.parseLong(String.valueOf(id)));
        }
        if (goodIds.size() > 0) {
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_prodmanage", (Object[])goodIds.toArray(), (OperateOption)saveOption);
            if (!deleteResullt.isSuccess()) {
                log.error(ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo()));
            } else {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            }
        }
    }

    private void prodChangePriceEffectValueSet(int rowIndex, DynamicObject prod) {
        String protocolInvalidDateStr;
        String biztype = (String)this.getModel().getValue("biztype");
        if ("2".equals(biztype)) {
            return;
        }
        String protocolEffectDateStr = this.getPageCache().get("protocolEffectDate");
        if (StringUtils.isNotBlank((CharSequence)protocolEffectDateStr) && null == this.getModel().getValue(PRICEEFFECTDATE, rowIndex)) {
            this.getModel().setValue(PRICEEFFECTDATE, (Object)DateUtil.string2date((String)protocolEffectDateStr, (String)YYYY_MM_DD), rowIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)(protocolInvalidDateStr = this.getPageCache().get("protocolInvalidDate"))) && null == this.getModel().getValue(PRICEINVALIDDATE, rowIndex)) {
            this.getModel().setValue(PRICEINVALIDDATE, (Object)DateUtil.string2date((String)protocolInvalidDateStr, (String)YYYY_MM_DD), rowIndex);
        }
        ArrayList<Long> goodsIds = new ArrayList<Long>(8);
        goodsIds.add(prod.getLong("id"));
        this.setGoodsEffectDateToEntry(goodsIds);
    }

    private void doPriceEffectDateChange(PropertyChangedArgs arg0) {
        String protocolEffectDateStr = this.getPageCache().get("protocolEffectDate");
        Object newValue = arg0.getChangeSet()[0].getNewValue();
        Object oldValue = arg0.getChangeSet()[0].getOldValue();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        String biztype = (String)this.getModel().getValue("biztype");
        if (newValue == null || biztype.equals("2")) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)protocolEffectDateStr)) {
            Date protocolEffectDate = DateUtil.string2date((String)protocolEffectDateStr, (String)YYYY_MM_DD);
            if (newValue != null && protocolEffectDate.after((Date)newValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProdAuditProtocolEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue(PRICEEFFECTDATE, oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView(ENTRY_ENTITY);
                return;
            }
        }
        Object priceInvalidDate = this.getModel().getValue(PRICEINVALIDDATE, rowIndex);
        if (newValue != null && priceInvalidDate != null && ((Date)newValue).after((Date)priceInvalidDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProdAuditProtocolEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(PRICEEFFECTDATE, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            return;
        }
    }

    private void doPriceInvalidDateChange(PropertyChangedArgs arg0) {
        String protocolInvalidDateStr = this.getPageCache().get("protocolInvalidDate");
        Object newValue = arg0.getChangeSet()[0].getNewValue();
        Object oldValue = arg0.getChangeSet()[0].getOldValue();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        String biztype = (String)this.getModel().getValue("biztype");
        if (newValue == null || biztype.equals("2")) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)protocolInvalidDateStr)) {
            Date protocolInvalidDate = DateUtil.string2date((String)protocolInvalidDateStr, (String)YYYY_MM_DD);
            if (newValue != null && protocolInvalidDate.before((Date)newValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProdAuditProtocolEdit_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue(PRICEINVALIDDATE, oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView(ENTRY_ENTITY);
                return;
            }
        }
        Object priceEffectDate = this.getModel().getValue(PRICEEFFECTDATE, rowIndex);
        if (newValue != null && priceEffectDate != null && ((Date)newValue).before((Date)priceEffectDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProdAuditProtocolEdit_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(PRICEINVALIDDATE, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (null == this.getPageCache().get(PROD_NUMBER)) {
            return;
        }
        List goods = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PROD_NUMBER), List.class);
        this.deleteSaveGoods(goods);
    }

    private void setMustInput(IDataModel model) {
        BasedataEdit goods = (BasedataEdit)this.getView().getControl(PROD_NUMBER);
        BasedataEdit classs = (BasedataEdit)this.getView().getControl(PROD_CLASS);
        DecimalEdit taxprice = (DecimalEdit)this.getView().getControl(PROD_TAXPRICE);
        taxprice.setMustInput(true);
        if (null != model.getValue("protocolid")) {
            goods.setMustInput(false);
            classs.setMustInput(false);
        } else {
            goods.setMustInput(true);
            classs.setMustInput(true);
        }
    }
}

