/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.BillFormUtil;

public class PmmSupplierAuditEdit
extends AbstractBillPlugIn {
    private static final String KEY_CONFIRM = "confirm";
    private static final String KEY_SUPPLIERINFO = "supplierinfo";
    private static final String BIZSTATUS = "cfmstatus";
    private static final String BILLID = "billid";
    private static final String SUPPLIERNAME = "suppliername";
    private static final String SUPPLIERID = "supplierid";
    private static final String BIZTYPE = "biztype";
    private static final String PMM_SUPPLIERAUDIT_CFM = "pmm_supplierauditcfm";
    private static final String RESULTCALLBACKID = "confirmActionId";
    private static final String MALLMANAGEBIZAPPID = "/FQ504NB63AY";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        DynamicObject tempObj = this.getModel().getDataEntity();
        if (tempObj == null && KEY_CONFIRM.equals(key)) {
            evt.setCancel(true);
            return;
        }
        if (tempObj == null) {
            return;
        }
        String bizStatus = tempObj.getString(BIZSTATUS);
        switch (key) {
            case "confirm": {
                if ("A".equals(bizStatus)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6279\u72b6\u6001\u7b49\u4e8e\u5f85\u5ba1\u6279 \u7684\u8d44\u6599\u624d\u80fd\u5f55\u5165\u5ba1\u6279\u7ed3\u679c\u3002", (String)"PmmSupplierAuditEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "supplierinfo": {
                DynamicObject suppInfo;
                Object object = this.getModel().getValue("supplier");
                if (!(object instanceof DynamicObject)) {
                    evt.setCancel(true);
                }
                if ((suppInfo = QueryServiceHelper.queryOne((String)"srm_supplierinfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("supplier", "=", ((DynamicObject)object).getPkValue())})) != null) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u975e\u62db\u52df\u6e20\u9053\u7684\u4f9b\u5e94\u5546\uff0c\u65e0\u5546\u5bb6\u6ce8\u518c\u4fe1\u606f\u3002", (String)"PmmSupplierAuditEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (itemKey = args.getOperateKey()) {
            case "confirm": {
                MutexHelper.require((String)"pmm_supplieraudit", (Object)String.valueOf(this.getModel().getDataEntity().getPkValue()), (String)KEY_CONFIRM, (StringBuilder)new StringBuilder("lock"));
                this.getPageCache().put("lockId", String.valueOf(this.getModel().getDataEntity().getPkValue()));
                this.auditResult();
                break;
            }
            case "supplierinfo": {
                Object object = this.getModel().getValue("supplier");
                if (!(object instanceof DynamicObject)) break;
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setStatus(OperationStatus.VIEW);
                DynamicObject suppInfo = QueryServiceHelper.queryOne((String)"srm_supplierinfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("supplier", "=", ((DynamicObject)object).getPkValue())});
                billShowParameter.setPkId((Object)suppInfo.getLong("id"));
                billShowParameter.setBillTypeId("srm_supplierinfo");
                billShowParameter.setFormId("srm_supplierinfo");
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)billShowParameter);
                break;
            }
        }
    }

    private void auditResult() {
        this.openDealPage(PMM_SUPPLIERAUDIT_CFM, RESULTCALLBACKID, ShowType.Modal);
    }

    private void openDealPage(String pageKey, String actionId, ShowType showType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(BILLID, this.getModel().getDataEntity().getPkValue());
        paramMap.put(SUPPLIERNAME, this.getModel().getDataEntity().getDynamicObject("supplier").getString("name"));
        paramMap.put(SUPPLIERID, this.getModel().getDataEntity().getDynamicObject("supplier").getPkValue());
        paramMap.put(BIZTYPE, this.getModel().getDataEntity().getString(BIZTYPE));
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)showType));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        BillModel model = (BillModel)this.getModel();
        switch (actionId) {
            case "confirmActionId": {
                MutexHelper.release((String)"pmm_supplieraudit", (String)KEY_CONFIRM, (String)this.getPageCache().get("lockId"));
                model.load(model.getPKValue());
                view.updateView();
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    public void pageRelease(EventObject e) {
        MutexHelper.release((String)"pmm_supplieraudit", (String)KEY_CONFIRM, (String)this.getPageCache().get("lockId"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.resetStatus();
    }

    public void resetStatus() {
        this.getModel().setDataChanged(false);
        DynamicObject recruitObject = this.getModel().getDataEntity();
        String bizStatus = recruitObject.getString(BIZSTATUS);
        if (bizStatus == null) {
            return;
        }
        if (bizStatus.equals(ConfirmStatusEnum.UNCONFIRM.getVal())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CONFIRM});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CONFIRM});
    }
}

