/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils;
import kd.scm.common.parent.TreeListBuildTreePlugin;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.malcore.domain.Sku;
import kd.scm.malcore.util.MalConfigUtil;
import kd.scm.pmm.business.service.impl.PmmProdManageAuditServiceImpl;

public class GoodsManageList
extends TreeListBuildTreePlugin
implements ListRowClickListener {
    private static Log log = LogFactory.getLog(GoodsManageList.class);
    private static final String KEY_TREEVIEW = "treeview";
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";
    private static final String ALLPROD = "allProd";
    private static final String MAL_PRODUCTDETAIL = "mal_productdetail";
    private static final String TREEDIMENSION = "treedimension";
    private static final String CHANGETREE = "CHANGETREE";
    private static final String FINALROOTID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String CONFIRMUP = "confirmup";
    public static final String PMM_PRODMATMAPPING = "pmm_prodmatmapping";
    private static final String INFO_CHANGE_CONFIRM = "infoChangeConfirm";
    private static final String OP_DELETE = "delete";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMAL");
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_addtopackege"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (null != evt.getCurrentListSelectedRow()) {
            Object entryPrimaryKeyValue = evt.getCurrentListSelectedRow().getEntryPrimaryKeyValue();
            this.getPageCache().put("entryid", String.valueOf(entryPrimaryKeyValue));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)CHANGETREE)) {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            IFormView view = this.getView();
            TreeView.TreeState ts = treeView.getTreeState();
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            IPageCache cache = this.getPageCache();
            if (newValue.equals(cache.get(CHANGETREE))) {
                return;
            }
            if (null != ts.getFocusNodeId() && !ts.getFocusNodeId().equals(this.getTreeModel().getRoot().getId())) {
                this.getModel().setValue("changetree", oldValue);
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6839\u8282\u70b9\u518d\u8fdb\u884c\u5207\u6362\u3002", (String)"GoodsManageList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode RootNode = this.getTreeModel().getRoot();
            treeView.focusNode(RootNode);
            if ("2".equals(newValue)) {
                cache.put(TREEDIMENSION, "sup");
                cache.put(CHANGETREE, "2");
            } else {
                cache.put(TREEDIMENSION, "class");
                cache.put(CHANGETREE, "1");
            }
            view.invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMAL");
        if (!checkResult.getHasLicense().booleanValue()) {
            this.getView().showMessage(checkResult.getMsg());
        }
    }

    public void initializeTree(EventObject e) {
        TreeNode Node2 = this.getCloudData("944841720602823680");
        ITreeModel treeModel = this.getTreeModel();
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        if (null == treeModel.getRoot() || treeModel.getRoot().getText().equals(ResManager.loadKDString((String)"\u5168\u90e8", (String)"GoodsManageList_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]))) {
            treeModel.setRoot(Node2);
            treeView.addNode(Node2);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TREEBUTTONPANEL});
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode rootnode = this.getTreeModel().getRoot();
        if (!e.getNodeId().toString().equals(rootnode.getId())) {
            TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(e.getNodeId().toString(), 20);
            if (null == currentNode.getChildren()) {
                e.setChildNodes(new ArrayList());
            }
            return;
        }
        IPageCache cache = this.getPageCache();
        String treedim = cache.get(TREEDIMENSION);
        if (null == treedim || treedim.equals("class")) {
            cache.put("standard", "944841720602823680");
            rootnode.setText(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b", (String)"GoodsManageList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            List filter = this.getTreeModel().getTreeFilter();
            filter.clear();
            QFilter sourceFilter = new QFilter("standard", "=", (Object)Long.valueOf("944841720602823680"));
            sourceFilter.and(new QFilter("enable", "=", (Object)"1"));
            filter.add(sourceFilter);
        } else {
            this.buildSupplierTree(e);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter qfilter = new QFilter("standard", "=", (Object)Long.valueOf("944841720602823680"));
        QFilter qFilter = new QFilter("origin", "=", (Object)"2").and(new QFilter("status", "!=", (Object)"C"));
        QFilter cfmStatus = new QFilter("status", "=", (Object)"C").or(qFilter);
        qfilter.and(cfmStatus);
        qFilters.add(qfilter);
    }

    private void buildSupplierTree(RefreshNodeEvent e) {
        DynamicObject[] suppliers;
        ArrayList<TreeNode> treenodes = new ArrayList<TreeNode>();
        TreeNode RootNode = this.getTreeModel().getRoot();
        RootNode.setText(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"GoodsManageList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        QFilter enterFilter = new QFilter("mallstatus", "=", (Object)"B");
        for (DynamicObject sup : suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name,number,longnumber", (QFilter[])new QFilter[]{enterFilter})) {
            TreeNode node = new TreeNode(RootNode.getId(), sup.getPkValue().toString(), sup.getString("name"));
            treenodes.add(node);
        }
        e.setChildNodes(treenodes);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        List filters = e.getFilters();
        IPageCache cache = this.getPageCache();
        String treedim = cache.get(TREEDIMENSION);
        if (null != treedim && treedim.equals("sup") && !e.getNodeId().toString().equals(this.getTreeModel().getRoot().getId())) {
            QFilter supfilter = new QFilter("supplier", "=", (Object)Long.valueOf(e.getNodeId().toString()));
            e.addQFilter(supfilter);
            for (QFilter filter : filters) {
                if (!filter.getProperty().equals("category")) continue;
                filter.__setProperty("supplier");
            }
            e.setCancel(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String clickKey = evt.getItemKey();
        int byte0 = -1;
        switch (clickKey) {
            case "tblmapping": {
                byte0 = 0;
                break;
            }
            case "tblswitchtree": {
                byte0 = 1;
                break;
            }
            case "tblinfochange": {
                this.infoChangeClick(evt);
                break;
            }
        }
        switch (byte0) {
            case 0: {
                TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
                IFormView view = this.getView();
                TreeView.TreeState ts = treeView.getTreeState();
                HashMap<String, Long> goodclassMap = new HashMap<String, Long>(1);
                HashMap<String, HashMap<String, Long>> FilterClassMap = new HashMap<String, HashMap<String, Long>>();
                goodclassMap.put("=", Long.valueOf(ts.getFocusNodeId()));
                FilterClassMap.put("id", goodclassMap);
                String selectFields = "number,isleaf";
                DynamicObject[] goodsclass = ORMUtil.load((String)"mdr_goodsclass", (String)selectFields, FilterClassMap);
                if (goodsclass.length != 0 && goodsclass[0].getBoolean("isleaf")) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f6\u5b50\u8282\u70b9\u3002", (String)"GoodsManageList_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case 1: {
                TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
                IFormView view = this.getView();
                TreeView.TreeState ts = treeView.getTreeState();
                if (null == ts.getFocusNodeId() || ts.getFocusNodeId().equals(this.getTreeModel().getRoot().getId())) break;
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6839\u8282\u70b9\u518d\u8fdb\u884c\u5207\u6362\u3002", (String)"GoodsManageList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void infoChangeClick(BeforeItemClickEvent evt) {
        IListView listview = (IListView)this.getView();
        Object[] primaryKeyValues = listview.getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            return;
        }
        if (primaryKeyValues.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u540c\u65f6\u5bf9\u4e00\u4e2a\u5546\u54c1\u8fdb\u884c\u4fe1\u606f\u53d8\u66f4\u3002", (String)"GoodsManageList_35", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String s = e.getParameter().getBillStatus().toString();
        Map customParams = e.getParameter().getCustomParams();
        Object iscopy = customParams.get("iscopy");
        ControlFilter controlFilter = (ControlFilter)((IListView)this.getView()).getControlFilters().getFilters().get("createorg.id");
        if ("ADDNEW".equalsIgnoreCase(s)) {
            String nodeId = this.getPageCache().get("nodeId");
            if (null != nodeId && iscopy == null) {
                e.getParameter().setCustomParam("node", (Object)nodeId);
            }
            if (controlFilter != null) {
                e.getParameter().setCustomParam("createOrgFilterValueList", (Object)controlFilter.getValue());
            }
        }
    }

    private void syncSpu(List<Object> prodIds) {
        PmmProdManageAuditServiceImpl entProdManageAuditService = new PmmProdManageAuditServiceImpl();
        List<Sku> skus = this.initSKu(prodIds);
        Map res = entProdManageAuditService.writeBackSpu(skus);
        if (res.get("msg") != null) {
            StringBuilder msg = (StringBuilder)res.get("msg");
            this.getView().showMessage(ResManager.loadKDString((String)"\u5546\u54c1\u5173\u8054SPU\u5931\u8d25\u3002", (String)"EntProdRequestEdit_20", (String)"scm-ent-formplugin", (Object[])new Object[0]), msg.toString(), MessageTypes.Default);
        }
    }

    private List<Sku> initSKu(List<Object> prodIds) {
        QFilter qFilter = new QFilter("id", "in", prodIds);
        qFilter.and("spunumber", "is not null", (Object)" ").and("spunumber", "!=", (Object)" ");
        DynamicObject[] prods = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"id,number,spunumber,createorg,supplier,prodattributeentry.prodattribute,prodattributeentry.prodattributevalue", (QFilter[])qFilter.toArray());
        ArrayList<Sku> skus = new ArrayList<Sku>(prods.length);
        for (DynamicObject dynamicObject : prods) {
            Sku sku = new Sku();
            sku.setId(Long.valueOf(dynamicObject.getLong("id")));
            sku.setCreateOrg(Long.valueOf(dynamicObject.getLong("createorg_id")));
            sku.setNumber(dynamicObject.getString("number"));
            sku.setSpu(dynamicObject.getString("spunumber"));
            sku.setSupplier(Long.valueOf(dynamicObject.getLong("supplier_id")));
            DynamicObjectCollection prodattributeentry = dynamicObject.getDynamicObjectCollection("prodattributeentry");
            HashSet<Long> baseAttributeValues = new HashSet<Long>(prodattributeentry.size());
            HashSet<Long> saleAttributeValues = new HashSet<Long>(prodattributeentry.size());
            for (DynamicObject entry : prodattributeentry) {
                DynamicObject prodattribute = entry.getDynamicObject("prodattribute");
                if ("1".equals(prodattribute.getString("attributetype"))) {
                    baseAttributeValues.add(entry.getLong("prodattributevalue_id"));
                    continue;
                }
                if (!"2".equals(prodattribute.getString("attributetype"))) continue;
                saleAttributeValues.add(entry.getLong("prodattributevalue_id"));
            }
            sku.setBaseAttributeValues(baseAttributeValues);
            sku.setSaleAttributeValues(saleAttributeValues);
            skus.add(sku);
        }
        return skus;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        IPageCache cache = this.getPageCache();
        IListView listview = (IListView)this.getView();
        ArrayList<Long> idList = new ArrayList<Long>();
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("audit".equals(key) && !args.getOperationResult().getSuccessPkIds().isEmpty()) {
            this.syncSpu(args.getOperationResult().getSuccessPkIds());
        }
        if (!Arrays.asList("setmaterialmapping", "importdata", "exportlist_expt", "exportlistbyselectfields", "exportlist").contains(key)) {
            ArrayList<String> selectList = "preview".equals(key) ? this.selectCheck(false) : this.selectCheck(true);
            if (null == selectList || selectList.size() < 1) {
                return;
            }
            for (String str : selectList) {
                idList.add(Long.parseLong(str));
            }
        }
        switch (key) {
            case "switchtree": {
                TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
                TreeNode RootNode = this.getTreeModel().getRoot();
                treeView.focusNode(RootNode);
                String treedim = cache.get(TREEDIMENSION);
                if (null == treedim || treedim.equals("class")) {
                    cache.put(TREEDIMENSION, "sup");
                } else {
                    cache.put(TREEDIMENSION, "class");
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "setcentral": {
                this.setCentral(true, 0);
                break;
            }
            case "setuncentral": {
                this.setCentral(false, 0);
                break;
            }
            case "preview": {
                Long productId = this.getProductId();
                if (null == productId) {
                    return;
                }
                this.showDetailPage(productId);
                break;
            }
            case "batchimportimage": {
                Object changetree = this.getModel().getValue("changetree");
                if (!"2".equals(changetree)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u6279\u91cf\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u5207\u6362\u5230\u4f9b\u5e94\u5546\u67e5\u8be2\u7ef4\u5ea6\u3002", (String)"GoodsManageList_36", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection dynList = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,supplier", (QFilter[])new QFilter("id", "in", idList).toArray());
                HashSet goodIds = new HashSet(dynList.size());
                dynList.forEach(t -> goodIds.add(t.getLong("supplier")));
                if (goodIds.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u3002", (String)"GoodsManageList_29", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (idList.size() > 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u6570\u91cf\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GoodsManageList_30", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pmm_importpicture");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
                detailParamMap.put("goodsIds", idList);
                detailParamMap.put("origin", "pmm");
                showParameter.setCustomParams(detailParamMap);
                this.getView().showForm(showParameter);
                break;
            }
            case "adjust": {
                HashMap param = new HashMap();
                ArrayList<String> allProdId = new ArrayList<String>();
                ListSelectedRowCollection selectCol = listview.getSelectedRows();
                for (ListSelectedRow listSelectedRow : selectCol) {
                    allProdId.add(listSelectedRow.toString());
                }
                param.put(ALLPROD, allProdId);
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pmm_prodadjusttool", param, null, (ShowType)ShowType.Modal));
                break;
            }
            case "setmaterialmapping": {
                this.setmaterialmapping();
                break;
            }
            case "infochange": {
                this.prodInfoChangeOp();
                break;
            }
            case "delete": {
                if (MalConfigUtil.isSearchV1()) break;
                ListSelectedRowCollection selectCol = listview.getSelectedRows();
                idList = new ArrayList(selectCol.size());
                for (ListSelectedRow str : selectCol) {
                    idList.add(Long.parseLong(String.valueOf(str.getPrimaryKeyValue())));
                }
                DynamicObjectCollection dyn = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number,status", (QFilter[])new QFilter[]{new QFilter("id", "in", idList).and(new QFilter("status", "=", (Object)"A"))});
                if (dyn.size() > 0) {
                    idList.clear();
                    for (DynamicObject dynamicObject : dyn) {
                        idList.add(dynamicObject.getLong("id"));
                    }
                }
                if (idList.size() <= 0) break;
                PbdMalElasticSearchUtils.MalGoodsBatchSync((String)"pmm_prodmanage", idList);
                break;
            }
            case "addtopackege": {
                this.checkAddtopackege(args);
                break;
            }
            case "setmulsku": {
                this.doSetMulSku();
                break;
            }
        }
    }

    private void doSetMulSku() {
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        if (selectCol.size() > 0) {
            ListSelectedRow listSelectedRow = selectCol.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            long id = Long.parseLong(String.valueOf(primaryKeyValue));
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("operate", "setmulsku");
            BillShowParameter billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"pmm_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)id, paramMap, null);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean hasPermResult;
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        if (OP_DELETE.equalsIgnoreCase(key)) {
            if (selectCol.size() == 0) {
                args.setCancel(true);
                return;
            }
            FormOperate source = (FormOperate)args.getSource();
            OperateOption option = source.getOption();
            option.setVariableValue("ignorerefentityids", "pmm_spu,ent_spu");
            source.setOption(option);
        }
        if (key.equalsIgnoreCase("new")) {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (StringUtils.isBlank((CharSequence)nodeId) || nodeId.equals(FINALROOTID)) {
                this.getPageCache().remove("nodeId");
                return;
            }
            QFilter filters = new QFilter("level", "=", (Object)Integer.parseInt("3")).and(new QFilter("id", "=", (Object)Long.parseLong(nodeId)));
            DynamicObject[] goodses = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)"id", (QFilter[])new QFilter[]{filters});
            if (goodses.length == 0) {
                this.getPageCache().remove("nodeId");
            } else {
                this.getPageCache().put("nodeId", nodeId);
            }
        }
        if (key.equalsIgnoreCase("viewladdderprice")) {
            this.showLadDerPriceForm(args);
        }
        if (key.equalsIgnoreCase("infochange") && !(hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)AppMetadataCache.getAppInfo((String)"pmm").getId(), (String)"pmm_prodchange_manage", (String)"47156aff000000ac"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5546\u54c1\u53d8\u66f4\u7ba1\u7406\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GoodsManageList_32", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (key.equalsIgnoreCase("setmulsku")) {
            this.checkSetMulSku(args);
        }
    }

    private void checkSetMulSku(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (ListSelectedRow row : selectCol) {
            idSet.add(Long.parseLong(String.valueOf(row.getPrimaryKeyValue())));
        }
        if (idSet.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u7ef4\u62a4\u591a\u4e2aSKU\u3002", (String)"GoodsManageList_39", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("spuskumapentry.goods.id", "=", (Object)Long.parseLong(String.valueOf(selectCol.get(0).getPrimaryKeyValue())));
        qFilter.and(new QFilter("spuskumapentry.confirmstatus", "!=", (Object)"D"));
        qFilter.and(new QFilter("origin", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "!=", (Object)"E"));
        boolean isExistSpu = QueryServiceHelper.exists((String)"pmm_spu", (QFilter[])qFilter.toArray());
        if (isExistSpu) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5546\u54c1\u5173\u8054\u7684SPU\u53d1\u8d77\u65b9\u4e3a\u4f9b\u5e94\u5546\uff0c\u4e0d\u652f\u6301\u7ef4\u62a4\u591a\u4e2aSKU\u3002", (String)"GoodsManageList_40", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter qFilter1 = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(selectCol.get(0).getPrimaryKeyValue())));
        qFilter1.and(new QFilter("status", "=", (Object)"A"));
        boolean isSaved = QueryServiceHelper.exists((String)"pmm_prodmanage", (QFilter[])qFilter1.toArray());
        if (!isSaved) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u7684\u5546\u54c1\u7ef4\u62a4\u591a\u4e2aSKU\u3002", (String)"GoodsManageList_45", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc) {
            DataEntityPropertyCollection dataModelProperties = e.getRowData().getDataEntityType().getProperties();
            boolean isContain = false;
            for (IDataEntityProperty iDataEntityProperty : dataModelProperties) {
                if (!iDataEntityProperty.getName().contains("protocolentry")) continue;
                isContain = true;
            }
            if (!isContain) {
                return;
            }
            List operationColItems = (List)e.getFormatValue();
            String pricetype = "A";
            if (null != e.getRowData().get("protocolentry.prodpool")) {
                pricetype = ((DynamicObject)e.getRowData().get("protocolentry.prodpool")).getString("pricetype");
            }
            for (OperationColItem operationColItem : operationColItems) {
                if ("viewladdderprice".equalsIgnoreCase(operationColItem.getOperationKey()) && "B".equals(pricetype)) {
                    operationColItem.setVisible(true);
                    continue;
                }
                operationColItem.setVisible(false);
            }
        }
        super.packageData(e);
    }

    private void showLadDerPriceForm(BeforeDoOperationEventArgs args) {
        QFilter qFilter;
        DynamicObjectCollection pools;
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        Object entryPrimaryKeyValue = selectCol.get(0).getEntryPrimaryKeyValue();
        if (null != this.getPageCache().get("entryid")) {
            entryPrimaryKeyValue = this.getPageCache().get("entryid");
            this.getPageCache().remove("entryid");
        }
        if ((pools = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"protocolentry.prodpool,protocolentry.prodpool.priceentry", (QFilter[])(qFilter = new QFilter("protocolentry.id", "=", (Object)Long.parseLong(String.valueOf(entryPrimaryKeyValue)))).toArray())).size() == 1) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u672a\u5f55\u9636\u68af\u4ef7\u3002", (String)"GoodsManageList_33", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        qFilter = new QFilter("id", "=", (Object)((DynamicObject)pools.get(0)).getLong("protocolentry.prodpool"));
        DynamicObjectCollection pmm_prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.curr,priceentry.qtyto,priceentry.qtyfrom,priceentry.ladprice", (QFilter[])qFilter.toArray());
        List<Object> ladderPriceInfos = new ArrayList(1024);
        for (DynamicObject info : pmm_prodpools) {
            BigDecimal qtyto = info.getBigDecimal("priceentry.qtyto");
            BigDecimal qtyfrom = info.getBigDecimal("priceentry.qtyfrom");
            BigDecimal ladprice = info.getBigDecimal("priceentry.ladprice");
            ladderPriceInfos.add(new LadderPriceInfo(qtyfrom, qtyto, ladprice, Long.valueOf(info.getLong("goods.curr"))));
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        detailParamMap.put("status", "1");
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private void prodInfoChangeOp() {
        IListView listview = (IListView)this.getView();
        Object[] primaryKeyValues = listview.getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            return;
        }
        this.getPageCache().put("infoChangId", primaryKeyValues[0].toString());
        if (!this.prodInfoChangeValid(primaryKeyValues)) {
            return;
        }
        OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"pmm_prodinfochange", (Object)primaryKeyValues[0], (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
    }

    private boolean prodInfoChangeValid(Object[] primaryKeyValues) {
        QFilter qFilter = new QFilter("entryentity.goods", "=", primaryKeyValues[0]);
        boolean exists = QueryServiceHelper.exists((String)"mal_order", (QFilter[])qFilter.toArray());
        if (exists) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u5173\u8054\u8ba2\u5355\uff0c\u5546\u54c1\u540d\u79f0\u3001\u89c4\u683c\u578b\u53f7\u3001\u7a0e\u7387\u7f16\u7801\u3001\u5546\u54c1\u8be6\u60c5\u3001\u5546\u54c1\u53c2\u6570\u3001\u5305\u88c5\u6e05\u5355\u3001\u552e\u540e\u4fdd\u969c\u5b57\u6bb5\u65e0\u6cd5\u4fee\u6539\u3002", (String)"GoodsManageList_37", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener(INFO_CHANGE_CONFIRM, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private ArrayList<String> selectCheck(boolean ismulti) {
        IListView listview = (IListView)this.getView();
        Object[] selectCol = listview.getSelectedRows().getPrimaryKeyValues();
        if (null != selectCol) {
            if (ismulti && selectCol.length < 1) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"GoodsManageList_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            }
            if (!ismulti && selectCol.length != 1) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u9884\u89c8\u3002", (String)"GoodsManageList_13", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                selectCol = null;
            }
            ArrayList<String> list = new ArrayList<String>();
            if (null != selectCol) {
                for (Object s : selectCol) {
                    list.add(s.toString());
                }
            }
            IPageCache cache = this.getPageCache();
            cache.put("select", String.join((CharSequence)",", list));
            return list;
        }
        return null;
    }

    private void setCentral(boolean central, int i) {
        ListSelectedRowCollection selectCol = this.selectCheck((byte)2);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow row : selectCol) {
            String id = row.getPrimaryKeyValue().toString();
            ids.add(Long.parseLong(id));
        }
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObject[] prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"id,centralpurtype", (QFilter[])new QFilter[]{idfilter});
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prod : prods) {
            Long pk = Long.parseLong(prod.getPkValue().toString());
            String centralpurtype = (String)prod.get("centralpurtype");
            if (i == 0) {
                String msg;
                if (central) {
                    if ("1".equals(centralpurtype)) {
                        msg = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u7b49\u4e8e{0}\u7684\u5546\u54c1\u5df2\u7ecf\u662f\u7b7e\u7ea6\u5546\u54c1\u3002", (String)"GoodsManageList_15", (String)"scm-pmm-formplugin", (Object[])new Object[]{prod.getString("number")});
                        sb.append(msg).append('\n');
                        ids.remove(pk);
                        continue;
                    }
                    prod.set("centralpurtype", (Object)"1");
                    continue;
                }
                if ("".equals(centralpurtype)) {
                    msg = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u7b49\u4e8e{0}\u7684\u5546\u54c1\u4e0d\u662f\u7b7e\u7ea6\u5546\u54c1\u3002", (String)"GoodsManageList_14", (String)"scm-pmm-formplugin", (Object[])new Object[]{prod.getString("number")});
                    sb.append(msg).append('\n');
                    ids.remove(pk);
                    continue;
                }
                prod.set("centralpurtype", (Object)" ");
                continue;
            }
            if (central) {
                prod.set("centralpurtype", (Object)"1");
                continue;
            }
            prod.set("centralpurtype", (Object)" ");
        }
        if (sb.length() > 0 && ids.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u5546\u54c1\u5747\u4e0d\u7b26\u5408\u89c4\u5219\u3002", (String)"GoodsManageList_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return;
        }
        if (sb.length() > 0 && i == 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5546\u54c1\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"GoodsManageList_17", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(String.valueOf(central)));
            return;
        }
        SaveServiceHelper.save((DynamicObject[])prods);
        String centralInfo = central ? ResManager.loadKDString((String)"\u8bbe\u7f6e", (String)"GoodsManageList_18", (String)"scm-pmm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GoodsManageList_19", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        String msg = ResManager.loadKDString((String)"\u7b7e\u7ea6\u5546\u54c1\u6210\u529f", (String)"GoodsManageList_20", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(centralInfo + msg);
        if (ids.size() > 0) {
            int j = 0;
            while (i < ids.size()) {
                PbdMalElasticSearchUtils.MalGoodsIncrSyn((String)"pmm_prodmanage", (long)((Long)ids.get(j)));
                ++i;
            }
        }
        this.getView().invokeOperation("refresh");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        HashMap<String, Object> customParams;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("true".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.setCentral(true, 1);
        }
        if ("false".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.setCentral(false, 1);
        }
        if (CONFIRMUP.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            HashMap<String, String> malParam = new HashMap<String, String>();
            ArrayList selectCol = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
            String selectcols = String.join((CharSequence)",", selectCol);
            malParam.put(ALLPROD, selectcols);
            malParam.put("new", "new");
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodrequest", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, malParam, null));
        }
        String toMaterialMappingId = this.getPageCache().get("toMaterialMappingId");
        if ("setMaterialMappingDynConfirm".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            customParams = new HashMap<String, Object>();
            customParams.put("openStyle", "setmaterialmapping");
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectCol = listview.getSelectedRows();
            customParams.put("selectType", "dynamicObject");
            customParams.put("id", selectCol.get(0).getPrimaryKeyValue().toString());
            this.toSetMaterialMappingEdit(customParams, Long.valueOf(toMaterialMappingId));
        }
        if ("setMaterialMappingTreeConfirm".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            customParams = new HashMap();
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            String nodeId = treeView.getTreeState().getFocusNodeId();
            customParams.put("openStyle", "setmaterialmapping");
            customParams.put("selectType", "treeNode");
            customParams.put("id", nodeId);
            this.toSetMaterialMappingEdit(customParams, Long.valueOf(toMaterialMappingId));
        }
        if (toMaterialMappingId != null) {
            this.getPageCache().remove("toMaterialMappingId");
        }
        if (INFO_CHANGE_CONFIRM.equals(callBackId)) {
            customParams = new HashMap(8);
            String infoChangId = this.getPageCache().get("infoChangId");
            customParams.put("hasOrder", "true");
            OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"pmm_prodinfochange", (Object)Long.valueOf(infoChangId), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, customParams, null);
        }
        if ("addtopackege".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.addPackege();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"setmaterialmapping")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private ListSelectedRowCollection selectCheck(byte byte0) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        if (byte0 == 1 && selectCol.size() > 1) {
            listview.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u9884\u89c8\u3002", (String)"GoodsManageList_21", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            selectCol = null;
        }
        return selectCol;
    }

    private void showDetailPage(Long productId) {
        FormShowParameter showParameter = new FormShowParameter();
        if (MalOrderUtil.getDefaultMalVersion()) {
            showParameter.setFormId("mal_newproductdetail");
        } else {
            showParameter.setFormId(MAL_PRODUCTDETAIL);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("productSelfId", String.valueOf(productId));
        detailParamMap.put("origin", "pur");
        showParameter.setCaption(ResManager.loadKDString((String)"\u5546\u54c1\u9884\u89c8", (String)"GoodsManageList_22", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private Long getProductId() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        if (selectCol.size() < 1) {
            listview.showMessage(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"GoodsManageList_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return null;
        }
        Object[] productIds = listview.getSelectedRows().getPrimaryKeyValues();
        if (productIds.length > 1) {
            return null;
        }
        return (Long)productIds[0];
    }

    private void setmaterialmapping() {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("openStyle", "setmaterialmapping");
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        if (selectCol.getPrimaryKeyValues().length > 1) {
            listview.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5355\u4e2a\u5546\u54c1\u8bbe\u7f6e\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"GoodsManageList_23", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectCol.getPrimaryKeyValues().length == 1) {
            DynamicObject mapping = QueryServiceHelper.queryOne((String)PMM_PRODMATMAPPING, (String)"id", (QFilter[])new QFilter[]{new QFilter("goods", "in", selectCol.get(0).getPrimaryKeyValue())});
            if (mapping != null) {
                this.getPageCache().put("toMaterialMappingId", mapping.getString("id"));
                String confirmTip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\uff0c\u786e\u8ba4\u8981\u66f4\u65b0\u5417\uff1f", (String)"GoodsManageList_27", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("setMaterialMappingDynConfirm", (IFormPlugin)this));
                return;
            }
            customParams.put("selectType", "dynamicObject");
            customParams.put("id", selectCol.get(0).getPrimaryKeyValue().toString());
        } else {
            boolean isEndTree = this.selectTreeCheck(customParams);
            if (!isEndTree) {
                return;
            }
        }
        this.toSetMaterialMapping(customParams);
    }

    private boolean selectTreeCheck(HashMap<String, Object> customParams) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (null != nodeId) {
            if (nodeId.equals(FINALROOTID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u672b\u7ea7\u5206\u7c7b\u8bbe\u7f6e\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"GoodsManageList_38", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            QFilter filters = new QFilter("level", "=", (Object)Integer.parseInt("3")).and(new QFilter("id", "=", (Object)Long.parseLong(nodeId)));
            DynamicObject[] goodses = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)"id", (QFilter[])new QFilter[]{filters});
            if (goodses.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u672b\u7ea7\u5206\u7c7b\u8bbe\u7f6e\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"GoodsManageList_24", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            boolean hasMapping = this.checkTreeNodeMapping(nodeId);
            if (hasMapping) {
                return false;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u6216\u5546\u54c1\u5206\u7c7b\u3002", (String)"GoodsManageList_25", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        customParams.put("selectType", "treeNode");
        customParams.put("id", nodeId);
        return true;
    }

    private boolean checkTreeNodeMapping(String nodeId) {
        IFormView listview = this.getView();
        DynamicObject mapping = QueryServiceHelper.queryOne((String)PMM_PRODMATMAPPING, (String)"id", (QFilter[])new QFilter[]{new QFilter("category", "=", (Object)Long.valueOf(nodeId))});
        if (mapping != null) {
            this.getPageCache().put("toMaterialMappingId", mapping.getString("id"));
            String confirmTip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\uff0c\u786e\u8ba4\u8981\u66f4\u65b0\u5417\uff1f", (String)"GoodsManageList_27", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            listview.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("setMaterialMappingTreeConfirm", (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private void toSetMaterialMapping(HashMap<String, Object> customParams) {
        boolean request = MutexUtil.request((String)customParams.get("id").toString(), (String)"pmm_prodmanage", (String)"tblquickset");
        if (!request) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5f00\u5546\u54c1\u5bf9\u5e94\u8868\u5931\u8d25\uff0c\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91\u3002", (String)"GoodsManageList_26", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
        BillShowParameter param = new BillShowParameter();
        param.setFormId(PMM_PRODMATMAPPING);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.ADDNEW);
        param.setCustomParams(customParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setmaterialmapping"));
        this.getView().showForm((FormShowParameter)param);
    }

    private void toSetMaterialMappingEdit(HashMap<String, Object> customParams, Long id) {
        boolean request = MutexUtil.request((String)customParams.get("id").toString(), (String)"pmm_prodmanage", (String)"tblquickset");
        if (!request) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5f00\u5546\u54c1\u5bf9\u5e94\u8868\u5931\u8d25\uff0c\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91\u3002", (String)"GoodsManageList_26", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
        BillShowParameter formShowParameter = BillFormUtil.assembleShowBillFormParam((String)PMM_PRODMATMAPPING, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.EDIT, (long)id, customParams, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "setmaterialmapping"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void search(SearchEnterEvent evt) {
    }

    private void checkAddtopackege(AfterDoOperationEventArgs e) {
        IListView listview = (IListView)this.getView();
        Object[] selectCol = listview.getSelectedRows().getPrimaryKeyValues();
        if (selectCol.length == 0) {
            return;
        }
        if (null != selectCol) {
            ArrayList<Long> proIds = new ArrayList<Long>(selectCol.length);
            for (Object s : selectCol) {
                proIds.add(Long.parseLong(s.toString()));
            }
            QFilter idFilter = new QFilter("id", "in", proIds);
            QFilter[] filters = new QFilter[]{idFilter};
            String selectFields = "id,number,name,createorg,status";
            DynamicObjectCollection col = QueryServiceHelper.query((String)"pmm_prodmanage", (String)selectFields, (QFilter[])filters);
            StringBuilder msg = new StringBuilder(64);
            HashSet<String> prodList = new HashSet<String>(col.size());
            ArrayList<Long> errorids = new ArrayList<Long>(selectCol.length);
            for (DynamicObject prod : col) {
                Long proid = prod.getLong("id");
                if (!"C".equals(prod.getString("status")) && !errorids.contains(proid)) {
                    errorids.add(proid);
                    msg.append(ResManager.loadKDString((String)"\u5546\u54c1{0}\uff1a\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5546\u54c1\u624d\u5141\u8bb8\u52a0\u5165\u91c7\u8d2d\u5957\u9910\u3002\r\n", (String)"PmmMallGoodsList_0", (String)"scm-pmm-formplugin", (Object[])new Object[]{prod.getString("number") + prod.getString("name")}));
                    continue;
                }
                prodList.add(String.valueOf(prod.getLong("id")));
            }
            String appId = AppMetadataCache.getAppInfo((String)"pmm").getId();
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)UserServiceHelper.getCurrentUserId(), (String)"04", (boolean)true, (String)appId, (String)"pmm_packageselection", (String)"47156aff000000ac");
            List orgids = hasPermOrgResult.getHasPermOrgs();
            if (!hasPermOrgResult.hasAllOrgPerm() && orgids.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u5957\u9910\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmMallGoodsList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long org = 0L;
            long curOrg = RequestContext.get().getOrgId();
            if (hasPermOrgResult.hasAllOrgPerm()) {
                DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fispurchase", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curOrg)});
                if (orgDyn == null) {
                    DynamicObjectCollection orgDyncol = QueryServiceHelper.query((String)"bos_org", (String)"id,fispurchase", (QFilter[])new QFilter[]{new QFilter("fispurchase", "=", (Object)"1")});
                    if (orgDyncol.size() > 0) {
                        org = ((DynamicObject)orgDyncol.get(0)).getLong("id");
                    }
                } else {
                    org = curOrg;
                }
            } else {
                org = !orgids.contains(curOrg) ? (Long)orgids.get(0) : Long.valueOf(curOrg);
            }
            if (prodList.size() == 0 && msg.length() > 0) {
                this.getView().showTipNotification(msg.toString());
                return;
            }
            this.getPageCache().put("pakage_org", String.valueOf(org));
            this.getPageCache().put("pakage_prodlist", String.join((CharSequence)",", prodList));
            if (msg.length() > 0) {
                String error = String.format(ResManager.loadKDString((String)"\u5df2\u9009 %1$s\u6761\u6570\u636e\u52a0\u5165\u91c7\u8d2d\u5957\u9910\uff0c\u7b26\u5408\u6761\u4ef6\u7684%2$s\u6761\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmMallGoodsList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]), selectCol.length, prodList.size());
                this.getView().showConfirm(error, msg.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("addtopackege"));
            } else {
                this.addPackege();
            }
        }
    }

    private void addPackege() {
        String prodliststr = this.getPageCache().get("pakage_prodlist");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("source", "pmm_prodmanage");
        param.put("allprodids", prodliststr);
        param.put("cur_org", this.getPageCache().get("pakage_org"));
        this.getPageCache().remove("pakage_org");
        this.getPageCache().remove("pakage_prodlist");
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_packageselection", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
    }
}

