/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.mvc.list.ListDataProvider;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.pmm.common.util.PmmGoodsUtil;

public class PackageSelectionListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int arg0, int arg1) {
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
        if (!properties.containsKey((Object)"totalamount")) {
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("totalamount", BigDecimal.class, (Object)BigDecimal.ZERO));
        }
        if (!properties.containsKey((Object)"entryentity.price")) {
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.price", BigDecimal.class, (Object)BigDecimal.ZERO));
        }
        if (!properties.containsKey((Object)"entryentity.amount")) {
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.amount", BigDecimal.class, (Object)BigDecimal.ZERO));
        }
        if (!properties.containsKey((Object)"entryentity.goodssupplier")) {
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.goodssupplier", String.class, null));
        }
        if (!properties.containsKey((Object)"entryentity.picture")) {
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.picture", String.class, null));
        }
        if (!properties.containsKey((Object)"entryentity.platform")) {
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.platform", String.class, null));
        }
        if (!properties.containsKey((Object)"entryentity.model")) {
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.model", String.class, null));
        }
        if (rows.isEmpty()) {
            return rows;
        }
        this.setGoodsEntryInfo(rows);
        return rows;
    }

    private void setGoodsEntryInfo(DynamicObjectCollection rows) {
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(rows.size());
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(rows.size());
        for (DynamicObject entry : rows) {
            DynamicObject goods = entry.getDynamicObject("entryentity.goods");
            if (goods == null) continue;
            Long goodsId = goods.getLong("masterid");
            String source = entry.getString("entryentity.source");
            if (!StringUtils.isNotBlank((CharSequence)source)) continue;
            if ("pmm_prodmanage".equals(source)) {
                selfGoodsIds.add(goodsId);
                continue;
            }
            ecGoodsIds.add(goodsId);
        }
        Map goodsMap = PmmGoodsUtil.getGoodsDynMap(selfGoodsIds, ecGoodsIds);
        HashMap<Long, BigDecimal> id2SumTaxAmount = new HashMap<Long, BigDecimal>(rows.size());
        for (DynamicObject entry : rows) {
            Long goodsId;
            DynamicObject ecGoodsEntry;
            DynamicObject goods = entry.getDynamicObject("entryentity.goods");
            if (goods == null || (ecGoodsEntry = (DynamicObject)goodsMap.get(goodsId = Long.valueOf(goods.getLong("masterid")))) == null) continue;
            entry.getDataEntityType().getProperties();
            entry.set("entryentity.price", (Object)ecGoodsEntry.getBigDecimal("price"));
            entry.set("entryentity.picture", (Object)ecGoodsEntry.getString("picture"));
            entry.set("entryentity.platform", (Object)ecGoodsEntry.getString("platform"));
            entry.set("entryentity.model", (Object)ecGoodsEntry.getString("model"));
            String platform = ecGoodsEntry.getString("platform");
            String supplierName = !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform) ? EcApiUtil.getMalName((String)platform) : ecGoodsEntry.getString("suppliername");
            entry.set("entryentity.goodssupplier", (Object)supplierName);
            BigDecimal qty = BigDecimal.ONE;
            if (entry.getBigDecimal("entryentity.qty") != null) {
                qty = entry.getBigDecimal("entryentity.qty");
            }
            BigDecimal amount = BigDecimal.ZERO;
            if (ecGoodsEntry.getBigDecimal("price") != null) {
                amount = ecGoodsEntry.getBigDecimal("price").multiply(qty).setScale(6, RoundingMode.HALF_UP);
                entry.set("entryentity.amount", (Object)amount);
            }
            BigDecimal sumAmount = BigDecimal.ZERO;
            if (id2SumTaxAmount.containsKey(entry.getLong("id"))) {
                sumAmount = (BigDecimal)id2SumTaxAmount.get(entry.getLong("id"));
                sumAmount = sumAmount.add(amount);
                id2SumTaxAmount.put(entry.getLong("id"), sumAmount);
                continue;
            }
            sumAmount = sumAmount.add(amount);
            id2SumTaxAmount.put(entry.getLong("id"), sumAmount);
        }
        for (DynamicObject dynamicObject : rows) {
            dynamicObject.set("totalamount", id2SumTaxAmount.get(dynamicObject.getLong("id")));
        }
    }
}

