/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockDataInfo;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.parent.TreeListBuildTreePlugin;

public class PmmCategoryUnionListPlugin
extends TreeListBuildTreePlugin {
    private static final String CMBSTANDARDLST = "cmbstandardlst";
    private static final String MDRGOODSCLASS = "mdr_goodsclass";
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String PMM_CATEGORY_UNION = "pmm_categoryunion";

    public void initializeTree(EventObject e) {
        TreeNode node = this.getCloudData("944841720602823680");
        node.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PmmCategoryUnionListPlugin_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        ITreeModel treeModel = this.getTreeModel();
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        if (null == treeModel.getRoot() || treeModel.getRoot().getText().equals(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PmmCategoryUnionListPlugin_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]))) {
            treeModel.setRoot(node);
            treeView.addNode(node);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String nodeId = e.getNodeId().toString();
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Object standardId = this.getModel().getValue(CMBSTANDARDLST);
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.parseLong(String.valueOf(standardId)));
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = "0";
        }
        QFilter qFilter2 = new QFilter("parent", "=", (Object)Long.parseLong(nodeId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)MDRGOODSCLASS, (String)"id,number,name,parent,level,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2});
        for (DynamicObject row : dynamicObjects) {
            String parentid = row.getString("parent");
            int level = row.getInt("level");
            if ("0".equals(parentid)) {
                if (level != 1) continue;
                parentid = ROOTNODEID;
            }
            TreeNode node = new TreeNode(parentid, row.getString("id"), row.getString("name"), !row.getBoolean("isleaf"), (Object)row);
            treeNodes.add(node);
        }
        return treeNodes;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)CMBSTANDARDLST)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        if (!ROOTNODEID.equals(nodeId)) {
            Iterator iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter qFilter = (QFilter)iterator.next();
                String property = qFilter.getProperty();
                if (!"ecclass".equals(property) && !"selfclass".equals(property)) continue;
                iterator.remove();
            }
        }
        QFilter filter = this.getRefreshFilter();
        qFilters.add(filter);
    }

    private QFilter getRefreshFilter() {
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        String classStandardId = (String)this.getModel().getValue(CMBSTANDARDLST);
        QFilter qFilter = new QFilter("selfclass.standard.id", "=", (Object)Long.parseLong(classStandardId));
        qFilter.or(new QFilter("ecclass.standard.id", "=", (Object)Long.parseLong(classStandardId)));
        if (ROOTNODEID.equals(nodeId) || nodeId == null) {
            return qFilter;
        }
        long itemClassId = Long.parseLong(nodeId);
        ArrayList<Long> childClassIds = new ArrayList<Long>();
        DynamicObject goodsClass = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"longnumber,isleaf", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)itemClassId)});
        if (goodsClass != null) {
            if (!goodsClass.getBoolean("isleaf")) {
                String longnumber = goodsClass.getString("longnumber");
                QFilter f1 = new QFilter("longnumber", "like", (Object)(longnumber + ".%"));
                QFilter f2 = new QFilter("standard.id", "=", (Object)Long.parseLong(classStandardId));
                QFilter[] qFilters = new QFilter[]{f1, f2};
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)MDRGOODSCLASS, (String)"id", (QFilter[])qFilters, (String)"id");){
                    dataSet.forEach(row -> childClassIds.add(row.getLong("id")));
                }
            }
            childClassIds.add(itemClassId);
        }
        QFilter categoryQfilter = new QFilter("selfclass.id", "in", childClassIds);
        categoryQfilter.or(new QFilter("ecclass.id", "in", childClassIds));
        qFilter.and(categoryQfilter);
        return qFilter;
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(CMBSTANDARDLST, (Object)"944841720602823680");
        this.setComboEdit();
    }

    private void setComboEdit() {
        ComboEdit combo = (ComboEdit)this.getView().getControl(CMBSTANDARDLST);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(5);
        DynamicObjectCollection comboEdit = this.getStandardDyos();
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5546\u57ce\u5546\u54c1\u5206\u7c7b\u6807\u51c6(00000801)", (String)"PmmCategoryUnionListPlugin_1", (String)"scm-pmm-formplugin", (Object[])new Object[0])), "944841720602823680"));
        HashMap<String, String> platformMap = new HashMap<String, String>(16);
        if (!CollectionUtils.isEmpty((Collection)comboEdit)) {
            for (DynamicObject dyo : comboEdit) {
                if (null == dyo.getString("standard.id")) continue;
                data.add(new ComboItem(this.getStandardName(dyo), dyo.getString("standard.id")));
                platformMap.put(dyo.getString("standard.id"), dyo.getString("platform"));
            }
        }
        this.getPageCache().put("platformcache", SerializationUtils.toJsonString(platformMap));
        combo.setComboItems(data);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        QFilter qFilter;
        DynamicObject dynamicObject;
        super.beforeShowBill(e);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        Object standardId = this.getModel().getValue(CMBSTANDARDLST);
        String platformcache = this.getPageCache().get("platformcache");
        Map platformMap = (Map)SerializationUtils.fromJsonString((String)platformcache, Map.class);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        String platform = (String)platformMap.get(String.valueOf(standardId));
        if (null == platformMap.get(String.valueOf(standardId))) {
            platform = "1";
        }
        paramMap.put("platform", platform);
        paramMap.put("standardid", standardId);
        paramMap.put("classid", nodeId);
        Object pkObj = e.getParameter().getPkId();
        if (null != pkObj && null != (dynamicObject = QueryServiceHelper.queryOne((String)PMM_CATEGORY_UNION, (String)"selfclass.id", (QFilter[])(qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(pkObj)))).toArray()))) {
            qFilter = new QFilter("selfclass.id", "=", (Object)dynamicObject.getLong("selfclass.id"));
            DynamicObjectCollection unionCols = QueryServiceHelper.query((String)PMM_CATEGORY_UNION, (String)"id", (QFilter[])qFilter.toArray());
            ArrayList<MutexLockInfo> mutexBaseInfos = new ArrayList<MutexLockInfo>(16);
            for (DynamicObject row : unionCols) {
                MutexLockInfo requestInfo = new MutexLockInfo(row.getString("id"), null, "default_netctrl", PMM_CATEGORY_UNION, "modify", true, "default");
                mutexBaseInfos.add(requestInfo);
            }
            DataMutex dataMutex = DataMutex.create();
            List lockInfo = dataMutex.getLockInfo(mutexBaseInfos);
            if (lockInfo.size() > 1) {
                QFilter userQfilter;
                DynamicObject user;
                String uerId = "";
                for (MutexLockDataInfo lock : lockInfo) {
                    if (pkObj.equals(lock.getDataObjId())) continue;
                    uerId = lock.getUserId();
                }
                if (!StringUtils.isEmpty((CharSequence)uerId) && null != (user = QueryServiceHelper.queryOne((String)"bos_user", (String)"name", (QFilter[])(userQfilter = new QFilter("id", "=", (Object)Long.parseLong(uerId))).toArray()))) {
                    String msg = ResManager.loadKDString((String)"{0} \u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\u76f8\u5173\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PmmCategoryUnionListPlugin_5", (String)"scm-pmm-formplugin", (Object[])new Object[]{user.getString("name")});
                    this.getView().showMessage(msg);
                    e.setCancel(true);
                }
            }
        }
        e.getParameter().getShowParameter().setCustomParams(paramMap);
    }

    private DynamicObjectCollection getStandardDyos() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        return QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform,standard.id,standard.number,standard.name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
    }

    private LocaleString getStandardName(DynamicObject dyo) {
        return new LocaleString(dyo.getString("standard.name") + "(" + dyo.getString("standard.number") + ")");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.equalsIgnoreCase("new")) {
            this.newValid(args);
        }
    }

    private void newValid(BeforeDoOperationEventArgs args) {
        boolean pmm_categoryunion;
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (null == nodeId || nodeId.equals(ROOTNODEID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e93\u7ea7\u5546\u54c1\u5206\u7c7b\u540e\u518d\u65b0\u589e\u3002", (String)"PmmCategoryUnionListPlugin_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter filters = new QFilter("id", "=", (Object)Long.parseLong(nodeId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"id,level,enable", (QFilter[])filters.toArray());
        if (dynamicObject.getInt("level") != 3) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e93\u7ea7\u5546\u54c1\u5206\u7c7b\u540e\u518d\u65b0\u589e\u3002", (String)"PmmCategoryUnionListPlugin_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("0".equals(dynamicObject.getString("enable"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u7ef4\u62a4\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"PmmCategoryUnionListPlugin_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (pmm_categoryunion = QueryServiceHelper.exists((String)PMM_CATEGORY_UNION, (QFilter[])(filters = new QFilter("ecclass.id", "=", (Object)Long.parseLong(nodeId))).toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5546\u5206\u7c7b\u5df2\u5bf9\u5e94\u81ea\u5efa\u5206\u7c7b\u3002", (String)"PmmCategoryUnionListPlugin_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

