/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pmm.common.consts.PmmOrgPackageSelectionConstant;

public class PmmOrgPackageSelectionList
extends AbstractListPlugin {
    private static final String OP_TO_ORDER = "toorder";
    private static final String OP_ADDCART = "addcart";
    private static final String OP_ADD_SCHEME = "addscheme";

    public void createNewData(BizDataEventArgs e) {
        if (this.getView().getParentView() != null && "mal_newshopcenter".equals(this.getView().getParentView().getEntityId())) {
            this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u91c7\u8d2d\u5957\u9910", (String)"PmmOrgPackageSelectionList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0])});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.getListUserOption().setMergeRow(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C"));
        e.getQFilters().add(BaseDataServiceHelper.getBaseDataFilter((String)"pmm_packageselection", (Long)RequestContext.get().getOrgId()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_ADDCART.equals(operateKey) || OP_TO_ORDER.equals(operateKey) || OP_ADD_SCHEME.equals(operateKey)) {
            OperateOption option = operate.getOption();
            BillList billList = (BillList)this.getControl("billlistap");
            QueryResult queryResult = billList.queryDataBySelectedRows(billList.getSelectedRows());
            DynamicObjectCollection col = queryResult.getCollection();
            ArrayList<String> selectedGoodsIds = new ArrayList<String>(col.size());
            for (DynamicObject selectedRowDyn : col) {
                selectedGoodsIds.add(selectedRowDyn.getString("goods_Id"));
            }
            option.setVariableValue(PmmOrgPackageSelectionConstant.SELECTED_GOODSIDS, StringUtils.join((Object[])selectedGoodsIds.toArray(), (String)","));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView parentView;
        DynamicObjectCollection col;
        QueryResult queryResult;
        BillList billList;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_TO_ORDER.equals(afterDoOperationEventArgs.getOperateKey())) {
            billList = (BillList)this.getControl("billlistap");
            queryResult = billList.queryDataBySelectedRows(billList.getSelectedRows());
            col = queryResult.getCollection();
            HashMap<String, Serializable> malToPlaceOrderParam = new HashMap<String, Serializable>();
            ArrayList malToPlaceOrderItems = new ArrayList();
            HashSet ecGoodsIdSet = new HashSet(col.size());
            for (DynamicObject selectedRowDyn : col) {
                DynamicObject goods = selectedRowDyn.getDynamicObject("entryentity.goods");
                malToPlaceOrderParam.put("dptOrgId", Long.valueOf(RequestContext.get().getOrgId()));
                Long goodsId = Long.valueOf(goods.getString("id"));
                String goodsNumber = goods.getString("number");
                String platform = selectedRowDyn.getString("entryentity.platform");
                BigDecimal qty = selectedRowDyn.getBigDecimal("entryentity.qty");
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
                    ecGoodsIdSet.add(goodsId);
                }
                HashMap<String, Object> malToPlaceOrderItem = new HashMap<String, Object>();
                malToPlaceOrderItem.put("goodsId", goodsId);
                malToPlaceOrderItem.put("goodsNumber", goodsNumber);
                malToPlaceOrderItem.put("platform", platform);
                malToPlaceOrderItem.put("qty", qty);
                malToPlaceOrderItems.add(malToPlaceOrderItem);
            }
            DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"MallGoodsService", (String)"syncEcGoodsToGoodsManage", (Object[])new Object[]{ecGoodsIdSet});
            malToPlaceOrderParam.put("malToPlaceOrderItemList", malToPlaceOrderItems);
            malToPlaceOrderParam.put("validateGoodsForPlaceOrder", Boolean.valueOf(false));
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("mal_placeorder");
            parameter.setCustomParam("MAL_TO_PLACEORDER_PARAM", (Object)JSON.toJSONString(malToPlaceOrderParam));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setShowTitle(false);
            this.getView().showForm(parameter);
        }
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_ADD_SCHEME.equals(afterDoOperationEventArgs.getOperateKey())) {
            billList = (BillList)this.getControl("billlistap");
            queryResult = billList.queryDataBySelectedRows(billList.getSelectedRows());
            col = queryResult.getCollection();
            ArrayList goodsInfoList = new ArrayList(col.size());
            String schemeName = "";
            for (DynamicObject selectedRowDyn : col) {
                DynamicObject goods = selectedRowDyn.getDynamicObject("entryentity.goods");
                HashMap<String, Number> goodsInfo = new HashMap<String, Number>();
                goodsInfo.put("goodsId", goods.getLong("id"));
                goodsInfo.put("qty", selectedRowDyn.getBigDecimal("entryentity.qty"));
                goodsInfoList.add(goodsInfo);
                if (!StringUtils.isEmpty((CharSequence)schemeName)) continue;
                schemeName = selectedRowDyn.getString("name");
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            paramMap.put("goodsInfos", goodsInfoList);
            paramMap.put("schemeName", schemeName);
            OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"mal_purscheme", null, (BillOperationStatus)BillOperationStatus.ADDNEW, (ShowType)ShowType.Modal, paramMap, null);
        }
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_ADDCART.equals(afterDoOperationEventArgs.getOperateKey()) && (parentView = this.getView().getParentView()) != null && "mal_newshopcenter".equals(parentView.getEntityId())) {
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"goods_number", (CharSequence)args.getFieldName())) {
            DynamicObject goods;
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ListSelectedRowCollection focusRows = new ListSelectedRowCollection();
            for (ListSelectedRow listSelectedRow : selectedRows) {
                if (listSelectedRow.getRowKey() != args.getRowIndex()) continue;
                focusRows.add((Object)listSelectedRow);
            }
            if (focusRows.isEmpty()) {
                return;
            }
            QueryResult queryResult = billList.queryDataBySelectedRows(focusRows);
            DynamicObjectCollection col = queryResult.getCollection();
            if (!col.isEmpty() && (goods = ((DynamicObject)col.get(0)).getDynamicObject("entryentity.goods")) != null) {
                String platform = ((DynamicObject)col.get(0)).getString("entryentity.platform");
                String goodsId = goods.getString("id");
                String goodsNumber = goods.getString("number");
                String caption = goods.getString("name");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("mal_newproductdetail");
                HashMap<String, String> detailParamMap = new HashMap<String, String>();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
                    detailParamMap.put("productSelfId", goodsId);
                } else {
                    detailParamMap.put("productJdSku", goodsNumber);
                    detailParamMap.put("productsource", platform);
                }
                showParameter.setCustomParams(detailParamMap);
                if (caption.length() > 6) {
                    caption = caption.substring(0, 6);
                }
                showParameter.setCaption(caption);
                this.getView().showForm(showParameter);
                args.setCancel(true);
            }
        }
    }
}

