/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.parent.TreeListBuildTreePlugin;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.pmm.business.service.impl.PmmSpuValidatorServiceImpl;

public class PmmProdSpuList
extends TreeListBuildTreePlugin {
    private static final String FINALROOTID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMAL");
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter supQFilter = new QFilter("status", "!=", (Object)"A");
        supQFilter.and(new QFilter("origin", "=", (Object)"1"));
        supQFilter.or(new QFilter("origin", "=", (Object)"2"));
        qFilters.add(supQFilter);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.hideTreeButton();
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        HasPermDimObjResult hasPermDimObjResult;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("orgfield.id".equals(fieldName) && !(hasPermDimObjResult = PermissionServiceHelper.getHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"/FQ504NB63AY", (String)"pmm_spu", (String)"47150e89000000ac")).hasAllDimObjPerm()) {
            args.getQfilters().add(new QFilter("id", "in", (Object)hasPermDimObjResult.getHasPermDimObjs()));
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        HasPermDimObjResult hasPermDimObjResult;
        super.filterColumnSetFilter(args);
        if ("orgfield.number".equals(args.getFieldName()) && !(hasPermDimObjResult = PermissionServiceHelper.getHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"/FQ504NB63AY", (String)"pmm_spu", (String)"47150e89000000ac")).hasAllDimObjPerm()) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)hasPermDimObjResult.getHasPermDimObjs()));
        }
    }

    public void initializeTree(EventObject e) {
        TreeNode Node2 = this.getCloudData("944841720602823680");
        ITreeModel treeModel = this.getTreeModel();
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        if (null == treeModel.getRoot() || treeModel.getRoot().getText().equals(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PmmProdSpuList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]))) {
            treeModel.setRoot(Node2);
            treeView.addNode(Node2);
        }
        this.hideTreeButton();
    }

    private void hideTreeButton() {
        IFormView treeview = this.getView();
        treeview.setVisible(Boolean.FALSE, new String[]{"btnnew"});
        treeview.setVisible(Boolean.FALSE, new String[]{"btnedit"});
        treeview.setVisible(Boolean.FALSE, new String[]{"btndel"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        List filter = this.getTreeModel().getTreeFilter();
        filter.clear();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sourceFilter = new QFilter("standard", "=", (Object)Long.parseLong("944841720602823680"));
        filter.add(sourceFilter);
        filter.add(enableFilter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        ControlFilter controlFilter;
        Map filters;
        super.beforeShowBill(e);
        String s = e.getParameter().getBillStatus().toString();
        if ("ADDNEW".equalsIgnoreCase(s) && null != (filters = ((IListView)this.getView()).getControlFilters().getFilters()).get("orgfield.id") && (controlFilter = (ControlFilter)filters.get("orgfield.id")) != null) {
            List values = controlFilter.getValue();
            ArrayList<Long> newOrgIds = new ArrayList<Long>(16);
            for (Object obj : values) {
                if (ObjectUtils.isEmpty(obj)) continue;
                newOrgIds.add(Long.parseLong(String.valueOf(obj)));
            }
            if (newOrgIds.size() > 0) {
                e.getParameter().setCustomParam("orgs", (Object)SerializationUtils.toJsonString(newOrgIds));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.equalsIgnoreCase("new")) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (null != nodeId && nodeId.equals(FINALROOTID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"SPU\u53ea\u80fd\u5728\u4e09\u7ea7\u5206\u7c7b\u4e0b\u521b\u5efa\u3002\u8bf7\u5148\u9009\u62e9\u7b2c3\u7ea7\u5206\u7c7b\uff0c\u518d\u65b0\u589eSPU\u3002", (String)"PmmProdSpuList_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter filters = new QFilter("level", "=", (Object)Integer.parseInt("3")).and(new QFilter("id", "=", (Object)Long.parseLong(nodeId)));
            DynamicObjectCollection goodsDyoCol = QueryServiceHelper.query((String)"mdr_goodsclass", (String)"id", (QFilter[])new QFilter[]{filters});
            if (CollectionUtils.isEmpty((Collection)goodsDyoCol)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"SPU\u53ea\u80fd\u5728\u4e09\u7ea7\u5206\u7c7b\u4e0b\u521b\u5efa\u3002\u8bf7\u5148\u9009\u62e9\u7b2c3\u7ea7\u5206\u7c7b\uff0c\u518d\u65b0\u589eSPU\u3002", (String)"PmmProdSpuList_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ("submit".equals(key)) {
            this.submitOp();
            args.setCancel(true);
        }
        if ("unsubmit".equals(key)) {
            this.unSubmitOp();
            args.setCancel(true);
        }
    }

    private void submitOp() {
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        Object[] entryPrimaryKeyValues = selectCol.getEntryPrimaryKeyValues();
        Object[] primaryKeyValues = selectCol.getPrimaryKeyValues();
        HashMap<Long, Integer> selectEntryIdAndRowIndexs = new HashMap<Long, Integer>(entryPrimaryKeyValues.length);
        for (ListSelectedRow listSelectedRow : selectCol) {
            selectEntryIdAndRowIndexs.put((Long)listSelectedRow.getEntryPrimaryKeyValue(), listSelectedRow.getRowKey());
        }
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObject[] spus = BusinessDataServiceHelper.load((String)"ent_spu", (String)"origin,id,orgfield,enable,supplier,group,number,status,spuskumapentry.confirmstatus,spuskumapentry.entryresult,spuskumapentry.note,spuskumapentry.seq,spuskumapentry.goods,baseattributeentry.prodattributevalue,saleattributeentry,saleattributeentry.seq,saleatrvalueentry.saleprodattributevalue,spuatrdetailentry.saleprodattributevalueid", (QFilter[])qFilter.toArray());
        PmmSpuValidatorServiceImpl entSpuValidatorService = new PmmSpuValidatorServiceImpl();
        Map res = entSpuValidatorService.submitHandleAndValid(spus, selectEntryIdAndRowIndexs);
        entSpuValidatorService.submitMessageShow(res, this.getView(), selectEntryIdAndRowIndexs);
        int successNum = (Integer)res.get("successNum");
        if (successNum > 0) {
            SaveServiceHelper.save((DynamicObject[])spus);
        }
        ((IListView)this.getView()).refresh();
    }

    private void unSubmitOp() {
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        Object[] entryPrimaryKeyValues = selectCol.getEntryPrimaryKeyValues();
        Object[] primaryKeyValues = selectCol.getPrimaryKeyValues();
        HashMap<Long, Integer> selectEntryIdAndRowIndexs = new HashMap<Long, Integer>(entryPrimaryKeyValues.length);
        for (ListSelectedRow listSelectedRow : selectCol) {
            selectEntryIdAndRowIndexs.put((Long)listSelectedRow.getEntryPrimaryKeyValue(), listSelectedRow.getRowKey());
        }
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObject[] spus = BusinessDataServiceHelper.load((String)"ent_spu", (String)"origin,id,number,status,enable,spuskumapentry.confirmstatus,spuskumapentry.entryresult", (QFilter[])qFilter.toArray());
        PmmSpuValidatorServiceImpl entSpuValidatorService = new PmmSpuValidatorServiceImpl();
        Map res = entSpuValidatorService.unSubmitHandleAndValid(spus, selectEntryIdAndRowIndexs);
        entSpuValidatorService.unSubmitMessageShow(res, this.getView(), selectEntryIdAndRowIndexs);
        int successNum = (Integer)res.get("successNum");
        int failNum = (Integer)res.get("failNum");
        if (successNum > 0 && failNum == 0) {
            SaveServiceHelper.save((DynamicObject[])spus);
        } else if (successNum > 0 && failNum > 0) {
            SaveServiceHelper.save((DynamicObject[])spus);
        }
        ((IListView)this.getView()).refresh();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey;
        super.afterDoOperation(args);
        switch (itemKey = args.getOperateKey()) {
            case "confirm": {
                if (!this.checkBeforeAudit()) break;
                this.auditResult();
                break;
            }
        }
    }

    private void auditResult() {
        ArrayList idList = StringConversionUtil.conversion((String)this.getPageCache().get("selectspu"));
        ArrayList entryIds = StringConversionUtil.conversion((String)this.getPageCache().get("entryIds"));
        if (entryIds.size() > 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("ids", String.join((CharSequence)",", idList));
            paramMap.put("entryIds", String.join((CharSequence)",", entryIds));
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pmm_spuauditcfm", paramMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "confirmActionId"), (ShowType)ShowType.Modal));
        }
    }

    private boolean checkBeforeAudit() {
        IListView listview = (IListView)this.getView();
        StringBuilder sb = new StringBuilder();
        ListSelectedRowCollection selectCols = listview.getSelectedRows();
        if (selectCols.size() == 0) {
            return false;
        }
        HashSet<String> idList = new HashSet<String>(selectCols.size());
        HashSet<Long> ids = new HashSet<Long>(selectCols.size());
        for (Object id : selectCols.getPrimaryKeyValues()) {
            idList.add(id.toString());
            ids.add(Long.parseLong(String.valueOf(id)));
        }
        Object[] entryPrimaryKeyValues = selectCols.getEntryPrimaryKeyValues();
        HashMap<Long, Integer> selectEntryIdAndRowIndexs = new HashMap<Long, Integer>(entryPrimaryKeyValues.length);
        for (ListSelectedRow listSelectedRow : selectCols) {
            selectEntryIdAndRowIndexs.put((Long)listSelectedRow.getEntryPrimaryKeyValue(), listSelectedRow.getRowKey());
        }
        Set entryIds = Arrays.stream(entryPrimaryKeyValues).map(String::valueOf).collect(Collectors.toSet());
        ArrayList<String> validEntryIds = new ArrayList<String>(entryIds.size());
        HashSet<String> removeList = new HashSet<String>();
        QFilter filter = new QFilter("spuskumapentry.id", "in", (Object)entryPrimaryKeyValues);
        filter.or(new QFilter("id", "in", ids));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pmm_spu", (String)"origin,id,number,enable,status,spuskumapentry.id entryid,spuskumapentry.confirmstatus confirmstatus", (QFilter[])filters);
        for (DynamicObject obj : objs) {
            if (null == selectEntryIdAndRowIndexs.get(obj.getLong("entryid")) || removeList.contains(obj.getString("id"))) continue;
            if ("2".equals(obj.getString("origin"))) {
                sb.append(ResManager.loadKDString((String)"{0}\uff1a\u53d1\u8d77\u65b9\u4e3a\u91c7\u8d2d\u65b9\uff0c\u65e0\u9700\u5ba1\u6838\u3002", (String)"PmmProdSpuList_10", (String)"scm-pmm-formplugin", (Object[])new Object[]{obj.getString("number")})).append("\n");
                removeList.add(obj.getString("id"));
                continue;
            }
            String status = obj.getString("status");
            if (!"B".equals(status)) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u4e0d\u662f\u5df2\u63d0\u4ea4\u7684\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002", (String)"PmmProdSpuList_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]), obj.getString("number"))).append("\n");
                removeList.add(obj.getString("id"));
                continue;
            }
            if ("0".equals(obj.getString("enable"))) {
                sb.append(ResManager.loadKDString((String)"{0}\uff1a\u5355\u636e\u4e0d\u662f\u53ef\u7528\u7684\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002", (String)"PmmProdSpuList_7", (String)"scm-pmm-formplugin", (Object[])new Object[]{obj.getString("number")})).append("\n");
                removeList.add(obj.getString("id"));
                continue;
            }
            if (null == selectEntryIdAndRowIndexs.get(obj.getLong("entryid"))) continue;
            if ("A".equals(obj.getString("confirmstatus"))) {
                validEntryIds.add(obj.getString("entryid"));
                continue;
            }
            sb.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\u5206\u5f55\u786e\u8ba4\u72b6\u6001\u4e0d\u662f\u5f85\u786e\u8ba4\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002", (String)"PmmProdSpuList_5", (String)"scm-pmm-formplugin", (Object[])new Object[]{obj.getString("number"), (Integer)selectEntryIdAndRowIndexs.get(obj.getLong("entryid")) + 1})).append("\n");
        }
        idList.removeAll(removeList);
        IPageCache cache = this.getPageCache();
        cache.put("selectspu", String.join((CharSequence)",", idList));
        cache.put("entryIds", String.join((CharSequence)",", validEntryIds));
        if (sb.length() > 0 && validEntryIds.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25", (String)"PmmProdSpuList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return false;
        }
        if (sb.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u9009\u62e9{0}\u6761\uff0c\u53ef\u5ba1\u6279{1}\u6761\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmProdSpuList_3", (String)"scm-pmm-formplugin", (Object[])new Object[]{idList.size() + removeList.size(), idList.size()}), String.valueOf(sb), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("auditCfm"));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("auditCfm".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.auditResult();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("confirmActionId")) {
            this.getView().invokeOperation("refresh");
        }
    }
}

