/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.BillFormUtil;

public class PmmProtocolList
extends AbstractListPlugin {
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (StringUtils.equals((CharSequence)"protocolcontinue", (CharSequence)evt.getItemKey())) {
            Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
            if (objects.length == 0 || objects.length > 1) {
                return;
            }
            DynamicObject pmm_priceprotocol = BillFormUtil.getSelectData((IFormView)this.getView(), (String)"pmm_protocol");
            if (null == pmm_priceprotocol) {
                return;
            }
            AppCache.get((String)this.getView().getPageId()).put("continue", (Object)"true");
            AppCache.get((String)this.getView().getPageId()).put("protocolnum", (Object)pmm_priceprotocol.getString("id"));
        }
        if (StringUtils.equals((CharSequence)"tblcopy", (CharSequence)evt.getItemKey())) {
            AppCache.get((String)this.getView().getPageId()).put("option", (Object)"copy");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if ("proend".equals(key) || "protocolgood".equals(key) || "protocolcontinue".equals(key)) {
            if (objects.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u64cd\u4f5c\u3002", (String)"PmmProtocolList_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("protocolgood".equals(key)) {
                this.checkProtocolgoood(args, objects);
            }
            if ("proend".equals(key)) {
                this.checkProEnd(args, objects);
            }
            if ("protocolcontinue".equals(key)) {
                this.checkProtocolContinue(args, objects);
            }
        }
    }

    private void checkProtocolContinue(BeforeDoOperationEventArgs args, Object[] objects) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(objects[0])));
        DynamicObjectCollection protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)"billstatus,continueprobillno", (QFilter[])qFilter.toArray());
        if (protocols.size() > 0) {
            String msg;
            DynamicObject protocol = (DynamicObject)protocols.get(0);
            String billstatus = protocol.getString("billstatus");
            Long continueprobillno = protocol.getLong("continueprobillno");
            if (!"C".equals(billstatus)) {
                msg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u534f\u8bae\u8fdb\u884c\u7eed\u7b7e\u64cd\u4f5c\u3002", (String)"PmmProtocolList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
            }
            if (0L != continueprobillno) {
                msg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u65e0\u7eed\u7b7e\u534f\u8bae\u7684\u534f\u8bae\u8fdb\u884c\u7eed\u7b7e\u64cd\u4f5c\u3002", (String)"PmmProtocolList_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
            }
        }
    }

    private void checkProEnd(BeforeDoOperationEventArgs args, Object[] objects) {
        QFilter qFilter = new QFilter("protocolid", "in", (Object)Long.parseLong(String.valueOf(objects[0])));
        QFilter statusQfilter = new QFilter("cfmstatus", "=", (Object)"E");
        statusQfilter.or(new QFilter("cfmstatus", "=", (Object)"A"));
        qFilter.and(statusQfilter);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"id", (QFilter[])qFilter.toArray());
        if (query.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u8be5\u534f\u8bae\u5173\u8054\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u4e0a\u67b6\u7533\u8bf7\u5355\uff0c\u8bf7\u5148\u64a4\u9500\u4e0a\u67b6\u7533\u8bf7\uff0c\u518d\u7ec8\u6b62\u534f\u8bae\u3002", (String)"PmmProtocolList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        }
    }

    private void checkProtocolgoood(BeforeDoOperationEventArgs args, Object[] objects) {
        QFilter qFilter = new QFilter("protocolid", "=", (Object)Long.parseLong(String.valueOf(objects[0])));
        QFilter statusQfilter = new QFilter("cfmstatus", "=", (Object)"E");
        statusQfilter.or(new QFilter("cfmstatus", "=", (Object)"A"));
        qFilter.and(statusQfilter);
        qFilter.and("biztype", "=", (Object)"1");
        DynamicObject ent_protocolCol = QueryServiceHelper.queryOne((String)"ent_prodrequest", (String)"id", (QFilter[])qFilter.toArray());
        if (null != ent_protocolCol) {
            String msg = ResManager.loadKDString((String)"\u8be5\u534f\u8bae\u5173\u8054\u7684\u5546\u54c1\u6b63\u5728\u4e0a\u67b6\u7533\u8bf7\u4e2d\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u5173\u8054\u5546\u54c1\u3002", (String)"PmmProtocolList_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"proend", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObject pmm_priceprotocol = BillFormUtil.getSelectData((IFormView)this.getView(), (String)"pmm_protocol");
            long orgId = pmm_priceprotocol.getDynamicObject("org").getLong("id");
            int permission = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)orgId, (String)"/FQ504NB63AY", (String)"pmm_protocol", (String)"2UY083WKU5W2");
            if (permission == 0) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u534f\u8bae\u7b7e\u8ba2\u201d\u7684\u201c\u534f\u8bae\u7ec8\u6b62\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmProtocolList_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", "true");
            ArrayList<Long> pks = new ArrayList<Long>(1024);
            pks.add(pmm_priceprotocol.getLong("id"));
            OperationServiceHelper.executeOperate((String)"protocolend", (String)"pmm_protocol", (Object[])pks.toArray(), (OperateOption)option);
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operate = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() == null || afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operate) {
                case "protocolgood": {
                    this.protocolGoodShowForm();
                    break;
                }
                case "proend": {
                    String confirmTip = ResManager.loadKDString((String)"\u534f\u8bae\u7ec8\u6b62\u540e\uff0c\u534f\u8bae\u4e0a\u67b6\u7684\u5546\u54c1\u5c06\u81ea\u52a8\u4e0b\u67b6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmProtocolList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("proend", (IFormPlugin)this));
                }
            }
        }
    }

    private void protocolGoodShowForm() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        paramMap.put("protocolId", objects[0]);
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(objects[0])));
        String selector = "entryentity1.material,partyb,entryentity1.id,entryentity1.materialname,entryentity1.purplanid";
        DynamicObjectCollection ent_protocolCol = QueryServiceHelper.query((String)"pmm_protocol", (String)selector, (QFilter[])qFilter.toArray());
        ArrayList<String> selectCol = new ArrayList<String>();
        HashMap<String, String> entryID_materialMap = new HashMap<String, String>();
        if (ent_protocolCol.size() > 0) {
            if (0L != ((DynamicObject)ent_protocolCol.get(0)).getLong("entryentity1.purplanid")) {
                HashSet materialIdSet = new HashSet(1024);
                for (DynamicObject protocol : ent_protocolCol) {
                    materialIdSet.add(protocol.getString("entryentity1.material") + protocol.getString("entryentity1.materialname") + protocol.getLong("entryentity1.purplanid"));
                }
                for (DynamicObject protocol : ent_protocolCol) {
                    String materialId = protocol.getString("entryentity1.material");
                    String materialName = protocol.getString("entryentity1.materialname");
                    String key = materialId + materialName + protocol.getLong("entryentity1.purplanid");
                    if (!materialIdSet.remove(key)) continue;
                    selectCol.add(protocol.getString("entryentity1.material"));
                    entryID_materialMap.put(protocol.getString("entryentity1.id"), materialId);
                }
            } else {
                for (DynamicObject protocol : ent_protocolCol) {
                    selectCol.add(protocol.getString("entryentity1.material"));
                    entryID_materialMap.put(protocol.getString("entryentity1.id"), protocol.getString("entryentity1.material"));
                }
            }
        }
        Long supplier = ((DynamicObject)ent_protocolCol.get(0)).getLong("partyb");
        String selectcols = String.join((CharSequence)",", selectCol);
        paramMap.put("allProd", selectcols);
        paramMap.put("supplier", supplier);
        paramMap.put("entrymapping", SerializationUtils.toJsonString(entryID_materialMap));
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_prodaudit", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, paramMap, null));
    }
}

