/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PmmPurPlanList
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMAL");
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (!superUser) {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), null, null, (String)"pmm_protocol", (String)"47150e89000000ac");
            List permOrgs = hasPermOrgResult.getHasPermOrgs();
            QFilter qFilter = new QFilter("protocol.org.id", "in", (Object)permOrgs);
            e.getQFilters().add(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"quickchangeorg")) {
            this.checkQuickChangeOrg(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"quickchangeorg")) {
            this.openOrgChangeForm();
        }
    }

    private void openOrgChangeForm() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pmm_purplanorgchange");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customParams = new HashMap<String, Object>(1024);
        customParams.put("purplanid", pks[0]);
        parameter.setCustomParams(customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "quickchangeorg"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("quickchangeorg".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void checkQuickChangeOrg(BeforeDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        if (pks.length != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PmmPurPlanList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(pks[0])));
        DynamicObjectCollection purPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"protocol.purmode,protocol.billstatus,protocol.protocolstatus", (QFilter[])qFilter.toArray());
        if (purPlans.size() > 0) {
            DynamicObject purPlan = (DynamicObject)purPlans.get(0);
            if (!"C".equals(purPlan.getString("protocol.billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5df2\u5ba1\u6838\u7684\u534f\u8bae\u5feb\u901f\u53d8\u66f4\u91c7\u4e70\u7ec4\u7ec7\u3002", (String)"PmmPurPlanList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("C".equals(purPlan.getString("protocol.protocolstatus")) || "D".equals(purPlan.getString("protocol.protocolstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5931\u6548\u6216\u5df2\u7ec8\u6b62\u7684\u534f\u8bae\u4e0d\u652f\u6301\u5feb\u901f\u53d8\u66f4\u91c7\u4e70\u7ec4\u7ec7\u3002", (String)"PmmPurPlanList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("1".equals(purPlan.getString("protocol.purmode"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u533a\u57df\u96c6\u91c7\u6216\u516c\u53f8\u81ea\u91c7\u7684\u534f\u8bae\u5feb\u901f\u53d8\u66f4\u91c7\u4e70\u7ec4\u7ec7\u3002", (String)"PmmPurPlanList_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

