/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.ExceptionUtil;

public class PmmUnitMappingList
extends StandardTreeListPlugin {
    private static final Log log = LogFactory.getLog(PmmUnitMappingList.class);
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private final String AUTOUNITPERMITEMID = "49VAH47+NS/1";
    private final String AUTOUNITTOUNITPERMITEMID = "49VAN3Y9RO79";

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        TreeNode rootNode = this.getTreeModel().createRootNode();
        rootNode.setId("0");
        rootNode.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeListBuildTreePlugin_0", (String)"scm-common", (Object[])new Object[0]));
        cloudNode.add(rootNode);
        DynamicObjectCollection standardDyos = this.getStandardDyos();
        for (DynamicObject row : standardDyos) {
            TreeNode node = new TreeNode();
            String nodeID = row.getString("id");
            node.setText(row.getString("name"));
            node.setParentid(rootNode.getId());
            node.setLongNumber(row.getString("number"));
            node.setId(nodeID);
            cloudNode.add(node);
        }
        Map<String, TreeNode> nodes = this.buildTree(cloudNode);
        ITreeModel treeModel = this.getTreeModel();
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeModel.setRoot(nodes.get("0"));
        treeView.addNode(nodes.get("0"));
        treeView.focusNode(nodes.get("0"));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)"ecunit", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            Object primaryKeyValue = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.doAddUnitMapping(primaryKeyValue);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String nodeId = e.getNodeId().toString();
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        if ("0".equals(nodeId)) {
            DynamicObjectCollection standardDyos = this.getStandardDyos();
            for (DynamicObject row : standardDyos) {
                TreeNode node = new TreeNode();
                String nodeID = row.getString("id");
                node.setText(row.getString("name"));
                node.setParentid("0");
                node.setLongNumber(row.getString("number"));
                node.setId(nodeID);
                treeNodes.add(node);
            }
        }
        return treeNodes;
    }

    private Map<String, TreeNode> buildTree(List<TreeNode> Nodes) {
        LinkedHashMap<String, TreeNode> allNodes = new LinkedHashMap<String, TreeNode>(Nodes.size());
        ArrayList<String> removeIds = new ArrayList<String>();
        for (TreeNode node : Nodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            if (node.getChildren() != null) continue;
            removeIds.add(node.getId());
        }
        for (int i = 0; i < removeIds.size(); ++i) {
            allNodes.remove(removeIds.get(i));
        }
        return allNodes;
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        if (null != nodeId && !"0".equals(nodeId)) {
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(nodeId));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)"platform", (QFilter[])qFilter.toArray());
            if (null != dynamicObject) {
                qFilters.add(new QFilter("platform", "=", (Object)dynamicObject.getString("platform")));
            }
        } else {
            qFilters.add(new QFilter("platform", "!=", null));
        }
    }

    private DynamicObjectCollection getStandardDyos() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        return QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform,standard.id,standard.number,standard.name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.equalsIgnoreCase("new")) {
            this.newValid(args);
        }
        if (key.equalsIgnoreCase("batchsetting")) {
            this.batchSettingValid(args);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("automapping".equals(itemKey)) {
            this.checkPermisson(evt, itemKey);
        }
        if ("automappingunit".equals(itemKey)) {
            this.checkPermisson(evt, itemKey);
        }
    }

    private void checkPermisson(BeforeItemClickEvent evt, String itemKey) {
        String msg;
        HasPermOrgResult hasPermOrgResult;
        List permOrgs;
        boolean superUser;
        if ("automapping".equals(itemKey) && !(superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) && (permOrgs = (hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), null, null, (String)"pmm_unitmapping", (String)"49VAH47+NS/1")).getHasPermOrgs()).size() == 0) {
            msg = ResManager.loadKDString((String)"\u65e0\u201c\u8ba1\u91cf\u5355\u4f4d\u6620\u5c04\u201d\u7684\u201c\u81ea\u52a8\u6620\u5c04\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmUnitMappingList_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
        }
        if ("automappingunit".equals(itemKey) && !(superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) && (permOrgs = (hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), null, null, (String)"pmm_unitmapping", (String)"49VAN3Y9RO79")).getHasPermOrgs()).size() == 0) {
            msg = ResManager.loadKDString((String)"\u65e0\u201c\u8ba1\u91cf\u5355\u4f4d\u6620\u5c04\u201d\u7684\u201c\u81ea\u52a8\u6620\u5c04\u5e76\u751f\u6210\u5355\u4f4d\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmUnitMappingList_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("automapping".equals(itemKey)) {
            this.doAutoMapping(false, itemKey);
        }
        if ("automappingunit".equals(itemKey)) {
            this.doAutoMapping(true, itemKey);
        }
    }

    private void batchSettingValid(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selCollection = ((IListView)this.getView()).getSelectedRows();
        if (selCollection.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PmmUnitMappingList_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("new".equals(operateKey)) {
            this.doAddUnitMapping(null);
        }
        if ("batchsetting".equals(operateKey)) {
            this.doBatchSetting();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    private void doAutoMapping(boolean isAutoUnit, String operateKey) {
        DynamicObjectCollection pmmUnitMappings;
        ListSelectedRowCollection selCollection = ((IListView)this.getView()).getSelectedRows();
        QFilter qFilter = new QFilter("mappingresult", "=", (Object)"2");
        if (selCollection.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>(16);
            for (ListSelectedRow row : selCollection) {
                ids.add(Long.parseLong(String.valueOf(row.getPrimaryKeyValue())));
            }
            qFilter.and("id", "in", ids);
        }
        if ((pmmUnitMappings = QueryServiceHelper.query((String)"pmm_unitmapping", (String)"id,ecunit", (QFilter[])qFilter.toArray())).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u91cf\u5355\u4f4d\u5df2\u6620\u5c04\u3002", (String)"PmmUnitMappingList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = "";
        msg = isAutoUnit ? ResManager.loadKDString((String)"\u5c06\u53d6{0}\u6761\u672a\u6620\u5c04\u7684\u5185\u5bb9\uff0c\u4e0e\u7cfb\u7edf\u73b0\u6709\u8ba1\u91cf\u5355\u4f4d\u901a\u8fc7\u540d\u79f0\u8fdb\u884c\u81ea\u52a8\u6620\u5c04\uff0c\u4e0d\u5b58\u5728\u540d\u79f0\u4e00\u81f4\u7684\u8ba1\u91cf\u5355\u4f4d\u65f6\uff0c\u5c06\u81ea\u52a8\u5728\u7535\u5546\u8ba1\u91cf\u5355\u4f4d\u5206\u7ec4\u4e0b\u521b\u5efa\u540d\u79f0\u4e00\u81f4\u7684\u8ba1\u91cf\u5355\u4f4d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmUnitMappingList_5", (String)"scm-pmm-formplugin", (Object[])new Object[]{pmmUnitMappings.size()}) : ResManager.loadKDString((String)"\u5c06\u53d6{0}\u6761\u672a\u6620\u5c04\u7684\u5185\u5bb9\uff0c\u4e0e\u7cfb\u7edf\u73b0\u6709\u8ba1\u91cf\u5355\u4f4d\u901a\u8fc7\u540d\u79f0\u8fdb\u884c\u81ea\u52a8\u6620\u5c04\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmUnitMappingList_4", (String)"scm-pmm-formplugin", (Object[])new Object[]{pmmUnitMappings.size()});
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        HasPermOrgResult hasPermOrgResult;
        List permOrgs;
        boolean superUser;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("automappingunit".equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
            if (!superUser && (permOrgs = (hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), null, null, (String)"pmm_unitmapping", (String)"49VAN3Y9RO79")).getHasPermOrgs()).size() == 0) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u8ba1\u91cf\u5355\u4f4d\u6620\u5c04\u201d\u7684\u201c\u81ea\u52a8\u6620\u5c04\u5e76\u751f\u6210\u5355\u4f4d\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmUnitMappingList_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            this.unitAutoMapping(true);
        }
        if ("automapping".equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
            if (!superUser && (permOrgs = (hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), null, null, (String)"pmm_unitmapping", (String)"49VAH47+NS/1")).getHasPermOrgs()).size() == 0) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u8ba1\u91cf\u5355\u4f4d\u6620\u5c04\u201d\u7684\u201c\u81ea\u52a8\u6620\u5c04\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmUnitMappingList_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            this.unitAutoMapping(false);
        }
    }

    private void unitAutoMapping(boolean isAutoUnit) {
        ListSelectedRowCollection selCollection = ((IListView)this.getView()).getSelectedRows();
        QFilter mappQFilter = new QFilter("mappingresult", "=", (Object)"2");
        if (selCollection.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>(16);
            for (ListSelectedRow row : selCollection) {
                ids.add(Long.parseLong(String.valueOf(row.getPrimaryKeyValue())));
            }
            mappQFilter.and("id", "in", ids);
        }
        DynamicObjectCollection pmmUnitMappings = QueryServiceHelper.query((String)"pmm_unitmapping", (String)"id,ecunit,platform", (QFilter[])mappQFilter.toArray());
        HashMap<Long, String> mappingMap = new HashMap<Long, String>(16);
        HashSet<String> ecunitNames = new HashSet<String>(16);
        for (DynamicObject row : pmmUnitMappings) {
            mappingMap.put(row.getLong("id"), row.getString("ecunit"));
            ecunitNames.add(row.getString("ecunit"));
        }
        HashSet<String> ecUnits = new HashSet<String>(16);
        ArrayList<DynamicObject> addUnitMappings = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> needSaveUnitMappings = new ArrayList<DynamicObject>(16);
        if (ecunitNames.size() > 0) {
            DynamicObject[] pmm_unitmappings;
            QFilter qFilter = new QFilter("name", "in", ecunitNames);
            DynamicObjectCollection bdMeasureUnits = QueryServiceHelper.query((String)"bd_measureunits", (String)"enable,status,name,id", (QFilter[])qFilter.toArray());
            HashMap<String, DynamicObject> measureUnitMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject measureUnit : bdMeasureUnits) {
                measureUnitMap.put(measureUnit.getString("name"), measureUnit);
            }
            Date now = TimeServiceHelper.now();
            QFilter unitmapQf = new QFilter("id", "in", mappingMap.keySet());
            for (DynamicObject unitMapp : pmm_unitmappings = BusinessDataServiceHelper.load((String)"pmm_unitmapping", (String)"platform,id,mappingresult,ecunit,unit,modifier,modifytime", (QFilter[])unitmapQf.toArray())) {
                String ecunit = unitMapp.getString("ecunit");
                if (measureUnitMap.size() > 0) {
                    DynamicObject measureUnit = (DynamicObject)measureUnitMap.get(ecunit);
                    if (null != measureUnit) {
                        if ("1".equals(measureUnit.getString("enable")) && "C".equals(measureUnit.getString("status"))) {
                            unitMapp.set("unit_id", (Object)measureUnit.getLong("id"));
                            unitMapp.set("mappingresult", (Object)"1");
                            unitMapp.set("modifier", (Object)RequestContext.get().getCurrUserId());
                            unitMapp.set("modifytime", (Object)now);
                        } else {
                            ecUnits.add(ecunit);
                        }
                        mappingMap.remove(unitMapp.getLong("id"));
                        needSaveUnitMappings.add(unitMapp);
                        continue;
                    }
                    addUnitMappings.add(unitMapp);
                    continue;
                }
                ecUnits.add(ecunit);
                addUnitMappings.add(unitMapp);
            }
        }
        if (isAutoUnit) {
            this.autoBdUnit(mappingMap, addUnitMappings, ecUnits);
            needSaveUnitMappings.addAll(addUnitMappings);
        }
        if (needSaveUnitMappings.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationServiceHelper.executeOperate((String)"save", (String)"pmm_unitmapping", (DynamicObject[])needSaveUnitMappings.toArray(new DynamicObject[0]), (OperateOption)option);
        }
        if (ecUnits.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u90e8\u5206\u7535\u5546\u8ba1\u91cf\u5355\u4f4d\u6620\u5c04\u5931\u8d25", (String)"PmmUnitMappingList_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            StringBuilder detail = new StringBuilder();
            for (String ecunit : ecUnits) {
                detail.append(ecunit).append(",");
            }
            if (detail.length() > 0) {
                this.getView().showMessage(msg, detail.substring(0, detail.length() - 1), MessageTypes.Default);
            }
        }
        this.getView().updateView();
    }

    private void autoBdUnit(Map<Long, String> mappingMap, List<DynamicObject> addUnitMappings, Set<String> ecUnits) {
        if (mappingMap.size() > 0) {
            QFilter qFilter = new QFilter("number", "=", (Object)"SYS-DS");
            DynamicObject unitGroup = QueryServiceHelper.queryOne((String)"bd_measureunitsgroup", (String)"id", (QFilter[])qFilter.toArray());
            if (null == unitGroup) {
                DynamicObject measureUnitGroup = ORM.create().newDynamicObject("bd_measureunitsgroup");
                measureUnitGroup.set("number", (Object)"SYS-DS");
                measureUnitGroup.set("name", (Object)ResManager.loadKDString((String)"\u7535\u5546\u8ba1\u91cf\u5355\u4f4d\u7ec4", (String)"PmmUnitMappingList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                measureUnitGroup.set("enable", (Object)"1");
                measureUnitGroup.set("status", (Object)"C");
                measureUnitGroup.set("creator", (Object)RequestContext.get().getCurrUserId());
                ORM.create().setPrimaryKey(measureUnitGroup);
                unitGroup = measureUnitGroup;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_measureunitsgroup", (DynamicObject[])new DynamicObject[]{measureUnitGroup}, (OperateOption)option);
                if (!operationResult.isSuccess()) {
                    log.info("$$$$bd_measureunitsgroup_save" + ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
                }
            }
            HashMap<String, Long> unitMap = new HashMap<String, Long>(16);
            ArrayList<DynamicObject> addUnits = new ArrayList<DynamicObject>(16);
            for (Map.Entry<Long, String> map : mappingMap.entrySet()) {
                DynamicObject measureUnit = ORM.create().newDynamicObject("bd_measureunits");
                ORM.create().setPrimaryKey(measureUnit);
                measureUnit.set("number", (Object)("DS-" + measureUnit.getString("id")));
                measureUnit.set("name", (Object)map.getValue());
                measureUnit.set("enable", (Object)"1");
                measureUnit.set("status", (Object)"C");
                measureUnit.set("group_id", (Object)unitGroup.getLong("id"));
                measureUnit.set("precisionaccount", (Object)"1");
                measureUnit.set("precision", (Object)0);
                measureUnit.set("enable", (Object)"1");
                unitMap.put(map.getValue(), measureUnit.getLong("id"));
                addUnits.add(measureUnit);
            }
            ArrayList<Long> successPkIds = new ArrayList<Long>(16);
            if (addUnits.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_measureunits", (DynamicObject[])addUnits.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!operationResult.isSuccess()) {
                    log.info("$$$$bd_measureunits_save" + ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
                }
                for (Object pk : operationResult.getSuccessPkIds()) {
                    successPkIds.add(Long.parseLong(String.valueOf(pk)));
                }
            }
            Date now = TimeServiceHelper.now();
            for (DynamicObject unitMapping : addUnitMappings) {
                String ecunit = unitMapping.getString("ecunit");
                long bdUnitId = (Long)unitMap.get(ecunit);
                if (null == unitMap.get(ecunit) || !successPkIds.contains(bdUnitId)) continue;
                unitMapping.set("unit_id", (Object)bdUnitId);
                unitMapping.set("mappingresult", (Object)"1");
                unitMapping.set("modifier", (Object)RequestContext.get().getCurrUserId());
                unitMapping.set("modifytime", (Object)now);
                ecUnits.remove(ecunit);
            }
        }
    }

    private void doBatchSetting() {
        CloseCallBack callBack = new CloseCallBack();
        callBack.setClassName(((Object)((Object)this)).getClass().getName());
        callBack.setActionId("batchsetting");
        HashMap<String, String> customFilter = new HashMap<String, String>();
        ListSelectedRowCollection selCollection = ((IListView)this.getView()).getSelectedRows();
        HashSet<String> unitMappingIds = new HashSet<String>(16);
        for (ListSelectedRow selectedRow : selCollection) {
            unitMappingIds.add(String.valueOf(selectedRow.getPrimaryKeyValue()));
        }
        customFilter.put("unitmappingids", SerializationUtils.toJsonString(unitMappingIds));
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pmm_batchunitmapp", customFilter, (CloseCallBack)callBack, (ShowType)ShowType.Modal));
    }

    private void doAddUnitMapping(Object pkId) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        CloseCallBack callBack = new CloseCallBack();
        callBack.setClassName(((Object)((Object)this)).getClass().getName());
        callBack.setActionId("new");
        HashMap<String, Object> customFilter = new HashMap<String, Object>();
        customFilter.put("platformid", nodeId);
        if (null != pkId) {
            customFilter.put("pkId", pkId);
        }
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pmm_unitmappingedit", customFilter, (CloseCallBack)callBack, (ShowType)ShowType.Modal));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("new".equals(actionId) || "batchsetting".equals(actionId)) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (null == nodeId || nodeId.equals("0")) {
                this.getView().updateView();
            } else {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void newValid(BeforeDoOperationEventArgs args) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (null == nodeId || nodeId.equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7535\u5546\u5e73\u53f0\u7c7b\u578b\u518d\u65b0\u589e\u3002", (String)"PmmUnitMappingList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.setCancel(true);
    }
}

