/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.task;

import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.event.ClickEventArgs;

public class PmmEcInitTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo != null) {
            if (!taskInfo.isTaskEnd()) {
                this.showProgress();
            } else {
                this.complete(taskInfo);
            }
            IFormView view = this.getParentView();
            if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
                this.getMainView().sendFormAction(view);
            }
        }
    }

    public boolean isExistProgressForm() {
        IFormView progressView;
        String progressPageId = TaskClientProxy.getProgressPageId((String)this.getTaskId());
        return StringUtils.isNotBlank((CharSequence)progressPageId) && (progressView = this.getMainView().getViewNoPlugin(progressPageId)) != null;
    }

    private void showProgress() {
        if (!this.isExistProgressForm()) {
            IFormView view = this.getParentView();
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (view != null && jobFormInfo != null) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pmm_inittaskrunning");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.getCustomParams().putAll(jobFormInfo.getParams());
                showParameter.getCustomParams().put("ecinit_jobforminfo", SerializationUtils.toJsonString((Object)jobFormInfo));
                showParameter.getCustomParams().put("ecinit_taskid", this.getTaskId());
                view.showForm(showParameter);
                this.setProgressPageId(showParameter.getPageId());
            }
        }
    }

    private void complete(TaskInfo taskInfo) {
        Map data;
        Object ecInitResultId;
        String strData;
        IFormView view = this.getParentView();
        if (view == null) {
            view = this.getMainView();
        }
        if (StringUtils.isNotBlank((CharSequence)(strData = taskInfo.getData())) && StringUtils.isNotBlank(ecInitResultId = (data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class)).get("ecInitResultId"))) {
            this.showEcInitResultDetailForm(view, ecInitResultId);
        }
    }

    private void showEcInitResultDetailForm(IFormView view, Object ecInitResultId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmm_initresult");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId(ecInitResultId);
        view.showForm((FormShowParameter)showParameter);
        TaskClientProxy.delTask((IFormView)this.getMainView(), (String)this.getTaskId());
    }
}

