/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pssc.business.helper.PsscPackageGroupHelper;
import kd.scm.pssc.business.helper.taskapprove.IPsscTaskApproveHandler;
import kd.scm.pssc.business.helper.taskapprove.PsscAllocateHandler;
import kd.scm.pssc.business.helper.taskapprove.PsscPackageGroupHandler;
import kd.scm.pssc.business.helper.taskapprove.PsscPriorityHandler;
import kd.scm.pssc.business.helper.taskapprove.PsscReBackHandler;
import kd.scm.pssc.business.helper.taskapprove.PsscTargetHandler;
import kd.scm.pssc.business.helper.taskapprove.PsscTransmitHandler;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.utils.PsscPackageGroupUtils;

public final class PsscTaskApproveAuditOp
extends AbstractOperationServicePlugIn {
    private static final Map<String, IPsscTaskApproveHandler> taskHandler = new HashMap<String, IPsscTaskApproveHandler>();
    private ArrayList<DynamicObject> needSyncDataTasks = new ArrayList(16);
    private ArrayList<DynamicObject> needSendMsgTasks = new ArrayList(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity.srcbillid");
        e.getFieldKeys().add("entryentity.entryresult");
        e.getFieldKeys().add("entryentity.approvetype");
        e.getFieldKeys().add("entryentity.opinion");
        e.getFieldKeys().add("entryentity.newpurgroup");
        e.getFieldKeys().add("entryentity.newhandler");
        e.getFieldKeys().add("entryentity.priority");
        e.getFieldKeys().add("entryentity.sourcetype");
        e.getFieldKeys().add("entryentity.srctype");
        e.getFieldKeys().add("entryentity.newsourceorg");
        e.getFieldKeys().add("entryentity.purmethod");
        e.getFieldKeys().add("entryentity.packagegroup");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> idlist = new ArrayList<Long>(16);
        HashMap<Long, DynamicObject> successMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entryentity = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                String entryresult = dynamicObject.getString("entryresult");
                String srcbillid = dynamicObject.getString("srcbillid");
                idlist.add(Long.parseLong(srcbillid));
                if (!"1".equals(entryresult)) continue;
                successMap.put(Long.parseLong(srcbillid), dynamicObject);
            }
        }
        QFilter idFilter = new QFilter("id", "in", idlist);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pssc_mytask", (String)"id,approvestatus,handler,purgroup,opinion,handleuser,sourcetype,srctype,purmethod,priority,sourceorg,handlestatus,number,packagegroup,material,jointdatachannelid", (QFilter[])idFilter.toArray());
        ArrayList logEntityList = new ArrayList(tasks.length);
        Map unDealPackGroup = new HashMap();
        block9: for (DynamicObject task : tasks) {
            task.set("approvestatus", (Object)"");
            long taskid = task.getLong("id");
            DynamicObject dynamicObject = (DynamicObject)successMap.get(taskid);
            if (dynamicObject == null || !successMap.containsKey(taskid)) continue;
            String approvetype = dynamicObject.getString("approvetype");
            IPsscTaskApproveHandler iPsscTaskApproveHandler = taskHandler.get(approvetype);
            if (iPsscTaskApproveHandler != null) {
                iPsscTaskApproveHandler.handler(this.needSyncDataTasks, this.needSendMsgTasks, logEntityList, task, dynamicObject);
            }
            switch (approvetype) {
                case "transmit": 
                case "allocate": {
                    PsscPackageGroupUtils.dealUnPackageData((DynamicObject)task, unDealPackGroup, (boolean)true);
                    continue block9;
                }
            }
        }
        if ((unDealPackGroup = PsscPackageGroupHelper.packageGroup(unDealPackGroup, (long)0L)).size() > 0) {
            for (DynamicObject task : tasks) {
                PsscPackageGroupUtils.dealPackageGroupInfo((DynamicObject)task, unDealPackGroup, (String)"id");
            }
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
        PsscHandleLogHelper.log(logEntityList);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OperationServiceHelper.executeOperate((String)"syncdata", (String)"pssc_mytask", (DynamicObject[])this.needSyncDataTasks.toArray(new DynamicObject[0]), null);
        OperationServiceHelper.executeOperate((String)"sendmsg", (String)"pssc_mytask", (DynamicObject[])this.needSendMsgTasks.toArray(new DynamicObject[0]), null);
    }

    static {
        taskHandler.put("transmit", (IPsscTaskApproveHandler)TypesContainer.createInstance(PsscTransmitHandler.class));
        taskHandler.put("priority", (IPsscTaskApproveHandler)TypesContainer.createInstance(PsscPriorityHandler.class));
        taskHandler.put("target", (IPsscTaskApproveHandler)TypesContainer.createInstance(PsscTargetHandler.class));
        taskHandler.put("allocate", (IPsscTaskApproveHandler)TypesContainer.createInstance(PsscAllocateHandler.class));
        taskHandler.put("packagegroup", (IPsscTaskApproveHandler)TypesContainer.createInstance(PsscPackageGroupHandler.class));
        taskHandler.put("reback", (IPsscTaskApproveHandler)TypesContainer.createInstance(PsscReBackHandler.class));
    }
}

