/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.opplugin.save;

import java.util.Calendar;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.pssc.business.helper.AppParameterHelper;
import kd.scm.pssc.opplugin.validator.PsscTimeSettingValidator;

public class PsscTimeSettingSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity.controlorgid");
        e.getFieldKeys().add("entryentity.control");
        e.getFieldKeys().add("timeentity.datefrom");
        e.getFieldKeys().add("timeentity.dateto");
        e.getFieldKeys().add("timeentity.starttimestamp");
        e.getFieldKeys().add("timeentity.endtimestamp");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("id");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PsscTimeSettingValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        boolean hasEnable = false;
        for (DynamicObject dataEntity : dataEntities) {
            String enable = dataEntity.getString("enable");
            if ("1".equals(enable)) {
                hasEnable = true;
            }
            DynamicObjectCollection timeentity = dataEntity.getDynamicObjectCollection("timeentity");
            for (DynamicObject row : timeentity) {
                Calendar start = Calendar.getInstance();
                start.setTime(row.getDate("datefrom"));
                start.set(1, 0);
                Calendar end = Calendar.getInstance();
                end.setTime(row.getDate("dateto"));
                end.set(1, 0);
                row.set("starttimestamp", (Object)start.getTimeInMillis());
                row.set("endtimestamp", (Object)end.getTimeInMillis());
            }
        }
        if (!AppParameterHelper.isReportControl() && hasEnable) {
            AppParameterHelper.saveReportControl();
        }
    }
}

