/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.opplugin.validator;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pssc.business.helper.AppParameterHelper;
import kd.scm.pssc.business.helper.ReqTimeSettingHelper;
import kd.scm.pssc.business.pojo.BillTypeOrgPair;
import kd.scm.pssc.business.pojo.TimeSettingParam;

public class PsscReqApplySubmitValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        return super.preparePropertys();
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (AppParameterHelper.isReportControl()) {
            Date now = TimeServiceHelper.now();
            Calendar instance = Calendar.getInstance();
            instance.setTime(now);
            instance.set(1, 0);
            long timeInMillis = instance.getTimeInMillis();
            TimeSettingParam param = new TimeSettingParam(this.getEntityKey(), timeInMillis);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject row = dataEntity.getDataEntity();
                long billtypeId = row.getLong("billtype_id");
                long orgId = row.getLong("org_id");
                String type = row.getString("type");
                if (!"1".equals(type)) continue;
                param.getBillTypeOrgInfoSet().add(new BillTypeOrgPair(billtypeId, orgId));
            }
            if (param.getBillTypeOrgInfoSet().size() > 0) {
                Map result = ReqTimeSettingHelper.matchNoticeInfo((TimeSettingParam)param);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    String notice;
                    DynamicObject row = dataEntity.getDataEntity();
                    long billtypeId = row.getLong("billtype_id");
                    long orgId = row.getLong("org_id");
                    String type = row.getString("type");
                    if (!"1".equals(type) || (notice = ReqTimeSettingHelper.getNoticeByBillTypeAndOrgId((Map)result, (long)billtypeId, (long)orgId)) == null) continue;
                    this.addErrorMessage(dataEntity, notice);
                }
            }
        }
    }
}

