/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.scm.pssc.common.utils.DateUtil;
import kd.scm.pssc.report.PurRptHelper;

public class PurReqBillRptQuery
extends AbstractReportListDataPlugin {
    private static final String ENTITY = "billentry";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<QFilter> qFilters = this.getFilters(filterInfo);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_requirapplybill", (String)this.getSelectFields(), (QFilter[])qFilters.toArray(new QFilter[0]), null);
        dataSet.select(this.getShowFields());
        return dataSet;
    }

    protected String getShowFields() {
        return "org,bizorg,billno,billtype,biztime,dept,bizuser,materialmasterid,auxpty,unit,qty,project,applyqty,matoutqty,reqdes,id";
    }

    protected String getSelectFields() {
        ArrayList<String> selectFields = new ArrayList<String>(36);
        selectFields.add("id");
        selectFields.add("org");
        selectFields.add("bizorg");
        selectFields.add("billtype");
        selectFields.add("billno");
        selectFields.add("biztime");
        selectFields.add("dept");
        selectFields.add("bizuser");
        selectFields.add("billentry.materialmasterid as materialmasterid");
        selectFields.add("billentry.auxpty as auxpty");
        selectFields.add("billentry.unit as unit");
        selectFields.add("billentry.qty as qty");
        selectFields.add("billentry.project as project");
        selectFields.add("billentry.applyqty as applyqty");
        selectFields.add("billentry.matoutqty as matoutqty");
        selectFields.add("billentry.rowclosestatus as rowclosestatus");
        selectFields.add("billentry.rowterminatestatus as rowterminatestatus");
        selectFields.add("billentry.reqdes as reqdes");
        selectFields.add("billentry.auditoption as auditoption");
        selectFields.add("billentry.option as option");
        return String.join((CharSequence)",", selectFields);
    }

    protected List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObject project;
        Date endDate;
        Date startDate;
        DynamicObjectCollection material;
        DynamicObjectCollection applyMan;
        DynamicObjectCollection dept;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        if (org != null) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if ((dept = filterInfo.getDynamicObjectCollection("reqdeptfield")) != null && dept.size() > 0) {
            filters.add(new QFilter("dept", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(dept)));
        }
        if ((applyMan = filterInfo.getDynamicObjectCollection("applymanfield")) != null && applyMan.size() > 0) {
            filters.add(new QFilter("bizuser", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(applyMan)));
        }
        if ((material = filterInfo.getDynamicObjectCollection("materialfield")) != null && material.size() > 0) {
            filters.add(new QFilter("billentry.materialmasterid", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(material)));
        }
        if ((startDate = filterInfo.getDate("startdatefield")) != null) {
            filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        }
        if ((endDate = filterInfo.getDate("enddatefield")) != null) {
            filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        }
        if ((project = filterInfo.getDynamicObject("projectfield")) != null) {
            filters.add(new QFilter("billentry.project", "=", project.getPkValue()));
        }
        filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        return filters;
    }
}

