/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.purreqrpt;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scm.pssc.common.utils.DateUtil;
import kd.scm.pssc.report.PurRptHelper;

public class PurReqBillRptHandle
implements IReportDataHandle {
    private static final String ENTITY = "billentry";

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> filters = this.getFilters(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"pm_requirapplybill".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
            Map repoColSrcColMap = srcBlockConf.getRepoColSrcColMap();
            repoColSrcColMap.putIfAbsent("billentryid", "billentry.id");
            repoColSrcColMap.putIfAbsent("id", "id");
            Map repoColFullSrcColMap = srcBlockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("billentryid", "billentry.id");
            repoColFullSrcColMap.putIfAbsent("id", "id");
        }
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ReportColumn reportCol = null;
        for (AbstractReportColumn abstractReportColumn : cols) {
            String fieldKey;
            if (!(abstractReportColumn instanceof ReportColumn) || !"material_ref_name".equals(fieldKey = (reportCol = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            reportCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"PurReqBillRptHandle_1", (String)"scm-pssc-report", (Object[])new Object[0])));
        }
        return cols;
    }

    protected List<QFilter> getFilters(Map<String, Object> params) {
        DynamicObject project;
        Date endDate;
        Date startDate;
        DynamicObjectCollection material;
        DynamicObjectCollection applyMan;
        DynamicObjectCollection dept;
        if (params == null || params.size() == 0) {
            return null;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObjectCollection org = (DynamicObjectCollection)params.get("orgfield");
        if (org != null && org.size() != 0) {
            filters.add(new QFilter("org", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(org)));
        }
        if ((dept = (DynamicObjectCollection)params.get("reqdeptfield")) != null && dept.size() > 0) {
            filters.add(new QFilter("dept", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(dept)));
        }
        if ((applyMan = (DynamicObjectCollection)params.get("applymanfield")) != null && applyMan.size() > 0) {
            filters.add(new QFilter("bizuser", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(applyMan)));
        }
        if ((material = (DynamicObjectCollection)params.get("materialfield")) != null && material.size() > 0) {
            filters.add(new QFilter("billentry.materialmasterid", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(material)));
        }
        if ((startDate = (Date)params.get("startdatefield")) != null) {
            filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        }
        if ((endDate = (Date)params.get("enddatefield")) != null) {
            filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        }
        if ((project = (DynamicObject)params.get("projectfield")) != null) {
            filters.add(new QFilter("billentry.project", "=", project.getPkValue()));
        }
        return filters;
    }

    public void transformResult(List<IDataTransform> transCollector, final ReportDataCtx ctx) {
        transCollector.add(new IDataTransform(){

            public DataSet doTransform(DataSet srcData) {
                TableDefine srcTable = EntityMetadataCache.loadTableDefine((String)"pm_requirapplybill", (String)PurReqBillRptHandle.ENTITY);
                TableDefine targetTable = EntityMetadataCache.loadTableDefine((String)"pm_purapplybill", (String)PurReqBillRptHandle.ENTITY);
                LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)"pm_purapplybill");
                if (srcTable != null && targetTable != null && linkSet != null) {
                    Long tableId = srcTable.getTableId();
                    Long tableId1 = targetTable.getTableId();
                    String trackerTable = linkSet.getTrackerTable();
                    DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)("select ftid targetentryid,fsid sourceentryid from " + trackerTable + " where fttableid = ? and fstableid = ? "), (Object[])new Object[]{tableId1, tableId});
                    Set showKeyCols = ctx.getShowKeyCols();
                    HashSet<String> showKeys = new HashSet<String>(ctx.getShowKeyCols().size());
                    showKeys.addAll(showKeyCols);
                    showKeys.add("billentryid");
                    DataSet finish = srcData.leftJoin(dataSet).on("billentryid", "sourceentryid").select(showKeys.toArray(new String[0]), new String[]{"targetentryid"}).finish();
                    DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_purapplybill", (String)"billentry.id,billentry.invqty invqty,billentry.receiveqty receiveqty,billentry.unit purunit,billentry.orderqty orderqty", null, null);
                    DataSet finish1 = finish.leftJoin(dataSet1).on("targetentryid", "billentry.id").select(showKeys.toArray(new String[0]), new String[]{"purunit", "orderqty", "receiveqty", "invqty", "billentry.id"}).finish();
                    DataSet dataSet2 = finish1.orderBy(new String[]{"billno desc", "billentryid asc"});
                    return dataSet2;
                }
                DataSet dataSet = srcData.orderBy(new String[]{"billno desc", "billentryid asc"});
                return dataSet;
            }
        });
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("billentryid");
    }
}

