/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.mservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.botp.ConvertRuleReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pssc.common.enums.HandleStatusEnums;
import kd.scm.pssc.common.utils.PsscAutoprocessUtil;
import kd.scm.pssc.common.utils.PsscParamUtil;
import kd.scm.pssc.mservice.api.IPsscBillService;

public class PsscBillServiceImpl
implements IPsscBillService {
    private static Log log = LogFactory.getLog(PsscBillServiceImpl.class);

    public Map<String, Object> updateContractStatus(Set<Long> reqEntryIds, String type) {
        DynamicObject[] pssc_mytask;
        log.info("\u66f4\u65b0\u4efb\u52a1\u6c60\u5904\u7406\u72b6\u6001\uff0c\u4f9b\u5e94\u94fe\u53c2\u6570\uff1a" + JSONObject.toJSONString(reqEntryIds));
        if (reqEntryIds == null || reqEntryIds.isEmpty()) {
            String expMsg = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u4efb\u52a1\u6c60\u5904\u7406\u72b6\u6001\uff0c\u4f9b\u5e94\u94fe\u53c2\u6570\u5f02\u5e38", (String)"PsscBillServiceImpl_0", (String)"scm-pssc-mservice", (Object[])new Object[0]), new Object[0]);
            log.error(expMsg);
            return this.buildFailureResult(expMsg);
        }
        List srcentryidList = reqEntryIds.stream().map(String::valueOf).collect(Collectors.toList());
        QFilter filter = new QFilter("srcentryid", "in", srcentryidList);
        block8: for (DynamicObject dynamicObject : pssc_mytask = BusinessDataServiceHelper.load((String)"pssc_mytask", (String)"handlestatus,statusbeforeend", (QFilter[])filter.toArray())) {
            String status = dynamicObject.getString("handlestatus");
            switch (type) {
                case "1": {
                    if (HandleStatusEnums.TERMINATED.getValue().equals(status) || HandleStatusEnums.SUSPEND.getValue().equals(status)) continue block8;
                    dynamicObject.set("handlestatus", (Object)HandleStatusEnums.TERMINATED.getValue());
                    dynamicObject.set("statusbeforeend", (Object)status);
                    continue block8;
                }
                case "2": {
                    String statusBeforeEnd = dynamicObject.getString("statusbeforeend");
                    if (!StringUtils.isNotBlank((CharSequence)statusBeforeEnd) || HandleStatusEnums.SUSPEND.getValue().equals(status)) continue block8;
                    dynamicObject.set("handlestatus", (Object)statusBeforeEnd);
                    continue block8;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])pssc_mytask);
        return this.buildSuccessResult();
    }

    public Map<String, Object> updateTaskByReqChangeIds(Set<String> reqBillIds) {
        String errMsg = "";
        DynamicObject[] tasks = this.getTaskBills(reqBillIds, "srcbillid");
        if (tasks == null || tasks.length == 0) {
            errMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u53d8\u66f4\u5355\u5173\u8054\u7684\u7533\u8bf7\u5355\u5931\u8d25\uff0c\u7533\u8bf7\u5355\u5355ID\uff1a%1s", (String)"PsscBillServiceImpl_2", (String)"scm-pssc-mservice", (Object[])new Object[0]), reqBillIds);
            return this.buildFailureResult(errMsg);
        }
        HashMap<Long, List<Long>> applyIdTaskIdMap = this.getApplyIdTaskIdMap(tasks);
        DynamicObject[] applybills = BusinessDataServiceHelper.load((Object[])reqBillIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pm_purapplybill"));
        ArrayList<Long> deletedList = new ArrayList<Long>();
        HashMap<Long, List<Long>> addMap = new HashMap<Long, List<Long>>();
        ArrayList<Long> updateList = new ArrayList<Long>();
        this.classifyData(applyIdTaskIdMap, applybills, deletedList, addMap, updateList);
        this.dealDeteleScene(deletedList);
        this.dealUpdateScene(updateList);
        this.dealAddScene(addMap);
        return StringUtils.isEmpty((CharSequence)errMsg) ? this.buildFailureResult(errMsg) : this.buildSuccessResult();
    }

    public Map<String, Object> updateTaskByReqBatchChangeIds(List<Long> reqBillEntryIds) {
        this.dealUpdateScene(reqBillEntryIds);
        return this.buildSuccessResult();
    }

    public Map<String, String> getTaskPoolOpen(Set<String> orgIds) {
        Map paramObjByOrg = PsscParamUtil.ifTaskPoolEnable(orgIds);
        return paramObjByOrg;
    }

    private Map<String, Object> buildFailureResult(String errMsg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", false);
        map.put("errmsg", errMsg);
        return map;
    }

    private HashMap<String, Object> buildSuccessResult() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", true);
        return map;
    }

    private void classifyData(Map<Long, List<Long>> applyIdTaskIdMap, DynamicObject[] applybills, List<Long> deletedList, Map<Long, List<Long>> addMap, List<Long> updateList) {
        for (DynamicObject applybill : applybills) {
            DynamicObjectCollection billentry = applybill.getDynamicObjectCollection("billentry");
            ArrayList<Long> entryidList = new ArrayList<Long>();
            for (DynamicObject entry : billentry) {
                entryidList.add(entry.getLong("id"));
            }
            List<Long> oldentryidList = applyIdTaskIdMap.get(applybill.getLong("id"));
            if (oldentryidList == null || oldentryidList.size() == 0) continue;
            ArrayList<Long> copyoldentryidList1 = new ArrayList<Long>(oldentryidList);
            ArrayList<Long> copyoldentryidList2 = new ArrayList<Long>(oldentryidList);
            ArrayList copyentryidList = new ArrayList(entryidList);
            oldentryidList.removeAll(entryidList);
            if (oldentryidList.size() > 0) {
                deletedList.addAll(oldentryidList);
            }
            entryidList.removeAll(copyoldentryidList1);
            if (entryidList.size() > 0) {
                addMap.put(applybill.getLong("id"), entryidList);
            }
            copyentryidList.retainAll(copyoldentryidList2);
            if (copyentryidList.size() <= 0) continue;
            updateList.addAll(copyentryidList);
        }
    }

    private HashMap<Long, List<Long>> getApplyIdTaskIdMap(DynamicObject[] tasks) {
        HashMap<Long, List<Long>> applyIdTaskIdMap = new HashMap<Long, List<Long>>();
        for (DynamicObject task : tasks) {
            String srcbillid = task.getString("srcbillid");
            String srcentryid = task.getString("srcentryid");
            List<Long> taskIdList = applyIdTaskIdMap.get(Long.parseLong(srcbillid));
            if (taskIdList == null) {
                taskIdList = new ArrayList<Long>(16);
                taskIdList.add(Long.parseLong(srcentryid));
            } else {
                taskIdList.add(Long.parseLong(srcentryid));
            }
            applyIdTaskIdMap.put(Long.parseLong(srcbillid), taskIdList);
        }
        return applyIdTaskIdMap;
    }

    private void dealDeteleScene(List<Long> deletedList) {
        List srcEntryids = deletedList.stream().map(Object::toString).collect(Collectors.toList());
        QFilter filter = new QFilter("srcentryid", "in", srcEntryids);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pssc_mytask", (String)"id", (QFilter[])filter.toArray());
        OperationServiceHelper.executeOperate((String)"delete", (String)"pssc_mytask", (DynamicObject[])tasks, (OperateOption)OperateOption.create());
    }

    private void dealUpdateScene(List<Long> updateList) {
        QFilter filter;
        Map<String, String> filedMap = this.buildApplyToTaskFieldMap();
        Set<Map.Entry<String, String>> entries = filedMap.entrySet();
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pm_purapplybill", (boolean)false);
        DynamicObject[] applybills = BusinessDataServiceHelper.load((String)"pm_purapplybill", (String)(selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pm_purapplybill", (String)"billentry", (boolean)false)), (QFilter[])(filter = new QFilter("billentry.id", "in", updateList)).toArray());
        if (applybills == null || applybills.length == 0) {
            return;
        }
        DynamicObject[] tasks = this.getTaskBills(updateList.stream().map(Object::toString).collect(Collectors.toSet()), "srcentryid");
        DataEntityPropertyCollection headprops = applybills[0].getDynamicObjectType().getProperties();
        HashMap<String, DynamicObject> idTaskMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject task : tasks) {
            idTaskMap.put(task.getString("srcentryid"), task);
        }
        HashSet<Long> realChangedTaskSet = new HashSet<Long>(16);
        for (DynamicObject applybill : applybills) {
            DynamicObjectCollection billentry = applybill.getDynamicObjectCollection("billentry");
            DataEntityPropertyCollection entryProps = billentry.getDynamicObjectType().getProperties();
            for (DynamicObject entry : billentry) {
                String entryid = entry.getString("id");
                DynamicObject taskbill = (DynamicObject)idTaskMap.get(entryid);
                if (taskbill == null) continue;
                for (Map.Entry<String, String> mapEntry : entries) {
                    IDataEntityProperty prop = (IDataEntityProperty)headprops.get((Object)mapEntry.getKey());
                    String targetPropKey = filedMap.get(mapEntry.getKey());
                    if (prop == null) {
                        Object newObject = entry.get(mapEntry.getKey());
                        Object oldObject = taskbill.get(targetPropKey);
                        if (this.isRealChanged(oldObject, newObject)) {
                            realChangedTaskSet.add(taskbill.getLong("id"));
                        }
                        prop = (IDataEntityProperty)entryProps.get((Object)mapEntry.getKey());
                        taskbill.set(targetPropKey, entry.get(mapEntry.getKey()));
                        if ("qty".equals(mapEntry.getKey()) && entry.getLong("joinqty") != 0L) {
                            String status = taskbill.getString("handlestatus");
                            if (entry.getLong("qty") > entry.getLong("joinqty")) {
                                taskbill.set(HandleStatusEnums.SUSPEND.getValue().equals(status) ? "statusbeforeend" : "handlestatus", (Object)HandleStatusEnums.PARTORDER.getValue());
                            } else {
                                taskbill.set(HandleStatusEnums.SUSPEND.getValue().equals(status) ? "statusbeforeend" : "handlestatus", (Object)HandleStatusEnums.TOORDER.getValue());
                            }
                        }
                        if (prop instanceof LargeTextProp) {
                            taskbill.set(targetPropKey + "_tag", entry.get(mapEntry.getKey() + "_tag"));
                        }
                        if (!(prop instanceof MulBasedataProp)) continue;
                        DynamicObjectCollection xRows = (DynamicObjectCollection)entry.get(mapEntry.getKey());
                        DynamicObjectCollection rows = this.copyNewMulBaseData(xRows);
                        taskbill.set(targetPropKey, (Object)rows);
                        continue;
                    }
                    taskbill.set(targetPropKey, applybill.get(mapEntry.getKey()));
                    if (prop instanceof LargeTextProp) {
                        taskbill.set(targetPropKey + "_tag", applybill.get(mapEntry.getKey() + "_tag"));
                    }
                    if (!(prop instanceof MulBasedataProp)) continue;
                    DynamicObjectCollection xRows = (DynamicObjectCollection)applybill.get(mapEntry.getKey());
                    DynamicObjectCollection rows = this.copyNewMulBaseData(xRows);
                    taskbill.set(targetPropKey, (Object)rows);
                }
            }
        }
        this.dealApproveBill(realChangedTaskSet);
        List<DynamicObject> taskList = Arrays.asList(tasks);
        PsscAutoprocessUtil.autoProcess(taskList, (boolean)true);
        SaveServiceHelper.save((DynamicObject[])tasks);
        OperationServiceHelper.executeOperate((String)"syncdata", (String)"pssc_mytask", (DynamicObject[])tasks, null);
    }

    private boolean isRealChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return false;
        }
        if (oldObject == null) {
            return true;
        }
        if (newObject == null) {
            return true;
        }
        if (oldObject instanceof BigDecimal) {
            if (newObject instanceof BigDecimal && ((BigDecimal)oldObject).compareTo((BigDecimal)newObject) != 0) {
                return true;
            }
            if (newObject instanceof String && ((BigDecimal)oldObject).compareTo(new BigDecimal(newObject.toString())) != 0) {
                return true;
            }
        } else if (oldObject.getClass().isAssignableFrom(newObject.getClass())) {
            if (newObject instanceof DynamicObject) {
                if (!((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                    return true;
                }
            } else {
                if (!(newObject instanceof OrmLocaleValue) || !(oldObject instanceof OrmLocaleValue)) {
                    return !oldObject.equals(newObject);
                }
                if (((OrmLocaleValue)newObject).getLocaleValue() == null) {
                    return true;
                }
                if (((OrmLocaleValue)oldObject).getLocaleValue() == null) {
                    return true;
                }
                if (!((OrmLocaleValue)oldObject).getLocaleValue().equals(((OrmLocaleValue)newObject).getLocaleValue())) {
                    return true;
                }
            }
        }
        return false;
    }

    private DynamicObjectCollection copyNewMulBaseData(DynamicObjectCollection oldRows) {
        DynamicObjectCollection xRows = new DynamicObjectCollection();
        if (oldRows != null && !oldRows.isEmpty() && oldRows instanceof MulBasedataDynamicObjectCollection) {
            DynamicObjectType type = oldRows.getDynamicObjectType();
            Iterator iterator = oldRows.iterator();
            while (oldRows.iterator().hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                DynamicObject value = row.getDynamicObject("fbasedataid");
                DynamicObject xRow = new DynamicObject(type);
                xRow.set("fbasedataid", (Object)value);
                xRows.add((Object)xRow);
            }
            return xRows;
        }
        return xRows;
    }

    private DynamicObject[] getTaskBills(Set<String> reqBillIds, String type) {
        String taskfields = DynamicObjectUtil.getSelectfields((String)"pssc_mytask", (boolean)false);
        QFilter taskfilter = new QFilter(type, "in", reqBillIds);
        return BusinessDataServiceHelper.load((String)"pssc_mytask", (String)taskfields, (QFilter[])taskfilter.toArray());
    }

    private Map<String, String> buildApplyToTaskFieldMap() {
        ConvertRuleReader reader = new ConvertRuleReader();
        List convertRuleElements = reader.loadRules("pm_purapplybill", "pssc_mytask");
        List fieldMapItems = ((ConvertRuleElement)convertRuleElements.get(0)).getFieldMapPolicy().getFieldMaps();
        HashMap<String, String> botpMapping = new HashMap<String, String>(fieldMapItems.size());
        for (FieldMapItem fieldMapItem : fieldMapItems) {
            String sourceFieldKey = fieldMapItem.getSourceFieldKey();
            String targetFieldKey = fieldMapItem.getTargetFieldKey();
            if (StringUtils.isBlank((CharSequence)sourceFieldKey)) continue;
            botpMapping.put(sourceFieldKey, targetFieldKey);
        }
        return botpMapping;
    }

    private void dealApproveBill(Set<Long> realChangedTaskSet) {
        if (!realChangedTaskSet.isEmpty()) {
            DynamicObject[] approveBills;
            List srcbillids = realChangedTaskSet.stream().map(Object::toString).collect(Collectors.toList());
            QFilter taskIdFilter = new QFilter("billstatus", "!=", (Object)"C");
            taskIdFilter.and(new QFilter("entryentity.srcbillid", "in", srcbillids));
            for (DynamicObject approveBill : approveBills = BusinessDataServiceHelper.load((String)"pssc_task_approve", (String)"billno, entryentity.tasknumber, entryentity.cancelstatus,entryentity.entryresult", (QFilter[])taskIdFilter.toArray())) {
                DynamicObjectCollection entryentity = approveBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    entry.set("cancelstatus", (Object)"1");
                    entry.set("entryresult", (Object)"0");
                }
            }
            SaveServiceHelper.save((DynamicObject[])approveBills);
        }
    }

    private void dealAddScene(Map<Long, List<Long>> addMap) {
        if (addMap == null || addMap.size() == 0) {
            return;
        }
        List<DynamicObject> tasks = this.doPush(addMap);
        PsscAutoprocessUtil.autoProcess(tasks, (boolean)false);
    }

    private List<DynamicObject> doPush(Map<Long, List<Long>> addMap) {
        ConvertOperationResult result;
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pm_purapplybill");
        pushArgs.setTargetEntityNumber("pssc_mytask");
        pushArgs.setRuleId("1873108404718108672");
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(16);
        Set<Map.Entry<Long, List<Long>>> entries = addMap.entrySet();
        for (Map.Entry<Long, List<Long>> entry : entries) {
            List<Long> applyBillEntryIds = entry.getValue();
            for (Long applyBillEntryId : applyBillEntryIds) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)entry.getKey());
                row.setEntryEntityKey("billentry");
                row.setEntryPrimaryKeyValue((Object)applyBillEntryId);
                selectedRowList.add(row);
            }
        }
        pushArgs.setHasRight(false);
        pushArgs.setSelectedRows(selectedRowList);
        try {
            result = ConvertServiceHelper.push((PushArgs)pushArgs);
        }
        catch (Exception e) {
            String logmessage = ResManager.loadKDString((String)"\u4e0b\u63a8\u751f\u6210\u4efb\u52a1\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"PsscApplyBillChangeEvent_1", (String)"scm-pssc-mservice", (Object[])new Object[0]);
            log.error(e.getMessage());
            throw new KDException(new ErrorCode("push error", logmessage), new Object[]{e.getMessage()});
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pssc_mytask");
        if (!result.isSuccess()) {
            String logMsg = "push exception, reason:" + result.getMessage();
            log.info(logMsg);
            throw new KDException(new ErrorCode("push error", logMsg), new Object[0]);
        }
        List targetObjects = result.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainType);
        return targetObjects;
    }
}

