/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.mservice.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.pssc.common.utils.PsscParamUtil;

public class PsscAutoDeleteTaskEvent
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PsscAutoDeleteTaskEvent.class);

    public Object handleEvent(KDBizEvent e) {
        if (e instanceof EntityEvent) {
            EntityEvent event = (EntityEvent)e;
            String entityNumber = event.getEntityNumber();
            String operation = event.getOperation();
            List businesskeys = event.getBusinesskeys();
            if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)operation) || businesskeys == null || businesskeys.size() == 0) {
                logger.info("\u4e8b\u4ef6\u8ba2\u9605\u7684\u53c2\u6570\u4e3a\u7a7a");
                return e.getEventId();
            }
            if ("pm_purapplybill".equals(entityNumber) && "unaudit".equals(operation)) {
                List ids = businesskeys.stream().map(Long::parseLong).collect(Collectors.toList());
                QFilter idFilter = new QFilter("id", "in", ids);
                DynamicObjectCollection applyBills = QueryServiceHelper.query((String)entityNumber, (String)"id, org", (QFilter[])idFilter.toArray());
                HashSet<String> orgSet = new HashSet<String>();
                HashMap<Long, String> idOrgidMap = new HashMap<Long, String>();
                for (DynamicObject applyBill : applyBills) {
                    orgSet.add(applyBill.getString("org"));
                    idOrgidMap.put(applyBill.getLong("id"), applyBill.getString("org"));
                }
                Map poolEnableMap = PsscParamUtil.ifTaskPoolEnable(orgSet);
                ids.removeIf(id -> "false".equals(poolEnableMap.get(idOrgidMap.get(id))));
                List isStringList = ids.stream().map(Object::toString).collect(Collectors.toList());
                if (!ids.isEmpty()) {
                    QFilter filter = new QFilter("srcbillid", "in", isStringList);
                    DynamicObject[] pssc_mytask = BusinessDataServiceHelper.load((String)"pssc_mytask", (String)"id", (QFilter[])filter.toArray());
                    OperationServiceHelper.executeOperate((String)"delete", (String)"pssc_mytask", (DynamicObject[])pssc_mytask, null);
                }
            }
        } else {
            logger.info("\u4e8b\u4ef6\u8ba2\u9605\u7ed1\u5b9a\u7684\u4e8b\u4ef6\u5b9a\u4e49\u4e0d\u662f\u64cd\u4f5c\u4e8b\u4ef6");
        }
        return e.getEventId();
    }
}

