/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.mservice.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.pssc.common.utils.PsscAutoprocessUtil;
import kd.scm.pssc.common.utils.PsscParamUtil;

public class PsscAutoPushTaskEvent
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PsscAutoPushTaskEvent.class);

    public Object handleEvent(KDBizEvent evt) {
        try {
            if (evt instanceof EntityEvent) {
                EntityEvent event = (EntityEvent)evt;
                String entityNumber = event.getEntityNumber();
                String operation = event.getOperation();
                if ("pm_purapplybill".equals(entityNumber) && "audit".equals(operation)) {
                    List businesskeys = event.getBusinesskeys();
                    HashSet<Long> applyBillIds = new HashSet<Long>(businesskeys.size());
                    businesskeys.forEach(row -> applyBillIds.add(Long.parseLong(row)));
                    this.filterPoolOpenData(applyBillIds, entityNumber);
                    if (applyBillIds.size() == 0) {
                        return evt.getEventId();
                    }
                    List<DynamicObject> targetObjects = this.doPush(applyBillIds, entityNumber);
                    PsscAutoprocessUtil.autoProcess(targetObjects, (boolean)false);
                    return evt.getEventId();
                }
            }
        }
        catch (Exception e) {
            logger.error("PsscAutoPushTaskEvent." + e.getMessage(), (Throwable)e);
        }
        return evt.getEventId();
    }

    private void filterPoolOpenData(Set<Long> applyBillIds, String entityNumber) {
        QFilter idFilter = new QFilter("id", "in", applyBillIds);
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)entityNumber, (String)"id, org", (QFilter[])idFilter.toArray());
        HashMap<String, HashSet<Long>> orgMapApplyIds = new HashMap<String, HashSet<Long>>(16);
        for (DynamicObject billObj : billObjs) {
            HashSet<Long> billIds = (HashSet<Long>)orgMapApplyIds.get(billObj.getString("org"));
            if (billIds == null) {
                billIds = new HashSet<Long>(10);
                orgMapApplyIds.put(billObj.getString("org"), billIds);
            }
            billIds.add(billObj.getLong("id"));
        }
        Map taskPoolEnable = PsscParamUtil.ifTaskPoolEnable(orgMapApplyIds.keySet());
        for (Map.Entry next : orgMapApplyIds.entrySet()) {
            Set value = (Set)next.getValue();
            String orgEnablePool = (String)taskPoolEnable.get(next.getKey());
            if (Boolean.parseBoolean(orgEnablePool)) continue;
            applyBillIds.removeAll(value);
        }
    }

    private List<DynamicObject> doPush(Set<Long> reqIds, String srcEntity) {
        String logMsg;
        ConvertOperationResult result;
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber("pssc_mytask");
        pushArgs.setRuleId("1873108404718108672");
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(reqIds.size());
        for (Long pk : reqIds) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)pk);
            selectedRowList.add(row);
        }
        pushArgs.setHasRight(false);
        pushArgs.setSelectedRows(selectedRowList);
        try {
            result = ConvertServiceHelper.push((PushArgs)pushArgs);
        }
        catch (Exception e) {
            logMsg = String.format(ResManager.loadKDString((String)"%1s push %2s  fail reason: %3s", (String)"PsscAutoPushTaskEvent_0", (String)"scm-pssc-mservice", (Object[])new Object[0]), srcEntity, "pssc_mytask", e.getMessage());
            logger.info(logMsg);
            throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u751f\u6210\u4efb\u52a1\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"PsscAutoPushTaskEvent_1", (String)"scm-pssc-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pssc_mytask");
        if (!result.isSuccess()) {
            logMsg = "push exception, reason:" + result.getMessage();
            logger.info(logMsg);
            throw new KDException(new ErrorCode("push error", logMsg), new Object[0]);
        }
        List targetObjects = result.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainType);
        return targetObjects;
    }

    private String getRowKey(DynamicObject row) {
        StringBuilder rowKeySb = new StringBuilder();
        Long baseDataId = 0L;
        String baseDataType = "";
        Long reqOrgId = row.getLong("reqorg.id");
        Long matId = row.getLong("material.id");
        if (matId > 0L) {
            baseDataType = "2";
            baseDataId = matId;
        } else {
            Long categoryId = row.getLong("category.id");
            baseDataType = "1";
            baseDataId = categoryId;
        }
        rowKeySb.append(reqOrgId).append('-').append(baseDataId).append('-').append('3').append('-').append(baseDataType);
        return rowKeySb.toString();
    }
}

