/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;

public class ReqApplyBillUpgradeServiceImpl
implements IUpgradeService {
    public static Log logger = LogFactory.getLog(ReqApplyBillUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        ThreadPools.executeOnce((String)this.getClass().getName(), () -> this.doUpdateMul(result));
        result.setSuccess(true);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpgradeResult doUpdateMul(UpgradeResult result) {
        Throwable throwable;
        String querySQL = "select e.fid,e.fentryid,p.forgid,p.fbizorgid  from  t_pm_requirapplybillentry e join t_pm_requirapplybill p on e.fid=p.fid  where  e.foriginorgid=0";
        String updateSQL = "update   t_pm_requirapplybillentry  set  fbalancestatus='C',freqkind='B',foriginorgid=?,fentrybizorgid=?  where  fentryid=?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        DBRoute route = new DBRoute("scm");
        int rows = 1000;
        try {
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)route, (String)querySQL, null);){
                for (Row row : ds) {
                    ArrayList param = new ArrayList(16);
                    Long entryId = row.getLong("fentryid");
                    Long orgId = row.getLong("forgid");
                    Long bizorgId = row.getLong("fbizorgid");
                    Collections.addAll(param, orgId, bizorgId, entryId);
                    paramList.add(param.toArray());
                    if (paramList.size() < rows) continue;
                    TXHandle h = TX.required((String)this.getClass().getName());
                    Throwable throwable2 = null;
                    try {
                        try {
                            this.executeSqlBatch(route, updateSQL, paramList);
                            paramList.clear();
                        }
                        catch (Throwable e) {
                            h.markRollback();
                            result.setSuccess(false);
                            String err = "database execution failed,errorInfo" + e.getMessage();
                            result.setErrorInfo(err);
                            result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                            UpgradeResult upgradeResult = result;
                            if (h != null) {
                                if (throwable2 != null) {
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                } else {
                                    h.close();
                                }
                            }
                            if (ds == null) return upgradeResult;
                            if (throwable != null) {
                                try {
                                    ds.close();
                                    return upgradeResult;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    return upgradeResult;
                                }
                            }
                            ds.close();
                            return upgradeResult;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable2 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (Throwable e) {
            result.setSuccess(false);
            String err = "query data field failed,errorMsgInfo\uff1a" + e.getMessage();
            result.setErrorInfo(err);
            result.setLog(err);
            logger.info(err);
            return result;
        }
        logger.info("query update successful.");
        if (paramList.isEmpty()) {
            logger.info("query update data is empty.");
            result.setSuccess(true);
            result.setLog("data update successful.");
            logger.info("data update successful.");
            return result;
        }
        throwable = null;
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                DB.executeBatch((DBRoute)route, (String)updateSQL, paramList);
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                String err = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(err);
                result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                logger.info(err);
                UpgradeResult upgradeResult = result;
                if (h == null) return upgradeResult;
                if (throwable == null) {
                    h.close();
                    return upgradeResult;
                }
                try {
                    h.close();
                    return upgradeResult;
                }
                catch (Throwable throwable8) {
                    throwable.addSuppressed(throwable8);
                    return upgradeResult;
                }
            }
        }
        catch (Throwable throwable9) {
            throwable = throwable9;
            throw throwable9;
        }
        result.setSuccess(true);
        result.setLog("data update successful.");
        logger.info("data update successful.");
        return result;
    }

    private void executeSqlBatch(DBRoute dbRoute, String sql, List<Object[]> paramList) {
        DB.executeBatch((DBRoute)dbRoute, (String)sql, paramList);
    }
}

