/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pssc.common.PsscOperationContext;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.log.PsscPriorityLog;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.formplugin.PsscReqPoolHandleCorePlugin;

public final class PsscReqPoolPriorityPlugin
extends PsscReqPoolHandleCorePlugin {
    private PsscHandleLogService priorityLog = new PsscPriorityLog();
    private static Log logger = LogFactory.getLog(PsscReqPoolPriorityPlugin.class);

    @Override
    protected void showWithoutPermMessage() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u8c03\u4f18\u5148\u7ea7\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqPoolPriorityPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean checkHasPermission() {
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)AppMetadataCache.getAppInfo((String)"pssc").getId(), (String)"pssc_taskmanage", (String)"3GRWFS70XCU3");
    }

    @Override
    protected void bindData(List<DynamicObject> targetObjects, PsscOperationContext context) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Map groupEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryentity, (String)"number");
        for (DynamicObject targetObject : targetObjects) {
            targetObject.set("biztype", (Object)context.getOperationKey());
            DynamicObjectCollection approveEntry = targetObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : approveEntry) {
                DynamicObject newRow = (DynamicObject)groupEntryMap.get(String.valueOf(entry.getString("tasknumber")));
                if (null == newRow) continue;
                entry.set("priority", (Object)newRow.getString("priority"));
                entry.set("opinion", (Object)newRow.getString("opinion"));
                entry.set("approvetype", (Object)context.getOperationKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(PsscOperationContext context) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        DynamicObject[] rows = context.getRows();
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(rows.length);
        DynamicObjectCollection entryRows = context.getView().getModel().getEntryEntity("entryentity");
        Map gourpEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryRows, (String)"srcbillid");
        for (DynamicObject row : rows) {
            DynamicObject newRow = (DynamicObject)gourpEntryMap.get(String.valueOf(row.getPkValue()));
            if (null == newRow) continue;
            HandleLogEntity logEntity = this.priorityLog.getLogInfo(context.getView(), row, newRow);
            this.priorityLog.updateLogInfo(logEntity, context.getView(), row);
            logEntityList.add(logEntity);
            row.set("priority", (Object)newRow.getString("priority"));
            row.set("opinion", (Object)newRow.getString("opinion"));
            ++count;
        }
        if (count > 0) {
            try (TXHandle tx = TX.requiresNew();){
                PsscCommonUtils.saveDynamicObjects((DynamicObject[])context.getRows());
                PsscHandleLogHelper.log(logEntityList);
                sb.append(ResManager.loadKDString((String)"\u8c03\u6574\u4f18\u5148\u7ea7\u6210\u529f\u3002", (String)"PsscReqPoolPriorityPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u4efb\u52a1\u3002", (String)"PsscReqPoolPriorityPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        }
        context.setMessage(sb);
    }
}

