/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pssc.business.helper.PsscPackageGroupHelper;
import kd.scm.pssc.common.PsscOperationContext;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.log.PsscTransmitLog;
import kd.scm.pssc.common.utils.MultiBasedataUtils;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.PsscPackageGroupUtils;
import kd.scm.pssc.formplugin.PsscReqPoolHandleCorePlugin;

public final class PsscReqPoolTransmitPlugin
extends PsscReqPoolHandleCorePlugin
implements BeforeF7SelectListener {
    private PsscHandleLogService psscHandleLogService = new PsscTransmitLog();
    private static Log logger = LogFactory.getLog(PsscReqPoolTransmitPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit handler = (BasedataEdit)this.getControl("newhandler");
        if (null != handler) {
            handler.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    @Override
    protected void showWithoutPermMessage() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u4efb\u52a1\u201d\u7684\u201c\u8f6c\u4ea4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqPoolTransmitPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean checkHasPermission() {
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)AppMetadataCache.getAppInfo((String)"pssc").getId(), (String)"pssc_mytask", (String)"3GRVZWLZI+9O");
    }

    @Override
    protected void bindData(List<DynamicObject> targetObjects, PsscOperationContext context) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Map groupEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryentity, (String)"number");
        for (DynamicObject targetObject : targetObjects) {
            targetObject.set("biztype", (Object)context.getOperationKey());
            DynamicObjectCollection approveEntry = targetObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : approveEntry) {
                DynamicObject newRow = (DynamicObject)groupEntryMap.get(String.valueOf(entry.getString("tasknumber")));
                if (null == newRow) continue;
                entry.set("newhandler_id", (Object)newRow.getLong("newhandler.id"));
                entry.set("newhandler", newRow.get("newhandler"));
                entry.set("newpurgroup_id", (Object)newRow.getLong("newpurgroup.id"));
                entry.set("newpurgroup", newRow.get("newpurgroup"));
                entry.set("opinion", (Object)newRow.getString("opinion"));
                entry.set("newsourceorg_id", (Object)newRow.getLong("sourceorg.id"));
                entry.set("newsourceorg", newRow.get("sourceorg"));
                entry.set("approvetype", (Object)context.getOperationKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(PsscOperationContext context) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        DynamicObjectCollection entryRows = context.getView().getModel().getEntryEntity("entryentity");
        Map gourpEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryRows, (String)"srcbillid");
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(entryRows.size());
        HashMap packageGroupInfos = new HashMap();
        for (DynamicObject row : context.getRows()) {
            DynamicObject newHandler;
            DynamicObject newRow = (DynamicObject)gourpEntryMap.get(String.valueOf(row.getPkValue()));
            if (null == newRow || null == (newHandler = newRow.getDynamicObject("newhandler"))) continue;
            Long userId = newHandler.getLong("operatorid.id");
            DynamicObjectCollection rows = row.getDynamicObjectCollection("partners");
            Set idSet = rows.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
            idSet.add(userId);
            MultiBasedataUtils.setMultiBasedataForBillObj((DynamicObject)row, idSet, (String)"partners");
            row.set("opinion", (Object)newRow.getString("opinion"));
            row.set("handler", (Object)newHandler);
            row.set("sourceorg", newRow.get("sourceorg"));
            row.set("handleuser_id", (Object)userId);
            if (newRow.get("newpurgroup") != null) {
                row.set("purgroup", (Object)newRow.getDynamicObject("newpurgroup").getLong("id"));
            }
            HandleLogEntity logEntity = this.psscHandleLogService.getLogInfo(context.getView(), row, newRow);
            this.psscHandleLogService.updateLogInfo(logEntity, context.getView(), row);
            logEntityList.add(logEntity);
            PsscPackageGroupUtils.dealUnPackageData((DynamicObject)row, packageGroupInfos, (boolean)true);
            ++count;
        }
        PsscPackageGroupHelper.packageGroup(packageGroupInfos, (long)0L);
        for (DynamicObject row : context.getRows()) {
            PsscPackageGroupUtils.dealPackageGroupInfo((DynamicObject)row, packageGroupInfos, (String)"id");
        }
        boolean needSync = true;
        if (count > 0) {
            try (TXHandle tx = TX.requiresNew();){
                PsscCommonUtils.saveDynamicObjects((DynamicObject[])context.getRows());
                PsscHandleLogHelper.log(logEntityList);
                sb.append(ResManager.loadKDString((String)"\u8f6c\u4ea4\u4efb\u52a1\u6210\u529f\u3002", (String)"PsscReqPoolTransmitPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (needSync) {
                OperationServiceHelper.executeOperate((String)"syncdata", (String)"pssc_mytask", (DynamicObject[])context.getRows(), null);
                OperationServiceHelper.executeOperate((String)"sendmsg", (String)"pssc_mytask", (DynamicObject[])context.getRows(), null);
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u8f6c\u4ea4\u7684\u4efb\u52a1\u3002", (String)"PsscReqPoolTransmitPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        }
        context.setMessage(sb);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        switch (name) {
            case "newhandler": {
                List qfilters = listShowParameter.getListFilterParameter().getQFilters();
                QFilter purGroupFilter = new QFilter("enable", "=", (Object)"1");
                HashSet<Long> opGroupIdSet = new HashSet<Long>();
                DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id", (QFilter[])purGroupFilter.toArray());
                for (DynamicObject col : cols) {
                    opGroupIdSet.add(col.getLong("id"));
                }
                if (opGroupIdSet.size() <= 0) break;
                qfilters.add(new QFilter("operatorgrpid", "in", opGroupIdSet));
            }
        }
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        super.beforeBatchFillEntry(e);
        IDataModel model = this.getModel();
        e.setPredicate(e.getPredicate().and(rowItem -> {
            IDataEntityProperty selProp = rowItem.getSelProp();
            int row = rowItem.getRow();
            switch (selProp.getName()) {
                case "newhandler": {
                    DynamicObject sourceorg = (DynamicObject)model.getValue("sourceorg", row);
                    if (sourceorg == null) {
                        return false;
                    }
                    int currentRow = model.getEntryCurrentRowIndex("entryentity");
                    DynamicObject currentRowCompareValue = (DynamicObject)model.getValue("sourceorg", currentRow);
                    if (currentRowCompareValue == null) {
                        return false;
                    }
                    return sourceorg.getLong("id") == currentRowCompareValue.getLong("id");
                }
            }
            return true;
        }));
    }
}

