/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin.botp;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.msbd.botp.BillUnitConvertPlugin;
import kd.mpscmm.msbd.common.context.CommonContext;

public class InvUnitConvertBotpPlugin
extends BillUnitConvertPlugin {
    private static final String MATERIALKEY = "MATERIAL";
    private static final String QTYKEY = "QTY";
    private static final String UNITKEY = "UNIT";
    private static final String BASEQTYKEY = "BASEQTY";
    private static final String BASEUNITKEY = "BASEUNIT";
    private static final String MAINBILLENTITYKEY = "MAINBILLENTITY";
    private static final String MAINBILLIDKEY = "MAINBILLID";
    private static final String MAINBILLENTRYIDKEY = "MAINBILLENTRYID";
    private static final String PRICEKEY = "PRICE";
    private static final String TAXPRICEKEY = "TAXPRICE";
    private static final String CURRENCYKEY = "CURRENCY";
    private static final String ISTAXKEY = "ISTAX";
    private static final String TAXRATEIDKEY = "TAXRATEID";
    private static final String TAXRATEKEY = "TAXRATE";
    private static final String DISCOUNTTYPEKEY = "DISCOUNTTYPE";
    private static final String DISCOUNTRATEKEY = "DISCOUNTRATE";
    private static final String AUDITQTY = "auditqty";

    protected CommonContext getCommonContext() {
        super.getCommonContext();
        String billType = this.getTgtMainType().toString();
        CommonContext commonContext = CommonContext.get();
        Map ProperytMapping = commonContext.getProperytMapping();
        ProperytMapping.put(MATERIALKEY, "material");
        ProperytMapping.put(BASEQTYKEY, "baseqty");
        ProperytMapping.put(BASEUNITKEY, "baseunit");
        ProperytMapping.put(QTYKEY, "qty");
        ProperytMapping.put(UNITKEY, "unit");
        switch (billType) {
            case "im_transdirbill": 
            case "im_transinbill": 
            case "im_transoutbill": 
            case "im_productinbill": 
            case "im_materialreqoutbill": 
            case "im_osmaterialreqoutbill": {
                ProperytMapping.put(PRICEKEY, "price");
                break;
            }
            case "im_purreceivebill": 
            case "im_ospurinbill": 
            case "im_purinbill": 
            case "im_saloutbill": {
                ProperytMapping.put(MAINBILLENTITYKEY, "mainbillentity");
                ProperytMapping.put(MAINBILLIDKEY, "mainbillid");
                ProperytMapping.put(MAINBILLENTRYIDKEY, "mainbillentryid");
                ProperytMapping.put(DISCOUNTTYPEKEY, "discounttype");
                ProperytMapping.put(DISCOUNTRATEKEY, "discountrate");
                ProperytMapping.put(PRICEKEY, "price");
                ProperytMapping.put(TAXPRICEKEY, "priceandtax");
                ProperytMapping.put(CURRENCYKEY, "settlecurrency");
                ProperytMapping.put(ISTAXKEY, "istax");
                ProperytMapping.put(TAXRATEIDKEY, "taxrateid");
                ProperytMapping.put(TAXRATEKEY, "taxrate");
            }
        }
        return commonContext;
    }

    protected void afterUnitConvert(DynamicObject entryInfo, int[] muBaseConv, int[] muConv, DynamicObject beforeUnit, DynamicObject convertUnit, DynamicObject mainBillEntryInfo) {
        super.afterUnitConvert(entryInfo, muBaseConv, muConv, beforeUnit, convertUnit, mainBillEntryInfo);
        String billType = this.getTgtMainType().toString();
        if ("im_transapply".equals(billType) || "im_materialreqbill".equals(billType)) {
            BigDecimal qty = entryInfo.getBigDecimal(QTYKEY);
            entryInfo.set(AUDITQTY, (Object)qty);
        }
    }
}

