/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin.edit;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.botp.jobtask.BackgroundTaskManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pssc.business.helper.BillQtyAndUnitHelper;
import kd.scm.pssc.business.helper.BotpHepler;
import kd.scm.pssc.business.pojo.ContactOrderWrapper;
import kd.scm.pssc.common.utils.PsscCommonUtils;

public class PsscReqContactOrderEditPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(PsscReqContactOrderEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid quoteGrid = (EntryGrid)this.getView().getControl("entryentity");
        quoteGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected void showWithoutPermMessage() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u4efb\u52a1\u201d\u7684\u201c\u5408\u540c\u4e0b\u5355\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqContactOrderEditPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }

    protected boolean checkHasPermission() {
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)AppMetadataCache.getAppInfo((String)"pssc").getId(), (String)"pssc_mytask", (String)"441FVZ6+SFJ6");
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        if ("entryentity".equals(name)) {
            int[] rowIndexs = e.getRowIndexs();
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            DataEntityPropertyCollection properties = entryentity.getDynamicObjectType().getProperties();
            int size = entryentity.size();
            for (int rowIndex : rowIndexs) {
                if (rowIndex >= size - 1) continue;
                DynamicObject row = (DynamicObject)entryentity.get(rowIndex);
                String tasksrcentryid = row.getString("tasksrcentryid_repeat");
                String tasknumber = row.getString("tasknumber");
                if (!StringUtils.isNotBlank((CharSequence)tasksrcentryid)) continue;
                DynamicObject rowNew = (DynamicObject)entryentity.get(rowIndex + 1);
                String tasksrcentryidnew = rowNew.getString("tasksrcentryid_repeat");
                String tasknumberNew = rowNew.getString("tasknumber");
                if (StringUtils.isNotBlank((CharSequence)tasksrcentryidnew) || !StringUtils.equals((CharSequence)tasknumberNew, (CharSequence)tasknumber)) continue;
                for (IDataEntityProperty property : properties) {
                    String name1 = property.getName();
                    if ("taskmaterialname_repeat".equals(name1) || "taskapplyqty_repeat".equals(name1) || "toorderqty".equals(name1)) {
                        this.getModel().setValue(name1, row.get(name1), rowIndex + 1);
                    }
                    if (name1.contains("_repeat") || !properties.containsKey((Object)(name1 + "_repeat"))) continue;
                    this.getModel().setValue(name1 + "_repeat", rowNew.get(name1), rowIndex + 1);
                }
            }
        }
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        block6: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            switch (name) {
                case "orderqty": {
                    this.changeQty(changeData.getNewValue(), changeData.getRowIndex());
                    continue block6;
                }
            }
        }
    }

    private void changeQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal qty = (BigDecimal)newValue;
            DynamicObject purMaterial = (DynamicObject)model.getValue("taskmaterial", rowIndex);
            if (purMaterial != null) {
                DynamicObject materialMaster = purMaterial.getDynamicObject("masterid");
                DynamicObject unit = (DynamicObject)model.getValue("taskunit", rowIndex);
                if (materialMaster == null || unit == null) {
                    return;
                }
                DynamicObject baseUnit = (DynamicObject)model.getValue("taskbaseunit", rowIndex);
                model.beginInit();
                if (baseUnit == null && (baseUnit = materialMaster.getDynamicObject("baseunit")) != null) {
                    model.setValue("taskbaseunit", baseUnit.getPkValue(), rowIndex);
                }
                if (baseUnit != null) {
                    Long materialMasterId = (Long)materialMaster.getPkValue();
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                    model.setValue("baseorderqty", (Object)baseQty, rowIndex);
                }
                model.endInit();
                IFormView view = this.getView();
                view.updateView("taskbaseunit", rowIndex);
                view.updateView("baseorderqty", rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("submit".equals(operate)) {
            if (!this.checkHasPermission()) {
                this.showWithoutPermMessage();
                args.setCancel(true);
                return;
            }
            if (!this.validateQty()) {
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            HashSet<Long> applyIdSet = new HashSet<Long>(16);
            HashMap<String, Long> taskidApplyidMap = new HashMap<String, Long>(16);
            for (DynamicObject dynamicObject : entryentity) {
                String applyid = dynamicObject.getString("tasksrcbillid");
                applyIdSet.add(Long.parseLong(applyid));
                taskidApplyidMap.put(dynamicObject.getString("tasknumber"), Long.parseLong(applyid));
            }
            try {
                Object result = DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurApplyService", (String)"getPurApplyChangeStatus", (Object[])new Object[]{applyIdSet});
                if (result instanceof Map) {
                    Map resultMap = (Map)result;
                    Iterator iterator = taskidApplyidMap.entrySet().iterator();
                    ArrayList tasknumberlist = new ArrayList(taskidApplyidMap.size());
                    while (iterator.hasNext()) {
                        Long applyId = (Long)iterator.next().getValue();
                        Boolean isChanging = (Boolean)resultMap.get(applyId);
                        if (isChanging == null || !isChanging.booleanValue()) continue;
                        tasknumberlist.add(iterator.next().getKey());
                    }
                    if (!tasknumberlist.isEmpty()) {
                        args.setCancel(true);
                        StringBuilder message = new StringBuilder();
                        message.append(ResManager.loadKDString((String)"\u4efb\u52a1", (String)"PsscReqPoolHandleCorePlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(StringUtils.join((Object[])tasknumberlist.toArray(), (String)"\u3001")).append(ResManager.loadKDString((String)"\u5173\u8054\u7684\u91c7\u8d2d\u7533\u8bf7\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"PsscReqPoolHandleCorePlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                        this.getView().showTipNotification(message.toString());
                    }
                }
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u67e5\u8be2\u7533\u8bf7\u5355\u53d8\u66f4\u72b6\u6001\u5931\u8d25", (String)"PsscReqPoolHandleCorePlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                logger.error("query purrequirebill change status fail:" + e.getMessage());
                args.setCancel(true);
            }
        }
    }

    private boolean validateQty() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        HashSet<String> taskNumber = new HashSet<String>();
        HashMap<String, BigDecimal> taskMapQty = new HashMap<String, BigDecimal>();
        for (DynamicObject task : entryentity) {
            taskNumber.add(task.getString("tasknumber"));
            BigDecimal orderQty = task.getBigDecimal("orderqty");
            if (orderQty == null || orderQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            taskMapQty.put(task.getString("tasknumber"), orderQty);
        }
        StringBuilder sb = new StringBuilder();
        boolean flag = true;
        for (String number : taskNumber) {
            BigDecimal qty = (BigDecimal)taskMapQty.get(number);
            if (qty != null) continue;
            sb.append(String.format(ResManager.loadKDString((String)"%1$s:\u8bf7\u586b\u5199\u672c\u6b21\u4e0b\u5355\u6570\u91cf\u3002", (String)"PsscReqContactOrderEditPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]), number)).append(System.lineSeparator());
            flag = false;
        }
        if (!flag) {
            this.getView().showTipNotification(sb.toString());
        }
        return flag;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "submit": {
                if (!args.getOperationResult().isSuccess()) break;
                try {
                    this.pushorder();
                }
                catch (IOException e) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6309\u5408\u540c\u4e0b\u5355\u53c2\u6570\u6784\u9020\u5931\u8d25\u3002", (String)"PsscReqContactOrderEditPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    logger.error("contact to order fail:" + e.getMessage());
                }
                break;
            }
            case "refresh": {
                this.initPage();
                break;
            }
        }
    }

    private void pushorder() throws IOException {
        DynamicObjectCollection tasks = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List<ConvertOperationResult> allResults = this.doPushOrder((List<DynamicObject>)tasks);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pm_purapplybill");
        pushArgs.setTargetEntityNumber("pm_purorderbill");
        pushArgs.setBuildConvReport(false);
        pushArgs.setAutoSave(true);
        pushArgs.setHasRight(false);
        pushArgs.setShowReport(true);
        pushArgs.setBuildConvReport(true);
        ArrayList<ConvertOperationResult> successResult = new ArrayList<ConvertOperationResult>();
        ArrayList<ConvertOperationResult> results = new ArrayList<ConvertOperationResult>();
        for (ConvertOperationResult result : allResults) {
            if (result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pm_purorderbill");
                List targetObjects = result.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainType);
                PsscCommonUtils.saveRelation((List)targetObjects);
                successResult.add(result);
                continue;
            }
            results.add(result);
        }
        if (allResults.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u4e0b\u5355\u6570\u636e\u3002", (String)"PsscReqContactOrderEditPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            return;
        }
        BotpHepler.dealResult(successResult, results, (PushArgs)pushArgs, (IFormView)this.getView());
    }

    private List<ConvertOperationResult> doPushOrder(List<DynamicObject> tasks) throws IOException {
        ArrayList<ConvertOperationResult> successResult = new ArrayList<ConvertOperationResult>(tasks.size());
        HashMap contactGroupMap = new HashMap(1);
        HashMap paramMaps = new HashMap(1);
        ContactOrderWrapper wrapper = new ContactOrderWrapper();
        ArrayList<DynamicObject> nextToPushInfo = new ArrayList<DynamicObject>(tasks.size());
        HashSet<Long> nextToPushEntryIds = new HashSet<Long>(tasks.size());
        for (DynamicObject task : tasks) {
            BigDecimal baseorderqty = task.getBigDecimal("baseorderqty");
            if (baseorderqty == null || baseorderqty.compareTo(BigDecimal.ZERO) == 0) continue;
            String groupKey = wrapper.makeOrderRowKey(task);
            String reqEntryId = task.getString("tasksrcentryid");
            if (nextToPushEntryIds.contains(Long.valueOf(reqEntryId))) {
                nextToPushInfo.add(task);
                continue;
            }
            ArrayList<ListSelectedRow> listSelectedRows = (ArrayList<ListSelectedRow>)contactGroupMap.get(groupKey);
            if (listSelectedRows == null) {
                listSelectedRows = new ArrayList<ListSelectedRow>(8);
                contactGroupMap.put(groupKey, listSelectedRows);
            }
            nextToPushEntryIds.add(Long.valueOf(reqEntryId));
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)Long.parseLong(task.getString("tasksrcbillid")));
            row.setEntryEntityKey("billentry");
            row.setEntryPrimaryKeyValue((Object)Long.parseLong(task.getString("tasksrcentryid")));
            listSelectedRows.add(row);
            wrapper.wrapBotpParam(task, paramMaps, groupKey);
        }
        Set entries = contactGroupMap.entrySet();
        for (Map.Entry next : entries) {
            Map param = (Map)paramMaps.get(next.getKey());
            List value = (List)next.getValue();
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("pm_purapplybill");
            pushArgs.setTargetEntityNumber("pm_purorderbill");
            pushArgs.setBuildConvReport(false);
            pushArgs.setAutoSave(true);
            pushArgs.setHasRight(false);
            pushArgs.setShowReport(true);
            pushArgs.setBuildConvReport(true);
            pushArgs.setSelectedRows(value);
            pushArgs.getCustomParams().putAll(param);
            pushArgs.getCustomParams().put("pssccontact", "contact");
            if (value.size() <= 20000) {
                ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
                successResult.add(result);
                continue;
            }
            pushArgs.setShowReport(true);
            this.pushAndSaveBackGround(pushArgs);
        }
        if (nextToPushInfo.size() > 0) {
            successResult.addAll(this.doPushOrder(nextToPushInfo));
        }
        return successResult;
    }

    private void pushAndSaveBackGround(PushArgs args) {
        BackgroundTaskManager pushAndSaveJob = BackgroundTaskManager.newInstance((IFormView)this.getView());
        pushAndSaveJob.dispatchBackgroundTask(args);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u63a8\u6570\u91cf\u8d85\u8fc720000\u6761, \u5df2\u8f6c\u540e\u53f0\u6267\u884c\u3002", (String)"PsscTaskPushList_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        this.initPage();
    }

    private void initPage() {
        Set handleIds = PsscCommonUtils.getHandleIdsFromView((IFormView)this.getView(), (String)"handle_ids");
        ContactOrderWrapper wrapper = new ContactOrderWrapper();
        try (DataSet contactDataSet = wrapper.getContactDataSet(handleIds);){
            if (contactDataSet == null) {
                return;
            }
            Set<String> contactProps = this.getContactProps(wrapper);
            Set<String> uniProps = this.getTaskProps(wrapper);
            DynamicObjectCollection entity = this.getView().getModel().getEntryEntity("entryentity");
            DataEntityPropertyCollection properties = entity.getDynamicObjectType().getProperties();
            HashSet<String> prname = new HashSet<String>();
            for (IDataEntityProperty property : properties) {
                prname.add(property.getName());
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            RowMeta rowMeta = contactDataSet.getRowMeta();
            int i = 0;
            HashSet<String> uniKeys = new HashSet<String>(16);
            for (Row row : contactDataSet) {
                StringBuilder sb = new StringBuilder();
                for (String uniProp : uniProps) {
                    if (!prname.contains(uniProp) || rowMeta.getField(uniProp, false) == null) continue;
                    sb.append(row.getString(uniProp));
                }
                BigDecimal taskapplyqty = row.getBigDecimal("taskapplyqty_repeat");
                BigDecimal reqjoinqty = row.getBigDecimal("reqjoinqty");
                if (taskapplyqty != null && reqjoinqty != null) {
                    sb.append(taskapplyqty.subtract(reqjoinqty));
                } else {
                    sb.append(taskapplyqty);
                }
                boolean contains = uniKeys.contains(sb.toString());
                for (String uniProp : uniProps) {
                    String repeat;
                    if (!prname.contains(uniProp) || rowMeta.getField(uniProp, false) == null) continue;
                    if (!contains) {
                        setter.set(uniProp, row.get(uniProp), i);
                    }
                    if (!prname.contains(repeat = uniProp.replace("_repeat", ""))) continue;
                    setter.set(repeat, row.get(uniProp), i);
                }
                if (!contains) {
                    if (taskapplyqty != null && reqjoinqty != null) {
                        setter.set("toorderqty", (Object)taskapplyqty.subtract(reqjoinqty), i);
                    } else {
                        setter.set("toorderqty", (Object)taskapplyqty, i);
                    }
                    uniKeys.add(sb.toString());
                }
                for (String contactProp : contactProps) {
                    if (!prname.contains(contactProp) || rowMeta.getField(contactProp, false) == null) continue;
                    sb.append(row.getString(contactProp));
                    setter.set(contactProp, row.get(contactProp), i);
                }
                ++i;
            }
            model.deleteEntryData("entryentity");
            this.getModel().beginInit();
            model.batchCreateNewEntryRow("entryentity", setter);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            grid.focusCell(0, "orderqty");
        }
    }

    private Set<String> getTaskProps(ContactOrderWrapper wrapper) {
        Map taskProperties = wrapper.getTaskProperties();
        HashSet<String> uniProps = new HashSet<String>(taskProperties.size());
        for (String value : taskProperties.values()) {
            uniProps.add(value);
        }
        return uniProps;
    }

    private Set<String> getContactProps(ContactOrderWrapper wrapper) {
        Map contactProperties = wrapper.getContactProperties();
        HashSet<String> contactProps = new HashSet<String>(contactProperties.size());
        for (String value : contactProperties.values()) {
            contactProps.add(value);
        }
        contactProps.addAll(wrapper.getReqProperties().values());
        return contactProps;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "red");
        this.getView().updateControlMetadata("orderqty", map);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        EntryGrid entryGrid;
        int[] selectRows;
        String fieldName = e.getFieldName();
        if (StringUtils.equals((CharSequence)"tasknumber_repeat", (CharSequence)fieldName) && (selectRows = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows()) != null && selectRows.length > 0) {
            int selectRow = selectRows[0];
            DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (rows.size() > selectRow) {
                DynamicObject row = (DynamicObject)rows.get(selectRow);
                long taskid = row.getLong("taskid");
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"pssc_mytask", (Object)taskid, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
            }
        }
    }
}

