/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pssc.business.helper.PsscPackageGroupHelper;
import kd.scm.pssc.business.helper.taskapprove.PsscPackageGroupHandler;
import kd.scm.pssc.common.PsscOperationContext;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.PsscPackageGroupUtils;
import kd.scm.pssc.formplugin.PsscReqPoolHandleCorePlugin;
import kd.scm.pssc.formplugin.PsscReqPoolTransmitPlugin;

public class PsscReqPoolPackageEditPlugin
extends PsscReqPoolHandleCorePlugin {
    private static Log logger = LogFactory.getLog(PsscReqPoolTransmitPlugin.class);
    private PsscHandleLogService logService = new PsscHandleLogService();

    @Override
    protected void showWithoutPermMessage() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u4efb\u52a1\u201d\u7684\u201c\u6253\u5305\u5206\u7ec4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqPoolPackageEditPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean checkHasPermission() {
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)AppMetadataCache.getAppInfo((String)"pssc").getId(), (String)"pssc_mytask", (String)"41USFXP6TZK6");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String fieldKey = e.getProperty().getName();
        block6: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            switch (fieldKey) {
                case "schema": {
                    if (StringUtils.isBlank((Object)newValue)) {
                        return;
                    }
                    String s = String.valueOf(newValue);
                    Long aLong = Long.valueOf(s);
                    PsscOperationContext context = this.initContext();
                    DynamicObject[] rows = context.getRows();
                    HashMap param = new HashMap();
                    for (DynamicObject row : rows) {
                        PsscPackageGroupUtils.dealUnPackageData((DynamicObject)row, param, (boolean)true);
                    }
                    PsscPackageGroupHelper.packageGroup(param, (long)aLong);
                    DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                    PsscPackageGroupUtils.dealPackageGroupInfos((DynamicObjectCollection)entryentity, param, (String)"srcbillid");
                    continue block6;
                }
            }
        }
        if ("schema".equals(fieldKey)) {
            this.getView().updateView("entryentity");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        QFilter qFilter = new QFilter("handleuser", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pssc_grouppackage", (String)"name,default,id", (QFilter[])new QFilter[]{qFilter}, (String)"default desc");
        ComboEdit comboEdit = (ComboEdit)this.getControl("schema");
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        for (DynamicObject info : query) {
            comboItem.add(new ComboItem(new LocaleString(info.getString("name")), info.getString("id")));
        }
        comboEdit.setComboItems(comboItem);
    }

    @Override
    protected void bindData(List<DynamicObject> targetObjects, PsscOperationContext context) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Map groupEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryentity, (String)"number");
        for (DynamicObject targetObject : targetObjects) {
            targetObject.set("biztype", (Object)context.getOperationKey());
            DynamicObjectCollection approveEntry = targetObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : approveEntry) {
                DynamicObject newRow = (DynamicObject)groupEntryMap.get(String.valueOf(entry.getString("tasknumber")));
                if (newRow == null) continue;
                entry.set("opinion", (Object)newRow.getString("opinion"));
                entry.set("packagegroup", (Object)newRow.getString("packagegroup"));
                entry.set("approvetype", (Object)context.getOperationKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(PsscOperationContext context) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        DynamicObject[] rows = context.getRows();
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(rows.length);
        DynamicObjectCollection entryRows = context.getView().getModel().getEntryEntity("entryentity");
        Map groupEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryRows, (String)"srcbillid");
        for (DynamicObject row : rows) {
            DynamicObject newRow = (DynamicObject)groupEntryMap.get(String.valueOf(row.getPkValue()));
            if (null == newRow) continue;
            String opinion = newRow.getString("opinion");
            String packageGroup = newRow.getString("packagegroup");
            row.set("opinion", (Object)opinion);
            row.set("packagegroup", (Object)packageGroup);
            String remark = PsscPackageGroupHandler.getLogRemark((String)packageGroup);
            String detail = this.logService.getDetail(row, newRow);
            HandleLogEntity logEntity = PsscHandleLogHelper.getLogInfo((String)remark, (String)detail);
            this.logService.updateLogInfo(logEntity, context.getView(), row);
            logEntityList.add(logEntity);
            ++count;
        }
        if (count > 0) {
            try (TXHandle tx = TX.required();){
                PsscCommonUtils.saveDynamicObjects((DynamicObject[])context.getRows());
                PsscHandleLogHelper.log(logEntityList);
                sb.append(ResManager.loadKDString((String)"\u6253\u5305\u5206\u7ec4\u6210\u529f\u3002", (String)"PsscReqPoolPackageEditPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                sb.append(System.lineSeparator());
            }
        }
        context.setMessage(sb);
    }
}

