/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldSumType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.scm.pssc.business.helper.ReqApplyBillHelper;
import org.apache.commons.lang3.StringUtils;

public class ReqApplyToReqApplyConvertPlugin
extends AbstractConvertPlugIn {
    private static final String QTY = "qty";
    private static final String BASEQTY = "baseqty";
    private static final String AUXQTY = "auxqty";
    private static final String SRCBILLENTRYID = "srcbillentryid";
    private static final String BILLENTRY = "billentry";
    private static final Log logger = LogFactory.getLog(ReqApplyToReqApplyConvertPlugin.class);

    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
        String groupBy;
        boolean containsVariable = this.getOption().containsVariable("summaryschema");
        if (containsVariable && StringUtils.isNotBlank((CharSequence)(groupBy = this.getOption().getVariableValue("summaryschema")))) {
            e.setHeadGroupKey("@all");
            e.setEntryGroupKey(groupBy);
            e.setSubEntryGroupKey("");
        }
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        List fieldMaps = this.getRule().getFieldMapPolicy().getFieldMaps();
        for (FieldMapItem fieldMapItem : fieldMaps) {
            String targetFieldKey = fieldMapItem.getTargetFieldKey();
            if (!SRCBILLENTRYID.equals(targetFieldKey)) continue;
            FieldSumType fieldSumType = fieldMapItem.getFieldSumType();
            if (FieldSumType.Max.equals((Object)fieldSumType)) break;
            e.setCustFilterExpression("false");
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u9700\u6c42\u7533\u8bf7\u6c47\u603b\u7528\u5230\u7684\u3010\u9700\u6c42\u7533\u8bf7\u5355_\u9700\u6c42\u7533\u8bf7\u5355\u3011\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u5b57\u6bb5\u6620\u5c04\u4e2d\u76ee\u6807\u5355\u5b57\u6bb5\u4e3a\u3010\u7269\u6599\u660e\u7ec6.\u6765\u6e90\u5355\u636e\u884cID\u3011\u7684\u5408\u5e76\u65b9\u5f0f\u5e94\u6539\u4e3a\u3010\u6700\u5927\u3011", (String)"ReqApplyToReqApplyConvertPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            break;
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        String sumDept;
        boolean containsVariable = this.getOption().containsVariable("entryresult");
        if (containsVariable) {
            String mapStr = this.getOption().getVariableValue("entryresult");
            String orgId = this.getOption().getVariableValue("org");
            Map paramData = (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
            ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
            ExtendedDataEntity[] entityList = entitySet.FindByEntityKey(this.getTgtMainType().toString());
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(orgId), (String)"bos_org");
            for (ExtendedDataEntity entity : entityList) {
                DynamicObject bill = entity.getDataEntity();
                bill.set("org", (Object)orgDyn);
                DynamicObjectCollection entryList = bill.getDynamicObjectCollection(BILLENTRY);
                for (DynamicObject entry : entryList) {
                    if (paramData != null && !paramData.isEmpty()) {
                        this.setQty(entry, paramData);
                    }
                    entry.set("classtype", (Object)"1");
                    entry.set("entrybizorg", null);
                }
            }
        }
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entityList = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        ArrayList<DynamicObject> reqApplyBillList = new ArrayList<DynamicObject>(16);
        boolean containsSumDept = this.getOption().containsVariable("sumdept");
        boolean multiBill = this.getOption().containsVariable("multiBill");
        DynamicObject sumDeptOrg = null;
        if (containsSumDept && StringUtils.isNotBlank((CharSequence)(sumDept = this.getOption().getVariableValue("sumdept")))) {
            sumDeptOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(sumDept), (String)"bos_adminorg");
        }
        HashSet<Long> deptIds = new HashSet<Long>(entityList.length);
        for (ExtendedDataEntity entity : entityList) {
            DynamicObject bizUser;
            DynamicObject dept;
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject bizOrg = bill.getDynamicObject("bizorg");
            if (bizOrg == null && org != null) {
                DynamicObject fromOrg = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"", (String)"02", (String)"toorg");
                bill.set("bizorg", (Object)fromOrg);
            }
            if (sumDeptOrg != null) {
                bill.set("dept", (Object)sumDeptOrg);
            }
            if (multiBill || containsVariable) {
                bill.set("type", (Object)"3");
            }
            if ((dept = bill.getDynamicObject("dept")) == null && (bizUser = bill.getDynamicObject("bizuser")) != null) {
                long userId = (Long)bizUser.getPkValue();
                Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
                deptIds.add(deptId);
                bill.set("dept_id", (Object)deptId);
            }
            reqApplyBillList.add(entity.getDataEntity());
        }
        this.setDeptInfo(deptIds, entityList);
        if (containsVariable) {
            ReqApplyBillHelper.calSumReqApplyLogical(reqApplyBillList);
        } else {
            ReqApplyBillHelper.calDefaultReqApplyLogical(reqApplyBillList);
        }
    }

    private void setDeptInfo(Set<Long> deptIds, ExtendedDataEntity[] entityList) {
        if (deptIds.size() > 0) {
            Map adminOrgMap = BusinessDataServiceHelper.loadFromCache((Object[])deptIds.toArray(new Object[0]), (String)"bos_adminorg");
            for (ExtendedDataEntity entity : entityList) {
                DynamicObject bill = entity.getDataEntity();
                Object dept = bill.get("dept");
                Object deptId = bill.get("dept_id");
                if (dept != null || deptId == null) continue;
                DynamicObject deptInfo = (DynamicObject)adminOrgMap.get(deptId);
                bill.set("dept", (Object)deptInfo);
            }
        }
    }

    private void setQty(DynamicObject row, Map<String, Map<String, Object>> paramMap) {
        String paramMapKeyStr = String.valueOf(row.get(SRCBILLENTRYID));
        Map<String, Object> mapQty = paramMap.get(paramMapKeyStr);
        if (mapQty != null && !mapQty.isEmpty()) {
            row.set(BASEQTY, mapQty.get(BASEQTY));
            row.set(AUXQTY, mapQty.get(AUXQTY));
            String reqDate = (String)mapQty.get("reqdate");
            if (reqDate != null && !"".equals(reqDate)) {
                row.set("reqdate", (Object)ReqApplyToReqApplyConvertPlugin.convertStrToDate(reqDate));
            } else {
                row.set("reqdate", null);
            }
        }
    }

    public static Date convertStrToDate(String strDate) {
        Date date;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = dateFormat.parse(strDate);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            date = null;
        }
        return date;
    }
}

