/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.mpscmm.msbd.business.helper.OrgHelper;

public class Requir2MatApplyConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(Requir2MatApplyConvertPlugin.class);
    public static final String SETTLECURRENCY = "settlecurrency";
    public static final String SETTLECURRENCY_ID = "settlecurrency_id";

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        HashSet orgIds = new HashSet(entitys.length);
        HashSet<Object> settleCurrencyIds = new HashSet<Object>(entitys.length);
        HashSet<Object> ownerIds = new HashSet<Object>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject bizorg = bill.getDynamicObject("bizorg");
            if (null == bizorg) {
                throw new KDBizException(ResManager.loadKDString((String)"\u3010\u9886\u6599\u7533\u8bf7\u5355\u3011\u3010\u5e93\u5b58\u7ec4\u7ec7\u3011\u53d6\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u6e90\u5355\u3010\u91c7\u8d2d\u7ec4\u7ec7\u3011\u662f\u5426\u6709\u503c\u6216\u3010\u91c7\u8d2d\u7ec4\u7ec7\u3011\u59d4\u6258\u5e93\u5b58\u6536\u8d27\u662f\u5426\u6709\u503c\u3002", (String)"Requir2MatApplyConvertPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            }
            if (bill.get("settleorg") == null && org != null) {
                Map map = OrgHelper.getCompanyByOrg((Long)((Long)org.getPkValue()), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Object settleOrgId = null;
                if (map != null) {
                    settleOrgId = map.get("id");
                }
                if (settleOrgId != null) {
                    orgIds.add(settleOrgId);
                }
                bill.set("settleorg_id", settleOrgId);
            }
            this.initCurrency(bill, settleCurrencyIds);
            this.setDefaultOwner(bill, ownerIds);
        }
        if (orgIds.size() > 0) {
            Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgIds.toArray(new Object[0]), (String)"bos_org");
            Map currencyMap = BusinessDataServiceHelper.loadFromCache((Object[])settleCurrencyIds.toArray(new Object[0]), (String)"bd_currency");
            Map ownerMap = BusinessDataServiceHelper.loadFromCache((Object[])ownerIds.toArray(new Object[0]), (String)"bos_org");
            for (ExtendedDataEntity entity : entitys) {
                Object ownerId;
                DynamicObject owner;
                Object settle;
                DynamicObject settelCurrency;
                DynamicObject bill = entity.getDataEntity();
                Object settleorg = bill.get("settleorg");
                Object settleorgId = bill.get("settleorg_id");
                if (settleorg == null && settleorgId != null) {
                    bill.set("settleorg_id", orgMap.get(settleorgId));
                }
                if ((settelCurrency = (DynamicObject)currencyMap.get(settle = bill.get(SETTLECURRENCY_ID))) != null) {
                    bill.set(SETTLECURRENCY, (Object)settelCurrency);
                }
                if ((owner = (DynamicObject)ownerMap.get(ownerId = bill.get("supplyowner_id"))) == null) continue;
                bill.set("supplyowner", (Object)owner);
            }
        }
    }

    private void setDefaultOwner(DynamicObject bill, Set<Object> ownerIds) {
        Long bizOrgId;
        Object defaultOwner;
        DynamicObject bizOrg = bill.getDynamicObject("bizorg");
        if (null != bizOrg && (defaultOwner = Requir2MatApplyConvertPlugin.getOwnerDefValue(bizOrgId = (Long)bizOrg.getPkValue())) != null) {
            bill.set("supplyowner_id", defaultOwner);
            ownerIds.add(defaultOwner);
        }
    }

    private void initCurrency(DynamicObject bill, Set<Object> currencyIds) {
        DynamicObject org = bill.getDynamicObject("org");
        Long orgId = null;
        if (org != null) {
            orgId = org.getLong("id");
        }
        if (orgId == null) {
            bill.set(SETTLECURRENCY, null);
            return;
        }
        Map<String, Long> map = Requir2MatApplyConvertPlugin.getCurrencyAndExRateTable(orgId);
        if (map == null) {
            bill.set(SETTLECURRENCY, null);
            return;
        }
        currencyIds.add(map.get("baseCurrencyID"));
        bill.set(SETTLECURRENCY_ID, (Object)map.get("baseCurrencyID"));
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != 0L && (mapOrg = OrgHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return null;
    }

    public static ArrayList<Object> getOwners(Long orgId) {
        ArrayList<Object> array = new ArrayList<Object>();
        if (orgId == null) {
            return array;
        }
        List ownerOrgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        if (ownerOrgs != null && ownerOrgs.size() > 0) {
            for (int i = 0; i < ownerOrgs.size(); ++i) {
                Long ownerOrgId = (Long)ownerOrgs.get(i);
                if (array.contains(ownerOrgId)) continue;
                array.add(ownerOrgs.get(i));
            }
        }
        return array;
    }

    public static Object getOwnerDefValue(Long toOrgId) {
        Map map;
        if (toOrgId == null || toOrgId.equals(0L)) {
            return 0L;
        }
        ArrayList<Object> orgIds = Requir2MatApplyConvertPlugin.getOwners(toOrgId);
        Object defOwnerId = orgIds.isEmpty() ? ((map = OrgUnitServiceHelper.getCompanyByOrg((Long)toOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) == null || map.isEmpty() ? Long.valueOf(0L) : map.get("id")) : orgIds.get(0);
        return defOwnerId;
    }
}

