/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.reqapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.QtyProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.scm.pssc.business.helper.BillQtyAndUnitHelper;
import kd.scm.pssc.business.helper.BotpHepler;
import kd.scm.pssc.business.helper.ReqSumSchemeHelper;
import kd.scm.pssc.business.pojo.ReturnResultInfo;
import kd.scm.pssc.business.pojo.SummarySchemaDTO;

public class ReqApplyToReqApplyPlugin
extends AbstractFormPlugin {
    private static final String BOTPRULE = "botprule";
    private static final String SUMSCHEME = "requirsumscheme";
    private static final String ENTRYENTITY = "resultentryentity";
    private static final String BASEQTY = "baseqty";
    private static final String AUXQTY = "auxqty";
    private static final String REQ_APPLY_ENTRY_ID_TO_ENTRY_ID_MAP = "reqApplyEntryIdTOEntryIdMap";

    public void afterCreateNewData(EventObject e) {
        Long defaultReqSumSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam("sumSchemeId");
        defaultReqSumSchemeId = defaultReqSumSchemeId != null ? defaultReqSumSchemeId : ReqSumSchemeHelper.getDefaultReqSumScheme();
        boolean existBotpRule = ReqSumSchemeHelper.judgeReqToReqBotpRule();
        if (!existBotpRule && defaultReqSumSchemeId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u6c47\u603b\u65b9\u6848\u3001\u8f6c\u6362\u89c4\u5219\u3002", (String)"ReqApplyToReqApplyPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!existBotpRule) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u7533\u8bf7\u5355\u751f\u6210\u9700\u6c42\u7533\u8bf7\u5355\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"ReqApplyToReqApplyPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (defaultReqSumSchemeId == null || defaultReqSumSchemeId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u6c47\u603b\u65b9\u6848\u3002", (String)"ReqApplyToReqApplyPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setTransformRule();
        this.getModel().setValue(SUMSCHEME, (Object)defaultReqSumSchemeId);
        this.queryAndShowList(defaultReqSumSchemeId);
        this.getView().updateView(ENTRYENTITY);
    }

    public void afterBindData(EventObject e) {
        this.initSelectRow();
        this.setButtonName();
    }

    private void setButtonName() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billTypeForm = (String)formShowParameter.getCustomParam("billTypeForm");
        if (StringUtils.isBlank((CharSequence)billTypeForm)) {
            return;
        }
        switch (billTypeForm) {
            case "pssc_requirapplymonthbill": {
                this.changeName("botpreq", ResManager.loadKDString((String)"\u751f\u6210\u6708\u5ea6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyToReqApplyPlugin_13", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "pssc_requirapplyyearbill": {
                this.changeName("botpreq", ResManager.loadKDString((String)"\u751f\u6210\u5e74\u5ea6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyToReqApplyPlugin_14", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "pssc_requirapplyotherbill": {
                this.changeName("botpreq", ResManager.loadKDString((String)"\u751f\u6210\u5176\u4ed6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyToReqApplyPlugin_15", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void changeName(String id, String name) {
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
        props.put("text", new LocaleString(name));
        this.getView().updateControlMetadata(id, props);
    }

    private void initSelectRow() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Integer> setSelectRow = new ArrayList<Integer>(dynamicObjects.size());
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            BigDecimal checkneedsnum = ((DynamicObject)dynamicObjects.get(i)).getBigDecimal("checkneedsnum");
            if (checkneedsnum == null || checkneedsnum.compareTo(BigDecimal.ZERO) == 0) continue;
            setSelectRow.add(i);
        }
        int[] selectRow = setSelectRow.stream().mapToInt(Integer::intValue).toArray();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.selectRows(selectRow, -1);
    }

    private void controlSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] beforeSelectRows = entryGrid.getSelectRows();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Integer> afterSelectRow = new ArrayList<Integer>(dynamicObjects.size());
        for (int row : beforeSelectRows) {
            BigDecimal checkneedsnum = ((DynamicObject)dynamicObjects.get(row)).getBigDecimal("checkneedsnum");
            if (checkneedsnum == null || checkneedsnum.compareTo(BigDecimal.ZERO) == 0) continue;
            afterSelectRow.add(row);
        }
        int[] selectRow = afterSelectRow.stream().mapToInt(Integer::intValue).toArray();
        entryGrid.selectRows(selectRow, -1);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "botpreq": {
                String ruleId = (String)this.getModel().getValue(BOTPRULE);
                boolean exists = QueryServiceHelper.exists((String)"botp_crlist", (Object)ruleId);
                if (!exists) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u88ab\u5220\u9664\uff0c\u8bf7\u9000\u51fa\u91cd\u65b0\u6c47\u603b\u3002", (String)"ReqApplyToReqApplyPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject sumScheme = (DynamicObject)this.getModel().getValue(SUMSCHEME);
                if (sumScheme == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u65b9\u6848\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReqApplyToReqApplyPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map<String, String> param = this.getBotpParam((Long)sumScheme.getPkValue());
                Set<String> entryIdSet = this.getSelectEntryIdSet();
                if (entryIdSet == null || entryIdSet.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761 \u201c\u786e\u8ba4\u9700\u6c42\u6570\u91cf\u201d \u4e0d\u4e3a0\u7684\u6570\u636e\u884c\u3002", (String)"ReqApplyToReqApplyPlugin_12", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                HashMap<Long, Long> transFormId = new HashMap<Long, Long>(16);
                Map sourceIdMap = (Map)formShowParameter.getCustomParam("selectentryidid");
                for (Map.Entry entry : sourceIdMap.entrySet()) {
                    if (!entryIdSet.contains(entry.getKey())) continue;
                    Long key = Long.valueOf((String)entry.getKey());
                    Long value = (Long)entry.getValue();
                    transFormId.put(key, value);
                }
                ReturnResultInfo result = BotpHepler.botpGenerateTargetBill(transFormId, (String)ruleId, (String)"pm_requirapplybill", (String)"billentry", (String)"pm_requirapplybill", (String)"billentry", (String)"save", param, (boolean)true);
                if (result.isSuccess()) {
                    this.getView().returnDataToParent((Object)result.getSuccessList());
                    this.getView().close();
                    break;
                }
                this.getView().showTipNotification(result.getMessage());
                return;
            }
        }
    }

    private Set<String> getSelectEntryIdSet() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return null;
        }
        String cacheString = this.getPageCache().get(REQ_APPLY_ENTRY_ID_TO_ENTRY_ID_MAP);
        if (StringUtils.isEmpty((CharSequence)cacheString)) {
            return null;
        }
        Map reqApplyEntryIdTOEntryIdMap = (Map)JSON.parseObject((String)cacheString, Map.class);
        if (reqApplyEntryIdTOEntryIdMap == null || reqApplyEntryIdTOEntryIdMap.isEmpty()) {
            return null;
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int selectRow : selectRows) {
            String reqapplyentryid;
            String entryIdsStr;
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            BigDecimal checkneedsnum = dynamicObject.getBigDecimal("checkneedsnum");
            if (checkneedsnum.compareTo(BigDecimal.ZERO) == 0 || StringUtils.isEmpty((CharSequence)(entryIdsStr = (String)reqApplyEntryIdTOEntryIdMap.get(reqapplyentryid = dynamicObject.getString("reqapplyentryid"))))) continue;
            List entryIds = Stream.of(entryIdsStr.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            entryIdSet.addAll(entryIds);
        }
        return entryIdSet;
    }

    private Map<String, String> getBotpParam(Long requireSumSchemeID) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        ArrayList<String> paramKeyField = new ArrayList<String>(16);
        Map<String, Map> initSummary = this.getSummaryParameter(paramKeyField);
        String entryData = SerializationUtils.toJsonString(initSummary);
        StringBuilder schemaField = new StringBuilder();
        Set<String> fields = this.getSumFields(requireSumSchemeID);
        ArrayList<String> copyFields = new ArrayList<String>(fields.size());
        for (String field : fields) {
            if (field.contains("billentry.") && !field.contains("billentry.id")) {
                copyFields.add(field.replace("billentry.", ""));
                continue;
            }
            copyFields.add(field);
        }
        String join = String.join((CharSequence)",", copyFields);
        schemaField.append(join);
        param.put("entryresult", entryData);
        param.put("summaryschema", schemaField.toString());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String orgId = (String)formShowParameter.getCustomParam("org");
        param.put("org", orgId);
        String sumdept = (String)formShowParameter.getCustomParam("sumdept");
        param.put("sumdept", sumdept);
        return param;
    }

    private Map<String, Map> getSummaryParameter(List<String> paramKeyField) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity(true);
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(ENTRYENTITY);
        HashMap<String, Map> mapCollection = new HashMap<String, Map>(entry.size());
        for (DynamicObject row : entry) {
            BigDecimal surplusbasenum = row.getBigDecimal(BASEQTY);
            BigDecimal auxqtysum = row.getBigDecimal(AUXQTY);
            Date reqDate = row.getDate("reqdateid");
            String paramMapKeyStr = String.valueOf(row.get("reqapplyentryid"));
            HashMap<String, Comparable<BigDecimal>> mapsum = new HashMap<String, Comparable<BigDecimal>>();
            mapsum.put(BASEQTY, surplusbasenum);
            mapsum.put(AUXQTY, auxqtysum);
            mapsum.put("reqdate", reqDate);
            mapCollection.put(paramMapKeyStr, mapsum);
        }
        return mapCollection;
    }

    private Set<String> getSumFields(Long schemeID) {
        HashSet<String> fields = new HashSet<String>(16);
        DynamicObject requireSumScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeID, (String)"pm_reqsumscheme", (String)"id,entryentity.sumcode");
        if (requireSumScheme != null) {
            DynamicObjectCollection entrys = requireSumScheme.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                fields.add(entry.getString("sumcode"));
            }
        }
        fields.add("billentry.unmaterialtag");
        return fields;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        block6: for (int i = 0; i < changeSet.length; ++i) {
            changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            DynamicObject dataEntity = changeData.getDataEntity();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldKey) {
                case "checkneedsnum": {
                    BigDecimal checkneedsnum = (BigDecimal)dataEntity.get("checkneedsnum");
                    if (checkneedsnum == null) {
                        model.setValue("checkneedsnum", (Object)new BigDecimal(0));
                    }
                    this.controlSelectRow();
                    DynamicObject material = dataEntity.getDynamicObject("materialmasterid");
                    DynamicObject baseUnit = dataEntity.getDynamicObject("baseunit");
                    DynamicObject purChaseUnit = dataEntity.getDynamicObject("purchaseunit");
                    BigDecimal purChaseUnitQty = (BigDecimal)newValue;
                    BigDecimal surplusbasenum = (BigDecimal)model.getValue("surplusbasenum", rowIndex);
                    if (purChaseUnitQty != null && surplusbasenum != null && purChaseUnitQty.compareTo(surplusbasenum) > 0) {
                        purChaseUnitQty = surplusbasenum;
                    }
                    if (material != null) {
                        Long materialmasterid = (Long)dataEntity.getDynamicObject("materialmasterid").getPkValue();
                        BigDecimal baseUnitQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialmasterid, (DynamicObject)purChaseUnit, (BigDecimal)purChaseUnitQty, (DynamicObject)baseUnit);
                        model.setValue(BASEQTY, (Object)baseUnitQty, rowIndex);
                        continue block6;
                    }
                    model.setValue(BASEQTY, (Object)purChaseUnitQty, rowIndex);
                    model.setValue(AUXQTY, (Object)purChaseUnitQty, rowIndex);
                    continue block6;
                }
            }
        }
        if (StringUtils.equals((CharSequence)SUMSCHEME, (CharSequence)fieldKey)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            ChangeData[] changeSet1 = e.getChangeSet();
            if (changeSet1.length > 0) {
                changeData = changeSet1[0];
                if (changeData == null) {
                    return;
                }
                if (changeData.getNewValue() instanceof DynamicObject) {
                    Long defaultRequireSumScheme = (Long)((DynamicObject)changeData.getNewValue()).getPkValue();
                    this.queryAndShowList(defaultRequireSumScheme);
                }
                this.getView().updateView(ENTRYENTITY);
            }
        }
    }

    private void queryAndShowList(Long requireSumSchemeID) {
        String tips;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List primaryIdList = (List)formShowParameter.getCustomParam("selectline");
        List entryPrimaryIdList = (List)formShowParameter.getCustomParam("selectentryline");
        if (primaryIdList != null && !primaryIdList.isEmpty()) {
            Map<String, SummarySchemaDTO> unMaterialInfo = this.getUnMaterialUnitInfo(entryPrimaryIdList);
            try (DataSet initSummarySchema = this.getSumData(requireSumSchemeID, entryPrimaryIdList);){
                try (DataSet copy = initSummarySchema.copy();){
                    int numSize = copy.count("billentry.materialmasterid", false);
                    tips = String.format(ResManager.loadKDString((String)"\u6309\u7167\u9700\u6c42\u6c47\u603b\u65b9\u6848\u8ba1\u7b97\uff0c%1$s\u5f20\uff08\u5171%2$s\u884c\uff09\u9700\u6c42\u7533\u8bf7\u5355\u88ab\u6c47\u603b\u4e3a%3$s\u884c", (String)"ReqApplyToReqApplyPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]), primaryIdList.size(), entryPrimaryIdList.size(), numSize);
                }
                this.getModel().beginInit();
                this.initDefaultResultEntry(initSummarySchema, unMaterialInfo);
                this.getModel().endInit();
            }
        }
        tips = ResManager.loadKDString((String)"\u6309\u7167\u9700\u6c42\u6c47\u603b\u65b9\u6848\u8ba1\u7b97\uff0c0\u5f20\uff08\u51710\u884c\uff09\u9700\u6c42\u7533\u8bf7\u5355\u88ab\u6c47\u603b\u4e3a0\u884c", (String)"ReqApplyToReqApplyPlugin_6", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
        Label labelAp = (Label)this.getView().getControl("sumlab");
        labelAp.setText(tips);
    }

    private Map<String, SummarySchemaDTO> getUnMaterialUnitInfo(List<Long> entryPrimaryIdList) {
        QFilter qFilter = new QFilter("billentry.id", "in", entryPrimaryIdList);
        qFilter.and("billentry.materialmasterid", "=", (Object)0L);
        HashSet<Long> unitIds = new HashSet<Long>();
        HashMap<String, Long[]> mid = new HashMap<String, Long[]>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_requirapplybill", (String)"billentry.id,billentry.baseunit,billentry.auxunit,billentry.unit", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                unitIds.add(row.getLong("billentry.auxunit"));
                unitIds.add(row.getLong("billentry.baseunit"));
                mid.put(row.getString("billentry.id"), new Long[]{row.getLong("billentry.baseunit"), row.getLong("billentry.auxunit")});
            }
        }
        HashMap<String, SummarySchemaDTO> summarySchemaDTOMap = new HashMap<String, SummarySchemaDTO>();
        Map unitMap = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(new Object[0]), (String)"bd_measureunits");
        for (Map.Entry next : mid.entrySet()) {
            String key = (String)next.getKey();
            Long[] value = (Long[])next.getValue();
            if (value == null || value.length != 2) continue;
            summarySchemaDTOMap.put(key, SummarySchemaDTO.initBaseUnitAndAuxunit((DynamicObject)((DynamicObject)unitMap.get(value[1])), (DynamicObject)((DynamicObject)unitMap.get(value[1])), (DynamicObject)((DynamicObject)unitMap.get(value[0]))));
        }
        return summarySchemaDTOMap;
    }

    private void initDefaultResultEntry(DataSet rows, Map<String, SummarySchemaDTO> summarySchemaDTOMap) {
        IDataModel model = this.getModel();
        DataSet dataSetCopy = rows.copy();
        HashMap<Long, String> materialNameMap = new HashMap<Long, String>(16);
        Map<Long, SummarySchemaDTO> initMaterialBaseUnitAndPurUnit = this.initMaterialBaseUnitAndPurUnitAndAuxunit(dataSetCopy, materialNameMap);
        dataSetCopy.close();
        QtyProp baseQtyProperty = (QtyProp)this.getModel().getDataEntityType().findProperty(BASEQTY);
        BigDecimal baseQtyMax = baseQtyProperty.getMax();
        BigDecimal baseQtyMin = baseQtyProperty.getMin();
        QtyProp surauxQtyProperty = (QtyProp)this.getModel().getDataEntityType().findProperty(AUXQTY);
        BigDecimal surauxQtyPropertyMax = surauxQtyProperty.getMax();
        BigDecimal surauxQtyPropertyMin = surauxQtyProperty.getMin();
        QtyProp surplusbasenumProperty = (QtyProp)this.getModel().getDataEntityType().findProperty("surplusbasenum");
        BigDecimal surplusbasenumMax = surplusbasenumProperty.getMax();
        BigDecimal surplusbasenumMin = surplusbasenumProperty.getMin();
        QtyProp checkneedsnumProperty = (QtyProp)this.getModel().getDataEntityType().findProperty("checkneedsnum");
        BigDecimal checkneedsnumMax = checkneedsnumProperty.getMax();
        BigDecimal checkneedsnumMin = checkneedsnumProperty.getMin();
        List<Field> rowFields = Arrays.asList(rows.getRowMeta().getFields());
        if (rowFields == null || rowFields.isEmpty()) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String orgId = (String)formShowParameter.getCustomParam("org");
        List rowFieldName = rowFields.stream().map(Field::getName).collect(Collectors.toList());
        HashMap<String, String> reqApplyEntryIdTOEntryIdMap = new HashMap<String, String>();
        for (Row row : rows) {
            String entryId = row.getString("billentry.id");
            reqApplyEntryIdTOEntryIdMap.put(entryId, row.getString("billentryids"));
            int rowId = model.createNewEntryRow(ENTRYENTITY);
            model.setValue("reqdateid", row.get("billentry.reqdate"), rowId);
            model.setValue("reqapplyentryid", row.get("billentry.id"), rowId);
            if (rowFieldName.contains("org")) {
                model.setValue("orgid", (Object)Long.valueOf(orgId), rowId);
            }
            Long materialmasterid = null;
            if (rowFieldName.contains("billentry.materialmasterid")) {
                materialmasterid = row.getLong("billentry.materialmasterid");
            }
            if (rowFieldName.contains("billentry.entrybizorg")) {
                model.setValue("purorg", row.get("billentry.entrybizorg"), rowId);
            }
            if (rowFieldName.contains("dept")) {
                model.setValue("dept", row.get("dept"), rowId);
            }
            if (rowFieldName.contains("billentry.project")) {
                model.setValue("project", row.get("billentry.project"), rowId);
            }
            if (rowFieldName.contains("billentry.supplier")) {
                model.setValue("supplierid", row.get("billentry.supplier"), rowId);
            }
            if (rowFieldName.contains("billentry.reqkind")) {
                model.setValue("reqkind", row.get("billentry.reqkind"), rowId);
            }
            if (rowFieldName.contains("billentry.originorg")) {
                model.setValue("originorg", row.get("billentry.originorg"), rowId);
            }
            SummarySchemaDTO sumSchema = initMaterialBaseUnitAndPurUnit.get(materialmasterid);
            DynamicObject baseUnit = null;
            DynamicObject purChaseUnit = null;
            DynamicObject auxunit = null;
            if (sumSchema != null) {
                baseUnit = sumSchema.getBaseUnit();
                purChaseUnit = sumSchema.getPurChaseUnit();
                auxunit = sumSchema.getAuxunit();
                model.setValue("materialmasterid", (Object)materialmasterid, rowId);
                model.setValue("purchaseunit", (Object)purChaseUnit, rowId);
                model.setValue("baseunit", (Object)baseUnit, rowId);
                model.setValue("auxunit", (Object)auxunit, rowId);
            } else {
                SummarySchemaDTO dto = summarySchemaDTOMap.get(entryId);
                baseUnit = dto.getBaseUnit();
                purChaseUnit = dto.getPurChaseUnit();
                auxunit = dto.getAuxunit();
                model.setValue("materialmasterid", (Object)materialmasterid, rowId);
                model.setValue("purchaseunit", (Object)purChaseUnit, rowId);
                model.setValue("baseunit", (Object)baseUnit, rowId);
                model.setValue("auxunit", (Object)auxunit, rowId);
            }
            Long unMaterialTag = row.getLong("billentry.unmaterialtag");
            if (unMaterialTag != null && unMaterialTag > 0L) {
                model.setValue("materialtext", row.get("materialnames"), rowId);
            } else {
                model.setValue("materialtext", materialNameMap.get(materialmasterid), rowId);
            }
            BigDecimal baseqty = row.getBigDecimal("billentry.baseqty");
            BigDecimal unionSumBaseQty = row.getBigDecimal("billentry.unionsumbaseqty");
            BigDecimal surauxqty = row.getBigDecimal("billentry.auxqty");
            BigDecimal auxqty = surauxqty.setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)auxunit), BillQtyAndUnitHelper.getPrecisionType((DynamicObject)auxunit));
            BigDecimal surplusbaseqty = baseqty.subtract(unionSumBaseQty);
            BigDecimal surplusqty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialmasterid, (DynamicObject)baseUnit, (BigDecimal)surplusbaseqty, (DynamicObject)purChaseUnit);
            if (baseqty.compareTo(baseQtyMax) > 0 || baseqty.compareTo(baseQtyMin) < 0) {
                model.setValue(BASEQTY, (Object)BigDecimal.ZERO, rowId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u7b2c%1$s\u884c\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5b57\u6bb5\u8bbe\u5b9a\u6570\u636e\u8303\u56f4", (String)"ReqApplyToReqApplyPlugin_7", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowId + 1));
            } else {
                model.setValue(BASEQTY, (Object)surplusbaseqty, rowId);
            }
            if (auxqty.compareTo(surauxQtyPropertyMax) > 0 || auxqty.compareTo(surauxQtyPropertyMin) < 0) {
                model.setValue(AUXQTY, (Object)BigDecimal.ZERO, rowId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u7b2c%1$s\u884c\u8f85\u52a9\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5b57\u6bb5\u8bbe\u5b9a\u6570\u636e\u8303\u56f4", (String)"ReqApplyToReqApplyPlugin_8", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowId + 1));
            } else {
                model.setValue(AUXQTY, (Object)auxqty, rowId);
            }
            if (surplusqty.compareTo(surplusbasenumMax) > 0 || surplusqty.compareTo(surplusbasenumMin) < 0) {
                model.setValue("surplusbasenum", (Object)BigDecimal.ZERO, rowId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u7b2c%1$s\u884c\u5269\u4f59\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5b57\u6bb5\u8bbe\u5b9a\u6570\u636e\u8303\u56f4", (String)"ReqApplyToReqApplyPlugin_9", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowId + 1));
            } else {
                model.setValue("surplusbasenum", (Object)surplusqty, rowId);
            }
            if (surplusqty.compareTo(checkneedsnumMax) > 0 || surplusqty.compareTo(checkneedsnumMin) < 0) {
                model.setValue("checkneedsnum", (Object)BigDecimal.ZERO, rowId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u7b2c%1$s\u884c\u786e\u8ba4\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5b57\u6bb5\u8bbe\u5b9a\u6570\u636e\u8303\u56f4", (String)"ReqApplyToReqApplyPlugin_10", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowId + 1));
                continue;
            }
            model.setValue("checkneedsnum", (Object)surplusqty, rowId);
        }
        this.getView().getPageCache().put(REQ_APPLY_ENTRY_ID_TO_ENTRY_ID_MAP, SerializationUtils.toJsonString(reqApplyEntryIdTOEntryIdMap));
    }

    private Map<Long, SummarySchemaDTO> initMaterialBaseUnitAndPurUnitAndAuxunit(DataSet dataSetCopy, Map<Long, String> materialNameMap) {
        int count = dataSetCopy.count("billentry.materialmasterid", true);
        HashSet<Long> materialList = new HashSet<Long>(count);
        for (Row row : dataSetCopy) {
            Long materialId = row.getLong("billentry.materialmasterid");
            materialList.add(materialId);
        }
        QFilter qFilter = new QFilter("id", "in", materialList);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,baseunit,auxptyunit", (QFilter[])qFilter.toArray());
        HashMap<Long, SummarySchemaDTO> mapDTO = new HashMap<Long, SummarySchemaDTO>(load.length);
        for (DynamicObject dynamic : load) {
            Long pkvalue = dynamic.getLong("id");
            ILocaleString name = dynamic.getLocaleString("name");
            materialNameMap.put(pkvalue, name == null ? "" : name.getLocaleValue());
            DynamicObject baseUnit = dynamic.getDynamicObject("baseunit");
            DynamicObject auxunit = dynamic.getDynamicObject("auxptyunit");
            mapDTO.put(pkvalue, SummarySchemaDTO.initBaseUnitAndAuxunit((DynamicObject)baseUnit, (DynamicObject)baseUnit, (DynamicObject)auxunit));
        }
        return mapDTO;
    }

    private DataSet getSumData(Long requireSumSchemeID, List<Long> selectEntryLine) {
        QFilter q1 = new QFilter("billentry.id", "in", selectEntryLine);
        QFilter q2 = new QFilter("billentry.baseqty", "!=", (Object)BigDecimal.ZERO);
        HashSet<String> queryFieldSet = new HashSet<String>(16);
        Collections.addAll(queryFieldSet, "id", "org", "dept", "bizorg", "billentry.id", "billentry.baseqty", "billentry.applybaseqty", "billentry.unionsumbaseqty", "billentry.auxqty", "billentry.reqdate", "billentry.supplier", "billentry.materialmasterid", "billentry.project", "billentry.reqkind", "billentry.originorg", "billentry.entrybizorg", "billentry.unmaterialtag", "billentry.materialname");
        Set<String> groupByFieldSet = this.getFieldList(requireSumSchemeID);
        queryFieldSet.addAll(groupByFieldSet);
        String queryFieldSql = queryFieldSet.stream().map(String::trim).collect(Collectors.joining(","));
        String groupByFieldSql = groupByFieldSet.stream().map(String::trim).collect(Collectors.joining(","));
        DataSet queryDataSet = null;
        if (groupByFieldSet.contains("billentry.reqdate")) {
            queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_requirapplybill", (String)queryFieldSql, (QFilter[])new QFilter[]{q1, q2}, (String)"billentry.reqdate desc");
            GroupbyDataSet groupDataSet = queryDataSet.groupBy(ReqSumSchemeHelper.convertStrToArray((String)groupByFieldSql)).groupConcat("billentry.id", "billentryids").groupConcat("billentry.materialname", "materialnames").max("billentry.id").sum("billentry.baseqty").sum("billentry.unionsumbaseqty").sum("( billentry.baseqty - billentry.unionsumbaseqty ) * billentry.auxqty / billentry.baseqty", "billentry.auxqty");
            queryDataSet = groupDataSet.finish();
        } else {
            queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_requirapplybill", (String)queryFieldSql, (QFilter[])new QFilter[]{q1, q2}, (String)"billentry.reqdate desc");
            GroupbyDataSet groupDataSet = queryDataSet.groupBy(ReqSumSchemeHelper.convertStrToArray((String)groupByFieldSql)).groupConcat("billentry.id", "billentryids").groupConcat("billentry.materialname", "materialnames").min("billentry.reqdate").max("billentry.id").sum("billentry.baseqty").sum("billentry.unionsumbaseqty").sum("( billentry.baseqty - billentry.unionsumbaseqty ) * billentry.auxqty / billentry.baseqty", "billentry.auxqty");
            queryDataSet = groupDataSet.finish();
        }
        return queryDataSet;
    }

    private Set<String> getFieldList(Long schemeID) {
        HashSet<String> fieldList = new HashSet<String>(16);
        QFilter filter = new QFilter("id", "=", (Object)schemeID);
        try (DataSet bizList = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_reqsumscheme", (String)"id,entryentity.sumcode", (QFilter[])filter.toArray(), null);){
            for (Row row : bizList) {
                fieldList.add(row.getString("entryentity.sumcode"));
            }
        }
        fieldList.add("billentry.unmaterialtag");
        return fieldList;
    }

    private String getLabelapValue(Map<String, List<Long>> selectLine, int numSize) {
        int num = 0;
        for (Map.Entry<String, List<Long>> item : selectLine.entrySet()) {
            List<Long> value = item.getValue();
            num += value.size();
        }
        String result = String.format(ResManager.loadKDString((String)"\u6309\u7167\u9700\u6c42\u6c47\u603b\u65b9\u6848\u8ba1\u7b97\uff0c%1$s\u5f20\uff08\u5171%2$s\u884c\uff09\u9700\u6c42\u7533\u8bf7\u5355\u88ab\u6c47\u603b\u4e3a%3$s\u884c", (String)"ReqApplyToReqApplyPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]), selectLine.size(), num, numSize);
        return result;
    }

    private void setTransformRule() {
        List ruleElements = ConvertMetaServiceHelper.loadRules((String)"pm_requirapplybill", (String)"pm_requirapplybill");
        int size = ruleElements.size();
        if (size <= 0) {
            return;
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        String defRuleId = "";
        for (int i = 0; i < size; ++i) {
            ConvertRuleElement ruleElement = (ConvertRuleElement)ruleElements.get(i);
            boolean enabled = ruleElement.isEnabled();
            boolean visibled = ruleElement.isVisibled();
            if (!enabled || !visibled) continue;
            boolean defRule = ruleElement.isDefRule();
            LocaleString caption = ruleElement.getName();
            String value = ruleElement.getId();
            ComboItem item = new ComboItem(caption, value);
            comboItemList.add(item);
            if (!defRule && i != 0) continue;
            defRuleId = value;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(BOTPRULE);
        comboEdit.setComboItems(comboItemList);
        this.getModel().setValue(BOTPRULE, (Object)defRuleId);
    }
}

