/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.reqapply;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ReqSumSchemePlugin
extends AbstractBasePlugIn {
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String SOURCETREENODES = "treenodes";
    private static final String CALLBACK = "callback";
    private static final String SELECT_CALLBACK = "select_callback";
    private static final String DELETEENTRY = "deleteentry";
    private final String[] entryFixedField = new String[]{"bizorg", "org", "materialmasterid", "reqsource"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sumname"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("sumname".equals(c.getKey())) {
            MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)"pm_requirapplybill");
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(true);
            option.setOnlyPhysicsField(true);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
            this.showFieldForm(treeNode);
        }
    }

    public void afterCreateNewData(EventObject e) {
        int i;
        IDataModel model = this.getModel();
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (i = 0; i < this.entryFixedField.length; ++i) {
            if (this.entryFixedField[i].equals("materialmasterid") || "reqsource".equals(this.entryFixedField[i])) {
                map.put("billentry." + this.entryFixedField[i], String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.%1$s", (String)"ReqSumSchemePlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]), this.propertyValue(this.entryFixedField[i])));
                continue;
            }
            map.put(this.entryFixedField[i], String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934.%1$s", (String)"ReqSumSchemePlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]), this.propertyValue(this.entryFixedField[i])));
        }
        model.batchCreateNewEntryRow("entryentity", map.size());
        i = 0;
        for (Map.Entry row : map.entrySet()) {
            model.setValue("sumcode", row.getKey(), i);
            model.setValue("sumname", row.getValue(), i);
            model.setValue("fixedfield", (Object)Boolean.TRUE, i);
            ++i;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (!"sumname".equals(fieldKey) || !StringUtils.isBlank((Object)newValue)) continue;
            int rowIndex = changeData.getRowIndex();
            model.setValue("sumcode", null, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObjectCollection billEntry;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject bill = this.getModel().getDataEntity(true);
        ArrayList<String> errorMessage = new ArrayList<String>(16);
        if (DELETEENTRY.equals(operateKey) && (billEntry = bill.getDynamicObjectCollection("entryentity")).size() != 0) {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entry.getSelectRows();
            ArrayList<String> list = new ArrayList<String>(5);
            ArrayList<Integer> listRow = new ArrayList<Integer>(5);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject row = (DynamicObject)billEntry.get(selectRows[i]);
                String sumName = row.getString("sumname");
                Boolean fixedfield = row.getBoolean("fixedfield");
                if (fixedfield.equals(Boolean.TRUE)) {
                    list.add(sumName);
                    continue;
                }
                listRow.add(selectRows[i]);
            }
            if (list.size() > 0) {
                StringBuilder errorInfoString = new StringBuilder();
                for (int j = 0; j < list.size(); ++j) {
                    if (j < list.size() - 1) {
                        errorInfoString.append((String)list.get(j)).append('\uff0c');
                        continue;
                    }
                    errorInfoString.append((String)list.get(j));
                }
                errorMessage.add(String.format(ResManager.loadKDString((String)"%1$s\u662f\u6c47\u603b\u7ef4\u5ea6\u5fc5\u9700\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u884c", (String)"ReqSumSchemePlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]), errorInfoString));
            }
            if (errorMessage.size() > 0) {
                StringBuilder allMessage = new StringBuilder();
                for (String s : errorMessage) {
                    allMessage.append(s);
                }
                if (listRow.size() > 0) {
                    listRow.sort(Collections.reverseOrder());
                    Iterator iterator = listRow.iterator();
                    while (iterator.hasNext()) {
                        int row = (Integer)iterator.next();
                        billEntry.remove(row);
                    }
                    this.getView().updateView("entryentity");
                }
                e.setCancel(true);
                this.getView().showTipNotification(String.format(String.valueOf(allMessage), "", MessageTypes.Commit));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null || StringUtils.isEmpty((CharSequence)actionId)) {
            return;
        }
        if (actionId.equals(CALLBACK)) {
            this.setCallBackResult(returnData);
        }
    }

    private void showFieldForm(TreeNode billNode) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put(SOURCETREENODES, nodesJson);
        if ("pm_requirapplybill".equals("pm_requirapplybill")) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setCallBackResult(Object returnData) {
        String parentName;
        String fieldId = returnData.toString();
        MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)"pm_requirapplybill");
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcBillMainType, (String)fieldId);
        String[] split = fieldId.split("\\.");
        String tempFieldId = split[0];
        IDataEntityProperty findProperty = srcBillMainType.findProperty(fieldId);
        if (findProperty == null) {
            findProperty = srcBillMainType.findProperty(tempFieldId);
        }
        if (findProperty != null && !StringUtils.equals((CharSequence)(parentName = findProperty.getParent().getName()), (CharSequence)tempFieldId)) {
            fieldId = this.getEntryFullField(srcBillMainType, fieldId, parentName);
        }
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (SELECT_CALLBACK.equals(SELECT_CALLBACK)) {
            DynamicObjectCollection billEntry = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : billEntry) {
                String entrySumName = entry.getString("sumname");
                String entrySumCode = entry.getString("sumcode");
                if (entrySumCode == null || !entrySumCode.equals(fieldId)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5728\u6c47\u603b\u5b57\u6bb5\u4e2d\u91cd\u590d\u51fa\u73b0", (String)"ReqSumSchemePlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]), entrySumName));
                return;
            }
            this.getModel().setValue("sumcode", (Object)fieldId, row);
            this.getModel().setValue("sumname", (Object)fieldCaption, row);
        }
    }

    public String propertyValue(String entityProperty) {
        MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)"pm_requirapplybill");
        IDataEntityProperty property = srcBillMainType.findProperty(entityProperty);
        return property.getDisplayName().toString();
    }

    private String getEntryFullField(MainEntityType srcBillMainType, String fieldId, String parentName) {
        while (!"pm_requirapplybill".equals(parentName)) {
            fieldId = parentName.concat(".").concat(fieldId);
            IDataEntityProperty parentProp = srcBillMainType.findProperty(parentName);
            if (parentProp.getParent() == null) break;
            parentName = parentProp.getParent().getName();
        }
        return fieldId;
    }
}

