/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.reqapply;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scm.pssc.business.helper.OrgHelper;
import kd.scm.pssc.business.helper.ReqSumSchemeHelper;
import kd.scm.pssc.business.pojo.SummarySchemaDTO;
import kd.scm.pssc.common.utils.DateUtil;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class RequireApplyQueryPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BeforeBindDataListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(RequireApplyQueryPlugin.class);

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList != null) {
            billList.getListUserOption().setMergeRow(false);
        }
    }

    public void registerListener(EventObject e) {
        BillList billList;
        Toolbar entryToolbar;
        BasedataEdit projectitem;
        BasedataEdit querymaterial;
        BasedataEdit querydept;
        BasedataEdit requireorg;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((requireorg = (BasedataEdit)this.getControl("requireorg")) != null) {
            requireorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((querydept = (BasedataEdit)this.getControl("querydept")) != null) {
            querydept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((querymaterial = (BasedataEdit)this.getControl("querymaterial")) != null) {
            querymaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((projectitem = (BasedataEdit)this.getControl("projectitem")) != null) {
            projectitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryToolbar = (Toolbar)this.getView().getControl("toolbarap")) != null) {
            entryToolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((billList = (BillList)this.getControl("billlistap")) != null) {
            billList.addBeforeBindDataListener((BeforeBindDataListener)this);
            billList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject requireorg;
        DynamicObject org;
        QFilter filterOrg;
        String fieldKey = event.getProperty().getName();
        String formId = this.getView().getEntityId();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("org".equals(fieldKey) && (filterOrg = OrgHelper.getHasPermissionOrgFilter((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType(), (IFormView)this.getView())) != null) {
            showParameter.getListFilterParameter().setFilter(filterOrg);
        }
        if ((org = (DynamicObject)this.getModel().getValue("org")) == null) {
            if ("requireorg".equals(fieldKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"RequireApplyQueryPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            if ("querymaterial".equals(fieldKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"RequireApplyQueryPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            if ("projectitem".equals(fieldKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"RequireApplyQueryPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
        }
        if ((requireorg = (DynamicObject)this.getModel().getValue("requireorg")) == null && "querydept".equals(fieldKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"RequireApplyQueryPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        LocalDateTime todayStart = LocalDateTime.of(LocalDate.now().minusMonths(1L), LocalTime.MIN);
        LocalDateTime todayEnd = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        model.setValue("applydate_startdate", (Object)todayStart);
        model.setValue("applydate_enddate", (Object)todayEnd);
        Long defaultOrg = OrgHelper.getDefaultOrg((String)this.getView().getEntityId(), (String)"02", (IFormView)this.getView());
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter filterParameter = new FilterParameter();
        QFilter qFilter = new QFilter("id", "=", (Object)0L);
        filterParameter.setFilter(qFilter);
        billList.setFilterParameter(filterParameter);
        billList.clearSelection();
        if (defaultOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u91c7\u8d2d\u7ec4\u7ec7", (String)"RequireApplyQueryPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            return;
        }
        model.setValue("org", (Object)defaultOrg);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (oldValue == null) {
            return;
        }
        if (newValue == null) {
            if ("org".equals(propName)) {
                model.setValue("requireorg", null);
                model.setValue("querymaterial", null);
                model.setValue("projectitem", null);
                model.setValue("querydept", null);
            }
            if ("requireorg".equals(propName)) {
                model.setValue("querydept", null);
            }
        } else {
            if ("org".equals(propName) && !oldValue.equals(newValue)) {
                model.setValue("requireorg", null);
                model.setValue("querymaterial", null);
                model.setValue("projectitem", null);
                model.setValue("querydept", null);
            }
            if ("requireorg".equals(propName) && !oldValue.equals(newValue)) {
                model.setValue("querydept", null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operatekey = event.getOperateKey();
        IFormView view = this.getView();
        BillList billList = (BillList)this.getControl("billlistap");
        switch (operatekey) {
            case "queryneeds": {
                QFilter qFilter = this.initQueryParam();
                FilterParameter filterParameter = new FilterParameter();
                filterParameter.setFilter(qFilter);
                billList.setFilterParameter(filterParameter);
                billList.refresh();
                billList.clearSelection();
                break;
            }
            case "summary": {
                ListSelectedRowCollection selectedRow = billList.getSelectedRows();
                if (selectedRow.size() <= 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fdb\u884c\u6c47\u603b\u7684\u6570\u636e\u884c", (String)"RequireApplyQueryPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean existBotpRule = this.isExistBotpRule();
                Long defaultRequireSumScheme = ReqSumSchemeHelper.getDefaultRequireSumScheme();
                if (!existBotpRule) {
                    if (defaultRequireSumScheme == null || defaultRequireSumScheme == 0L) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u6c47\u603b\u65b9\u6848\u3001\u8f6c\u6362\u89c4\u5219\u3002", (String)"RequireApplyQueryPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u7533\u8bf7\u5355\u751f\u6210\u91c7\u8d2d\u7533\u8bf7\u5355\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"RequireApplyQueryPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (defaultRequireSumScheme == null || defaultRequireSumScheme == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u6c47\u603b\u65b9\u6848\u3002", (String)"RequireApplyQueryPlugin_6", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                SummarySchemaDTO initMaterialExist = this.initMaterialBaseUnitAndPurUnit(selectedRow);
                List listDTO = initMaterialExist.getListDTO();
                MultiValuedMap allMapExist = initMaterialExist.getAllMapExist();
                Object[] entryprimarykey = selectedRow.getEntryPrimaryKeyValues();
                if (entryprimarykey[0] == null) {
                    entryprimarykey = allMapExist.values().toArray();
                }
                if (listDTO != null && !listDTO.isEmpty()) {
                    String warnMsg = initMaterialExist.getWarnMsg();
                    ArrayList<Long> noexist = new ArrayList<Long>(listDTO.size());
                    for (SummarySchemaDTO summarySchemaDTO : listDTO) {
                        Object[] entrypkv = summarySchemaDTO.getMasteridseqid();
                        noexist.add((Long)entrypkv);
                    }
                    ArrayListValuedHashMap mapNoExist = new ArrayListValuedHashMap(selectedRow.size());
                    ArrayList<Long> listNoExist = new ArrayList<Long>(entryprimarykey.length);
                    for (ListSelectedRow listSelectedRow : selectedRow) {
                        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                        Object entryPrimaryKeyValue = listSelectedRow.getEntryPrimaryKeyValue();
                        if (entryPrimaryKeyValue == null) {
                            Set tempList = allMapExist.get(primaryKeyValue).stream().collect(Collectors.toSet());
                            for (Object aLong : tempList) {
                                if (noexist.contains(aLong)) continue;
                                mapNoExist.put(primaryKeyValue, aLong);
                            }
                            continue;
                        }
                        if (noexist.contains(entryPrimaryKeyValue)) continue;
                        mapNoExist.put(primaryKeyValue, entryPrimaryKeyValue);
                    }
                    for (Object object : entryprimarykey) {
                        if (noexist.contains(object)) continue;
                        listNoExist.add((Long)object);
                    }
                    Map asMap = mapNoExist.asMap();
                    String mapNoExistStr = SerializationUtils.toJsonString((Object)asMap);
                    IPageCache pageCache = this.getPageCache();
                    pageCache.put("listNoExist", ((Object)listNoExist).toString());
                    pageCache.put("mapNoExist", mapNoExistStr);
                    this.openConfirmDialog(warnMsg);
                    break;
                }
                ArrayListValuedHashMap mapAllExist = new ArrayListValuedHashMap(selectedRow.size());
                Object[] entryprimaryall = selectedRow.getEntryPrimaryKeyValues();
                if (entryprimaryall[0] == null) {
                    entryprimaryall = allMapExist.values().toArray();
                }
                ArrayList<Long> listAllExist = new ArrayList<Long>(entryprimaryall.length);
                for (ListSelectedRow listSelectedRow : selectedRow) {
                    Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                    Object entryPrimaryKeyValue = listSelectedRow.getEntryPrimaryKeyValue();
                    if (entryPrimaryKeyValue == null) {
                        Set tempList = allMapExist.get(primaryKeyValue).stream().collect(Collectors.toSet());
                        for (Object aLong : tempList) {
                            mapAllExist.put(primaryKeyValue, aLong);
                        }
                        continue;
                    }
                    mapAllExist.put(primaryKeyValue, entryPrimaryKeyValue);
                }
                for (Object object : entryprimarykey) {
                    listAllExist.add((Long)object);
                }
                this.openCreateSummary((MultiValuedMap<Object, Object>)mapAllExist, listAllExist);
                break;
            }
        }
    }

    private SummarySchemaDTO initMaterialBaseUnitAndPurUnit(ListSelectedRowCollection selectedRow) {
        HashSet<Long> idset = new HashSet<Long>(selectedRow.size());
        HashSet<Long> entryIdSet = new HashSet<Long>(selectedRow.size());
        for (ListSelectedRow row : selectedRow) {
            Object primaryKeyValue = row.getPrimaryKeyValue();
            Object entryPrimaryKeyValue = row.getEntryPrimaryKeyValue();
            idset.add((Long)primaryKeyValue);
            entryIdSet.add((Long)entryPrimaryKeyValue);
        }
        QFilter entryqFilter = new QFilter("id", "in", idset);
        entryqFilter.and(new QFilter("billentry.id", "in", entryIdSet));
        entryqFilter.and(new QFilter("billentry.rowclosestatus", "in", (Object)"A"));
        entryqFilter.and(new QFilter("billentry.rowterminatestatus", "in", (Object)"A"));
        entryqFilter.and(new QFilter("billentry.baseqty", ">", (Object)"billentry.applybaseqty", true));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pm_requirapplybill", (String)"id,billentry.id,billentry.materialmasterid,billentry.materialmasterid.number", (QFilter[])entryqFilter.toArray());
        HashSet<Long> masteridset = new HashSet<Long>(rows.size());
        ArrayList<SummarySchemaDTO> listDTO = new ArrayList<SummarySchemaDTO>(rows.size());
        ArrayListValuedHashMap allMapExist = new ArrayListValuedHashMap(rows.size());
        for (DynamicObject row : rows) {
            Long masteridseq = row.getLong("billentry.id");
            Long masterid = row.getLong("billentry.materialmasterid");
            String masternumber = row.getString("billentry.materialmasterid.number");
            masteridset.add(masterid);
            listDTO.add(SummarySchemaDTO.initMasteridExistDTO((Long)masteridseq, (Long)masterid, (String)masternumber));
            allMapExist.put(row.get("id"), (Object)masteridseq);
        }
        QFilter masteridqFilter = new QFilter("masterid.id", "in", masteridset);
        DynamicObject currentOrg = (DynamicObject)this.getModel().getValue("org");
        Long defaultOrg = (Long)currentOrg.getPkValue();
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialpurchaseinfo", (Long)defaultOrg);
        QFilter endqFilter = masteridqFilter.and(baseDataFilter);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_materialpurchaseinfo", (String)"masterid.id,masterid.number", (QFilter[])endqFilter.toArray());
        for (DynamicObject dynamic : query) {
            long masterid = dynamic.getLong("masterid.id");
            masteridset.remove(masterid);
        }
        StringBuilder warnMsg = new StringBuilder();
        Iterator entry = listDTO.iterator();
        while (entry.hasNext()) {
            SummarySchemaDTO dto = (SummarySchemaDTO)entry.next();
            Long masterid = dto.getMasterid();
            if (masteridset.contains(masterid)) {
                String masternumber = dto.getMasternumber();
                warnMsg.append(ResManager.loadKDString((String)"\u7269\u6599\uff1a", (String)"RequireApplyQueryPlugin_7", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append("\u3010").append(masternumber).append("\u3011").append('\n');
                continue;
            }
            entry.remove();
        }
        SummarySchemaDTO initMasteridExist = SummarySchemaDTO.initMasteridExist((String)warnMsg.toString(), listDTO, (MultiValuedMap)allMapExist);
        return initMasteridExist;
    }

    protected void openConfirmDialog(String errorMsg) {
        IDataModel model = this.getModel();
        DynamicObject currentOrg = (DynamicObject)model.getValue("org");
        String orgName = currentOrg.getString("name");
        String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u9700\u6c42\u7533\u8bf7\u5355\u4e2d\u4ee5\u4e0b\u7269\u6599\u6ca1\u6709\u521b\u5efa\u3010\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u3011\uff0c\u6216\u8005\u3010\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u3011\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7\u3010%s\u3011\u4f7f\u7528\uff0c\u662f\u5426\u7ee7\u7eed\u6c47\u603b\uff1f", (String)"RequireApplyQueryPlugin_8", (String)"scm-pssc-formplugin", (Object[])new Object[0]), orgName);
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        ConfirmTypes confirmTypes = ConfirmTypes.Default;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener("createsummary", (IFormPlugin)this);
        this.getView().showConfirm(msg, errorMsg, options, confirmTypes, callBack);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"createsummary", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IPageCache pageCache = this.getPageCache();
            String listNoExistStr = pageCache.get("listNoExist");
            List listNoExist = (List)SerializationUtils.fromJsonString((String)listNoExistStr, List.class);
            String mapNoExistStr = pageCache.get("mapNoExist");
            Map mapNoExist = (Map)SerializationUtils.fromJsonString((String)mapNoExistStr, Map.class);
            this.openCreateSummary(mapNoExist, (List<Long>)listNoExist);
        }
    }

    private void openCreateSummary(Map<Long, List<Long>> mapNoExist, List<Long> entryprimarykey) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pm_needsummaryresult");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("org", org.getPkValue());
        if (mapNoExist != null) {
            fsp.setCustomParam("selectline", mapNoExist);
        }
        if (entryprimarykey != null) {
            fsp.setCustomParam("selectentryline", entryprimarykey);
        }
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creation"));
        this.getView().showForm(fsp);
    }

    private void openCreateSummary(MultiValuedMap<Object, Object> mapKey, List<Long> entryprimarykey) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pm_needsummaryresult");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("org", org.getPkValue());
        if (mapKey != null) {
            fsp.setCustomParam("selectline", (Object)mapKey.asMap());
        }
        if (entryprimarykey != null) {
            fsp.setCustomParam("selectentryline", entryprimarykey);
        }
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creation"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("creation")) {
            BillList billList = (BillList)this.getControl("billlistap");
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setFilter(this.initQueryParam());
            billList.setFilterParameter(filterParameter);
            billList.refresh();
            billList.clearSelection();
            Object returnData = closedCallBackEvent.getReturnData();
            log.info("\u91c7\u8d2d\u7533\u8bf7\u5355ID-->" + returnData);
            if (returnData instanceof List) {
                ListShowParameter lsp = new ListShowParameter();
                lsp.setBillFormId("pm_summaryapplybill");
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                QFilter qFilter = new QFilter("id", "in", returnData);
                ListFilterParameter lfp = new ListFilterParameter();
                lfp.setFilter(qFilter);
                lsp.setListFilterParameter(lfp);
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    private QFilter initQueryParam() {
        DynamicObject requireorg;
        DynamicObject dept;
        List<Object> projectItemIds;
        DynamicObject bizuser;
        List<Object> querymaterialIds;
        Date enddate;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        QFilter qFilter = null;
        qFilter = org != null ? new QFilter("bizorg", "in", org.getPkValue()) : new QFilter("bizorg", "in", null);
        DynamicObject billtype = (DynamicObject)model.getValue("billtype");
        if (billtype != null) {
            qFilter.and(new QFilter("billtype", "in", billtype.getPkValue()));
        } else {
            qFilter = new QFilter("billtype", "in", null);
        }
        Date startdate = (Date)model.getValue("applydate_startdate");
        if (startdate != null) {
            qFilter.and(new QFilter("biztime", ">=", (Object)startdate));
        }
        if ((enddate = (Date)model.getValue("applydate_enddate")) != null) {
            Date endOfDay = DateUtil.getEndOfDay((Date)enddate);
            qFilter.and(new QFilter("biztime", "<=", (Object)endOfDay));
        }
        if ((querymaterialIds = this.getMulBaseDataIds("querymaterial")) != null && !querymaterialIds.isEmpty()) {
            qFilter.and(new QFilter("billentry.materialmasterid", "in", querymaterialIds));
        }
        if ((bizuser = (DynamicObject)model.getValue("querybizuser")) != null) {
            qFilter.and(new QFilter("bizuser", "in", bizuser.getPkValue()));
        }
        if ((projectItemIds = this.getMulBaseDataIds("projectitem")) != null && !projectItemIds.isEmpty()) {
            qFilter.and(new QFilter("billentry.project", "in", projectItemIds));
        }
        if ((dept = (DynamicObject)model.getValue("querydept")) != null) {
            qFilter.and(new QFilter("dept", "in", dept.getPkValue()));
        }
        if ((requireorg = (DynamicObject)model.getValue("requireorg")) != null) {
            qFilter.and(new QFilter("org", "in", requireorg.getPkValue()));
        }
        qFilter.and(new QFilter("billstatus", "in", (Object)"C"));
        qFilter.and(new QFilter("closestatus", "in", (Object)"A"));
        qFilter.and(new QFilter("billentry.rowclosestatus", "in", (Object)"A"));
        qFilter.and(new QFilter("billentry.rowterminatestatus", "in", (Object)"A"));
        qFilter.and(new QFilter("billentry.baseqty", ">", (Object)"billentry.applybaseqty", true));
        qFilter.and(new QFilter("billentry.auditoption", "!=", (Object)"2"));
        String classType = (String)model.getValue("classtype");
        if (StringUtils.isNotBlank((CharSequence)classType)) {
            qFilter.and(new QFilter("billentry.classtype", "=", (Object)classType));
        }
        qFilter.and(new QFilter("billentry.materialmasterid.id", ">", (Object)0L));
        return qFilter;
    }

    public void beforeBindData(BeforeBindDataEvent paramBeforeBindDataEvent) {
        BillList param = (BillList)paramBeforeBindDataEvent.getSource();
        QFilter qFilter = this.initQueryParam();
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(qFilter);
        param.setFilterParameter(filterParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        BillList billList = (BillList)evt.getSource();
        Object focusRowPkId = billList.getFocusRowPkId();
        if (focusRowPkId != null) {
            Long billid = Long.valueOf(focusRowPkId.toString());
            this.showOneBillInfo("pm_requirapplybill", billid);
        }
    }

    private void showOneBillInfo(String entityid, Long billTypeID) {
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId(entityid);
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setPkId((Object)billTypeID);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private boolean isExistBotpRule() {
        List ruleElements = ConvertMetaServiceHelper.loadRules((String)"pm_requirapplybill", (String)"pm_purapplybill");
        if (ruleElements == null || ruleElements.isEmpty()) {
            return false;
        }
        int size = ruleElements.size();
        for (int i = 0; i < size; ++i) {
            ConvertRuleElement ruleElement = (ConvertRuleElement)ruleElements.get(i);
            if (!ruleElement.isEnabled() || !ruleElement.isVisibled()) continue;
            return true;
        }
        return false;
    }

    private List<Object> getMulBaseDataIds(String fieldKey) {
        DynamicObjectCollection baseDataCol = (DynamicObjectCollection)this.getModel().getValue(fieldKey);
        ArrayList<Object> baseDataIds = new ArrayList<Object>(16);
        if (baseDataCol != null && baseDataCol.size() > 0) {
            for (int i = 0; i < baseDataCol.size(); ++i) {
                DynamicObject baseData = (DynamicObject)baseDataCol.get(i);
                baseDataIds.add(((DynamicObject)baseData.get("fbasedataid")).getPkValue());
            }
        }
        return baseDataIds;
    }
}

