/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pssc.business.helper.AppParameterHelper;
import kd.scm.pssc.business.helper.PsscPackageGroupDefaultExecutor;
import kd.scm.pssc.business.pojo.PsscPackageGroupRuleInfo;
import kd.sdk.scm.pssc.packagegroup.IPsscPackageGroupPrepareExecutor;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscPackageGroupContext;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscTagGroupRuleOrderInfo;

public class PsscPackageGroupHelper {
    private static Log logger = LogFactory.getLog(PsscPackageGroupHelper.class);

    public static Map<Long, JSONObject> packageGroup(Map<Long, JSONObject> unDealTasks, long schemaId) {
        if (schemaId == 0L && !AppParameterHelper.isAutoPackage() || unDealTasks == null || unDealTasks.size() == 0) {
            return new HashMap<Long, JSONObject>();
        }
        PsscPackageGroupContext context = PsscPackageGroupContext.initContext(unDealTasks, (long)schemaId);
        if (context.getSchema() == null || context.getSchema().size() == 0) {
            return context.getDealTask();
        }
        context.loadPackageGroupInfo(PsscPackageGroupHelper.getTagGroupRulePlugin());
        PsscPackageGroupHelper.doPrepareData(context);
        try {
            PsscPackageGroupHelper.doMatch(context);
        }
        catch (Exception e) {
            logger.error("packageGroup error", (Object)e.getMessage());
        }
        return context.getDealTask();
    }

    private static void doPrepareData(PsscPackageGroupContext context) {
        PsscPackageGroupDefaultExecutor executor = new PsscPackageGroupDefaultExecutor();
        PluginProxy pluginProxy = PluginProxy.create((Object)executor, IPsscPackageGroupPrepareExecutor.class, (String)"SCM_PSSC_PACKAGEGROUP_PREEXECUTER", null);
        LinkedList executors = new LinkedList();
        executors.addAll(pluginProxy.getPlugins());
        for (IPsscPackageGroupPrepareExecutor plugin : executors) {
            plugin.prepareData(context);
        }
    }

    private static List<PsscTagGroupRuleOrderInfo> getTagGroupRulePlugin() {
        PsscPackageGroupRuleInfo defaultRule = new PsscPackageGroupRuleInfo();
        PluginProxy pluginProxy = PluginProxy.create((Object)((Object)defaultRule), PsscTagGroupRuleOrderInfo.class, (String)"SCM_PSSC_PACKAGEGROUP_RULEPLUGIN", null);
        ArrayList<PsscTagGroupRuleOrderInfo> plugins = new ArrayList<PsscTagGroupRuleOrderInfo>(1);
        plugins.addAll(pluginProxy.getPlugins());
        return plugins;
    }

    private static void doMatch(PsscPackageGroupContext context) throws Exception {
        Map unDealTask = context.getUnDealTask();
        Set entries = unDealTask.entrySet();
        for (Map.Entry next : entries) {
            TreeSet infos;
            JSONObject row = (JSONObject)next.getValue();
            Long handerId = row.getLong("hander");
            row.put("firstmatch", (Object)true);
            Map rules = context.getRules();
            if (rules == null || rules.size() == 0 || (infos = (TreeSet)context.getRules().get(handerId)) == null) continue;
            for (PsscTagGroupRuleOrderInfo info : infos) {
                Boolean firstMatch;
                JSONObject value = (JSONObject)next.getValue();
                if (value != null && (firstMatch = value.getBoolean("firstmatch")) != null && firstMatch.booleanValue()) {
                    value.put("tag", null);
                    value.put("firstmatch", (Object)false);
                }
                info.doMatch(context, next);
            }
        }
    }
}

