/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.BizCancelStatusEnum;
import kd.mpscmm.msbd.common.enums.BizCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scm.pssc.business.helper.AppParameterHelper;
import kd.scm.pssc.business.helper.BillQtyAndUnitHelper;
import kd.scm.pssc.business.helper.CurrencyHelper;

public class PurApplyBillHelper {
    private static final String ENTITYNAME = "msbd_puropermaterctrl";
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;

    private static void setDefaultHeadStatusAndDate(DynamicObject bill) {
        Date bizTime;
        String billStatus = bill.getString("billstatus");
        if (CommonUtils.isNull((Object)billStatus)) {
            bill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        }
        if (CommonUtils.isNull((Object)(bizTime = bill.getDate("biztime")))) {
            bill.set("biztime", (Object)new Date());
        }
        if (billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("auditor", null);
            bill.set("auditdate", null);
            bill.set("closer", null);
            bill.set("closedate", null);
            bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            bill.set("canceler", null);
            bill.set("canceldate", null);
            bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
            bill.set("changer", null);
            bill.set("changedate", null);
            bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
        } else {
            if (CommonUtils.isNull((Object)bill.getString("closestatus"))) {
                bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                bill.set("closer", null);
                bill.set("closedate", null);
            }
            if (CommonUtils.isNull((Object)bill.getString("cancelstatus"))) {
                bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
                bill.set("canceler", null);
                bill.set("canceldate", null);
            }
            if (CommonUtils.isNull((Object)bill.getString("changestatus"))) {
                bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
                bill.set("changer", null);
                bill.set("changedate", null);
            }
        }
    }

    public static void calcuAmount(DynamicObject bill) {
        BigDecimal totalAmountAndTax = BigDecimal.ZERO;
        boolean isTax = bill.getBoolean("istax");
        DynamicObject currency = bill.getDynamicObject("currency");
        int amountPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        int pricePrecision = 10;
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        HashSet<Object> taxRateIds = new HashSet<Object>(entrys.size());
        for (DynamicObject entry : entrys) {
            DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
            if (taxRateId == null) {
                DynamicObject master;
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || (master = material.getDynamicObject("masterid")) == null || master.getDynamicObject("taxrate") == null || (taxRateId = master.getDynamicObject("taxrate")) == null) continue;
                taxRateIds.add(taxRateId.getPkValue());
                entry.set("taxrateid_id", taxRateId.getPkValue());
                continue;
            }
            entry.set("taxrate", (Object)taxRateId.getBigDecimal("taxrate"));
        }
        Map taxRateMap = BusinessDataServiceHelper.loadFromCache((Object[])taxRateIds.toArray(new Object[0]), (String)"bd_taxrate");
        entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal price = entry.getBigDecimal("price");
            BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
            DynamicObject taxrate = (DynamicObject)taxRateMap.get(entry.get("taxrateid_id"));
            entry.set("taxrateid", (Object)taxrate);
            entry.set("taxrate", (Object)taxrate.getBigDecimal("taxrate"));
            if (qty == null) continue;
            Map<String, Object> amountMap = PurApplyBillHelper.getAmount(qty, isTax, price, priceAndTax, taxrate.getBigDecimal("taxrate"), amountPrecision, pricePrecision);
            BigDecimal amount = (BigDecimal)amountMap.get("amount");
            BigDecimal taxAmount = (BigDecimal)amountMap.get("taxamount");
            BigDecimal amountAndTax = (BigDecimal)amountMap.get("amountandtax");
            entry.set("price", amountMap.get("price"));
            entry.set("priceandtax", amountMap.get("priceandtax"));
            entry.set("amount", (Object)amount);
            entry.set("taxamount", (Object)taxAmount);
            entry.set("amountandtax", (Object)amountAndTax);
            totalAmountAndTax = totalAmountAndTax.add(amountAndTax);
        }
        bill.set("totalallamount", (Object)totalAmountAndTax);
    }

    public static List<DynamicObject> batchSetPurApplyDefValue(List<DynamicObject> bills) {
        if (CommonUtils.isNull(bills)) {
            return bills;
        }
        HashMap materFitOpeMap = new HashMap();
        HashMap<String, Boolean> orgIsUpApplyMap = new HashMap<String, Boolean>();
        long currentUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject currApplyer = BusinessDataServiceHelper.loadSingle((Object)currentUserId, (String)"bos_user");
        for (DynamicObject bill : bills) {
            DynamicObject material;
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject dept = bill.getDynamicObject("dept");
            DynamicObject applyer = bill.getDynamicObject("bizuser");
            if (applyer == null) {
                applyer = currApplyer;
                bill.set("bizuser", (Object)applyer);
            }
            if (dept == null && applyer != null) {
                dept = OrgHelper.getDefaultDepartmentObject((Long)((Long)applyer.getPkValue()));
                bill.set("dept", (Object)dept);
            }
            Long orgId = (Long)org.getPkValue();
            DynamicObject currency = bill.getDynamicObject("currency");
            if (currency == null) {
                currency = CurrencyHelper.getCurrency(orgId);
                bill.set("currency", (Object)currency);
            }
            int amountPrecision = currency == null ? 10 : currency.getInt("amtprecision");
            int pricePrecision = 10;
            boolean isTax = bill.getBoolean("istax");
            BigDecimal totalAmountAndTax = BigDecimal.ZERO;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            HashSet<Long> materialNumber = new HashSet<Long>(entrys.size());
            boolean isUpApply = false;
            String entityName = bill.getDataEntityType().getName();
            if (!entityName.equals("pm_purplanbill")) {
                if (orgIsUpApplyMap.containsKey(orgId + "Operator")) {
                    isUpApply = (Boolean)orgIsUpApplyMap.get(orgId + "Operator");
                } else {
                    Object isUpApplyObj = AppParameterHelper.getPmAppParameter(orgId, "purapplyfitoperator");
                    if (isUpApplyObj instanceof Boolean) {
                        isUpApply = (Boolean)isUpApplyObj;
                        orgIsUpApplyMap.put(orgId + "Operator", (Boolean)isUpApplyObj);
                    }
                }
                if (isUpApply) {
                    Map<Long, Map<String, Object>> operatorMap;
                    for (Object billEntry : entrys) {
                        material = billEntry.getDynamicObject("material");
                        material = material == null ? null : material.getDynamicObject("masterid");
                        if (material == null) continue;
                        String materialID = String.valueOf(material.getPkValue());
                        String OperatorKey = orgId + materialID;
                        if (materFitOpeMap.containsKey(OperatorKey)) continue;
                        materialNumber.add((Long)material.getPkValue());
                    }
                    if (materialNumber.size() > 0 && (operatorMap = PurApplyBillHelper.getMaterialFitOperatorNew(orgId, materialNumber)) != null && operatorMap.size() > 0) {
                        Object billEntry;
                        billEntry = operatorMap.entrySet().iterator();
                        while (billEntry.hasNext()) {
                            Map.Entry operatorMaps = (Map.Entry)billEntry.next();
                            materFitOpeMap.put(String.valueOf(orgId) + operatorMaps.getKey(), operatorMaps.getValue());
                        }
                    }
                }
            }
            for (DynamicObject entry : entrys) {
                material = entry.getDynamicObject("material");
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal applyQty = entry.getBigDecimal("applyqty");
                if (material != null) {
                    DynamicObject masterMaterial = entry.getDynamicObject("materialmasterid");
                    if (masterMaterial == null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                        entry.set("materialmasterid", (Object)masterMaterial);
                    }
                    DynamicObject masterIdObj = material.getDynamicObject("masterid");
                    if (isUpApply && masterIdObj != null && materFitOpeMap.size() > 0 && !entityName.equals("pm_purplanbill")) {
                        Map OpeAOpeGroupMap;
                        String masterId = String.valueOf(masterIdObj.getPkValue());
                        String OperatorKey = orgId + masterId;
                        DynamicObject entryoperator = entry.getDynamicObject("entryoperator");
                        DynamicObject entryoperatorgroup = entry.getDynamicObject("entryoperatorgroup");
                        if (entryoperator == null && entryoperatorgroup == null && (OpeAOpeGroupMap = (Map)materFitOpeMap.get(OperatorKey)) != null) {
                            entry.set("entryoperator_id", OpeAOpeGroupMap.get("operator"));
                            entry.set("entryoperatorgroup_id", OpeAOpeGroupMap.get("operatorgroup"));
                        }
                    }
                    DynamicObject unit = entry.getDynamicObject("unit");
                    DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                    BigDecimal baseQty = entry.getBigDecimal("baseqty");
                    if (unit == null && (unit = material.getDynamicObject("purchaseunit")) != null) {
                        entry.set("unit", (Object)unit);
                    }
                    if (!(unit == null || baseUnit == null || baseQty == null || masterMaterial == null || qty != null && BigDecimal.ZERO.compareTo(qty) != 0 || applyQty != null && BigDecimal.ZERO.compareTo(applyQty) != 0 || (qty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterMaterial.getPkValue(), baseUnit, baseQty, unit)) == null)) {
                        entry.set("qty", (Object)qty);
                        entry.set("applyqty", (Object)qty);
                    }
                }
                BigDecimal price = entry.getBigDecimal("price");
                BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                if (qty == null) continue;
                Map<String, Object> amountMap = PurApplyBillHelper.getAmount(qty, isTax, price, priceAndTax, taxRate, amountPrecision, pricePrecision);
                BigDecimal amount = (BigDecimal)amountMap.get("amount");
                BigDecimal taxAmount = (BigDecimal)amountMap.get("taxamount");
                BigDecimal amountAndTax = (BigDecimal)amountMap.get("amountandtax");
                entry.set("price", amountMap.get("price"));
                entry.set("priceandtax", amountMap.get("priceandtax"));
                entry.set("amount", (Object)amount);
                entry.set("taxamount", (Object)taxAmount);
                entry.set("amountandtax", (Object)amountAndTax);
                totalAmountAndTax = totalAmountAndTax.add(amountAndTax);
            }
            bill.set("totalallamount", (Object)totalAmountAndTax);
        }
        return bills;
    }

    private static Map<String, Object> getAmount(BigDecimal qty, boolean isTax, BigDecimal price, BigDecimal priceAndTax, BigDecimal taxRate, Integer settlePrecision, Integer pricePrecision) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal hundred = new BigDecimal("100");
        BigDecimal bigDecimal = taxRate = taxRate == null ? ZERO : taxRate.divide(hundred);
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), (int)pricePrecision, RoundingMode.HALF_UP);
                amountAndTax = qty.multiply(priceAndTax).setScale((int)settlePrecision, RoundingMode.HALF_UP);
                taxAmount = amountAndTax.divide(ONE.add(taxRate), (int)settlePrecision, RoundingMode.HALF_UP).multiply(taxRate).setScale((int)settlePrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale((int)settlePrecision, RoundingMode.HALF_UP);
            } else if (price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale((int)pricePrecision, RoundingMode.HALF_UP);
                amount = qty.multiply(price).setScale((int)settlePrecision, RoundingMode.HALF_UP);
                taxAmount = amount.multiply(taxRate).setScale((int)settlePrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount).setScale((int)settlePrecision, RoundingMode.HALF_UP);
            }
        }
        map.put("price", price);
        map.put("priceandtax", priceAndTax);
        map.put("amount", amount);
        map.put("taxamount", taxAmount);
        map.put("amountandtax", amountAndTax);
        return map;
    }

    @Deprecated
    public static Map<String, Map<String, Object>> getMaterialFitOperator(Long orgPkValue, Set<String> materialIDSet) {
        if (orgPkValue == null || materialIDSet == null || materialIDSet.size() == 0) {
            return null;
        }
        HashMap<String, Map<String, Object>> materFitOpeMap = new HashMap<String, Map<String, Object>>(materialIDSet.size());
        QFilter qFilter = new QFilter("controldimension", "=", (Object)"OPER_MATER");
        QFilter qFilterNumber = new QFilter("entryentity.material.masterid.number", "in", materialIDSet);
        QFilter qFilterOrg = new QFilter("org", "=", (Object)orgPkValue);
        QFilter qFilterControlType = new QFilter("controltype", "=", (Object)"ALLOW");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        Map pur0perMaters = BusinessDataServiceHelper.loadFromCache((String)ENTITYNAME, (String)"id,org,entryentity.seq,entryentity.material,entryentity.operator,entryentity.operatorgroup", (QFilter[])new QFilter[]{qFilter.and(qFilterOrg).and(qFilterEnable).and(qFilterStatus).and(qFilterControlType).and(qFilterNumber)}, (String)"audittime");
        if (!pur0perMaters.isEmpty()) {
            return materFitOpeMap;
        }
        for (DynamicObject dynamicObject : pur0perMaters.values()) {
            DynamicObjectCollection entryEntity;
            DynamicObject orgObj;
            if (dynamicObject == null || (orgObj = dynamicObject.getDynamicObject("org")) == null || !orgObj.getPkValue().equals(orgPkValue) || (entryEntity = dynamicObject.getDynamicObjectCollection("entryentity")) == null) continue;
            for (int j = entryEntity.size() - 1; j >= 0; --j) {
                String materialIDNum;
                DynamicObject operatorGroup;
                DynamicObject operator;
                DynamicObject entryObj = (DynamicObject)entryEntity.get(j);
                DynamicObject material = entryObj.getDynamicObject("material");
                if (material == null || material.get("masterid") == null || (operator = entryObj.getDynamicObject("operator")) == null) continue;
                Object pkValue1 = operator.getPkValue();
                boolean invalid = operator.getBoolean("invalid");
                if (invalid || (operatorGroup = entryObj.getDynamicObject("operatorgroup")) == null || operatorGroup.get("enable").equals("0")) continue;
                DynamicObjectCollection dynamicObjectCollection = operatorGroup.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : dynamicObjectCollection) {
                    Object pkValue = object.getPkValue();
                    if (!pkValue1.equals(pkValue)) continue;
                    invalid = object.getBoolean("invalid");
                    break;
                }
                if (invalid || materFitOpeMap.containsKey(materialIDNum = (String)material.get("masterid.number"))) continue;
                HashMap<String, Object> OpeAOpeGroupMap = new HashMap<String, Object>(2);
                if (!materialIDSet.contains(materialIDNum)) continue;
                OpeAOpeGroupMap.put("operator", operator.getPkValue());
                OpeAOpeGroupMap.put("operatorgroup", operatorGroup.getPkValue());
                materFitOpeMap.put(materialIDNum, OpeAOpeGroupMap);
            }
        }
        return materFitOpeMap;
    }

    public static Map<Long, Map<String, Object>> getMaterialFitOperatorNew(Long orgPkValue, Set<Long> materialIDSet) {
        if (orgPkValue == null || materialIDSet == null || materialIDSet.size() == 0) {
            return null;
        }
        HashMap<Long, Map<String, Object>> materFitOpeMap = new HashMap<Long, Map<String, Object>>(materialIDSet.size());
        QFilter qFilter = new QFilter("controldimension", "=", (Object)"OPER_MATER");
        QFilter qFilterNumber = new QFilter("entryentity.material.masterid", "in", materialIDSet);
        QFilter qFilterOrg = new QFilter("org", "=", (Object)orgPkValue);
        QFilter qFilterControlType = new QFilter("controltype", "=", (Object)"ALLOW");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter operatorgroup = new QFilter("entryentity.operatorgroup.enable", "!=", (Object)"0");
        QFilter operator = new QFilter("entryentity.operator.invalid", "!=", (Object)Boolean.TRUE);
        DynamicObjectCollection pur0perMaters = QueryServiceHelper.query((String)ENTITYNAME, (String)"id,org,entryentity.seq,entryentity.material.masterid,entryentity.operator,entryentity.operatorgroup", (QFilter[])new QFilter[]{qFilter.and(qFilterOrg).and(qFilterEnable).and(qFilterStatus).and(qFilterControlType).and(qFilterNumber).and(operatorgroup).and(operator)}, (String)"audittime");
        if (pur0perMaters == null || pur0perMaters.size() == 0) {
            return materFitOpeMap;
        }
        for (int j = pur0perMaters.size() - 1; j >= 0; --j) {
            Long orgID;
            DynamicObject dynamicObject = (DynamicObject)pur0perMaters.get(j);
            if (dynamicObject == null || !(orgID = Long.valueOf(dynamicObject.getLong("org"))).equals(orgPkValue)) continue;
            Long materialID = dynamicObject.getLong("entryentity.material.masterid");
            Long operatorID = dynamicObject.getLong("entryentity.operator");
            Long operatorGroupID = dynamicObject.getLong("entryentity.operatorgroup");
            if (materFitOpeMap.containsKey(materialID)) continue;
            HashMap<String, Long> OpeAOpeGroupMap = new HashMap<String, Long>(2);
            if (!materialIDSet.contains(materialID)) continue;
            OpeAOpeGroupMap.put("operator", operatorID);
            OpeAOpeGroupMap.put("operatorgroup", operatorGroupID);
            materFitOpeMap.put(materialID, OpeAOpeGroupMap);
        }
        return materFitOpeMap;
    }
}

