/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.pssc.business.helper.BillQtyAndUnitHelper;

public class ReqApplyBillHelper {
    private static final Log log = LogFactory.getLog(ReqApplyBillHelper.class);

    public static void batchSetUnMaterialTag(List<DynamicObject> reqEntryList) {
        for (DynamicObject entryRow : reqEntryList) {
            ReqApplyBillHelper.setUnMaterialTag(entryRow);
        }
    }

    public static void setUnMaterialTag(DynamicObject entryRow) {
        long materialId = entryRow.getLong("materialmasterid_id");
        if (materialId == 0L) {
            entryRow.set("unmaterialtag", (Object)DBServiceHelper.genGlobalLongId());
        } else {
            entryRow.set("unmaterialtag", (Object)0L);
        }
    }

    public static void calSumReqApplyLogical(List<DynamicObject> reqList) {
        for (DynamicObject reqApplyBill : reqList) {
            DynamicObjectCollection billEntry = reqApplyBill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                DynamicObject materialMaster = row.getDynamicObject("materialmasterid");
                DynamicObject unit = row.getDynamicObject("unit");
                DynamicObject baseUnit = null;
                if (materialMaster == null && unit == null) continue;
                baseUnit = row.getDynamicObject("baseunit");
                if (baseUnit == null) {
                    if (materialMaster != null) {
                        baseUnit = materialMaster.getDynamicObject("baseunit");
                    }
                    if (baseUnit != null) {
                        row.set("baseunit", (Object)baseUnit);
                    }
                }
                if (baseUnit == null) continue;
                BigDecimal baseQty = row.getBigDecimal("baseqty");
                row.set("unit", (Object)baseUnit);
                row.set("qty", (Object)baseQty);
            }
        }
    }

    public static void calDefaultReqApplyLogical(List<DynamicObject> reqList) {
        for (DynamicObject reqApplyBill : reqList) {
            DynamicObjectCollection billEntry = reqApplyBill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                DynamicObject materialMaster = row.getDynamicObject("materialmasterid");
                DynamicObject unit = row.getDynamicObject("unit");
                if (unit == null) continue;
                DynamicObject baseUnit = row.getDynamicObject("baseunit");
                if (baseUnit == null && materialMaster != null && (baseUnit = materialMaster.getDynamicObject("baseunit")) != null) {
                    row.set("baseunit", (Object)baseUnit);
                }
                if (baseUnit == null) continue;
                BigDecimal baseQty = row.getBigDecimal("baseqty");
                if (materialMaster == null) {
                    row.set("qty", (Object)baseQty);
                    continue;
                }
                Long materialMasterId = (Long)materialMaster.getPkValue();
                BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv(materialMasterId, baseUnit, baseQty, unit);
                row.set("qty", (Object)qty);
            }
        }
    }

    public static void addBillTypeFilter(String entityId, List<QFilter> qFilters) {
        if (qFilters == null) {
            return;
        }
        switch (entityId) {
            case "pssc_requirapplyyearbill": {
                qFilters.add(new QFilter("id", "=", (Object)1868906308766414848L));
                break;
            }
            case "pssc_requirapplymonthbill": {
                qFilters.add(new QFilter("id", "=", (Object)1868906708617803776L));
                break;
            }
            default: {
                qFilters.add(new QFilter("id", "not in", (Object)new Long[]{1868906308766414848L, 1868906708617803776L}));
            }
        }
    }

    public static long getReqBillType(String entityId) {
        if (entityId == null) {
            return 0L;
        }
        switch (entityId) {
            case "pssc_requirapplyyearbill": {
                return 1868906308766414848L;
            }
            case "pssc_requirapplymonthbill": {
                return 1868906708617803776L;
            }
        }
        return 0L;
    }

    public static String getReqBillTypeEntity(long billTypeId) {
        if (billTypeId == 1868906308766414848L) {
            return "pssc_requirapplyyearbill";
        }
        if (billTypeId == 1868906708617803776L) {
            return "pssc_requirapplymonthbill";
        }
        return "";
    }

    public static String getReqBillName(String billTypeForm) {
        if (billTypeForm == null) {
            return "";
        }
        switch (billTypeForm) {
            case "pssc_requirapplyyearbill": {
                return ResManager.loadKDString((String)"\u5e74\u5ea6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyBillHelper_3", (String)"scm-pssc-business", (Object[])new Object[0]);
            }
            case "pssc_requirapplymonthbill": {
                return ResManager.loadKDString((String)"\u6708\u5ea6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyBillHelper_4", (String)"scm-pssc-business", (Object[])new Object[0]);
            }
            case "pssc_requirapplyotherbill": {
                return ResManager.loadKDString((String)"\u5176\u4ed6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyBillHelper_5", (String)"scm-pssc-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static Map<String, Map<String, Object>> getEBPurOrgData(List<Map<String, Object>> inParameterList, String entityKey) {
        Boolean success;
        log.info("\u8c03\u7528\u96c6\u91c7\u76ee\u5f55\u7684\u91c7\u8d2d\u7ec4\u7ec7\u670d\u52a1\u5165\u53c2parameter1:{}\uff0cparameter2:{}", (Object)SerializationUtils.toJsonString(inParameterList), (Object)entityKey);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"batchGetPurChaseOrg", (Object[])new Object[]{inParameterList, entityKey});
        log.info("\u8c03\u7528\u96c6\u91c7\u76ee\u5f55\u7684\u91c7\u8d2d\u7ec4\u7ec7\u670d\u52a1\u51fa\u53c2\u7ed3\u679c:{}", (Object)SerializationUtils.toJsonString((Object)result));
        Map data = null;
        if (result != null && (success = (Boolean)result.get("success")) == Boolean.TRUE) {
            data = (Map)result.get("data");
        }
        return data;
    }

    public static DynamicObject getEBPurOrg(Map<String, Map<String, Object>> data, Long orgId, String reqKind, Long materialMasterId, DynamicObject row) {
        DynamicObject purOrg = null;
        String uniqueKey = orgId + "-" + materialMasterId;
        if ("A".equals(reqKind)) {
            uniqueKey = uniqueKey + "-2-2";
        } else if ("B".equals(reqKind)) {
            uniqueKey = uniqueKey + "-3-2";
        }
        if (data != null) {
            Map<String, Object> resultMap = data.get(uniqueKey);
            if (resultMap != null) {
                String classType = (String)resultMap.get("classtype");
                if (StringUtils.isNotBlank((CharSequence)classType)) {
                    row.set("classtype", (Object)classType);
                    Long purOrgId = (Long)resultMap.get("orgId");
                    if (purOrgId != null) {
                        purOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)purOrgId, (String)"bos_org");
                    }
                } else {
                    row.set("classtype", (Object)"2");
                }
            } else {
                row.set("classtype", (Object)"2");
            }
        }
        return purOrg;
    }

    public static boolean getKindParameter() {
        try {
            Boolean flag = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mcm", (String)"IMcmService", (String)"isMcmServiceOn", (Object[])new Object[0]);
            if (flag != null) {
                return flag;
            }
            return false;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }
}

