/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.InvoiceBiztypeHelper;
import kd.mpscmm.msbd.common.utils.MetadataUtils;
import kd.scm.pssc.common.enums.SupplierFunction;

public class SupplierHelper {
    public static final String BIZ_FUNCTION_KEY = "bizfunction";
    public static final String PURCHASE_HOLD = "purchasehold";
    public static final String INVOICE_HOLD = "invoicehold";
    public static final String PAY_HOLD = "payhold";
    public static final String DELIVER_SUPPLIER_KEY = "deliversupplierid";
    public static final String INVOICE_SUPPLIER_KEY = "invoicesupplierid";
    public static final String RECEIVING_SUPPLIER_KEY = "receivingsupplierid";
    public static final String SETTLE_CURRENCY_KEY = "settlementcyid";

    public static String getDefaultAddressString(DynamicObject supplier) {
        ILocaleString defaultAddress = SupplierHelper.getDefaultAddressLocaleString(supplier);
        if (defaultAddress != null) {
            return defaultAddress.toString();
        }
        return null;
    }

    public static ILocaleString getDefaultAddressLocaleString(DynamicObject supplier) {
        return SupplierHelper.getDetailAddress(SupplierHelper.getDefaultAddressObj(supplier));
    }

    public static DynamicObject getDefaultAddress(DynamicObject supplier, String selectProperties) {
        QFilter invalid;
        QFilter supplierId;
        DynamicObject[] load;
        if (supplier != null && StringUtils.isNotBlank((Object)supplier.getPkValue()) && (load = BusinessDataServiceHelper.load((String)"bd_address", (String)selectProperties, (QFilter[])new QFilter[]{supplierId = new QFilter("supplierid", "=", (Object)supplier.getPkValue().toString()), invalid = new QFilter("invalid", "=", (Object)Boolean.FALSE)}, (String)"default desc", (int)1)) != null && load.length > 0) {
            return load[0];
        }
        return null;
    }

    public static DynamicObject getDefaultAddressObj(DynamicObject supplier) {
        return SupplierHelper.getDefaultAddress(supplier, "id,default,invalid,detailaddress");
    }

    public static DynamicObject getDefaultLinkManObj(DynamicObject supplier) {
        Long defaultLinkManId = SupplierHelper.getDefaultLinkManId(supplier);
        if (defaultLinkManId == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)defaultLinkManId, (String)"bd_supplierlinkman");
    }

    public static Long getDefaultLinkManId(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        Long defaultLinkManId = null;
        DynamicObjectCollection linkmans = supplier.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return (Long)linkman.getPkValue();
            }
            if (defaultLinkManId != null || invalid) continue;
            defaultLinkManId = (Long)linkman.getPkValue();
        }
        return defaultLinkManId;
    }

    public static Long getDefaultSettleTypeId(DynamicObject supplier) {
        DynamicObject settleType = SupplierHelper.getDefaultSettleTypeObj(supplier);
        if (settleType == null) {
            return null;
        }
        return (Long)settleType.getPkValue();
    }

    public static DynamicObject getDefaultSettleTypeObj(DynamicObject supplier) {
        DynamicObject settleType;
        if (supplier != null && (settleType = supplier.getDynamicObject("settlementtypeid")) != null) {
            return settleType;
        }
        QFilter isDefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isEnable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isDefault.and(isEnable);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id,isdefault,enable", (QFilter[])filter.toArray());
    }

    private static DynamicObject getDefaultReceiveSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(RECEIVING_SUPPLIER_KEY);
    }

    private static DynamicObject getDefaultInvoiceSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(INVOICE_SUPPLIER_KEY);
    }

    private static DynamicObject getDefaultDeliverSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(DELIVER_SUPPLIER_KEY);
    }

    public static ILocaleString getDetailAddress(DynamicObject address) {
        if (address == null) {
            return null;
        }
        return address.getLocaleString("detailaddress");
    }

    public static DynamicObject getOtherSupplier(DynamicObject supplier, String otherSupplierKey) {
        if (otherSupplierKey == null) {
            return null;
        }
        switch (otherSupplierKey) {
            case "deliversupplierid": {
                return SupplierHelper.getDefaultDeliverSupplier(supplier);
            }
            case "invoicesupplierid": {
                return SupplierHelper.getDefaultInvoiceSupplier(supplier);
            }
            case "receivingsupplierid": {
                return SupplierHelper.getDefaultReceiveSupplier(supplier);
            }
        }
        return null;
    }

    public static QFilter getPurchaseFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.PURCHASE.getValue());
    }

    public static boolean validBizFunction(DynamicObject supplier, SupplierFunction function) {
        String bizFunction;
        if (supplier == null) {
            return false;
        }
        if (!MetadataUtils.checkProperty((DynamicObject)supplier, (String)BIZ_FUNCTION_KEY)) {
            supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,bizfunction");
        }
        if ((bizFunction = SupplierHelper.getBizFunction(supplier)) == null) {
            return false;
        }
        return function != null && bizFunction.contains(function.getValue());
    }

    private static String getBizFunction(DynamicObject supplier) {
        return supplier.getString(BIZ_FUNCTION_KEY);
    }

    public static Long getDefaultSettleType(DynamicObject supplier) {
        return SupplierHelper.getDefaultSettleTypeId(supplier);
    }

    @Deprecated
    public static Long getOtherSupplier(DynamicObject supplier, String otherSupplierKey, String fieldKey) {
        if (supplier == null) {
            return null;
        }
        DynamicObject otherSupplier = supplier.getDynamicObject(otherSupplierKey);
        if (otherSupplier != null) {
            return (Long)otherSupplier.getPkValue();
        }
        String bizfunction = supplier.getString(BIZ_FUNCTION_KEY);
        if (StringUtils.isBlank((CharSequence)bizfunction)) {
            return null;
        }
        switch (otherSupplierKey) {
            case "deliversupplierid": {
                if (!supplier.getBoolean(PURCHASE_HOLD) && bizfunction.contains("1")) break;
                return null;
            }
            case "invoicesupplierid": {
                if (!supplier.getBoolean(INVOICE_HOLD) && bizfunction.contains("2")) break;
                return null;
            }
            case "receivingsupplierid": {
                if (!supplier.getBoolean(PAY_HOLD) && bizfunction.contains("3")) break;
                return null;
            }
        }
        return (Long)supplier.getPkValue();
    }

    public static QFilter getBizfunctionAndHoldFilter(String fieldKey) {
        if (fieldKey.equals("providersupplier") || fieldKey.equals("supplier")) {
            QFilter purchasehold = new QFilter(PURCHASE_HOLD, "=", (Object)Boolean.FALSE);
            QFilter bizfunction = QFilter.like((String)BIZ_FUNCTION_KEY, (String)"1");
            return purchasehold.and(bizfunction);
        }
        if (fieldKey.equals("invoicesupplier")) {
            QFilter invoicehold = new QFilter(INVOICE_HOLD, "=", (Object)Boolean.FALSE);
            QFilter bizfunction = QFilter.like((String)BIZ_FUNCTION_KEY, (String)"2");
            return invoicehold.and(bizfunction);
        }
        if (fieldKey.equals("receivesupplier")) {
            QFilter payhold = new QFilter(PAY_HOLD, "=", (Object)Boolean.FALSE);
            QFilter bizfunction = QFilter.like((String)BIZ_FUNCTION_KEY, (String)"3");
            return payhold.and(bizfunction);
        }
        return null;
    }

    public static DynamicObject getInvoiceType(DynamicObject supplier, String appNmuber) {
        if (supplier != null) {
            Object invoicetype = supplier.get("invoicecategory");
            Long invoicetypeId = 0L;
            if (invoicetype != null) {
                invoicetypeId = (Long)((DynamicObject)invoicetype).getPkValue();
            }
            return InvoiceBiztypeHelper.getInvoiceBizType((Long)invoicetypeId, (String)appNmuber);
        }
        return null;
    }
}

