/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper.taskapprove;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pssc.business.helper.taskapprove.IPsscTaskApproveHandler;
import kd.scm.pssc.common.enums.HandleStatusEnums;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.log.PsscHandleLogService;

public class PsscAllocateHandler
implements IPsscTaskApproveHandler {
    private PsscHandleLogService logservice = new PsscHandleLogService();

    @Override
    public void handler(ArrayList<DynamicObject> needSyncDataTasks, ArrayList<DynamicObject> needSendMsgTasks, List<HandleLogEntity> logEntityList, DynamicObject task, DynamicObject approveInfo) {
        needSyncDataTasks.add(task);
        needSendMsgTasks.add(task);
        task.set("sourceorg", (Object)approveInfo.getLong("newsourceorg.id"));
        task.set("opinion", (Object)approveInfo.getString("opinion"));
        task.set("purgroup", (Object)approveInfo.getLong("newpurgroup.id"));
        DynamicObject newhandler = approveInfo.getDynamicObject("newhandler");
        if (newhandler != null) {
            task.set("handler", (Object)newhandler.getLong("id"));
            task.set("handleuser", (Object)newhandler.getLong("operatorid.id"));
        }
        String handlestatus = task.getString("handlestatus");
        if (HandleStatusEnums.TOALLOCATE.getValue().equals(handlestatus)) {
            task.set("handlestatus", (Object)HandleStatusEnums.PROCESSING);
        }
        this.dealAllocateLog(logEntityList, task, approveInfo, newhandler);
    }

    private void dealAllocateLog(List<HandleLogEntity> logEntityList, DynamicObject task, DynamicObject dynamicObject, DynamicObject newhandler) {
        String remark = this.getAllocateRemark(newhandler);
        String detail = this.getOptionLogDetail(dynamicObject);
        HandleLogEntity allocatelogEntity = PsscHandleLogHelper.getLogInfo((String)remark, (String)detail);
        this.logservice.updateLogInfo(allocatelogEntity, "allocate", task, "pssc_taskmanage");
        logEntityList.add(allocatelogEntity);
    }

    private String getAllocateRemark(DynamicObject handler) {
        return String.format(ResManager.loadKDString((String)"%1$s \u5206\u914d\u7ed9 %2$s", (String)"PsscAllocateHandler_0", (String)"scm-pssc-business", (Object[])new Object[0]), RequestContext.get().getUserName(), handler == null ? "" : handler.getString("operatorname"));
    }
}

