/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.comptpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.common.util.cal.CalImpl;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.pssc.common.utils.PsscExchangeRateUtils;

public class PsscCalImpl
extends CalImpl {
    public void calByEntryTaxAmountChange(IDataModel datamodel, String entryKey) {
        this.calEntryTaxPriceByTaxAmount(datamodel, entryKey);
        this.calEntryPriceByTaxPrice(datamodel, entryKey);
        this.calEntryDiscountRate(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        this.calEntryTax(datamodel, entryKey);
        this.calEntryAmount(datamodel, entryKey);
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    public void proChanged(IDataModel datamodel, String entryKey, String propertyName) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        if (index < 0) {
            this.calSum(datamodel, entryKey);
        } else {
            super.proChanged(datamodel, entryKey, propertyName);
            if ("price_uom".equals(propertyName) || "entrycurrency".equals(propertyName)) {
                this.needChange(false);
                this.calByEntryQtyChange(datamodel, entryKey);
                this.needChange(true);
            }
            if (this.isCalLocalEntryData(propertyName)) {
                this.needChange(false);
                this.calcLocalPriceAndAmount(datamodel, entryKey);
                this.needChange(true);
            }
        }
    }

    public void calByEntryQtyChange(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        boolean containTax = this.isContainTax(taxType);
        if (containTax) {
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
        } else {
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
        }
        this.calSum(datamodel, entryKey);
    }

    public void calEntryTaxAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        boolean containTax = this.isContainTax(taxType);
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxAmount = BigDecimal.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (containTax) {
            BigDecimal price_uom;
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
            BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.getTAXPRICE());
            BigDecimal discount = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTAMOUNT());
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)discount, (int)scale);
            Object price_uomObj = this.getEntryObject(datamodel, index, "price_uom");
            BigDecimal bigDecimal = price_uom = null == price_uomObj ? BigDecimal.ZERO : new BigDecimal(String.valueOf(price_uomObj));
            if (price_uom.compareTo(BigDecimal.ZERO) > 0) {
                taxAmount = taxAmount.divide(price_uom, scale, RoundingMode.HALF_UP);
            }
        } else {
            BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.getAMOUNT());
            BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.getTAX());
            taxAmount = CalculateUtils.calTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
        }
        datamodel.setValue(this.getTAXAMOUNT(), (Object)taxAmount, index);
    }

    public void calEntryAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        boolean containTax = this.isContainTax(taxType);
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal amount = BigDecimal.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (containTax) {
            BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, this.getTAXAMOUNT());
            BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.getTAX());
            amount = CalculateUtils.calAmountInTax((BigDecimal)taxAmount, (BigDecimal)tax, (int)scale);
        } else {
            BigDecimal price_uom;
            BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
            BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, this.getPRICE());
            amount = CalculateUtils.calAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)price, (BigDecimal)discountRate, (int)scale);
            Object price_uomObj = this.getEntryObject(datamodel, index, "price_uom");
            BigDecimal bigDecimal = price_uom = null == price_uomObj ? BigDecimal.ZERO : new BigDecimal(String.valueOf(price_uomObj));
            if (price_uom.compareTo(BigDecimal.ZERO) > 0) {
                amount = amount.divide(price_uom, scale, RoundingMode.HALF_UP);
            }
        }
        datamodel.setValue(this.getAMOUNT(), (Object)amount, index);
    }

    protected int getAmtPrecision(IDataModel datamodel, String entryKey) {
        int amtPrecision = 6;
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        Object currency = datamodel.getValue("currency", index);
        if (currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            amtPrecision = curr.getInt("amtprecision");
        }
        return amtPrecision;
    }

    protected int getPricePrecision(IDataModel datamodel, String entryKey) {
        int pricePrecision = 6;
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        Object currency = datamodel.getValue("currency", index);
        if (currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            pricePrecision = curr.getInt("priceprecision");
        }
        return pricePrecision;
    }

    public boolean isCalLocalEntryData(String pro) {
        boolean isCalLocal = false;
        if (this.getPRICE().equals(pro) || this.getTAXPRICE().equals(pro) || this.getAMOUNT().equals(pro) || this.getTAXAMOUNT().equals(pro) || "exrate".equals(pro)) {
            isCalLocal = true;
        }
        return isCalLocal;
    }

    public void calcLocalPriceAndAmount(IDataModel datamodel, String entryKey) {
        DynamicObject billObj = datamodel.getDataEntity();
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        DynamicObject entryObj = datamodel.getEntryRowEntity(entryKey, index);
        datamodel.setValue("locprice", (Object)PsscExchangeRateUtils.calcLocalValue(billObj, entryObj, "price", "priceprecision"), index);
        datamodel.setValue("loctaxprice", (Object)PsscExchangeRateUtils.calcLocalValue(billObj, entryObj, "taxprice", "priceprecision"), index);
        datamodel.setValue("loctax", (Object)PsscExchangeRateUtils.calcLocalValue(billObj, entryObj, "tax", "priceprecision"), index);
        datamodel.setValue("locamount", (Object)PsscExchangeRateUtils.calcLocalValue(billObj, entryObj, "amount", "priceprecision"), index);
        datamodel.setValue("loctaxamount", (Object)PsscExchangeRateUtils.calcLocalValue(billObj, entryObj, "taxamount", "priceprecision"), index);
        this.calLocalSum(datamodel, entryKey);
    }

    protected void calSum(IDataModel datamodel, String entryKey) {
        super.calSum(datamodel, entryKey);
        this.calLocalSum(datamodel, entryKey);
    }

    public void calLocalSum(IDataModel datamodel, String entryKey) {
        BigDecimal sumLocalAmount = BigDecimal.ZERO;
        BigDecimal sumLocalTaxAmount = BigDecimal.ZERO;
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            sumLocalAmount = sumLocalAmount.add(entry.getBigDecimal("locamount"));
            sumLocalTaxAmount = sumLocalTaxAmount.add(entry.getBigDecimal("loctaxamount"));
        }
        datamodel.setValue("sumlocamount", (Object)sumLocalAmount);
        datamodel.setValue("sumloctaxamount", (Object)sumLocalTaxAmount);
    }
}

