/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.helper.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pssc.common.helper.status.manager.StatusManager;
import kd.scm.pssc.common.utils.PsscParamUtil;

public class PsscStatusConvertHelper {
    public static void calculateMyTaskStatus(Set<String> srcentryidSet) {
        StatusManager manager = new StatusManager(srcentryidSet);
        manager.calcStatusForTask();
        manager.persisTask();
    }

    public static HashSet<String> getRelationEntryIdList(DynamicObjectCollection orders) {
        DynamicObjectCollection relations = PsscStatusConvertHelper.getRelationInfo(orders);
        HashSet<String> srcEntryIdSet = new HashSet<String>();
        for (DynamicObject relation : relations) {
            srcEntryIdSet.add(relation.getString("ordersrcentryid"));
        }
        return srcEntryIdSet;
    }

    public static DynamicObjectCollection getRelationInfo(DynamicObjectCollection orders) {
        ArrayList<String> orderidList = new ArrayList<String>();
        for (DynamicObject order : orders) {
            orderidList.add(order.getString("id"));
        }
        QFilter filter = new QFilter("orderid", "in", orderidList);
        return QueryServiceHelper.query((String)"pssc_order_relation", (String)"orderid, ordersrcentryid", (QFilter[])filter.toArray());
    }

    public static void removeRelationInfo(List<String> orderIds) {
        if (orderIds != null && orderIds.size() > 0) {
            QFilter filter = new QFilter("orderid", "in", orderIds);
            DeleteServiceHelper.delete((String)"pssc_order_relation", (QFilter[])filter.toArray());
        }
    }

    public static void changeStatusWhenDelete(List<String> businesskeys, String variables) {
        Map variableMap = (Map)SerializationUtils.fromJsonString((String)variables, Map.class);
        if (variableMap != null) {
            String idreqidMapJson = (String)variableMap.get("reqids");
            String reqorgsJson = (String)variableMap.get("reqorgs");
            Map idreqidMap = new HashMap();
            Map idorgmap = new HashMap();
            if (idreqidMapJson != null && !idreqidMapJson.isEmpty()) {
                idreqidMap = (Map)SerializationUtils.fromJsonString((String)idreqidMapJson, Map.class);
            }
            if (idreqidMapJson != null && !idreqidMapJson.isEmpty()) {
                idorgmap = (Map)SerializationUtils.fromJsonString((String)reqorgsJson, Map.class);
            }
            if (idreqidMap.size() > 0 && idorgmap.size() > 0) {
                HashSet<String> orgSet = new HashSet<String>();
                for (Map.Entry idorgentry : idorgmap.entrySet()) {
                    orgSet.add((String)idorgentry.getValue());
                }
                Map<String, String> poolEnableMap = PsscParamUtil.ifTaskPoolEnable(orgSet);
                Map finalIdorgmap = idorgmap;
                businesskeys.removeIf(id -> "false".equals(poolEnableMap.get(finalIdorgmap.get(id))));
                HashSet<String> reqIdSet = new HashSet<String>();
                for (String businesskey : businesskeys) {
                    reqIdSet.addAll((Collection)idreqidMap.get(businesskey));
                }
                PsscStatusConvertHelper.calculateMyTaskStatus(reqIdSet);
            }
        }
    }
}

