/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.helper.status.manager;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pssc.common.enums.HandleStatusEnums;
import kd.scm.pssc.common.helper.status.manager.AbstractStatusCalculatetor;
import kd.scm.pssc.common.helper.status.manager.StatusManager;

public class PsscOrderStatusCalculatetor
extends AbstractStatusCalculatetor {
    private boolean queryOrder = true;

    @Override
    protected void calcStatus(Map<String, HandleStatusEnums> statusMap, Set<String> applyentryIds) {
        List<Long> applyentryids = applyentryIds.stream().map(Long::parseLong).collect(Collectors.toList());
        HashSet<String> orderSet = this.queryOrder ? StatusManager.getordeSet(applyentryids) : null;
        QFilter applyfilter = new QFilter("billentry.id", "in", applyentryids);
        DynamicObjectCollection purapplybill = QueryServiceHelper.query((String)"pm_purapplybill", (String)"billentry.id entryid, billentry.joinqty joinqty, billentry.qty qty,billentry.rowterminatestatus rowterminatestatus", (QFilter[])applyfilter.toArray());
        HashMap<String, DynamicObject> applyinfoMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject applybill : purapplybill) {
            String entryid = applybill.getString("entryid");
            applyinfoMap.put(entryid, applybill);
        }
        Iterator<String> iterator = applyentryIds.iterator();
        while (iterator.hasNext()) {
            BigDecimal qty;
            String entryid = iterator.next();
            DynamicObject applybill = (DynamicObject)applyinfoMap.get(entryid);
            if (applybill == null) {
                statusMap.put(entryid, null);
                iterator.remove();
                continue;
            }
            if (orderSet != null && !orderSet.contains(entryid)) continue;
            String rowterminatestatus = applybill.getString("rowterminatestatus");
            if ("B".equals(rowterminatestatus)) {
                statusMap.put(entryid, HandleStatusEnums.TERMINATED);
                iterator.remove();
                continue;
            }
            BigDecimal joinQty = applybill.getBigDecimal("joinqty");
            if (joinQty.compareTo(qty = applybill.getBigDecimal("qty")) >= 0) {
                statusMap.put(entryid, HandleStatusEnums.TOORDER);
                iterator.remove();
                continue;
            }
            if (joinQty.compareTo(BigDecimal.ZERO) == 0 || joinQty.compareTo(qty) >= 0) continue;
            statusMap.put(entryid, HandleStatusEnums.PARTORDER);
            iterator.remove();
        }
    }

    public boolean isQueryOrder() {
        return this.queryOrder;
    }

    public void setQueryOrder(boolean queryOrder) {
        this.queryOrder = queryOrder;
    }
}

