/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.log;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormConfig;
import kd.bos.form.IFormView;
import kd.scm.pssc.common.enums.HandleTypeEnums;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.IPsscHandleLog;
import kd.scm.pssc.common.log.PsscHandleLogHelper;

public class PsscHandleLogService
implements IPsscHandleLog {
    @Override
    public HandleLogEntity getLogInfo(String remark, String detail) {
        HandleLogEntity logEntity = new HandleLogEntity(remark, detail);
        return logEntity;
    }

    public HandleLogEntity getLogInfo(IFormView view, DynamicObject sourceRow, DynamicObject handleRow) {
        String remark = this.getRemark(view, sourceRow, handleRow, "", null);
        String detail = this.getDetail(sourceRow, handleRow);
        HandleLogEntity logEntity = PsscHandleLogHelper.getLogInfo(remark, detail);
        this.updateLogInfo(logEntity, view, sourceRow);
        return logEntity;
    }

    public HandleLogEntity getLogInfo(String remark, String detail, DynamicObject handleRow, String opType) {
        HandleLogEntity logEntity = PsscHandleLogHelper.getLogInfo(remark, detail);
        this.updateLogInfo(logEntity, opType, handleRow);
        return logEntity;
    }

    public void updateLogInfo(HandleLogEntity logEntity, IFormView view, DynamicObject row) {
        logEntity.setBillid(row.getLong("id"));
        logEntity.setBillno(row.getString("number"));
        logEntity.setOptype(view.getFormShowParameter().getFormConfig().getCaption().toString());
        logEntity.setEntitykey(row.getDynamicObjectType().getName());
        logEntity.setHandletype(HandleTypeEnums.HANDLE.getValue());
    }

    public void updateLogInfo(HandleLogEntity logEntity, String optype, DynamicObject row) {
        logEntity.setBillid(row.getLong("id"));
        logEntity.setBillno(row.getString("number"));
        logEntity.setOptype(optype);
        logEntity.setEntitykey(row.getDynamicObjectType().getName());
        logEntity.setHandletype(HandleTypeEnums.HANDLE.getValue());
    }

    public void updateLogInfo(HandleLogEntity logEntity, String opType, DynamicObject row, String entityName) {
        logEntity.setBillid(row.getLong("id"));
        logEntity.setBillno(row.getString("number"));
        logEntity.setOptype(opType);
        logEntity.setEntitykey(entityName);
        logEntity.setHandletype(HandleTypeEnums.HANDLE.getValue());
    }

    public String getRemark(IFormView view, DynamicObject sourceRow, DynamicObject handleRow, String opName, String customMsg) {
        StringBuilder remarkSb = new StringBuilder();
        remarkSb.append(RequestContext.get().getUserName()).append(" ").append(opName);
        if (null == opName || "".equals(opName)) {
            FormConfig config;
            if (null != view && null != view.getFormShowParameter() && null != (config = view.getFormShowParameter().getFormConfig()) && null != config.getCaption()) {
                remarkSb.append(config.getCaption()).append(" ");
            }
        } else {
            remarkSb.append(opName);
        }
        if (null != customMsg) {
            remarkSb.append(customMsg);
        }
        return remarkSb.toString();
    }

    public String getDetail(DynamicObject sourceRow, DynamicObject handleRow) {
        String opinion = handleRow.getString("opinion");
        StringBuilder detailSb = new StringBuilder();
        detailSb.append(ResManager.loadKDString((String)"\u5904\u7406\u610f\u89c1\uff1a", (String)"PsscHandleLogService_0", (String)"scm-pssc-common", (Object[])new Object[0])).append(opinion);
        return detailSb.toString();
    }

    public String getDetail(DynamicObject handleRow) {
        String opinion = handleRow.getString("opinion");
        StringBuilder detailSb = new StringBuilder();
        detailSb.append(ResManager.loadKDString((String)"\u5904\u7406\u610f\u89c1\uff1a", (String)"PsscHandleLogService_0", (String)"scm-pssc-common", (Object[])new Object[0])).append(opinion);
        return detailSb.toString();
    }

    public String getDetail(String detail, DynamicObject handleRow) {
        String opinion = handleRow.getString("opinion");
        StringBuilder detailSb = new StringBuilder();
        detailSb.append(ResManager.loadKDString((String)"\u5904\u7406\u610f\u89c1\uff1a", (String)"PsscHandleLogService_0", (String)"scm-pssc-common", (Object[])new Object[0])).append(opinion);
        return detailSb.toString();
    }
}

