/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static Date getCurrYearFirst() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return DateUtil.getYearFirst(currentYear);
    }

    public static Date getCurrYearLast() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        currCal.set(currentYear, 11, 31, 23, 59, 59);
        return currCal.getTime();
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getThisMonthFirstDay() {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        return c.getTime();
    }

    public static Date getThisMonthEndDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return ca.getTime();
    }

    public static Date getQuarterFirst(int quarter) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        cal.clear();
        if (quarter == 1) {
            cal.set(year, 0, 1, 0, 0, 0);
        } else if (quarter == 2) {
            cal.set(year, 3, 1, 0, 0, 0);
        } else if (quarter == 3) {
            cal.set(year, 6, 1, 0, 0, 0);
        } else {
            cal.set(year, 9, 1, 0, 0, 0);
        }
        return cal.getTime();
    }

    public static Date getQuarterLast(int quarter) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        cal.clear();
        if (quarter == 1) {
            cal.set(year, 2, 31, 23, 59, 59);
        } else if (quarter == 2) {
            cal.set(year, 5, 30, 23, 59, 59);
        } else if (quarter == 3) {
            cal.set(year, 8, 30, 23, 59, 59);
        } else {
            cal.set(year, 11, 31, 23, 59, 59);
        }
        return cal.getTime();
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date date) {
        return DateUtil.localDateTimeToDate(LocalDateTime.of(DateUtil.dateToLocalDate(date), LocalTime.MIN));
    }

    public static Date getEndOfDay(Date date) {
        return DateUtil.localDateTimeToDate(LocalDateTime.of(DateUtil.dateToLocalDate(date), LocalTime.MAX));
    }

    public static LocalDate dateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDateTimeToDate(LocalDateTime date) {
        return Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date localDateToDate(LocalDate date) {
        return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate getStartOfYear(int year) {
        return LocalDate.of(year, 1, 1);
    }

    public static Date addYears(Date date, int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }
}

