/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pssc.common.PsscOperationContext;

public class PsscCommonUtils {
    private static final Log logger = LogFactory.getLog(PsscCommonUtils.class);

    public static void setPrimaryKey(DynamicObject entryObj) {
        ORM.create().setPrimaryKey(entryObj);
    }

    public static String getOpNumber(String opName, String type, String type2) {
        StringBuilder sb = new StringBuilder();
        sb.append("pssc_reqpool_").append(opName).append(type).append(type2);
        return sb.toString();
    }

    public static Set<Long> getHandleIdsFromView(IFormView view, String key) {
        Map paramMap = view.getFormShowParameter().getCustomParams();
        if (paramMap == null) {
            return null;
        }
        return PsscCommonUtils.getHandleIdsFromParam(paramMap, key);
    }

    public static Set<Long> getHandleIdsFromParam(Map<String, Object> paramMap, String key) {
        if (paramMap == null) {
            return null;
        }
        Object idsObj = paramMap.get(key);
        if (idsObj != null) {
            return (Set)SerializationUtils.fromJsonString((String)idsObj.toString(), Set.class);
        }
        Object pkId = paramMap.get("pkId");
        if (pkId != null) {
            HashSet<Long> idSet = new HashSet<Long>(1);
            idSet.add(PsscCommonUtils.object2Long(pkId));
            return idSet;
        }
        return null;
    }

    public static void setEntryDefaultValue(IFormView view, String entryentity, Set<String> excFields, DynamicObject[] srouceRows) {
        if (null == srouceRows) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.deleteEntryData(entryentity);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryentity);
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        DynamicObject srouceRow = srouceRows[0];
        HashSet<String> entryGridProperties = new HashSet<String>();
        if (srouceRow != null) {
            DataEntityPropertyCollection sourceProperty = srouceRow.getDynamicObjectType().getProperties();
            for (String property : properties) {
                if (!excFields.contains(property) && sourceProperty.containsKey((Object)property)) {
                    entryGridProperties.add(property);
                    continue;
                }
                if (!property.equals("srcbillid") && !property.equals("srcentryid") && !property.equals("applyid") && !property.equals("bidattach") && !"material".equals(property)) continue;
                entryGridProperties.add(property);
            }
        }
        for (int i = 0; i < srouceRows.length; ++i) {
            DynamicObject row = srouceRows[i];
            for (String pro : entryGridProperties) {
                if (excFields.contains(pro)) continue;
                if (pro.equals("srcbillid")) {
                    ts.set(pro, row.getPkValue(), i);
                    continue;
                }
                if (pro.equals("srcentryid")) {
                    ts.set("srcentryid", row.getPkValue(), i);
                    continue;
                }
                if (pro.equals("applyid")) {
                    ts.set(pro, (Object)row.getString("srcbillid"), i);
                    continue;
                }
                if (pro.equals("bidattach")) {
                    ts.set(pro, (Object)PsscCommonUtils.cloneAttachment(row, pro), i);
                    continue;
                }
                if (row.get(pro) instanceof DynamicObject && "material".equals(pro)) {
                    ts.set(pro, row.getDynamicObject(pro).get("masterid_id"), i);
                    continue;
                }
                if (row.get(pro) instanceof DynamicObject) {
                    ts.set(pro, row.getDynamicObject(pro).getPkValue(), i);
                    continue;
                }
                ts.set(pro, row.get(pro), i);
            }
        }
        model.beginInit();
        model.batchCreateNewEntryRow(entryentity, ts);
        model.endInit();
        view.updateView(entryentity);
    }

    public static List<String> getEntryProperties(PsscOperationContext context) {
        EntryGrid entryGrid = (EntryGrid)context.getView().getControl("entryentity");
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        return properties;
    }

    public static Set<String> getExcludedFields() {
        HashSet<String> excludedFields = new HashSet<String>();
        excludedFields.add("srcbillno");
        excludedFields.add("reqtitle");
        excludedFields.add("material");
        excludedFields.add("materialnane");
        excludedFields.add("unit");
        excludedFields.add("qty");
        excludedFields.add("srcbillid");
        return excludedFields;
    }

    public static DynamicObject getReqPoolObj(IFormView view) {
        BillList list = (BillList)view.getControl("billlistap");
        long pkValue = PsscCommonUtils.object2Long(list.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        return BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pssc_reqpool_tpl");
    }

    public static long object2Long(Object obj) {
        long var = 0L;
        if (Objects.nonNull(obj)) {
            try {
                var = Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                logger.error(e.getMessage());
            }
        }
        return var;
    }

    public static DynamicObjectCollection cloneAttachment(DynamicObject row, String pro) {
        return PsscCommonUtils.cloneCols(row, pro);
    }

    public static DynamicObjectCollection cloneCols(DynamicObject row, String pro) {
        return PsscCommonUtils.cloneCols(row.getDynamicObjectCollection(pro));
    }

    public static DynamicObjectCollection cloneCols(DynamicObjectCollection cols) {
        DynamicObjectCollection newCols = new DynamicObjectCollection(cols.getDynamicObjectType(), (Object)cols);
        for (DynamicObject col : cols) {
            DynamicObject newCol = (DynamicObject)OrmUtils.clone((IDataEntityBase)col, (boolean)true, (boolean)true);
            newCols.add((Object)newCol);
        }
        return newCols;
    }

    public static DynamicObject[] loadBillObjsByQFilter(String entityName, QFilter qfilter) {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return null;
        }
        Object[] pkIds = new Object[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            pkIds[i] = ((DynamicObject)rows.get(i)).getLong("id");
        }
        return PsscCommonUtils.loadBillObjsById(entityName, pkIds);
    }

    public static DynamicObject[] loadBillObjsById(String entityName, Object[] pkIds) {
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)entityName).getDynamicObjectType());
        return billObjs;
    }

    public static Object getCustomParamValue(IFormView currView, String key) {
        Map<String, Object> paramMap = PsscCommonUtils.getCustomParamMap(currView);
        if (null == paramMap || paramMap.size() == 0) {
            return null;
        }
        Object valurObj = paramMap.get(key);
        if (null == valurObj) {
            return null;
        }
        return valurObj;
    }

    public static Map<String, Object> getCustomParamMap(IFormView currView) {
        FormShowParameter formShowParameter = currView.getFormShowParameter();
        return formShowParameter.getCustomParams();
    }

    public static Object[] saveDynamicObjects(DynamicObject[] objs) {
        if (objs == null || objs.length == 0) {
            return null;
        }
        return SaveServiceHelper.save((DynamicObject[])objs);
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, DynamicObject newObj, List<String> properties, Set<String> excludedFields, int seq) {
        PsscCommonUtils.copyDynamicObjectValue(oldObj, newObj, properties, excludedFields, seq, "");
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, DynamicObject newObj, List<String> properties, Set<String> excludedFields, int seq, String subfix) {
        if (null == subfix) {
            subfix = "";
        }
        DataEntityPropertyCollection propertySet = newObj.getDynamicObjectType().getProperties();
        for (String property : properties) {
            if (null != excludedFields && excludedFields.size() > 0 && excludedFields.contains(property)) continue;
            Object objValue = oldObj.get(property);
            if (objValue instanceof DynamicObject && "material".equals(property)) {
                PsscCommonUtils.setValue(newObj, propertySet, property + ".masterid_id", ((DynamicObject)objValue).getPkValue());
                continue;
            }
            if (objValue instanceof DynamicObject) {
                PsscCommonUtils.setValue(newObj, propertySet, property + subfix, ((DynamicObject)objValue).getPkValue());
                continue;
            }
            if (objValue instanceof DynamicObjectCollection) {
                PsscCommonUtils.setValue(newObj, propertySet, property + subfix, PsscCommonUtils.cloneCols(oldObj, property));
                continue;
            }
            PsscCommonUtils.setValue(newObj, propertySet, property + subfix, objValue);
        }
        if (seq >= 0 && !properties.contains("fseq")) {
            newObj.set("seq", (Object)seq);
        }
    }

    private static void setValue(DynamicObject newObj, DataEntityPropertyCollection propertySet, String property, Object value) {
        if (propertySet.containsKey((Object)property)) {
            newObj.set(property, value);
        }
    }

    public static void setSourceOrg(List<DynamicObject> targetObjects, boolean isHandOperation) {
        Map<String, Map<String, Object>> orgData = PsscCommonUtils.getPurOrgByCategory(targetObjects);
        if (orgData != null) {
            for (DynamicObject targetObject : targetObjects) {
                long sourceorg;
                String rowKey = PsscCommonUtils.getRowKey(targetObject);
                Map<String, Object> valMap = orgData.get(rowKey);
                if (null == valMap || (sourceorg = targetObject.getLong("sourceorg.id")) != 0L && !isHandOperation) continue;
                Long orgId = (Long)valMap.get("orgId");
                if (orgId > 0L) {
                    targetObject.set("sourceorg_id", (Object)orgId);
                    continue;
                }
                targetObject.set("sourceorg_id", (Object)targetObject.getLong("purorg_id"));
            }
        }
    }

    public static Map<String, Map<String, Object>> getPurOrgByCategory(List<DynamicObject> rowList) {
        Object success;
        ArrayList<Map<String, Object>> paramMaps = new ArrayList<Map<String, Object>>(rowList.size());
        for (DynamicObject row : rowList) {
            Map<String, Object> rowParamMap = PsscCommonUtils.getParamMap(row);
            if (rowParamMap.size() == 0) continue;
            paramMaps.add(rowParamMap);
        }
        if (paramMaps.isEmpty()) {
            return null;
        }
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"batchGetPurChaseOrg", (Object[])new Object[]{paramMaps, "pssc_mytask"});
        Map data = null;
        if (null != result && null != (success = result.get("success")) && ((Boolean)success).booleanValue()) {
            data = (Map)result.get("data");
        }
        return data;
    }

    private static Map<String, Object> getParamMap(DynamicObject row) {
        Long baseDataId = 0L;
        String baseDataType = "";
        HashMap<String, Object> rowParamMap = new HashMap<String, Object>(4);
        Long reqOrgId = row.getLong("reqorg.id");
        if (reqOrgId == 0L) {
            return rowParamMap;
        }
        Long matId = row.getLong("material.id");
        Long categoryId = row.getLong("category.id");
        if (matId > 0L) {
            baseDataType = "2";
            baseDataId = matId;
        } else {
            baseDataType = "1";
            baseDataId = categoryId;
        }
        if (matId == 0L && categoryId == 0L) {
            return rowParamMap;
        }
        rowParamMap.put("orgId", reqOrgId);
        rowParamMap.put("baseDataType", baseDataType);
        rowParamMap.put("baseDataId", baseDataId);
        rowParamMap.put("bizType", "2");
        return rowParamMap;
    }

    private static String getRowKey(DynamicObject row) {
        StringBuilder rowKeySb = new StringBuilder();
        Long baseDataId = 0L;
        String baseDataType = "";
        Long reqOrgId = row.getLong("reqorg.id");
        Long matId = row.getLong("material.id");
        if (matId > 0L) {
            baseDataType = "2";
            baseDataId = matId;
        } else {
            Long categoryId = row.getLong("category.id");
            baseDataType = "1";
            baseDataId = categoryId;
        }
        rowKeySb.append(reqOrgId).append('-').append(baseDataId).append('-').append('2').append('-').append(baseDataType);
        return rowKeySb.toString();
    }

    public static void showApproveBill(QFilter filter, IFormView view) {
        DynamicObject[] approvebill = BusinessDataServiceHelper.load((String)"pssc_task_approve", (String)"id", (QFilter[])filter.toArray());
        if (approvebill == null || approvebill.length == 0) {
            String message = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ba1\u6279\u8bb0\u5f55", (String)"PsscCommonUtils_0", (String)"scm-pssc-common", (Object[])new Object[0]);
            view.showTipNotification(message);
            return;
        }
        ArrayList<Object> idlist = new ArrayList<Object>();
        for (DynamicObject dynamicObject : approvebill) {
            idlist.add(dynamicObject.get("id"));
        }
        QFilter idfilter = new QFilter("id", "in", idlist);
        OpenFormUtil.openListPage((IFormView)view, (String)"pssc_task_approve", (ShowType)ShowType.MainNewTabPage, null, (QFilter)idfilter, null);
    }

    public static void saveRelation(List<DynamicObject> targetObjects) {
        ArrayList<DynamicObject> datalist = new ArrayList<DynamicObject>(16);
        Date now = TimeServiceHelper.now();
        for (DynamicObject targetObject : targetObjects) {
            long orderid = targetObject.getLong("id");
            DynamicObjectCollection billentrys = targetObject.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"pssc_order_relation");
                data.set("orderid", (Object)orderid);
                data.set("ordersrcentryid", (Object)billentry.getString("srcbillentryid"));
                data.set("createdate", (Object)now);
                datalist.add(data);
            }
        }
        SaveServiceHelper.save((DynamicObject[])datalist.toArray(new DynamicObject[0]));
    }

    public static Map<Long, LinkedList<Long>> getLongNumMapByCategory(Set<Long> categoryIds, Long standardId) {
        HashMap<Long, LinkedList<Long>> resultList = new HashMap<Long, LinkedList<Long>>();
        HashMap longNumbers = new HashMap();
        HashSet<String> numbers = new HashSet<String>();
        QFilter qFilter = new QFilter("id", "in", categoryIds);
        qFilter.and("standard", "=", (Object)standardId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PsscCommonUtils_number", (String)"bd_materialgroup", (String)"id,number,longnumber", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Object row : dataSet) {
                LinkedList<String> number = (LinkedList<String>)longNumbers.get(row.getLong("id"));
                if (number == null) {
                    number = new LinkedList<String>();
                    longNumbers.put(row.getLong("id"), number);
                }
                if (!StringUtils.isNotBlank((CharSequence)row.getString("longnumber"))) continue;
                String[] longnumbers = row.getString("longnumber").split("!");
                for (int i = longnumbers.length - 1; i >= 0; --i) {
                    number.add(longnumbers[i]);
                    numbers.add(longnumbers[i]);
                }
            }
        }
        if (numbers.size() > 0) {
            HashMap<String, Long> categoryNumber = new HashMap<String, Long>();
            qFilter = new QFilter("number", "in", numbers);
            qFilter.and("standard", "=", (Object)standardId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PsscCommonUtils_group", (String)"bd_materialgroup", (String)"id,number", (QFilter[])new QFilter[]{qFilter}, null);
            Object object = null;
            try {
                for (Row row : dataSet) {
                    categoryNumber.put(row.getString("number"), row.getLong("id"));
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            for (Map.Entry next : longNumbers.entrySet()) {
                Long key = (Long)next.getKey();
                LinkedList<Long> longs = (LinkedList<Long>)resultList.get(key);
                if (longs == null) {
                    longs = new LinkedList<Long>();
                    resultList.put(key, longs);
                }
                LinkedList value = (LinkedList)next.getValue();
                for (String s : value) {
                    Long aLong = (Long)categoryNumber.get(s);
                    longs.add(aLong);
                }
            }
        }
        return resultList;
    }

    public static String dealOperationResult(OperationResult result, boolean isFormPlugin) {
        StringBuilder sb = new StringBuilder();
        ValidateResultCollection col = result.getValidateResult();
        Map billNos = result.getBillNos();
        List list = col.getValidateErrors();
        for (ValidateResult vr : list) {
            List errInfoList = vr.getAllErrorInfo();
            for (OperateErrorInfo info : errInfoList) {
                Object pkValue = info.getPkValue();
                String number = isFormPlugin ? (String)billNos.get(pkValue) : (String)billNos.get(String.valueOf(pkValue));
                if (!kd.bos.util.StringUtils.isNotEmpty((String)info.getMessage())) continue;
                String message = info.getMessage().replace("{number}", number);
                info.setMessage(message);
                sb.append(message);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static void businessCheck(DynamicObject[] tasks, ArrayList<String> srcentryidList, long currUserId, StringBuilder stringBuilder) {
        if (tasks != null && stringBuilder != null && srcentryidList != null) {
            for (DynamicObject task : tasks) {
                if (task.getLong("handleuser_id") != 0L && task.getLong("handleuser_id") != currUserId) {
                    srcentryidList.remove(task.getString("srcentryid"));
                    stringBuilder.append(String.format(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1%s\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PsscCommonUtils_1", (String)"scm-pssc-common", (Object[])new Object[0]), task.getString("number"))).append(System.lineSeparator());
                }
                if ("A".equals(task.getString("approvestatus"))) {
                    srcentryidList.remove(task.getString("srcentryid"));
                    stringBuilder.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%s\uff1a\u5ba1\u6279\u72b6\u6001\u4e3a\u5ba1\u6279\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PsscCommonUtils_2", (String)"scm-pssc-common", (Object[])new Object[0]), task.getString("number"))).append(System.lineSeparator());
                }
                if (!"F".equals(task.getString("handlestatus")) && !"G".equals(task.getString("handlestatus"))) continue;
                srcentryidList.remove(task.getString("srcentryid"));
                stringBuilder.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%s\u5904\u7406\u72b6\u6001\u4e3a\u6682\u6302\u6216\u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PsscCommonUtils_3", (String)"scm-pssc-common", (Object[])new Object[0]), task.getString("number"))).append(System.lineSeparator());
            }
        }
    }
}

