/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.form.IFormView;
import kd.bos.form.operate.botp.Push;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.business.helper.FetchPriceHelper;
import kd.scm.pssc.common.enums.HandleStatusEnums;
import kd.scm.pssc.common.enums.PurMethodEnums;
import kd.scm.pssc.common.helper.MaterialOperatorHelper;
import kd.scm.pssc.common.helper.MaterialOperatorInfo;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.utils.MultiBasedataUtils;

public class PsscTaskPoolUtil {
    private static Log logger = LogFactory.getLog(PsscTaskPoolUtil.class);

    public static void setHandleStatus(DynamicObject task, Boolean isHandOperation) {
        if (null == task) {
            return;
        }
        if (isHandOperation.booleanValue() && HandleStatusEnums.TOALLOCATE.getValue().equals(task.getString("handlestatus"))) {
            task.set("handlestatus", (Object)HandleStatusEnums.PROCESSING.getValue());
            return;
        }
        if (isHandOperation.booleanValue() && !HandleStatusEnums.TOALLOCATE.getValue().equals(task.getString("handlestatus"))) {
            return;
        }
        String handleStatus = HandleStatusEnums.TOALLOCATE.getValue();
        Long handlerId = 0L;
        Object handler = task.get("handler");
        if (handler instanceof Long) {
            handlerId = (Long)handler;
        } else if (handler instanceof DynamicObject) {
            handlerId = task.getLong("handler.id");
        }
        Long purGroupId = 0L;
        Object purGroup = task.get("purgroup");
        if (purGroup instanceof Long) {
            purGroupId = (Long)purGroup;
        } else if (purGroup instanceof DynamicObject) {
            purGroupId = task.getLong("purgroup.id");
        }
        if (handlerId == 0L && purGroupId == 0L) {
            handleStatus = HandleStatusEnums.TOALLOCATE.getValue();
        } else if (handlerId > 0L) {
            handleStatus = HandleStatusEnums.PROCESSING.getValue();
        }
        task.set("handlestatus", (Object)handleStatus);
    }

    public static void setValByCategoryStrategy(List<DynamicObject> targetObjects, boolean isHandOperate) {
        ArrayList paramMaps = new ArrayList(targetObjects.size());
        HashMap<String, ArrayList<DynamicObject>> keyTargetObjMap = new HashMap<String, ArrayList<DynamicObject>>(targetObjects.size());
        Long baseDataId = 0L;
        String baseDataType = "";
        PsscHandleLogService psscHandleLogService = new PsscHandleLogService();
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(16);
        for (DynamicObject taskPool : targetObjects) {
            if (!taskPool.getString("purmethod").isEmpty()) continue;
            StringBuilder uniqueKeySb = new StringBuilder();
            HashMap<String, Object> rowParamMap = new HashMap<String, Object>(4);
            Long purOrgId = taskPool.getLong("purorg.id");
            rowParamMap.put("orgId", purOrgId);
            rowParamMap.put("entityKey", "pssc_mytask");
            Long matId = taskPool.getLong("material.masterid_id");
            if (matId > 0L) {
                baseDataType = "2";
                baseDataId = matId;
            } else {
                Long categoryId = taskPool.getLong("category.id");
                baseDataType = "1";
                baseDataId = categoryId;
            }
            rowParamMap.put("baseDataType", baseDataType);
            rowParamMap.put("baseDataId", baseDataId);
            uniqueKeySb.append(purOrgId).append('-').append(baseDataId).append('-').append(baseDataType);
            ArrayList<DynamicObject> needToDealTask = (ArrayList<DynamicObject>)keyTargetObjMap.get(uniqueKeySb.toString());
            if (needToDealTask == null) {
                needToDealTask = new ArrayList<DynamicObject>(1);
                keyTargetObjMap.put(uniqueKeySb.toString(), needToDealTask);
            }
            needToDealTask.add(taskPool);
            paramMaps.add(rowParamMap);
        }
        logger.info("\u8c03\u7528\u54c1\u7c7b\u7ba1\u7406\u83b7\u53d6\u91c7\u8d2d\u7ec4\u7ec7\u53c2\u6570\uff1a" + SerializationUtils.toJsonString(paramMaps));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"matchPurChaseStrategy", (Object[])new Object[]{paramMaps, "pssc_mytask"});
        logger.info("\u8bf7\u6c42\u54c1\u7c7b\u8fd4\u56de\u503c\u4e3a\uff1a" + SerializationUtils.toJsonString((Object)result));
        if (null != result) {
            Object success = result.get("success");
            if (null != success && ((Boolean)success).booleanValue()) {
                Map data = (Map)result.get("data");
                if (null != data) {
                    for (Map.Entry dataMapEntry : data.entrySet()) {
                        List taskPools = (List)keyTargetObjMap.get(dataMapEntry.getKey());
                        if (null == taskPools) continue;
                        for (DynamicObject taskPool : taskPools) {
                            Object isMal;
                            Map purStrategyDataMap = (Map)dataMapEntry.getValue();
                            if (null == purStrategyDataMap || !String.valueOf(isMal = purStrategyDataMap.get("isMal")).equals("true")) continue;
                            taskPool.set("purmethod", (Object)PurMethodEnums.MALL.getValue());
                            if (isHandOperate) continue;
                            PsscTaskPoolUtil.recordTargetLog(psscHandleLogService, logEntityList, taskPool, "mall");
                        }
                    }
                    PsscTaskPoolUtil.saveHandleLog(logEntityList);
                }
            } else {
                BizLog.log((String)("###setValByCategoryStrategy matchPurChaseStrategy fail:" + result.get("error")));
            }
        }
    }

    public static void recordTargetLog(PsscHandleLogService psscHandleLogService, List<HandleLogEntity> logEntityList, DynamicObject taskPool, String purType) {
        String targetRemark = ResManager.loadKDString((String)"\u7cfb\u7edf\u786e\u8ba4\u6267\u884c\u65b9\u5f0f\u4e3a\u5bfb\u6e90", (String)"PsscTaskPoolUtil_1", (String)"scm-pssc-common", (Object[])new Object[0]);
        switch (purType) {
            case "mall": {
                targetRemark = ResManager.loadKDString((String)"\u7cfb\u7edf\u786e\u8ba4\u6267\u884c\u65b9\u5f0f\u4e3a\u5546\u57ce", (String)"PsscTaskPoolUtil_2", (String)"scm-pssc-common", (Object[])new Object[0]);
                break;
            }
            case "order": {
                targetRemark = ResManager.loadKDString((String)"\u7cfb\u7edf\u786e\u8ba4\u6267\u884c\u65b9\u5f0f\u4e3a\u8ba2\u5355", (String)"PsscTaskPoolUtil_3", (String)"scm-pssc-common", (Object[])new Object[0]);
                break;
            }
        }
        HandleLogEntity targetlogEntity = PsscHandleLogHelper.getLogInfo(targetRemark, "");
        psscHandleLogService.updateLogInfo(targetlogEntity, "target", taskPool, "pssc_mytask");
        logEntityList.add(targetlogEntity);
    }

    public static void setTargetValByPrice(List<DynamicObject> myTaskObjs, boolean isHandOperate) {
        HashMap<Long, ArrayList<DynamicObject>> billMap = new HashMap<Long, ArrayList<DynamicObject>>(8);
        ArrayList<DynamicObject> getPriceObjList = new ArrayList<DynamicObject>(8);
        PsscHandleLogService psscHandleLogService = new PsscHandleLogService();
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(16);
        for (DynamicObject myTask : myTaskObjs) {
            String purmethod = myTask.getString("purmethod");
            if (!purmethod.isEmpty()) continue;
            Long orgId = myTask.getLong("purorg.id");
            ArrayList<DynamicObject> myTaskObjsList = (ArrayList<DynamicObject>)billMap.get(orgId);
            if (null == myTaskObjsList) {
                myTaskObjsList = new ArrayList<DynamicObject>(4);
            }
            myTaskObjsList.add(myTask);
            billMap.put(orgId, myTaskObjsList);
            getPriceObjList.add(myTask);
        }
        HashMap quoteOtherParam = new HashMap(1);
        if (billMap.size() == 0) {
            return;
        }
        logger.info("\u53d6\u4ef7\u53c2\u6570\uff1a" + SerializationUtils.toJsonString(billMap));
        Map result = FetchPriceHelper.integrationFetchPrice(billMap, (String)"pssc_mytask", quoteOtherParam);
        logger.info("\u53d6\u4ef7\u7ed3\u679c\u4e3a\uff1a" + SerializationUtils.toJsonString((Object)result));
        if (null == result) {
            return;
        }
        for (DynamicObject myTask : getPriceObjList) {
            Object pkId;
            Object priceObj;
            BigDecimal taxPrice;
            Long orgId = myTask.getLong("purorg.id");
            Map priceMap = (Map)result.get(orgId);
            if (null == priceMap || (taxPrice = null == (priceObj = priceMap.get((pkId = myTask.getPkValue()) + "$$priceandtax")) ? BigDecimal.ZERO : (BigDecimal)priceObj).compareTo(BigDecimal.ZERO) <= 0) continue;
            myTask.set("purmethod", (Object)PurMethodEnums.ORDER.getValue());
            if (isHandOperate) continue;
            PsscTaskPoolUtil.recordTargetLog(psscHandleLogService, logEntityList, myTask, "order");
        }
        PsscTaskPoolUtil.saveHandleLog(logEntityList);
    }

    public static void setBizPersonOrBizGroup(List<DynamicObject> targetObjects, boolean isHandOprate) {
        HashSet<MaterialOperatorInfo> materialOpSet = new HashSet<MaterialOperatorInfo>(targetObjects.size());
        int baseDataType = 1;
        HashMap<String, ArrayList<DynamicObject>> rowKeyObjMap = new HashMap<String, ArrayList<DynamicObject>>(targetObjects.size());
        for (DynamicObject taskPool : targetObjects) {
            MaterialOperatorInfo info = new MaterialOperatorInfo();
            Long orgId = "sourc".equals(taskPool.getString("purmethod")) ? Long.valueOf(taskPool.getLong("sourceorg.id")) : Long.valueOf(taskPool.getLong("purorg.id"));
            Long materialId = isHandOprate ? Long.valueOf(taskPool.getLong("material.id")) : Long.valueOf(taskPool.getLong("material.masterid_id"));
            Long categoryId = taskPool.getLong("category.id");
            baseDataType = materialId > 0L ? 1 : 2;
            info.setOrgid(orgId);
            info.setMaterialid(materialId);
            info.setMaterialgroupid(categoryId);
            info.setMaterialtype(baseDataType);
            materialOpSet.add(info);
            String rowKey = PsscTaskPoolUtil.getRowKey(orgId, materialId, categoryId, baseDataType);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)rowKeyObjMap.get(rowKey);
            if (list == null) {
                list = new ArrayList<DynamicObject>(16);
                list.add(taskPool);
                rowKeyObjMap.put(rowKey, list);
                continue;
            }
            list.add(taskPool);
        }
        logger.info("\u81ea\u52a8\u83b7\u53d6\u91c7\u8d2d\u5458\u53c2\u6570\uff1a" + SerializationUtils.toJsonString(rowKeyObjMap));
        PsscHandleLogService psscHandleLogService = new PsscHandleLogService();
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(16);
        MaterialOperatorHelper helper = new MaterialOperatorHelper();
        Set<MaterialOperatorInfo> resultSet = helper.getOperatorByMaterial(materialOpSet, "pssc_mytask");
        logger.info("\u81ea\u52a8\u83b7\u53d6\u91c7\u8d2d\u5458\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + SerializationUtils.toJsonString(resultSet));
        ArrayList<Long> operatoridList = new ArrayList<Long>(resultSet.size());
        for (MaterialOperatorInfo info : resultSet) {
            long operatorid = info.getOperatorid();
            if (operatorid <= 0L) continue;
            operatoridList.add(operatorid);
        }
        QFilter idFilter = new QFilter("id", "in", operatoridList);
        Map operatorMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])idFilter.toArray());
        for (MaterialOperatorInfo info : resultSet) {
            String rowKey = PsscTaskPoolUtil.getRowKey(info.getOrgid(), info.getMaterialid(), info.getMaterialgroupid(), info.getMaterialtype());
            List myTaskList = (List)rowKeyObjMap.get(rowKey);
            for (DynamicObject myTask : myTaskList) {
                if (null == myTask) continue;
                if (info.getOperatorid() > 0L && isHandOprate) {
                    PsscTaskPoolUtil.setHanderInfo(info, myTask);
                    continue;
                }
                if (isHandOprate || info.getOperatorid() <= 0L || myTask.getLong("handler.id") != 0L) continue;
                PsscTaskPoolUtil.setHanderInfo(info, myTask);
                PsscTaskPoolUtil.recordAllocateLog(psscHandleLogService, logEntityList, myTask, operatorMap);
                if (info.getPersonid() <= 0L) continue;
                HashSet<Long> idSet = new HashSet<Long>(1);
                idSet.add(info.getPersonid());
                MultiBasedataUtils.setMultiBasedataForBillObj(myTask, idSet, "partners");
            }
        }
        PsscTaskPoolUtil.saveHandleLog(logEntityList);
    }

    public static void saveHandleLog(List<HandleLogEntity> logEntityList) {
        if (!logEntityList.isEmpty()) {
            PsscHandleLogHelper.log(logEntityList);
        }
    }

    private static void recordAllocateLog(PsscHandleLogService psscHandleLogService, List<HandleLogEntity> logEntityList, DynamicObject myTask, Map<Object, DynamicObject> operatorMap) {
        long handlerid = myTask.getLong("handler_id");
        DynamicObject handler = operatorMap.get(handlerid);
        if (handler == null) {
            return;
        }
        String operName = handler.getString("operatorname");
        StringBuilder remarkSb = new StringBuilder();
        remarkSb.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u5206\u914d\u7ed9", (String)"PsscTaskPoolUtil_0", (String)"scm-pssc-common", (Object[])new Object[0])).append(operName);
        HandleLogEntity logEntity = PsscHandleLogHelper.getLogInfo(remarkSb.toString(), "");
        psscHandleLogService.updateLogInfo(logEntity, "allocate", myTask);
        logEntityList.add(logEntity);
    }

    private static void setHanderInfo(MaterialOperatorInfo info, DynamicObject myTask) {
        myTask.set("handler", (Object)info.getOperatorid());
        myTask.set("handler_id", (Object)info.getOperatorid());
        myTask.set("handleuser", (Object)info.getPersonid());
        myTask.set("handleuser_id", (Object)info.getPersonid());
        myTask.set("purgroup", (Object)info.getOperatorgroupid());
        myTask.set("purgroup_id", (Object)info.getOperatorgroupid());
    }

    private static String getRowKey(Long orgId, Long matId, Long categoryId, int baseDataType) {
        StringBuilder rowKeySb = new StringBuilder();
        rowKeySb.append(orgId).append('-').append(matId).append('-').append(categoryId).append('-').append(baseDataType);
        return rowKeySb.toString();
    }

    public static void dealResult(List<ConvertOperationResult> successResult, List<ConvertOperationResult> errorResults, PushArgs args, IFormView view) {
        if (successResult.size() > 0) {
            errorResults.clear();
            errorResults.addAll(successResult);
        }
        ConvertOperationResult mergeResult = new ConvertOperationResult();
        if (errorResults.size() > 0) {
            mergeResult = errorResults.get(0);
            for (ConvertOperationResult result : errorResults) {
                if (mergeResult == result) continue;
                mergeResult.setMessage(mergeResult.getMessage() + result.getMessage());
                mergeResult.setSuccess(mergeResult.isSuccess() && result.isSuccess());
                mergeResult.getCachePageIds().addAll(result.getCachePageIds());
                mergeResult.getCacheTargetObjStr().putAll(result.getCacheTargetObjStr());
                mergeResult.getTargetBillIds().addAll(result.getTargetBillIds());
                mergeResult.getDataMutexSrcBillIds().addAll(result.getDataMutexSrcBillIds());
                mergeResult.getBillReports().addAll(result.getBillReports());
                mergeResult.setFinishedTime(result.getFinishedTime());
            }
        }
        if (!mergeResult.isSuccess() || mergeResult.getCachePageIds().size() + mergeResult.getTargetBillIds().size() == 0) {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)args, (ConvertOperationResult)mergeResult);
        } else if (mergeResult.getCachePageIds().size() + mergeResult.getTargetBillIds().size() == 1) {
            Push.showTargetBill((IFormView)view, (PushArgs)args, (ConvertOperationResult)mergeResult, (boolean)false);
        } else {
            Push.showMultiTargetBills((IFormView)view, (PushArgs)args, (ConvertOperationResult)mergeResult, (boolean)false);
        }
    }
}

