/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.common.util.ScmcUtil;
import kd.scm.pur.api.PurWebApiService;
import kd.scm.pur.api.args.ApiArgs;

public class PurPushToPurOrderService
extends PurWebApiService {
    private static Log log = LogFactory.getLog(PurPushToPurOrderService.class);
    private static final String PM_PURORDER = "pm_purorderbill";
    private static final String PUR_PURORDER = "pur_order";
    private static final String PUR_PURORDER_ENTRY = "materialentry";

    @Override
    protected void checkParam(ApiArgs apiArgs) {
        super.checkParam(apiArgs);
        Map<String, Object> param = apiArgs.getParam();
        Object data = param.get("data");
        if (null == data) {
            apiArgs.setCancel(true);
            apiArgs.setResult(ApiResult.fail((String)"\u6570\u636e\u4e3a\u7a7a!"));
        }
    }

    @Override
    protected void doService(ApiArgs apiArgs) {
        super.doService(apiArgs);
        Map<String, Object> param = apiArgs.getParam();
        Object data = param.get("data");
        Map entityMap = null;
        HashMap<String, Map<String, Map<String, Object>>> entryDataMap = new HashMap<String, Map<String, Map<String, Object>>>(1024);
        List dataList = (List)data;
        for (Object object : dataList) {
            if (null == object) continue;
            entityMap = (Map)object;
            String id = String.valueOf(entityMap.get("id"));
            List entryList = (List)entityMap.get("entryentity");
            HashMap<String, Map> entryDetailMap = new HashMap<String, Map>();
            for (Object entry : entryList) {
                Map entryMap = (Map)entry;
                String entryId = String.valueOf(entryMap.get("entryid"));
                entryDetailMap.putIfAbsent(entryId, entryMap);
            }
            entryDataMap.put(id, entryDetailMap);
        }
        Object result = this.toPurPurOrder(entryDataMap);
        apiArgs.getResult().setMessage(String.valueOf(result));
    }

    private Object toPurPurOrder(Map<String, Map<String, Map<String, Object>>> entryDataMap) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(PM_PURORDER);
        pushArgs.setTargetEntityNumber(PUR_PURORDER);
        pushArgs.setBuildConvReport(true);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)PUR_PURORDER);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        ArrayList<DynamicObject> pushedDataList = new ArrayList<DynamicObject>();
        StringBuilder msgSb = new StringBuilder();
        for (Map.Entry<String, Map<String, Map<String, Object>>> entryData : entryDataMap.entrySet()) {
            Map<String, Map<String, Object>> entryMap = entryData.getValue();
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(entryMap.size());
            for (Map.Entry<String, Map<String, Object>> entry : entryMap.entrySet()) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)entryData.getKey());
                row.setEntryEntityKey(PUR_PURORDER_ENTRY);
                row.setEntryPrimaryKeyValue((Object)entry.getKey());
                selectedRowList.add(row);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                pushedDataList.addAll(targetData);
                result.release(refDataProvider, mainType);
                continue;
            }
            msgSb.append("id:").append(entryData.getKey()).append("\u4e0b\u63a8\u5931\u8d25!").append("\u5931\u8d25\u539f\u56e0\uff1a").append(result.getMessage()).append("\u3002\n");
            log.info("@@@\u4f9b\u5e94\u94fe\u91c7\u8d2d\u8ba2\u5355\u4e0b\u63a8\u534f\u540c\u8ba2\u5355\u5f02\u5e38\uff1a" + result.getMessage());
        }
        if (pushedDataList.size() > 0) {
            this.dealPurOrderInfo(pushedDataList);
            String msg = ScmcUtil.dealConvertResult(pushedDataList, (String)PUR_PURORDER, (boolean)true);
            msgSb.append("----").append(msg);
        }
        return msgSb.toString();
    }

    public void dealPurOrderInfo(List<DynamicObject> pushedDataList) {
        for (int i = 0; i < pushedDataList.size(); ++i) {
            pushedDataList.get(i).set("srctype", (Object)"3");
        }
    }
}

